/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.acm.seguin.uml.UMLType;
import org.acm.seguin.uml.line.EndPointPanel;
import org.acm.seguin.uml.line.Segment;
import org.acm.seguin.uml.line.Vertex;

public class SegmentedLine
implements ComponentListener {
    protected Vertex[] vertices;
    protected int[] Xs;
    protected int[] Ys;
    private EndPointPanel startPanel;
    private EndPointPanel endPanel;
    private int activeVertex;
    private Segment workingSegment;
    protected double scalingFactor;
    private static double SHORT_BACK = 17.32050807568877;

    public SegmentedLine(EndPointPanel endPointPanel, EndPointPanel endPointPanel2) {
        this.startPanel = endPointPanel;
        this.endPanel = endPointPanel2;
        this.scalingFactor = 1.0;
        this.vertices = new Vertex[2];
        this.workingSegment = new Segment();
        this.initEndPoints();
        this.activeVertex = -1;
        this.Xs = new int[5];
        this.Ys = new int[5];
        this.startPanel.addComponentListener(this);
        this.endPanel.addComponentListener(this);
        if (this.startPanel == this.endPanel) {
            Rectangle rectangle = this.startPanel.getBounds();
            int n = rectangle.x + rectangle.width / 2;
            int n2 = rectangle.y + rectangle.height + 10;
            this.insertAt(1, new Vertex(new Point(n, n2)));
            n = rectangle.x - 10;
            n2 = rectangle.y + rectangle.height + 10;
            this.insertAt(2, new Vertex(new Point(n, n2)));
            n = rectangle.x - 10;
            n2 = rectangle.y + rectangle.height / 2;
            this.insertAt(3, new Vertex(new Point(n, n2)));
            this.updateEnd();
        }
    }

    public boolean isBothEndsSelected() {
        return this.startPanel.isSelected() && this.endPanel.isSelected();
    }

    public void paint(Graphics graphics) {
        this.vertices[0].paint(graphics);
        int n = 1;
        while (n < this.vertices.length - 1) {
            this.Xs[n - 1] = this.vertices[n].getX();
            this.Ys[n - 1] = this.vertices[n].getY();
            this.vertices[n].paint(graphics);
            ++n;
        }
        this.vertices[this.vertices.length - 1].paint(graphics);
        this.paintCentral(graphics, this.Xs, this.Ys, this.vertices.length - 2);
        if (this.vertices.length == 2) {
            this.drawSingleSegment(graphics);
        } else {
            this.drawStartSegment(graphics);
            this.drawArrow(graphics);
        }
    }

    public void select(boolean bl) {
        int n = 0;
        while (n < this.vertices.length) {
            this.vertices[n].select(bl);
            this.vertices[n].active(false);
            ++n;
        }
    }

    public boolean hit(Point point) {
        this.activeVertex = this.hitVertex(point);
        if (this.activeVertex == -1) {
            int n = this.hitSegment(point);
            if (n == -1) {
                this.select(false);
                return false;
            }
            Vertex vertex = new Vertex(point);
            this.insertAt(n, vertex);
            this.select(true);
            vertex.active(true);
            this.activeVertex = n;
        } else {
            this.select(true);
            this.vertices[this.activeVertex].active(true);
        }
        return this.activeVertex >= 0;
    }

    public void drag(Point point) {
        if (this.activeVertex > 0 && this.activeVertex < this.vertices.length - 1) {
            this.vertices[this.activeVertex].move(point);
            if (this.activeVertex == 1) {
                this.updateStart();
            }
            if (this.activeVertex == this.vertices.length - 2) {
                this.updateEnd();
            }
        }
    }

    public void drop() {
        if (this.activeVertex > 0 && this.activeVertex < this.vertices.length - 1) {
            this.vertices[this.activeVertex].active(false);
            if (this.shouldDelete(this.activeVertex)) {
                this.deleteVertex(this.activeVertex);
            }
            this.activeVertex = -1;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (this.vertices.length == 2) {
            this.updateStart();
            this.updateEnd();
        } else if (component.equals(this.startPanel)) {
            this.updateStart();
        } else if (component.equals(this.endPanel)) {
            this.updateEnd();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (component.equals(this.startPanel)) {
            this.updateStart();
        } else if (component.equals(this.endPanel)) {
            this.updateEnd();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void save(PrintWriter printWriter) {
        printWriter.print("S[");
        this.saveStartPanel(printWriter);
        printWriter.print(",");
        this.saveEndPanel(printWriter);
        printWriter.print("]");
        this.saveVertices(printWriter);
        printWriter.println("");
    }

    public boolean match(EndPointPanel endPointPanel, EndPointPanel endPointPanel2) {
        return endPointPanel.equals(this.startPanel) && endPointPanel2.equals(this.endPanel);
    }

    public void load(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.vertices = new Vertex[n];
        String string3 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string3, "(),");
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            try {
                int n3 = Integer.parseInt(string4);
                int n4 = Integer.parseInt(string5);
                this.vertices[n2] = new Vertex(new Point(n3, n4));
            }
            catch (NumberFormatException numberFormatException) {
                this.vertices[n2] = new Vertex(new Point(0, 0));
            }
            ++n2;
        }
        int n5 = n / 5 + 1;
        this.Xs = new int[n5 * 5];
        this.Ys = new int[n5 * 5];
    }

    public void shift(int n, int n2) {
        int n3 = 0;
        while (n3 < this.vertices.length) {
            this.vertices[n3].shift(n, n2);
            ++n3;
        }
    }

    public void scale(double d) {
        int n = 0;
        while (n < this.vertices.length) {
            this.vertices[n].scale(d);
            ++n;
        }
        this.scalingFactor = d;
    }

    protected Point getShortPoint() {
        int n = this.vertices.length;
        this.workingSegment.reset(this.vertices[n - 2].getPoint(), this.vertices[n - 1].getPoint());
        double d = this.workingSegment.findFromEnd(SHORT_BACK * this.scalingFactor);
        return this.workingSegment.getPoint(d);
    }

    protected Point getArrowPointAbove() {
        int n = this.vertices.length;
        this.workingSegment.reset(this.vertices[n - 2].getPoint(), this.vertices[n - 1].getPoint());
        double d = this.workingSegment.findFromEnd(SHORT_BACK * this.scalingFactor);
        return this.workingSegment.aboveLine(d, 10.0 * this.scalingFactor);
    }

    protected Point getArrowPointBelow() {
        int n = this.vertices.length;
        this.workingSegment.reset(this.vertices[n - 2].getPoint(), this.vertices[n - 1].getPoint());
        double d = this.workingSegment.findFromEnd(SHORT_BACK * this.scalingFactor);
        return this.workingSegment.belowLine(d, 10.0 * this.scalingFactor);
    }

    protected void updateEnd() {
        int n = this.vertices.length;
        Rectangle rectangle = this.endPanel.getBounds();
        this.workingSegment.reset(this.vertices[n - 2].getPoint(), rectangle);
        double d = this.workingSegment.intersect(rectangle);
        this.vertices[n - 1].move(this.workingSegment.getPoint(d));
    }

    protected void drawSingleSegment(Graphics graphics) {
        this.drawArrow(graphics);
    }

    protected void drawStartSegment(Graphics graphics) {
        Point point = this.vertices[0].getPoint();
        Point point2 = this.vertices[1].getPoint();
        graphics.drawLine((int)point.getX(), (int)point.getY(), (int)point2.getX(), (int)point2.getY());
    }

    protected void paintCentral(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        graphics.setColor(Color.black);
        graphics.drawPolyline(nArray, nArray2, n);
    }

    protected void drawArrow(Graphics graphics) {
        Point point = this.getShortPoint();
        int n = this.vertices.length;
        double d = this.vertices[n - 2].getPoint().getX();
        double d2 = this.vertices[n - 2].getPoint().getY();
        graphics.drawLine((int)d, (int)d2, (int)point.getX(), (int)point.getY());
        Point point2 = this.vertices[n - 1].getPoint();
        Point point3 = this.getArrowPointAbove();
        Point point4 = this.getArrowPointBelow();
        this.Xs[0] = (int)point2.getX();
        this.Xs[1] = (int)point3.getX();
        this.Xs[2] = (int)point4.getX();
        this.Xs[3] = (int)point2.getX();
        this.Ys[0] = (int)point2.getY();
        this.Ys[1] = (int)point3.getY();
        this.Ys[2] = (int)point4.getY();
        this.Ys[3] = (int)point2.getY();
        graphics.drawPolyline(this.Xs, this.Ys, 4);
    }

    protected void saveStartPanel(PrintWriter printWriter) {
        this.savePanel(printWriter, this.startPanel);
    }

    protected void saveEndPanel(PrintWriter printWriter) {
        this.savePanel(printWriter, this.endPanel);
    }

    protected void savePanel(PrintWriter printWriter, EndPointPanel endPointPanel) {
        if (endPointPanel instanceof UMLType) {
            printWriter.print(((UMLType)endPointPanel).getID());
        } else {
            printWriter.print("???");
        }
    }

    protected void saveVertices(PrintWriter printWriter) {
        printWriter.print("{");
        printWriter.print(this.vertices.length);
        printWriter.print(":");
        this.vertices[0].save(printWriter);
        int n = 1;
        while (n < this.vertices.length) {
            printWriter.print(",");
            this.vertices[n].save(printWriter);
            ++n;
        }
        printWriter.print("}");
    }

    private void initEndPoints() {
        Rectangle rectangle = this.startPanel.getBounds();
        Rectangle rectangle2 = this.endPanel.getBounds();
        this.workingSegment.reset(rectangle, rectangle2);
        double d = this.workingSegment.intersect(rectangle);
        double d2 = this.workingSegment.intersect(rectangle2);
        this.vertices[0] = new Vertex(this.workingSegment.getPoint(d));
        this.vertices[this.vertices.length - 1] = new Vertex(this.workingSegment.getPoint(d2));
    }

    private void updateStart() {
        Rectangle rectangle = this.startPanel.getBounds();
        this.workingSegment.reset(rectangle, this.vertices[1].getPoint());
        double d = this.workingSegment.intersect(rectangle);
        this.vertices[0].move(this.workingSegment.getPoint(d));
    }

    private void insertAt(int n, Vertex vertex) {
        Vertex[] vertexArray = new Vertex[this.vertices.length + 1];
        System.arraycopy(this.vertices, 0, vertexArray, 0, n);
        System.arraycopy(this.vertices, n, vertexArray, n + 1, this.vertices.length - n);
        vertexArray[n] = vertex;
        this.vertices = vertexArray;
        if (this.vertices.length > this.Xs.length) {
            this.Xs = new int[this.Xs.length + 5];
            this.Ys = new int[this.Ys.length + 5];
        }
    }

    private int hitVertex(Point point) {
        int n = 1;
        while (n < this.vertices.length - 1) {
            if (this.vertices[n].hit(point)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int hitSegment(Point point) {
        int n = 0;
        while (n < this.vertices.length - 1) {
            Point point2 = this.vertices[n].getPoint();
            Point point3 = this.vertices[n + 1].getPoint();
            this.workingSegment.reset(point2, point3);
            double d = this.workingSegment.distanceToPoint(point);
            if (d > 0.0 && d < 3.0) {
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    private boolean shouldDelete(int n) {
        Point point = this.vertices[n].getPoint();
        if (this.startPanel.getBounds().contains(point) || this.endPanel.getBounds().contains(point)) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.vertices.length) {
            if (n2 != n && this.vertices[n2].hit(point)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void deleteVertex(int n) {
        Vertex[] vertexArray = new Vertex[this.vertices.length - 1];
        System.arraycopy(this.vertices, 0, vertexArray, 0, n);
        System.arraycopy(this.vertices, n + 1, vertexArray, n, this.vertices.length - n - 1);
        this.vertices = vertexArray;
    }
}

