/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.line.EndPointPanel;
import org.acm.seguin.uml.line.LinedPanel;

public class DragPanelAdapter
implements MouseListener,
MouseMotionListener {
    private EndPointPanel panel;
    private LinedPanel parent;
    private Point mouseStart;
    private Point panelStart;

    public DragPanelAdapter(EndPointPanel endPointPanel, LinedPanel linedPanel) {
        this.panel = endPointPanel;
        this.parent = linedPanel;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = !this.panel.isSelected();
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (!mouseEvent.isControlDown()) {
            this.parent.deselectAll();
        }
        this.panel.setSelected(bl);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseStart = mouseEvent.getPoint();
        this.panelStart = this.panel.getLocation(this.panelStart);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.parent instanceof LinedPanel) {
                this.parent.drop();
            }
            if (this.parent instanceof UMLPackage) {
                ((UMLPackage)this.parent).setDirty();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            Point point = mouseEvent.getPoint();
            int n = point.x - this.mouseStart.x;
            int n2 = point.y - this.mouseStart.y;
            if (!this.panel.isSelected()) {
                this.panel.shift(n, n2);
            } else {
                this.parent.shift(n, n2);
            }
            this.parent.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

