/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import org.acm.seguin.uml.UMLField;
import org.acm.seguin.uml.line.EndPointPanel;
import org.acm.seguin.uml.line.SegmentedLine;

public class AssociationRelationship
extends SegmentedLine {
    private UMLField field;
    private boolean dead;

    public AssociationRelationship(EndPointPanel endPointPanel, EndPointPanel endPointPanel2, UMLField uMLField) {
        super(endPointPanel, endPointPanel2);
        this.field = uMLField;
        this.dead = false;
        Point point = this.vertices[this.vertices.length - 2].getPoint();
        Point point2 = this.vertices[this.vertices.length - 1].getPoint();
        Dimension dimension = this.field.getSize();
        int n = point.x < point2.x ? point2.x - dimension.width - 10 : point2.x + 10;
        int n2 = point.y < point2.y ? point2.y - dimension.height - 10 : point2.y + 10;
        this.field.setLocation(n, n2);
    }

    public UMLField getField() {
        return this.field;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void save(PrintWriter printWriter) {
        printWriter.print("A[");
        this.saveStartPanel(printWriter);
        printWriter.print(",");
        printWriter.print(this.field.getSummary().getName());
        printWriter.print("]");
        this.saveVertices(printWriter);
        Point point = this.field.getUnscaledLocation();
        printWriter.println("{" + point.x + "," + point.y + "}");
    }

    public void delete() {
        this.dead = true;
    }

    protected void drawArrow(Graphics graphics) {
        int n = this.vertices.length;
        double d = this.vertices[n - 2].getPoint().getX();
        double d2 = this.vertices[n - 2].getPoint().getY();
        Point point = this.vertices[n - 1].getPoint();
        Point point2 = this.getArrowPointAbove();
        Point point3 = this.getArrowPointBelow();
        this.Xs[0] = (int)d;
        this.Xs[1] = (int)point.getX();
        this.Xs[2] = (int)point3.getX();
        this.Xs[3] = (int)point.getX();
        this.Xs[4] = (int)point2.getX();
        this.Ys[0] = (int)d2;
        this.Ys[1] = (int)point.getY();
        this.Ys[2] = (int)point3.getY();
        this.Ys[3] = (int)point.getY();
        this.Ys[4] = (int)point2.getY();
        graphics.drawPolyline(this.Xs, this.Ys, 5);
    }

    protected void updateEnd() {
        if (this.dead) {
            return;
        }
        int n = this.vertices.length;
        Point point = this.vertices[n - 1].getPoint();
        int n2 = point.x;
        int n3 = point.y;
        super.updateEnd();
        point = this.vertices[n - 1].getPoint();
        int n4 = point.x;
        int n5 = point.y;
        point = this.field.getLocation();
        int n6 = point.x;
        int n7 = point.y;
        this.field.setLocation(n6 + n4 - n2, n7 + n5 - n3);
    }
}

