/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.stub;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.acm.seguin.tools.stub.StubFile;

class StubGenFromZip {
    private String filename;
    private StubFile sf;

    public StubGenFromZip(String string, String string2, File file) {
        this.filename = string;
        this.sf = new StubFile(string2, file);
    }

    public void run() {
        try {
            ZipFile zipFile = new ZipFile(this.filename);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!this.applies(zipEntry)) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.generateStub(inputStream, zipEntry.getName());
                inputStream.close();
            }
            this.sf.done();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
    }

    private boolean applies(ZipEntry zipEntry) {
        return !zipEntry.isDirectory() && zipEntry.getName().endsWith(".java");
    }

    private void generateStub(InputStream inputStream, String string) {
        System.out.println("Generating a stub for:  " + string);
        this.sf.apply(inputStream, string);
    }
}

