/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.tools.install.TagEditorPanel;
import org.acm.seguin.tools.install.TagLinePanel;
import org.acm.seguin.tools.install.TagListModel;
import org.acm.seguin.util.MissingSettingsException;

public class TagEditorSettingPanel
extends SettingPanel {
    private JList listBox;
    private TagEditorPanel editor;
    private TagListModel listModel;
    private JButton upButton;
    private JButton downButton;
    private static final int CLASS_TYPE = 1;
    private static final int METHOD_TYPE = 2;
    private static final int FIELD_TYPE = 3;

    public TagEditorSettingPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.add((Component)new JLabel("The following are javadoc tags that are required by the system."), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel("To make the javadoc tag required, add the tag and include the description."), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)new JLabel("Use the up and down buttons to adjust the order that javadoc tags are."), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)new JLabel("sorted in."), gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 4;
        this.editor = new TagEditorPanel();
        this.editor.addUpdateListener(new UpdateTagListener());
        this.editor.addClearListener(new ClearTagListener());
        this.add((Component)this.editor, gridBagConstraints);
        this.listModel = new TagListModel();
        this.load();
        this.listBox = new JList(this.listModel);
        this.listBox.addListSelectionListener(new TagListener());
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this.listBox), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(new MoveUpListener());
        this.add((Component)this.upButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(new MoveDownListener());
        this.add((Component)this.downButton, gridBagConstraints);
    }

    public String getKey() {
        return "";
    }

    public void generateSetting(PrintWriter printWriter) {
        StringBuffer stringBuffer = new StringBuffer("class.tags=");
        boolean bl = false;
        StringBuffer stringBuffer2 = new StringBuffer("method.tags=");
        boolean bl2 = false;
        StringBuffer stringBuffer3 = new StringBuffer("field.tags=");
        boolean bl3 = false;
        printWriter.println("#");
        printWriter.println("#  The following are the tags and the order");
        printWriter.println("#  that are required in javadocs.  If there is");
        printWriter.println("#  description, then they are not required and the");
        printWriter.println("#  system is only specifying the order in which they");
        printWriter.println("#  should appear.  If a description is provided, then");
        printWriter.println("#  the tag is required.");
        printWriter.println("#");
        Iterator iterator = this.listModel.iterator();
        while (iterator.hasNext()) {
            TagLinePanel tagLinePanel = (TagLinePanel)iterator.next();
            if (tagLinePanel.getDescription().length() > 0) {
                printWriter.println(tagLinePanel.getTagName() + ".descr=" + tagLinePanel.getDescription());
                printWriter.println("");
            }
            if (tagLinePanel.isClassType()) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(tagLinePanel.getTagName());
                bl = true;
            }
            if (tagLinePanel.isMethodType()) {
                if (bl2) {
                    stringBuffer2.append(",");
                }
                stringBuffer2.append(tagLinePanel.getTagName());
                bl2 = true;
            }
            if (!tagLinePanel.isFieldType()) continue;
            if (bl3) {
                stringBuffer3.append(",");
            }
            stringBuffer3.append(tagLinePanel.getTagName());
            bl3 = true;
        }
        printWriter.println(stringBuffer.toString());
        printWriter.println(stringBuffer2.toString());
        printWriter.println(stringBuffer3.toString());
        printWriter.println(" ");
    }

    private void load() {
        TagLinePanel tagLinePanel;
        try {
            this.loadTags(SettingPanel.bundle.getString("class.tags"), 1);
        }
        catch (MissingSettingsException missingSettingsException) {
            tagLinePanel = new TagLinePanel();
            tagLinePanel.setTagName("author");
            tagLinePanel.setDescription("{0}");
            tagLinePanel.setClassType(true);
            this.listModel.add(tagLinePanel);
            tagLinePanel = new TagLinePanel();
            tagLinePanel.setTagName("created");
            tagLinePanel.setDescription("{1}");
            this.listModel.add(tagLinePanel);
            tagLinePanel.setClassType(true);
        }
        try {
            this.loadTags(SettingPanel.bundle.getString("method.tags"), 2);
            String string = SettingPanel.bundle.getString("param.descr");
            String string2 = SettingPanel.bundle.getString("return.descr");
            String string3 = SettingPanel.bundle.getString("exception.descr");
        }
        catch (MissingSettingsException missingSettingsException) {
            tagLinePanel = new TagLinePanel();
            tagLinePanel.setTagName("param");
            tagLinePanel.setDescription("Description of the Parameter");
            tagLinePanel.setMethodType(true);
            this.listModel.add(tagLinePanel);
            tagLinePanel = new TagLinePanel();
            tagLinePanel.setTagName("return");
            tagLinePanel.setDescription("Description of the Return Value");
            tagLinePanel.setMethodType(true);
            this.listModel.add(tagLinePanel);
            tagLinePanel = new TagLinePanel();
            tagLinePanel.setTagName("exception");
            tagLinePanel.setDescription("Description of the Exception");
            tagLinePanel.setMethodType(true);
            this.listModel.add(tagLinePanel);
        }
        try {
            this.loadTags(SettingPanel.bundle.getString("field.tags"), 3);
        }
        catch (MissingSettingsException missingSettingsException) {
            // empty catch block
        }
    }

    private void loadTags(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            TagLinePanel tagLinePanel = this.listModel.find(string2);
            if (tagLinePanel == null) {
                tagLinePanel = new TagLinePanel();
                tagLinePanel.setTagName(string2);
                this.listModel.add(tagLinePanel);
                try {
                    tagLinePanel.setDescription(SettingPanel.bundle.getString(string2 + ".descr"));
                }
                catch (MissingSettingsException missingSettingsException) {
                    tagLinePanel.setDescription("");
                }
            }
            if (n == 1) {
                tagLinePanel.setClassType(true);
            }
            if (n == 2) {
                tagLinePanel.setMethodType(true);
            }
            if (n != 3) continue;
            tagLinePanel.setFieldType(true);
        }
    }

    protected String getInitialValue() {
        return "";
    }

    public void reload() {
        this.listModel.clearAll();
        this.load();
    }

    public class MoveDownListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TagEditorSettingPanel.this.listBox.getSelectedIndex();
            if (n == TagEditorSettingPanel.this.listModel.getSize() - 1) {
                return;
            }
            TagEditorSettingPanel.this.listModel.swap(n, n + 1);
            TagEditorSettingPanel.this.listBox.setSelectedIndex(n + 1);
        }
    }

    public class MoveUpListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TagEditorSettingPanel.this.listBox.getSelectedIndex();
            if (n == 0) {
                return;
            }
            TagEditorSettingPanel.this.listModel.swap(n, n - 1);
            TagEditorSettingPanel.this.listBox.setSelectedIndex(n - 1);
        }
    }

    public class ClearTagListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TagEditorSettingPanel.this.editor.getTagName();
            TagEditorSettingPanel.this.listModel.remove(string);
        }
    }

    public class UpdateTagListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TagEditorSettingPanel.this.editor.getTagName();
            TagLinePanel tagLinePanel = TagEditorSettingPanel.this.listModel.find(string);
            boolean bl = false;
            if (tagLinePanel == null) {
                tagLinePanel = new TagLinePanel();
                TagEditorSettingPanel.this.listModel.add(tagLinePanel);
                bl = true;
            }
            TagEditorSettingPanel.this.editor.save(tagLinePanel);
            if (bl) {
                try {
                    TagEditorSettingPanel.this.listBox.setSelectedIndex(0);
                    TagEditorSettingPanel.this.listBox.setListData(new String[]{"Please wait..."});
                    TagEditorSettingPanel.this.listBox.setModel(TagEditorSettingPanel.this.listModel);
                    TagEditorSettingPanel.this.listBox.setSelectedIndex(TagEditorSettingPanel.this.listModel.getSize() - 1);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.out);
                }
            } else {
                TagEditorSettingPanel.this.listBox.repaint();
            }
        }
    }

    public class TagListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = TagEditorSettingPanel.this.listBox.getSelectedIndex();
            TagLinePanel tagLinePanel = (TagLinePanel)TagEditorSettingPanel.this.listModel.getElementAt(n);
            TagEditorSettingPanel.this.editor.load(tagLinePanel);
        }
    }
}

