/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.acm.seguin.tools.install.SettingPanel;

public abstract class SortSettingPanel
extends SettingPanel {
    protected GridBagConstraints constraints;
    private JCheckBox enabledCheckbox;
    private LinkedList list;
    private int order;

    public SortSettingPanel() {
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.ipadx = 0;
        this.constraints.ipady = 0;
        this.enabledCheckbox = new JCheckBox(this.getSortName() + " Enabled");
        this.enabledCheckbox.setSelected(true);
        this.add(this.enabledCheckbox, this.constraints);
        this.list = new LinkedList();
        this.order = 1000;
    }

    public boolean isSortEnabled() {
        return this.enabledCheckbox.isSelected();
    }

    public String getKey() {
        return "sort";
    }

    public int getOrder() {
        return this.order;
    }

    public abstract void generateSetting(PrintWriter var1, int var2);

    protected void setSortEnabled(boolean bl) {
        this.enabledCheckbox.setSelected(bl);
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((JComponent)iterator.next()).setEnabled(bl);
        }
    }

    protected void setOrder(int n) {
        this.order = n;
    }

    protected abstract String getSortName();

    public String toString() {
        return this.getSortName();
    }

    protected void addLabel(String string) {
        ++this.constraints.gridy;
        this.add(new JLabel(string), this.constraints);
    }

    protected void add(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        super.add((Component)jComponent, gridBagConstraints);
        if (this.list != null) {
            this.list.add(jComponent);
        }
    }

    protected void addListener() {
        this.enabledCheckbox.addChangeListener(new EnabledListener());
    }

    protected void generateSetting(PrintWriter printWriter, int n, String string) {
        this.printDescription(printWriter);
        if (!this.isSortEnabled()) {
            printWriter.print("#");
        }
        printWriter.println("sort." + n + "=" + this.getValue());
    }

    protected String getInitialValue() {
        return "";
    }

    private class EnabledListener
    implements ChangeListener {
        private EnabledListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = SortSettingPanel.this.enabledCheckbox.isSelected();
            Iterator iterator = SortSettingPanel.this.list.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }
}

