/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import org.acm.seguin.tools.install.SettingPanel;
import org.acm.seguin.util.MissingSettingsException;

public abstract class MultilineSettingPanel
extends SettingPanel {
    private JTextArea textArea;

    public MultilineSettingPanel() {
        this.setLayout(new GridBagLayout());
    }

    public String getValue() {
        return this.textArea.getText();
    }

    public String getDefaultValue() {
        int n = 1;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        while (bl) {
            try {
                stringBuffer.append(SettingPanel.bundle.getString(this.getKey() + "." + n));
                stringBuffer.append("\n");
                ++n;
            }
            catch (MissingSettingsException missingSettingsException) {
                bl = false;
            }
        }
        return stringBuffer.toString();
    }

    public void addControl() {
        this.textArea = new JTextArea();
        this.textArea.setText(this.getDefaultValue());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.textArea.setBorder(new EtchedBorder());
        this.add((Component)this.textArea, gridBagConstraints);
    }

    public void generateSetting(PrintWriter printWriter) {
        this.printDescription(printWriter);
        StringTokenizer stringTokenizer = new StringTokenizer(this.textArea.getText(), "\r\n");
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            printWriter.println(this.getKey() + "." + n + "=" + stringTokenizer.nextToken());
            ++n;
        }
        printWriter.println("");
    }

    protected String getInitialValue() {
        return "";
    }

    public void reload() {
        this.textArea.setText(this.getDefaultValue());
    }
}

