/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.factory.BufferParserFactory;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.parser.factory.InputStreamParserFactory;
import org.acm.seguin.parser.factory.ParserFactory;
import org.acm.seguin.summary.ImportSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.SummaryLoadVisitor;
import org.acm.seguin.summary.SummaryLoaderState;
import org.acm.seguin.summary.SummaryVisitor;
import org.acm.seguin.summary.TypeSummary;

public class FileSummary
extends Summary {
    private boolean delete;
    private static HashMap fileMap;
    private ArrayList importList;
    private boolean isMoving;
    private Date lastModified;
    private File theFile;
    private LinkedList typeList;

    protected FileSummary(Summary summary, File file) {
        super(summary);
        this.theFile = file;
        this.importList = null;
        this.typeList = null;
        this.isMoving = false;
        this.delete = false;
        this.lastModified = new Date();
    }

    public void setDeleted(boolean bl) {
        this.delete = bl;
    }

    public void setMoving(boolean bl) {
        this.isMoving = bl;
    }

    public File getFile() {
        return this.theFile;
    }

    public static FileSummary getFileSummary(File file) {
        FileSummary fileSummary;
        if (fileMap == null) {
            FileSummary.init();
        }
        if ((fileSummary = (FileSummary)fileMap.get(FileSummary.getKey(file))) == null) {
            SummaryLoaderState summaryLoaderState = FileSummary.loadNewFileSummary(file);
            fileSummary = FileSummary.linkFileSummary(summaryLoaderState, file);
        } else {
            Date date = new Date(file.lastModified());
            if (date.after(fileSummary.lastModified)) {
                FileSummary.resetFileSummary(file, fileSummary);
                fileSummary.lastModified = new Date(file.lastModified());
                FileParserFactory fileParserFactory = new FileParserFactory(file);
                SimpleNode simpleNode = fileParserFactory.getAbstractSyntaxTree(false);
                if (simpleNode == null) {
                    return null;
                }
                FileSummary.reloadFileSummary(file, fileSummary, simpleNode);
            }
        }
        return fileSummary;
    }

    public static FileSummary getFileSummary(String string) {
        BufferParserFactory bufferParserFactory = new BufferParserFactory(string);
        SimpleNode simpleNode = bufferParserFactory.getAbstractSyntaxTree(false);
        if (simpleNode == null || !FileSummary.hasType(simpleNode)) {
            return null;
        }
        SummaryLoaderState summaryLoaderState = new SummaryLoaderState();
        summaryLoaderState.setFile(null);
        simpleNode.jjtAccept(new SummaryLoadVisitor(), summaryLoaderState);
        FileSummary fileSummary = (FileSummary)summaryLoaderState.getCurrentSummary();
        ((PackageSummary)fileSummary.getParent()).addFileSummary(fileSummary);
        return fileSummary;
    }

    public Iterator getImports() {
        if (this.importList == null) {
            return null;
        }
        return ((AbstractList)this.importList).iterator();
    }

    protected static String getKey(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return "Unknown";
        }
    }

    public String getName() {
        if (this.theFile == null) {
            return "";
        }
        return this.theFile.getName();
    }

    public int getTypeCount() {
        if (this.typeList == null) {
            return 0;
        }
        return this.typeList.size();
    }

    public Iterator getTypes() {
        if (this.typeList == null) {
            return null;
        }
        return this.typeList.iterator();
    }

    public boolean isDeleted() {
        return this.delete;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public Object accept(SummaryVisitor summaryVisitor, Object object) {
        return summaryVisitor.visit(this, object);
    }

    protected void add(ImportSummary importSummary) {
        if (importSummary != null) {
            if (this.importList == null) {
                this.initImportList();
            }
            this.importList.add(importSummary);
        }
    }

    protected void add(TypeSummary typeSummary) {
        if (typeSummary != null) {
            if (this.typeList == null) {
                this.initTypeList();
            }
            this.typeList.add(typeSummary);
        }
    }

    private static boolean hasType(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            if (simpleNode.jjtGetChild(n2) instanceof ASTTypeDeclaration) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void init() {
        if (fileMap == null) {
            fileMap = new HashMap();
        }
    }

    private void initImportList() {
        this.importList = new ArrayList();
    }

    private void initTypeList() {
        this.typeList = new LinkedList();
    }

    private static FileSummary linkFileSummary(SummaryLoaderState summaryLoaderState, File file) {
        FileSummary fileSummary = (FileSummary)summaryLoaderState.getCurrentSummary();
        ((PackageSummary)fileSummary.getParent()).addFileSummary(fileSummary);
        fileMap.put(FileSummary.getKey(file), fileSummary);
        return fileSummary;
    }

    private static SummaryLoaderState loadNewFileSummary(File file) {
        FileParserFactory fileParserFactory = new FileParserFactory(file);
        SimpleNode simpleNode = fileParserFactory.getAbstractSyntaxTree(false);
        if (simpleNode == null) {
            return null;
        }
        SummaryLoaderState summaryLoaderState = new SummaryLoaderState();
        summaryLoaderState.setFile(file);
        simpleNode.jjtAccept(new SummaryLoadVisitor(), summaryLoaderState);
        return summaryLoaderState;
    }

    static void register(FileSummary fileSummary) {
        File file;
        if (fileMap == null) {
            FileSummary.init();
        }
        if ((file = fileSummary.getFile()) == null) {
            return;
        }
        fileMap.put(FileSummary.getKey(file), fileSummary);
    }

    private static void reloadFileSummary(File file, FileSummary fileSummary, SimpleNode simpleNode) {
        SummaryLoaderState summaryLoaderState = new SummaryLoaderState();
        summaryLoaderState.setFile(file);
        summaryLoaderState.startSummary(fileSummary);
        summaryLoaderState.setCode(1);
        simpleNode.jjtAccept(new SummaryLoadVisitor(), summaryLoaderState);
    }

    public static FileSummary reloadFromBuffer(File file, InputStream inputStream) {
        Object object;
        if (fileMap == null) {
            FileSummary.init();
        }
        if (file == null) {
            System.out.println("No file!");
            return null;
        }
        String string = FileSummary.getKey(file);
        if (string == null) {
            System.out.println("No key:  " + file.toString());
            return null;
        }
        FileSummary fileSummary = (FileSummary)fileMap.get(string);
        if (fileSummary == null) {
            System.out.println("No initial file summary");
            object = FileSummary.loadNewFileSummary(file);
            fileSummary = FileSummary.linkFileSummary((SummaryLoaderState)object, file);
            if (fileSummary == null) {
                System.out.println("Unable to load the file summary from the file");
                return null;
            }
        }
        FileSummary.resetFileSummary(file, fileSummary);
        fileSummary.lastModified = new Date(file.lastModified());
        object = inputStream == null ? new FileParserFactory(file) : new InputStreamParserFactory(inputStream, string);
        SimpleNode simpleNode = ((ParserFactory)object).getAbstractSyntaxTree(false);
        if (simpleNode == null) {
            System.out.println("Unable to get a parse tree for this file:  Using existing file summary");
            return fileSummary;
        }
        FileSummary.reloadFileSummary(file, fileSummary, simpleNode);
        return fileSummary;
    }

    public static void removeAll() {
        fileMap = null;
        FileSummary.init();
    }

    public static void removeDeletedSummaries() {
        File file;
        Object object;
        if (fileMap == null) {
            FileSummary.init();
            return;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        Iterator iterator = fileMap.values().iterator();
        while (iterator.hasNext()) {
            object = (FileSummary)iterator.next();
            file = ((FileSummary)object).getFile();
            if (file == null || file.exists()) continue;
            linkedList.add(file);
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            file = (File)object.next();
            FileSummary.removeFileSummary(file);
        }
    }

    public static void removeFileSummary(File file) {
        String string;
        FileSummary fileSummary;
        if (fileMap == null) {
            FileSummary.init();
        }
        if ((fileSummary = (FileSummary)fileMap.get(string = FileSummary.getKey(file))) != null) {
            fileMap.remove(string);
            PackageSummary packageSummary = (PackageSummary)fileSummary.getParent();
            packageSummary.deleteFileSummary(fileSummary);
        }
    }

    private static void resetFileSummary(File file, FileSummary fileSummary) {
        if (fileSummary == null) {
            return;
        }
        fileSummary.theFile = file;
        fileSummary.importList = null;
        fileSummary.typeList = null;
        fileSummary.isMoving = false;
        fileSummary.delete = false;
    }

    public String toString() {
        if (this.theFile == null) {
            return "FileSummary<Framework File>";
        }
        return "FileSummary<" + this.theFile.getName() + ">";
    }
}

