/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RemoveImportTransform;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.refactor.type.RemoveSamePackageTransform;
import org.acm.seguin.refactor.type.State;
import org.acm.seguin.summary.FieldAccessSummary;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.ImportSummary;
import org.acm.seguin.summary.LocalVariableSummary;
import org.acm.seguin.summary.MessageSendSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TraversalVisitor;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.VariableSummary;

public abstract class TypeChangeVisitor
extends TraversalVisitor {
    private ComplexTransform refactoring;

    public TypeChangeVisitor(ComplexTransform complexTransform) {
        this.refactoring = complexTransform;
    }

    public Object visit(Summary summary, Object object) {
        return object;
    }

    public Object visit(FileSummary fileSummary, Object object) {
        Object object2;
        if (fileSummary.getFile() == null) {
            return null;
        }
        if (!this.preconditions(fileSummary)) {
            return null;
        }
        this.refactoring.clear();
        LinkedList linkedList = this.getAppropriateClasses(fileSummary);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            boolean bl = this.checkImports(fileSummary, object2);
            if (!this.checkTypes(fileSummary, this.getState(bl, fileSummary, (String)object2))) continue;
            AddImportTransform addImportTransform = this.getNewImports(fileSummary, (String)object2);
            if (addImportTransform != null) {
                addImportTransform.setIgnorePackageName(true);
                this.refactoring.add(addImportTransform);
            }
            this.addRenamingTransforms(this.refactoring, fileSummary, (String)object2);
        }
        this.refactoring.add(this.getFileSpecificTransform(fileSummary));
        if (this.refactoring.hasAnyChanges()) {
            object2 = fileSummary.getFile();
            File file = this.getNewFile(fileSummary);
            System.out.println("Updating:  " + ((File)object2).getName());
            this.refactoring.add(new RemoveSamePackageTransform());
            this.refactoring.apply((File)object2, file);
        }
        return this.refactoring;
    }

    public Object visit(ImportSummary importSummary, Object object) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = importSummary.getPackage().getName().equals(this.getCurrentPackage());
        if (bl3) {
            String string = importSummary.getType();
            if (string == null) {
                bl2 = true;
            } else {
                String string2 = (String)object;
                bl = string2.equals(string);
            }
        }
        if (bl) {
            this.refactoring.add(this.getRemoveImportTransform(importSummary));
        }
        return new Boolean(bl2 || bl);
    }

    public Object visit(TypeSummary typeSummary, Object object) {
        Summary summary;
        Boolean bl = new Boolean(false);
        TypeDeclSummary typeDeclSummary = typeSummary.getParentClass();
        if (typeDeclSummary != null) {
            bl = (Boolean)typeDeclSummary.accept(this, object);
        }
        if (bl.booleanValue()) {
            return bl;
        }
        Iterator iterator = typeSummary.getImplementedInterfaces();
        if (iterator != null) {
            while (iterator.hasNext()) {
                summary = (TypeDeclSummary)iterator.next();
                bl = (Boolean)((TypeDeclSummary)summary).accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        if ((iterator = typeSummary.getFields()) != null) {
            while (iterator.hasNext()) {
                summary = (FieldSummary)iterator.next();
                bl = (Boolean)((FieldSummary)summary).accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        if ((iterator = typeSummary.getMethods()) != null) {
            while (iterator.hasNext()) {
                summary = (MethodSummary)iterator.next();
                bl = (Boolean)((MethodSummary)summary).accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        if ((iterator = typeSummary.getTypes()) != null) {
            while (iterator.hasNext()) {
                summary = (TypeSummary)iterator.next();
                bl = (Boolean)((TypeSummary)summary).accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        return bl;
    }

    public Object visit(MethodSummary methodSummary, Object object) {
        Summary summary;
        Boolean bl = new Boolean(false);
        TypeDeclSummary typeDeclSummary = methodSummary.getReturnType();
        if (typeDeclSummary != null && (bl = (Boolean)typeDeclSummary.accept(this, object)).booleanValue()) {
            return bl;
        }
        Iterator iterator = methodSummary.getParameters();
        if (iterator != null) {
            while (iterator.hasNext()) {
                summary = (ParameterSummary)iterator.next();
                bl = (Boolean)((ParameterSummary)summary).accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        if ((iterator = methodSummary.getExceptions()) != null) {
            while (iterator.hasNext()) {
                summary = (TypeDeclSummary)iterator.next();
                bl = (Boolean)((TypeDeclSummary)summary).accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        if ((iterator = methodSummary.getDependencies()) != null) {
            while (iterator.hasNext()) {
                summary = (Summary)iterator.next();
                bl = (Boolean)summary.accept(this, object);
                if (!bl.booleanValue()) continue;
                return bl;
            }
        }
        return bl;
    }

    public Object visit(FieldSummary fieldSummary, Object object) {
        return this.visit((VariableSummary)fieldSummary, object);
    }

    public Object visit(ParameterSummary parameterSummary, Object object) {
        return this.visit((VariableSummary)parameterSummary, object);
    }

    public Object visit(LocalVariableSummary localVariableSummary, Object object) {
        return this.visit((VariableSummary)localVariableSummary, object);
    }

    public Object visit(VariableSummary variableSummary, Object object) {
        return variableSummary.getTypeDecl().accept(this, object);
    }

    public Object visit(TypeDeclSummary typeDeclSummary, Object object) {
        State state = (State)object;
        boolean bl = state.isPackageRequired();
        String string = state.getClassName();
        String string2 = typeDeclSummary.getPackage();
        if (this.isMatchingPackage(string2, bl)) {
            return new Boolean(string.equals(typeDeclSummary.getType()));
        }
        return new Boolean(false);
    }

    public Object visit(MessageSendSummary messageSendSummary, Object object) {
        State state = (State)object;
        boolean bl = state.isPackageRequired();
        String string = state.getClassName();
        boolean bl2 = messageSendSummary.getObjectName() != null && messageSendSummary.getObjectName().equals(string);
        boolean bl3 = this.isMatchingPackage(messageSendSummary.getPackageName(), bl);
        return new Boolean(bl2 && bl3);
    }

    public Object visit(FieldAccessSummary fieldAccessSummary, Object object) {
        State state = (State)object;
        boolean bl = state.isPackageRequired();
        String string = state.getClassName();
        boolean bl2 = fieldAccessSummary.getObjectName() != null && fieldAccessSummary.getObjectName().equals(string);
        boolean bl3 = this.isMatchingPackage(fieldAccessSummary.getPackageName(), bl);
        return new Boolean(bl2 && bl3);
    }

    protected State getState(boolean bl, FileSummary fileSummary, String string) {
        boolean bl2 = !bl && !this.isSamePackage(fileSummary);
        return new State(string, bl2);
    }

    protected abstract TransformAST getFileSpecificTransform(FileSummary var1);

    protected abstract AddImportTransform getNewImports(FileSummary var1, String var2);

    protected abstract RemoveImportTransform getRemoveImportTransform(ImportSummary var1);

    protected abstract LinkedList getAppropriateClasses(FileSummary var1);

    protected abstract File getNewFile(FileSummary var1);

    protected abstract String getCurrentPackage();

    protected boolean preconditions(FileSummary fileSummary) {
        return true;
    }

    protected abstract void addRenamingTransforms(ComplexTransform var1, FileSummary var2, String var3);

    private boolean isSamePackage(FileSummary fileSummary) {
        PackageSummary packageSummary = (PackageSummary)fileSummary.getParent();
        return packageSummary.getName().equals(this.getCurrentPackage());
    }

    private boolean isMatchingPackage(String string, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = string == null;
        if (bl && bl2) {
            return false;
        }
        return bl2 || string.equals(this.getCurrentPackage());
    }

    private boolean checkImports(FileSummary fileSummary, Object object) {
        Iterator iterator = fileSummary.getImports();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ImportSummary importSummary = (ImportSummary)iterator.next();
                Object object2 = importSummary.accept(this, object);
                if (!((Boolean)object2).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkTypes(FileSummary fileSummary, Object object) {
        Iterator iterator = fileSummary.getTypes();
        if (iterator != null) {
            while (iterator.hasNext()) {
                TypeSummary typeSummary = (TypeSummary)iterator.next();
                if (!((Boolean)typeSummary.accept(this, object)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

