/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RemoveImportTransform;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.refactor.type.ChangePackageTransform;
import org.acm.seguin.refactor.type.RenameTypeTransform;
import org.acm.seguin.refactor.type.TypeChangeVisitor;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.ImportSummary;
import org.acm.seguin.summary.query.FileSummaryGetter;
import org.acm.seguin.summary.query.MovingTypeList;
import org.acm.seguin.summary.query.StayingTypeList;

public class MoveClassVisitor
extends TypeChangeVisitor {
    private String oldPackageName;
    private String newPackageName;
    private File base;

    public MoveClassVisitor(String string, String string2, File file, ComplexTransform complexTransform) {
        super(complexTransform);
        this.oldPackageName = string;
        this.newPackageName = string2;
        this.base = file;
    }

    protected TransformAST getFileSpecificTransform(FileSummary fileSummary) {
        if (fileSummary.isMoving()) {
            return new ChangePackageTransform(this.newPackageName);
        }
        return null;
    }

    protected AddImportTransform getNewImports(FileSummary fileSummary, String string) {
        String string2 = "";
        String string3 = "";
        if (fileSummary.isMoving()) {
            string2 = this.oldPackageName;
            string3 = this.newPackageName;
        } else {
            string2 = this.newPackageName;
            string3 = this.oldPackageName;
        }
        return new AddImportTransform(string2, string);
    }

    protected RemoveImportTransform getRemoveImportTransform(ImportSummary importSummary) {
        if (importSummary.getType() == null) {
            return null;
        }
        return new RemoveImportTransform(this.oldPackageName, importSummary.getType());
    }

    protected LinkedList getAppropriateClasses(FileSummary fileSummary) {
        if (!fileSummary.isMoving()) {
            MovingTypeList movingTypeList = new MovingTypeList();
            return movingTypeList.query(this.oldPackageName);
        }
        StayingTypeList stayingTypeList = new StayingTypeList();
        return stayingTypeList.query(this.oldPackageName);
    }

    protected File getNewFile(FileSummary fileSummary) {
        if (!fileSummary.isMoving()) {
            return fileSummary.getFile();
        }
        File file = this.base;
        StringTokenizer stringTokenizer = new StringTokenizer(this.newPackageName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            file = new File(file, stringTokenizer.nextToken());
        }
        return new File(file, fileSummary.getName());
    }

    protected String getCurrentPackage() {
        return this.oldPackageName;
    }

    protected void addRenamingTransforms(ComplexTransform complexTransform, FileSummary fileSummary, String string) {
        String string2 = "";
        String string3 = "";
        if (fileSummary.isMoving()) {
            string2 = this.oldPackageName;
            string3 = this.newPackageName;
        } else {
            string2 = this.newPackageName;
            string3 = this.oldPackageName;
        }
        if (string3.length() > 0) {
            complexTransform.add(new RenameTypeTransform(string3, string2, string));
        }
    }

    protected void add(String string) {
        FileSummary fileSummary = new FileSummaryGetter().query(this.oldPackageName, string);
        if (fileSummary != null) {
            fileSummary.setMoving(true);
        } else {
            System.out.println("WARNING:  Unable to find the class " + string + " in the package " + this.oldPackageName);
        }
    }
}

