/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.type.AddClassRefactoring;
import org.acm.seguin.refactor.type.CreateClass;
import org.acm.seguin.refactor.type.RenameParentTypeTransform;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class AddAbstractParent
extends AddClassRefactoring {
    protected AddAbstractParent() {
    }

    public void setParentName(String string) {
        this.setNewClassName(string);
    }

    public String getDescription() {
        return "Adds a parent class named " + this.getNewClassName();
    }

    public int getID() {
        return 3;
    }

    public void addChildClass(String string, String string2) {
        this.addTargetClass(GetTypeSummary.query(PackageSummary.getPackageSummary(string), string2));
    }

    public void addChildClass(TypeSummary typeSummary) {
        this.addTargetClass(typeSummary);
    }

    protected void createClass(TypeSummary typeSummary, String string) {
        try {
            CreateClass createClass = new CreateClass(typeSummary, string, true);
            File file = createClass.run();
            this.getComplexTransform().createFile(file);
        }
        catch (RefactoringException refactoringException) {
            System.out.println(refactoringException.getMessage());
        }
    }

    protected void transformOriginal(TypeSummary typeSummary) {
        FileSummary fileSummary = (FileSummary)typeSummary.getParent();
        File file = fileSummary.getFile();
        PackageSummary packageSummary = (PackageSummary)fileSummary.getParent();
        ComplexTransform complexTransform = this.getComplexTransform();
        complexTransform.add(this.createRenameType(typeSummary, packageSummary));
        complexTransform.apply(file, file);
    }

    RenameParentTypeTransform createRenameType(TypeSummary typeSummary, PackageSummary packageSummary) {
        RenameParentTypeTransform renameParentTypeTransform = new RenameParentTypeTransform();
        renameParentTypeTransform.setNewName(this.getNewClassName());
        renameParentTypeTransform.setOldName(typeSummary.getName());
        return renameParentTypeTransform;
    }
}

