/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.util.Iterator;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.AddMethodTransform;
import org.acm.seguin.refactor.method.AddMethodTypeVisitor;
import org.acm.seguin.refactor.method.InvokeMovedMethodTransform;
import org.acm.seguin.refactor.method.MethodRefactoring;
import org.acm.seguin.refactor.method.MoveMethodVisitor;
import org.acm.seguin.refactor.method.RemoveMethodTransform;
import org.acm.seguin.summary.FieldAccessSummary;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.MessageSendSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.VariableSummary;
import org.acm.seguin.summary.query.FieldQuery;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.summary.query.MethodQuery;
import org.acm.seguin.summary.query.SamePackage;

public class MoveMethodRefactoring
extends MethodRefactoring {
    private MethodSummary methodSummary;
    private TypeSummary typeSummary;
    private Summary destination;

    protected MoveMethodRefactoring() {
    }

    public void setMethod(MethodSummary methodSummary) {
        Summary summary = this.methodSummary = methodSummary;
        while (!(summary instanceof TypeSummary)) {
            summary = summary.getParent();
        }
        this.typeSummary = (TypeSummary)summary;
    }

    public void setDestination(Summary summary) {
        this.destination = summary;
    }

    public String getDescription() {
        return "Moving " + this.methodSummary.toString() + " from " + this.typeSummary.toString() + " to " + this.destination.toString();
    }

    public int getID() {
        return 204;
    }

    protected void preconditions() throws RefactoringException {
        Summary summary;
        Summary summary2;
        Iterator iterator = this.methodSummary.getDependencies();
        while (iterator != null && iterator.hasNext()) {
            summary2 = (Summary)iterator.next();
            if (summary2 instanceof FieldAccessSummary) {
                summary = (FieldAccessSummary)summary2;
                this.checkFieldAccess((FieldAccessSummary)summary);
                continue;
            }
            if (!(summary2 instanceof MessageSendSummary)) continue;
            summary = (MessageSendSummary)summary2;
            this.checkMessageSend((MessageSendSummary)summary);
        }
        if (this.destination instanceof VariableSummary) {
            summary2 = (VariableSummary)this.destination;
            summary = ((VariableSummary)summary2).getTypeDecl();
            TypeSummary typeSummary = GetTypeSummary.query(summary);
            if (typeSummary == null) {
                throw new RefactoringException("The parameter " + ((VariableSummary)summary2).getName() + " is a primitive");
            }
            FileSummary fileSummary = (FileSummary)typeSummary.getParent();
            if (fileSummary.getFile() == null) {
                throw new RefactoringException("The source code for " + typeSummary.getName() + " is not modifiable");
            }
        }
    }

    protected void transform() {
        TypeSummary typeSummary;
        ComplexTransform complexTransform = this.getComplexTransform();
        SimpleNode simpleNode = this.removeMethod(this.typeSummary, complexTransform);
        if (simpleNode == null) {
            return;
        }
        this.update(simpleNode);
        if (this.destination instanceof VariableSummary) {
            VariableSummary variableSummary = (VariableSummary)this.destination;
            TypeDeclSummary typeDeclSummary = variableSummary.getTypeDecl();
            typeSummary = GetTypeSummary.query(typeDeclSummary);
        } else if (this.destination instanceof TypeSummary) {
            typeSummary = (TypeSummary)this.destination;
        } else {
            return;
        }
        this.addMethodToDest(complexTransform, simpleNode, typeSummary);
    }

    protected SimpleNode removeMethod(TypeSummary typeSummary, ComplexTransform complexTransform) {
        RemoveMethodTransform removeMethodTransform = new RemoveMethodTransform(this.methodSummary);
        complexTransform.add(removeMethodTransform);
        InvokeMovedMethodTransform invokeMovedMethodTransform = new InvokeMovedMethodTransform(this.methodSummary, this.destination);
        complexTransform.add(invokeMovedMethodTransform);
        FileSummary fileSummary = (FileSummary)typeSummary.getParent();
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
        return removeMethodTransform.getMethodDeclaration();
    }

    protected void addMethodToDest(ComplexTransform complexTransform, SimpleNode simpleNode, TypeSummary typeSummary) {
        complexTransform.clear();
        AddMethodTransform addMethodTransform = new AddMethodTransform(simpleNode);
        complexTransform.add(addMethodTransform);
        AddMethodTypeVisitor addMethodTypeVisitor = new AddMethodTypeVisitor();
        this.methodSummary.accept(addMethodTypeVisitor, complexTransform);
        FileSummary fileSummary = (FileSummary)typeSummary.getParent();
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
    }

    private String getFieldGetter(FieldSummary fieldSummary) {
        String string = fieldSummary.getType();
        String string2 = "get";
        if (string.equalsIgnoreCase("boolean")) {
            string2 = "is";
        }
        String string3 = fieldSummary.getName();
        return string2 + string3.substring(0, 1).toUpperCase() + string3.substring(1);
    }

    private String getFieldSetter(FieldSummary fieldSummary) {
        String string = "set";
        String string2 = fieldSummary.getName();
        return string + string2.substring(0, 1).toUpperCase() + string2.substring(1);
    }

    private void checkFieldAccess(FieldAccessSummary fieldAccessSummary) throws RefactoringException {
        FieldSummary fieldSummary;
        if (fieldAccessSummary.getPackageName() == null && (fieldAccessSummary.getObjectName() == null || fieldAccessSummary.getObjectName().equals("this")) && (fieldSummary = FieldQuery.find(this.typeSummary, fieldAccessSummary.getFieldName())) != null && fieldSummary.getModifiers().isPrivate()) {
            this.checkForMethod(fieldAccessSummary, fieldSummary);
        }
    }

    private void checkForMethod(FieldAccessSummary fieldAccessSummary, FieldSummary fieldSummary) throws RefactoringException {
        String string = fieldAccessSummary.isAssignment() ? this.getFieldSetter(fieldSummary) : this.getFieldGetter(fieldSummary);
        MethodSummary methodSummary = MethodQuery.find(this.typeSummary, string);
        if (methodSummary == null) {
            throw new RefactoringException("Unable to find the appropriate method (" + string + ") for private field access in " + this.typeSummary.getName());
        }
    }

    private void update(SimpleNode simpleNode) {
        MoveMethodVisitor moveMethodVisitor = new MoveMethodVisitor(this.typeSummary, this.methodSummary, this.destination);
        simpleNode.jjtAccept(moveMethodVisitor, null);
    }

    private void checkMessageSend(MessageSendSummary messageSendSummary) throws RefactoringException {
        if (messageSendSummary.getPackageName() == null && (messageSendSummary.getObjectName() == null || messageSendSummary.getObjectName().equals("this"))) {
            MethodSummary methodSummary = MethodQuery.find(this.typeSummary, messageSendSummary.getMessageName());
            if (methodSummary == null) {
                throw new RefactoringException("Unable to find the method (" + messageSendSummary.getMessageName() + ") in " + this.typeSummary.getName());
            }
            if (methodSummary.getModifiers().isPrivate()) {
                throw new RefactoringException("Moving a method (" + messageSendSummary.getMessageName() + ") from " + this.typeSummary.getName() + " that requires private access is illegal");
            }
            if (methodSummary.getModifiers().isPackage()) {
                TypeSummary typeSummary;
                if (this.destination instanceof VariableSummary) {
                    VariableSummary variableSummary = (VariableSummary)this.destination;
                    TypeDeclSummary typeDeclSummary = variableSummary.getTypeDecl();
                    typeSummary = GetTypeSummary.query(typeDeclSummary);
                } else if (this.destination instanceof TypeSummary) {
                    typeSummary = (TypeSummary)this.destination;
                } else {
                    throw new RefactoringException("Cannot find the type associated with " + this.destination.getName());
                }
                if (!SamePackage.query(this.typeSummary, typeSummary)) {
                    throw new RefactoringException("Moving a method (" + messageSendSummary.getMessageName() + ") from " + this.typeSummary.getName() + " to a different package that requires package access is illegal.");
                }
            }
        }
    }
}

