/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.method.AddMethodTransform;
import org.acm.seguin.refactor.method.AddMethodTypeVisitor;
import org.acm.seguin.refactor.method.MethodRefactoring;
import org.acm.seguin.refactor.method.RemoveMethodTransform;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.SameMethod;

abstract class InheretenceMethodRefactoring
extends MethodRefactoring {
    protected MethodSummary methodSummary = null;

    InheretenceMethodRefactoring() {
    }

    public void setMethod(MethodSummary methodSummary) {
        this.methodSummary = methodSummary;
    }

    protected void checkDestination(TypeSummary typeSummary) throws RefactoringException {
        MethodSummary methodSummary = SameMethod.find(typeSummary, this.methodSummary);
        if (methodSummary != null) {
            ModifierHolder modifierHolder = methodSummary.getModifiers();
            if (!modifierHolder.isAbstract()) {
                throw new RefactoringException("A method with the same signature (name and parameter types) already exists in the " + typeSummary.getName() + " class");
            }
        } else if (SameMethod.findConflict(typeSummary, this.methodSummary) != null) {
            throw new RefactoringException("A method with the conflicting signature (name and parameter types) already exists in the " + typeSummary.getName() + " class");
        }
    }

    protected ASTMethodDeclaration updateMethod(SimpleNode simpleNode) {
        ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)simpleNode.jjtGetChild(0);
        ModifierHolder modifierHolder = aSTMethodDeclaration.getModifiers();
        if (!modifierHolder.isPublic()) {
            modifierHolder.setPrivate(false);
            modifierHolder.setProtected(true);
        }
        return aSTMethodDeclaration;
    }

    protected void addMethodToDest(ComplexTransform complexTransform, RemoveMethodTransform removeMethodTransform, SimpleNode simpleNode, TypeSummary typeSummary) {
        complexTransform.clear();
        complexTransform.add(removeMethodTransform);
        AddMethodTransform addMethodTransform = new AddMethodTransform(simpleNode);
        complexTransform.add(addMethodTransform);
        AddMethodTypeVisitor addMethodTypeVisitor = new AddMethodTypeVisitor();
        this.methodSummary.accept(addMethodTypeVisitor, complexTransform);
        FileSummary fileSummary = (FileSummary)typeSummary.getParent();
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
    }
}

