/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.util.Iterator;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TraversalVisitor;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class AddMethodTypeVisitor
extends TraversalVisitor {
    private boolean methodContents;

    public AddMethodTypeVisitor() {
        this.methodContents = true;
    }

    public AddMethodTypeVisitor(boolean bl) {
        this.methodContents = bl;
    }

    public Object visit(TypeDeclSummary typeDeclSummary, Object object) {
        if (typeDeclSummary.isPrimitive()) {
            return object;
        }
        TypeSummary typeSummary = GetTypeSummary.query(typeDeclSummary);
        if (typeSummary != null) {
            this.addTransform(object, new AddImportTransform(typeSummary));
        }
        return object;
    }

    public Object visit(MethodSummary methodSummary, Object object) {
        Summary summary;
        Iterator iterator;
        TypeDeclSummary typeDeclSummary = methodSummary.getReturnType();
        if (typeDeclSummary != null) {
            typeDeclSummary.accept(this, object);
        }
        if ((iterator = methodSummary.getParameters()) != null) {
            while (iterator.hasNext()) {
                summary = (Summary)iterator.next();
                summary.accept(this, object);
            }
        }
        if ((iterator = methodSummary.getExceptions()) != null) {
            while (iterator.hasNext()) {
                summary = (Summary)iterator.next();
                summary.accept(this, object);
            }
        }
        if (this.methodContents && (iterator = methodSummary.getDependencies()) != null) {
            while (iterator.hasNext()) {
                summary = (Summary)iterator.next();
                summary.accept(this, object);
            }
        }
        return object;
    }

    private void addTransform(Object object, AddImportTransform addImportTransform) {
        if (object instanceof ComplexTransform) {
            ComplexTransform complexTransform = (ComplexTransform)object;
            complexTransform.add(addImportTransform);
        } else if (object instanceof SimpleNode) {
            SimpleNode simpleNode = (SimpleNode)object;
            addImportTransform.update(simpleNode);
        }
    }
}

