/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.acm.seguin.parser.ChildrenVisitor;
import org.acm.seguin.parser.ast.ASTArguments;
import org.acm.seguin.parser.ast.ASTConstructorDeclaration;
import org.acm.seguin.parser.ast.ASTFieldDeclaration;
import org.acm.seguin.parser.ast.ASTMethodDeclaration;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTPackageDeclaration;
import org.acm.seguin.parser.ast.ASTPrimaryExpression;
import org.acm.seguin.parser.ast.ASTPrimaryPrefix;
import org.acm.seguin.parser.ast.ASTPrimarySuffix;
import org.acm.seguin.parser.ast.ASTUnmodifiedClassDeclaration;
import org.acm.seguin.parser.ast.ASTUnmodifiedInterfaceDeclaration;
import org.acm.seguin.parser.ast.ASTVariableDeclarator;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.refactor.field.RenameFieldData;
import org.acm.seguin.summary.LocalVariableSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.VariableSummary;
import org.acm.seguin.summary.query.GetMethodSummary;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.summary.query.ImportsType;
import org.acm.seguin.summary.query.LookupVariable;

public class RenameFieldVisitor
extends ChildrenVisitor {
    public Object visit(ASTPackageDeclaration aSTPackageDeclaration, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        ASTName aSTName = (ASTName)aSTPackageDeclaration.jjtGetChild(0);
        PackageSummary packageSummary = PackageSummary.getPackageSummary(aSTName.getName());
        renameFieldData.setCurrentSummary(packageSummary);
        return super.visit(aSTPackageDeclaration, object);
    }

    public Object visit(ASTUnmodifiedClassDeclaration aSTUnmodifiedClassDeclaration, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        Summary summary = renameFieldData.getCurrentSummary();
        if (summary == null) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query("", aSTUnmodifiedClassDeclaration.getName()));
        } else if (summary instanceof PackageSummary) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query((PackageSummary)summary, aSTUnmodifiedClassDeclaration.getName()));
        } else if (summary instanceof TypeSummary) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query((TypeSummary)summary, aSTUnmodifiedClassDeclaration.getName()));
        } else if (summary instanceof MethodSummary) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query((MethodSummary)summary, aSTUnmodifiedClassDeclaration.getName()));
        }
        Object object2 = super.visit(aSTUnmodifiedClassDeclaration, object);
        renameFieldData.setCurrentSummary(summary);
        return object2;
    }

    public Object visit(ASTUnmodifiedInterfaceDeclaration aSTUnmodifiedInterfaceDeclaration, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        Summary summary = renameFieldData.getCurrentSummary();
        if (summary == null) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query("", aSTUnmodifiedInterfaceDeclaration.getName()));
        } else if (summary instanceof PackageSummary) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query((PackageSummary)summary, aSTUnmodifiedInterfaceDeclaration.getName()));
        } else if (summary instanceof TypeSummary) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query((TypeSummary)summary, aSTUnmodifiedInterfaceDeclaration.getName()));
        } else if (summary instanceof MethodSummary) {
            renameFieldData.setCurrentSummary(GetTypeSummary.query((MethodSummary)summary, aSTUnmodifiedInterfaceDeclaration.getName()));
        }
        Object object2 = super.visit(aSTUnmodifiedInterfaceDeclaration, object);
        renameFieldData.setCurrentSummary(summary);
        return object2;
    }

    public Object visit(ASTFieldDeclaration aSTFieldDeclaration, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        if (renameFieldData.getCurrentSummary() == renameFieldData.getTypeSummary()) {
            int n = 1;
            while (n < aSTFieldDeclaration.jjtGetNumChildren()) {
                ASTVariableDeclarator aSTVariableDeclarator = (ASTVariableDeclarator)aSTFieldDeclaration.jjtGetChild(n);
                ASTVariableDeclaratorId aSTVariableDeclaratorId = (ASTVariableDeclaratorId)aSTVariableDeclarator.jjtGetChild(0);
                if (aSTVariableDeclaratorId.getName().equals(renameFieldData.getOldName())) {
                    aSTVariableDeclaratorId.setName(renameFieldData.getNewName());
                }
                ++n;
            }
        }
        return super.visit(aSTFieldDeclaration, object);
    }

    public Object visit(ASTPrimaryExpression aSTPrimaryExpression, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        ASTPrimaryPrefix aSTPrimaryPrefix = (ASTPrimaryPrefix)aSTPrimaryExpression.jjtGetChild(0);
        if ("this".equals(aSTPrimaryPrefix.getName())) {
            this.processThisExpression(renameFieldData, aSTPrimaryExpression, aSTPrimaryPrefix);
        } else if (aSTPrimaryPrefix.jjtGetNumChildren() >= 1 && aSTPrimaryPrefix.jjtGetChild(0) instanceof ASTName) {
            this.processNameExpression(renameFieldData, aSTPrimaryExpression, aSTPrimaryPrefix);
        }
        return super.visit(aSTPrimaryExpression, object);
    }

    public Object visit(ASTMethodDeclaration aSTMethodDeclaration, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        Summary summary = renameFieldData.getCurrentSummary();
        MethodSummary methodSummary = GetMethodSummary.query((TypeSummary)summary, aSTMethodDeclaration);
        renameFieldData.setCurrentSummary(methodSummary);
        renameFieldData.setMustInsertThis(this.isAlreadyPresent(methodSummary, renameFieldData.getNewName()));
        boolean bl = LookupVariable.getLocal(methodSummary, renameFieldData.getOldName()) != null;
        renameFieldData.setThisRequired(bl);
        Object object2 = super.visit(aSTMethodDeclaration, object);
        renameFieldData.setThisRequired(false);
        renameFieldData.setCurrentSummary(summary);
        return object2;
    }

    public Object visit(ASTConstructorDeclaration aSTConstructorDeclaration, Object object) {
        RenameFieldData renameFieldData = (RenameFieldData)object;
        Summary summary = renameFieldData.getCurrentSummary();
        MethodSummary methodSummary = GetMethodSummary.query((TypeSummary)summary, aSTConstructorDeclaration);
        renameFieldData.setCurrentSummary(methodSummary);
        renameFieldData.setMustInsertThis(this.isAlreadyPresent(methodSummary, renameFieldData.getNewName()));
        boolean bl = LookupVariable.getLocal(methodSummary, renameFieldData.getOldName()) != null;
        renameFieldData.setThisRequired(bl);
        Object object2 = super.visit(aSTConstructorDeclaration, object);
        renameFieldData.setThisRequired(false);
        renameFieldData.setCurrentSummary(summary);
        return object2;
    }

    private boolean isAlreadyPresent(MethodSummary methodSummary, String string) {
        Summary summary;
        Iterator iterator = methodSummary.getParameters();
        if (iterator != null) {
            while (iterator.hasNext()) {
                summary = (ParameterSummary)iterator.next();
                if (!((VariableSummary)summary).getName().equals(string)) continue;
                return true;
            }
        }
        if ((iterator = methodSummary.getDependencies()) != null) {
            while (iterator.hasNext()) {
                summary = (Summary)iterator.next();
                if (!(summary instanceof LocalVariableSummary) || !summary.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private int shouldChangePart(ASTName aSTName, String string, Summary summary, boolean bl, TypeSummary typeSummary) {
        int n = aSTName.getNameSize() - 1;
        if (bl) {
            --n;
        }
        int n2 = -1;
        int n3 = n;
        while (n3 >= 0) {
            if (aSTName.getNamePart(n3).equals(string)) {
                n2 = n3;
            }
            --n3;
        }
        if (n2 == -1) {
            return -1;
        }
        VariableSummary variableSummary = LookupVariable.query((MethodSummary)summary, aSTName.getNamePart(0));
        if (variableSummary == null) {
            return -1;
        }
        TypeSummary typeSummary2 = GetTypeSummary.query(variableSummary.getTypeDecl());
        int n4 = 1;
        while (n4 < n2) {
            variableSummary = LookupVariable.queryFieldSummary(typeSummary2, aSTName.getNamePart(n4));
            if (variableSummary == null) {
                return -1;
            }
            typeSummary2 = GetTypeSummary.query(variableSummary.getTypeDecl());
            ++n4;
        }
        if (typeSummary2 == typeSummary) {
            return n2;
        }
        return -1;
    }

    private void processThisExpression(RenameFieldData renameFieldData, ASTPrimaryExpression aSTPrimaryExpression, ASTPrimaryPrefix aSTPrimaryPrefix) {
        if (renameFieldData.isAllowedToChangeThis() && aSTPrimaryExpression.jjtGetNumChildren() >= 2) {
            ASTPrimarySuffix aSTPrimarySuffix = (ASTPrimarySuffix)aSTPrimaryExpression.jjtGetChild(1);
            if (renameFieldData.getOldName().equals(aSTPrimarySuffix.getName())) {
                ASTPrimarySuffix aSTPrimarySuffix2;
                boolean bl = true;
                if (aSTPrimaryExpression.jjtGetNumChildren() >= 3 && (aSTPrimarySuffix2 = (ASTPrimarySuffix)aSTPrimaryExpression.jjtGetChild(2)).jjtGetChild(0) != null && aSTPrimarySuffix2.jjtGetChild(0) instanceof ASTArguments) {
                    bl = false;
                }
                if (bl) {
                    aSTPrimarySuffix.setName(renameFieldData.getNewName());
                }
            }
        }
    }

    private void processNameExpression(RenameFieldData renameFieldData, ASTPrimaryExpression aSTPrimaryExpression, ASTPrimaryPrefix aSTPrimaryPrefix) {
        ASTName aSTName = (ASTName)aSTPrimaryPrefix.jjtGetChild(0);
        if (!renameFieldData.isThisRequired()) {
            ASTPrimarySuffix aSTPrimarySuffix;
            boolean bl = false;
            if (aSTPrimaryExpression.jjtGetNumChildren() >= 2 && (aSTPrimarySuffix = (ASTPrimarySuffix)aSTPrimaryExpression.jjtGetChild(1)).jjtGetChild(0) != null && aSTPrimarySuffix.jjtGetChild(0) instanceof ASTArguments) {
                bl = true;
            }
            if (aSTName.getNameSize() > 1 || !bl) {
                if (renameFieldData.isAllowedToChangeFirst() && aSTName.getNamePart(0).equals(renameFieldData.getOldName())) {
                    aSTName.setNamePart(0, renameFieldData.getNewName());
                    if (renameFieldData.isMustInsertThis()) {
                        aSTName.insertNamePart(0, "this");
                    }
                } else {
                    int n = this.shouldChangePart(aSTName, renameFieldData.getOldName(), renameFieldData.getCurrentSummary(), bl, renameFieldData.getTypeSummary());
                    if (n > -1) {
                        aSTName.setNamePart(n, renameFieldData.getNewName());
                    }
                }
            }
        }
        if (renameFieldData.getOldField().getModifiers().isStatic()) {
            String string = aSTName.getName();
            if (string.startsWith(renameFieldData.getFullName())) {
                this.replaceNamePart(aSTName, renameFieldData.getFullName(), renameFieldData.getNewName());
            } else if (string.startsWith(renameFieldData.getImportedName()) && ImportsType.query(renameFieldData.getCurrentSummary(), renameFieldData.getTypeSummary())) {
                this.replaceNamePart(aSTName, renameFieldData.getImportedName(), renameFieldData.getNewName());
            }
        }
    }

    private void replaceNamePart(ASTName aSTName, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = -1;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            ++n;
        }
        if (aSTName.getNamePart(n).equals(string3)) {
            aSTName.setNamePart(n, string2);
        }
    }
}

