/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import java.util.Iterator;
import java.util.LinkedList;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.RefactoringException;
import org.acm.seguin.refactor.field.AddFieldTransform;
import org.acm.seguin.refactor.field.FieldRefactoring;
import org.acm.seguin.refactor.field.RemoveFieldTransform;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.FieldQuery;
import org.acm.seguin.summary.query.GetTypeSummary;

public class PushDownFieldRefactoring
extends FieldRefactoring {
    private LinkedList childTypes = new LinkedList();

    protected PushDownFieldRefactoring() {
        this.field = null;
        this.typeSummary = null;
    }

    public String getDescription() {
        return "Moves a field " + this.field + " into child classes of " + this.typeSummary.getName();
    }

    public int getID() {
        return 101;
    }

    public void addChild(String string, String string2) {
        this.addChild(GetTypeSummary.query(PackageSummary.getPackageSummary(string), string2));
    }

    public void addChild(TypeSummary typeSummary) {
        if (typeSummary != null) {
            System.out.println("Adding " + typeSummary.getName());
            this.childTypes.add(typeSummary);
        }
    }

    protected void preconditions() throws RefactoringException {
        if (this.field == null) {
            throw new RefactoringException("No field specified");
        }
        if (this.typeSummary == null) {
            throw new RefactoringException("No type specified");
        }
        if (this.childTypes.size() == 0) {
            throw new RefactoringException("No child types specified");
        }
        if (FieldQuery.query(this.typeSummary, this.field, 1) == null) {
            throw new RefactoringException("Field named " + this.field + " does not exist in " + this.typeSummary.getName());
        }
        if (((FileSummary)this.typeSummary.getParent()).getFile() == null) {
            throw new RefactoringException("Can't push down a field from source code that you don't have");
        }
        Iterator iterator = this.childTypes.iterator();
        while (iterator.hasNext()) {
            TypeSummary typeSummary = (TypeSummary)iterator.next();
            if (typeSummary == null) {
                throw new RefactoringException("Can't push down a field into source code that you don't have");
            }
            if (FieldQuery.query(typeSummary, this.field, 1) != null) {
                throw new RefactoringException("Field named " + this.field + " already exists in " + typeSummary.getName());
            }
            if (((FileSummary)typeSummary.getParent()).getFile() == null) {
                throw new RefactoringException("Can't push up a field into source code that you don't have");
            }
            TypeDeclSummary typeDeclSummary = typeSummary.getParentClass();
            TypeSummary typeSummary2 = GetTypeSummary.query(typeDeclSummary);
            if (typeSummary2 == this.typeSummary) continue;
            throw new RefactoringException("Trying to push a field from " + this.typeSummary.getName() + " to " + typeSummary.getName() + " and the destination is not a subclass of the source");
        }
    }

    protected void transform() {
        FileSummary fileSummary = this.getFileSummary(this.typeSummary);
        RemoveFieldTransform removeFieldTransform = new RemoveFieldTransform(this.field);
        ComplexTransform complexTransform = this.getComplexTransform();
        complexTransform.add(removeFieldTransform);
        complexTransform.apply(fileSummary.getFile(), fileSummary.getFile());
        SimpleNode simpleNode = removeFieldTransform.getFieldDeclaration();
        if (simpleNode == null) {
            return;
        }
        Iterator iterator = this.childTypes.iterator();
        while (iterator.hasNext()) {
            AddFieldTransform addFieldTransform = new AddFieldTransform(simpleNode);
            complexTransform.clear();
            complexTransform.add(addFieldTransform);
            Object object = this.getFieldType(simpleNode, fileSummary);
            if (object != null) {
                if (object instanceof TypeSummary && !this.isInJavaLang((TypeSummary)object)) {
                    complexTransform.add(new AddImportTransform((TypeSummary)object));
                } else if (object instanceof ASTName && !this.isInJavaLang((ASTName)object)) {
                    complexTransform.add(new AddImportTransform((ASTName)object));
                }
            }
            TypeSummary typeSummary = (TypeSummary)iterator.next();
            FileSummary fileSummary2 = (FileSummary)typeSummary.getParent();
            complexTransform.apply(fileSummary2.getFile(), fileSummary2.getFile());
        }
    }
}

