/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor;

import org.acm.seguin.refactor.field.FieldRefactoringFactory;
import org.acm.seguin.refactor.field.PushDownFieldRefactoring;
import org.acm.seguin.refactor.field.PushUpFieldRefactoring;
import org.acm.seguin.refactor.field.RenameFieldRefactoring;
import org.acm.seguin.refactor.method.ExtractMethodRefactoring;
import org.acm.seguin.refactor.method.MethodRefactoringFactory;
import org.acm.seguin.refactor.method.MoveMethodRefactoring;
import org.acm.seguin.refactor.method.PushDownMethodRefactoring;
import org.acm.seguin.refactor.method.PushUpAbstractMethodRefactoring;
import org.acm.seguin.refactor.method.PushUpMethodRefactoring;
import org.acm.seguin.refactor.method.RenameParameterRefactoring;
import org.acm.seguin.refactor.type.AddAbstractParent;
import org.acm.seguin.refactor.type.AddChildRefactoring;
import org.acm.seguin.refactor.type.ExtractInterfaceRefactoring;
import org.acm.seguin.refactor.type.MoveClass;
import org.acm.seguin.refactor.type.RemoveEmptyClassRefactoring;
import org.acm.seguin.refactor.type.RenameClassRefactoring;
import org.acm.seguin.refactor.type.TypeRefactoringFactory;

public class RefactoringFactory {
    private TypeRefactoringFactory typeFactory = new TypeRefactoringFactory();
    private FieldRefactoringFactory fieldFactory = new FieldRefactoringFactory();
    private MethodRefactoringFactory methodFactory = new MethodRefactoringFactory();
    private static RefactoringFactory singleton;

    protected RefactoringFactory() {
    }

    public AddChildRefactoring addChild() {
        this.prepare();
        return this.typeFactory.addChild();
    }

    public AddAbstractParent addParent() {
        this.prepare();
        return this.typeFactory.addParent();
    }

    public MoveClass moveClass() {
        this.prepare();
        return this.typeFactory.moveClass();
    }

    public RenameClassRefactoring renameClass() {
        this.prepare();
        return this.typeFactory.renameClass();
    }

    public RemoveEmptyClassRefactoring removeEmptyClass() {
        this.prepare();
        return this.typeFactory.removeEmptyClass();
    }

    public ExtractInterfaceRefactoring extractInterface() {
        this.prepare();
        return this.typeFactory.extractInterface();
    }

    public PushDownFieldRefactoring pushDownField() {
        this.prepare();
        return this.fieldFactory.pushDownField();
    }

    public RenameFieldRefactoring renameField() {
        this.prepare();
        return this.fieldFactory.renameField();
    }

    public PushUpFieldRefactoring pushUpField() {
        this.prepare();
        return this.fieldFactory.pushUpField();
    }

    public PushUpMethodRefactoring pushUpMethod() {
        this.prepare();
        return this.methodFactory.pushUpMethod();
    }

    public PushUpAbstractMethodRefactoring pushUpAbstractMethod() {
        this.prepare();
        return this.methodFactory.pushUpAbstractMethod();
    }

    public PushDownMethodRefactoring pushDownMethod() {
        this.prepare();
        return this.methodFactory.pushDownMethod();
    }

    public MoveMethodRefactoring moveMethod() {
        this.prepare();
        return this.methodFactory.moveMethod();
    }

    public RenameParameterRefactoring renameParameter() {
        this.prepare();
        return this.methodFactory.renameParameter();
    }

    public ExtractMethodRefactoring extractMethod() {
        return this.methodFactory.extractMethod();
    }

    protected void prepare() {
    }

    public static void setSingleton(RefactoringFactory refactoringFactory) {
        singleton = refactoringFactory;
    }

    public static RefactoringFactory get() {
        if (singleton == null) {
            RefactoringFactory.init();
        }
        return singleton;
    }

    private static synchronized void init() {
        if (singleton == null) {
            singleton = new RefactoringFactory();
        }
    }
}

