/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.xml;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import org.acm.seguin.print.text.LinePrinter;
import org.acm.seguin.print.text.LineSet;
import org.acm.seguin.print.xml.State;
import org.acm.seguin.print.xml.TagState;
import org.acm.seguin.print.xml.TextState;
import org.acm.seguin.util.TextFormatter;

public class XMLLinePrinter
extends LinePrinter {
    private ArrayList list = new ArrayList();
    private int fontSize = -1;
    private Font lineNo;

    public void setFontSize(int n) {
        if (n != this.fontSize) {
            this.fontSize = n;
            this.lineNo = new Font("Monospaced", 0, this.fontSize);
        }
    }

    public int getLineHeight(Graphics graphics) {
        this.init(graphics);
        graphics.setFont(this.lineNo);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return fontMetrics.getHeight();
    }

    public void print(Graphics graphics, String string, int n, int n2, LineSet lineSet, int n3) {
        if (n3 == 0) {
            this.list.add(0, TextState.getState());
        }
        State state = (State)this.list.get(n3);
        if (string.length() == 0) {
            this.list.add(n3 + 1, state);
            return;
        }
        if (state instanceof TextState && string.charAt(0) == '<') {
            state = TagState.getState();
        }
        String string2 = TextFormatter.rightJustifyNumber(n3 + 1, 5) + ":  ";
        graphics.setFont(this.lineNo);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string2, n, n2);
        state.setGraphics(graphics);
        state.setX(n + fontMetrics.stringWidth(string2));
        state.setY(n2);
        state.setFontSize(this.fontSize);
        this.list.add(n3 + 1, state.processLine(string));
    }
}

