/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import org.acm.seguin.metrics.PackageMetrics;

public class ProjectMetrics {
    private int publicMethodTotal = 0;
    private int otherMethodTotal = 0;
    private int classMethodTotal = 0;
    private int instanceVariableTotal = 0;
    private int classVariableTotal = 0;
    private int classTotal = 0;
    private int abstractClassTotal = 0;
    private int interfaceTotal = 0;
    private int statementTotal = 0;
    private int parameterTotal = 0;

    public int getPublicMethodTotal() {
        return this.publicMethodTotal;
    }

    public int getOtherMethodTotal() {
        return this.otherMethodTotal;
    }

    public int getClassMethodTotal() {
        return this.classMethodTotal;
    }

    public int getMethodTotal() {
        return this.publicMethodTotal + this.classMethodTotal + this.otherMethodTotal;
    }

    public int getInstanceVariableTotal() {
        return this.instanceVariableTotal;
    }

    public int getClassVariableTotal() {
        return this.classVariableTotal;
    }

    public int getClassTotal() {
        return this.classTotal;
    }

    public int getAbstractClassTotal() {
        return this.abstractClassTotal;
    }

    public int getInterfaceTotal() {
        return this.interfaceTotal;
    }

    public int getStatementTotal() {
        return this.statementTotal;
    }

    public int getParameterTotal() {
        return this.parameterTotal;
    }

    public double getStatementAverage() {
        double d = this.statementTotal;
        double d2 = this.publicMethodTotal + this.otherMethodTotal + this.classMethodTotal;
        return d / d2;
    }

    public double getParameterAverage() {
        double d = this.parameterTotal;
        double d2 = this.publicMethodTotal + this.otherMethodTotal + this.classMethodTotal;
        return d / d2;
    }

    public double getPublicMethodAverage() {
        double d = this.publicMethodTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getOtherMethodAverage() {
        double d = this.otherMethodTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getClassMethodAverage() {
        double d = this.classMethodTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getInstanceVariableAverage() {
        double d = this.instanceVariableTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getClassVariableAverage() {
        double d = this.classVariableTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getAbstractClassPercentage() {
        double d = this.abstractClassTotal;
        double d2 = this.classTotal;
        return 100.0 * d / d2;
    }

    public double getInterfacePercentage() {
        double d = this.interfaceTotal;
        double d2 = this.classTotal;
        return 100.0 * d / d2;
    }

    void add(PackageMetrics packageMetrics) {
        this.classTotal += packageMetrics.getClassTotal();
        this.abstractClassTotal += packageMetrics.getAbstractClassCount();
        this.interfaceTotal += packageMetrics.getInterfaceCount();
        this.publicMethodTotal += packageMetrics.getPublicMethodTotal();
        this.otherMethodTotal += packageMetrics.getOtherMethodTotal();
        this.classMethodTotal += packageMetrics.getClassMethodTotal();
        this.instanceVariableTotal += packageMetrics.getInstanceVariableTotal();
        this.classVariableTotal += packageMetrics.getClassVariableTotal();
        this.statementTotal += packageMetrics.getStatementTotal();
        this.parameterTotal += packageMetrics.getParameterTotal();
    }
}

