/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import org.acm.seguin.metrics.TypeMetrics;

public class PackageMetrics {
    private String packageName;
    private int publicMethodTotal = 0;
    private int otherMethodTotal = 0;
    private int classMethodTotal = 0;
    private int instanceVariableTotal = 0;
    private int classVariableTotal = 0;
    private int classTotal = 0;
    private int abstractClassCount = 0;
    private int interfaceCount = 0;
    private int statementTotal = 0;
    private int parameterTotal = 0;
    private int blockDepthTotal = 0;
    private int lineCountTotal = 0;

    public PackageMetrics(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getPublicMethodTotal() {
        return this.publicMethodTotal;
    }

    public int getOtherMethodTotal() {
        return this.otherMethodTotal;
    }

    public int getClassMethodTotal() {
        return this.classMethodTotal;
    }

    public int getInstanceVariableTotal() {
        return this.instanceVariableTotal;
    }

    public int getClassVariableTotal() {
        return this.classVariableTotal;
    }

    public int getClassTotal() {
        return this.classTotal;
    }

    public int getAbstractClassCount() {
        return this.abstractClassCount;
    }

    public int getInterfaceCount() {
        return this.interfaceCount;
    }

    public int getStatementTotal() {
        return this.statementTotal;
    }

    public int getParameterTotal() {
        return this.parameterTotal;
    }

    public double getStatementAverage() {
        double d = this.statementTotal;
        double d2 = this.publicMethodTotal + this.otherMethodTotal + this.classMethodTotal;
        return d / d2;
    }

    public double getParameterAverage() {
        double d = this.parameterTotal;
        double d2 = this.publicMethodTotal + this.otherMethodTotal + this.classMethodTotal;
        return d / d2;
    }

    public double getBlockDepthAverage() {
        double d = this.blockDepthTotal;
        double d2 = this.publicMethodTotal + this.otherMethodTotal + this.classMethodTotal;
        return d / d2;
    }

    public double getLinesOfCodeAverage() {
        double d = this.lineCountTotal;
        double d2 = this.publicMethodTotal + this.otherMethodTotal + this.classMethodTotal;
        return d / d2;
    }

    public double getPublicMethodAverage() {
        double d = this.publicMethodTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getOtherMethodAverage() {
        double d = this.otherMethodTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getClassMethodAverage() {
        double d = this.classMethodTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getInstanceVariableAverage() {
        double d = this.instanceVariableTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getClassVariableAverage() {
        double d = this.classVariableTotal;
        double d2 = this.classTotal;
        return d / d2;
    }

    public double getAbstractClassPercentage() {
        double d = this.abstractClassCount;
        double d2 = this.classTotal;
        return 100.0 * d / d2;
    }

    public double getInterfacePercentage() {
        double d = this.interfaceCount;
        double d2 = this.classTotal;
        return 100.0 * d / d2;
    }

    void incrAbstractClassCount() {
        ++this.abstractClassCount;
    }

    void incrInterfaceCount() {
        ++this.interfaceCount;
    }

    void add(TypeMetrics typeMetrics) {
        this.publicMethodTotal += typeMetrics.getPublicMethodCount();
        this.otherMethodTotal += typeMetrics.getOtherMethodCount();
        this.classMethodTotal += typeMetrics.getClassMethodCount();
        this.instanceVariableTotal += typeMetrics.getInstanceVariableCount();
        this.classVariableTotal += typeMetrics.getClassVariableCount();
        this.statementTotal += typeMetrics.getStatementTotal();
        this.parameterTotal += typeMetrics.getParameterTotal();
        this.lineCountTotal += typeMetrics.getLinesOfCodeTotal();
        this.blockDepthTotal += typeMetrics.getBlockDepthTotal();
        ++this.classTotal;
    }
}

