/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.metrics;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.acm.seguin.awt.ExceptionPrinter;

public class LineCounter {
    File file;

    public LineCounter(File file) {
        this.file = file;
    }

    public int countLines() {
        int n = 1;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            int n2 = 0;
            while (n2 != -1) {
                n2 = fileInputStream.read();
                n += this.countCharacter(n2, fileInputStream);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
        return n;
    }

    public int printMessage() {
        int n = this.countLines();
        if (n < 10) {
            System.out.println("      " + n + "  " + this.file.getPath());
        } else if (n < 100) {
            System.out.println("     " + n + "  " + this.file.getPath());
        } else if (n < 1000) {
            System.out.println("    " + n + "  " + this.file.getPath());
        } else if (n < 10000) {
            System.out.println("   " + n + "  " + this.file.getPath());
        } else if (n < 100000) {
            System.out.println("  " + n + "  " + this.file.getPath());
        } else {
            System.out.println(" " + n + "  " + this.file.getPath());
        }
        return n;
    }

    protected int countCharacter(int n, InputStream inputStream) throws IOException {
        if (n == 10) {
            return 1;
        }
        if (n == 13) {
            int n2 = inputStream.read();
            if (n2 == 10) {
                return 1;
            }
            return 1 + this.countCharacter(n2, inputStream);
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Syntax:  java org.acm.seguin.metrics.LineCounter <filename>");
            return;
        }
        int n = new LineCounter(new File(stringArray[0])).printMessage();
    }
}

