/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.acm.seguin.io.FileCopy;

public class InplaceOutputStream
extends OutputStream {
    private File finalDestination;
    private File temporary;
    private FileOutputStream out;

    public InplaceOutputStream(File file) throws IOException {
        this.finalDestination = file;
        String string = file.getPath();
        if (!(string != null && this.attempt(string + File.separator + "inplace") || this.attempt("." + File.separator + "inplace") || this.attempt(System.getProperty("user.home") + File.separator + ".Refactory" + File.separator + "inplace"))) {
            throw new IOException("Unable to create the output file!");
        }
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        if (this.temporary.exists() && this.temporary.length() > 0L) {
            new FileCopy(this.temporary, this.finalDestination, false).run();
        }
        this.temporary.delete();
        this.out = null;
    }

    public void flush() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.flush();
    }

    public void write(int n) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(byArray, n, n2);
    }

    protected void finalize() {
        if (this.out == null) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File createTempFile(String string, String string2) {
        int n = 0;
        while (n < 1024) {
            double d = Math.random() * 1024.0 * 1024.0;
            long l = Math.round(d);
            File file = new File(string + l + string2);
            if (!file.exists()) {
                return file;
            }
            ++n;
        }
        return null;
    }

    private boolean attempt(String string) {
        try {
            this.temporary = this.createTempFile(string, ".java");
            this.temporary.delete();
            if (this.temporary.exists()) {
                return false;
            }
            this.out = new FileOutputStream(this.temporary);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

