/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.jbuilder.refactor;

import com.borland.jbuilder.node.JavaFileNode;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.Node;
import com.borland.primetime.vfs.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.acm.seguin.ide.common.action.SelectedFileSet;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.TypeSummary;

public class JBuilderSelectedFileSet
extends SelectedFileSet {
    private Node[] initialNodes;

    public JBuilderSelectedFileSet(Node[] nodeArray) {
        this.initialNodes = nodeArray;
    }

    private Node[] getNodes() {
        if (this.initialNodes == null) {
            Node[] nodeArray = new Node[1];
            Browser browser = Browser.getActiveBrowser();
            nodeArray[0] = browser.getActiveNode();
            return nodeArray;
        }
        return this.initialNodes;
    }

    public TypeSummary[] getTypeSummaryArray() {
        Node[] nodeArray = this.getNodes();
        TypeSummary[] typeSummaryArray = new TypeSummary[nodeArray.length];
        int n = 0;
        while (n < nodeArray.length) {
            TypeSummary typeSummary = this.getTypeSummaryFromNode(nodeArray[n]);
            if (typeSummary == null) {
                return null;
            }
            typeSummaryArray[n] = typeSummary;
            ++n;
        }
        return typeSummaryArray;
    }

    private TypeSummary getTypeSummaryFromNode(Node node) {
        FileSummary fileSummary = this.reloadNode(node);
        if (fileSummary == null) {
            return null;
        }
        return this.getTypeSummary(fileSummary);
    }

    public boolean isAllJava() {
        Node[] nodeArray = this.getNodes();
        int n = 0;
        while (n < nodeArray.length) {
            if (!(nodeArray[0] instanceof JavaFileNode)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isSingleJavaFile() {
        Node[] nodeArray = this.getNodes();
        return nodeArray.length == 1 && nodeArray[0] instanceof JavaFileNode;
    }

    private FileSummary reloadNode(Node node) {
        try {
            if (node instanceof JavaFileNode) {
                JavaFileNode javaFileNode = (JavaFileNode)node;
                Buffer buffer = javaFileNode.getBuffer();
                byte[] byArray = buffer.getContent();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                return this.reloadFile(javaFileNode.getUrl().getFileObject(), byteArrayInputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

