/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.awt;

import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import org.acm.seguin.awt.MoveItemAdapter;
import org.acm.seguin.awt.OrderableListModel;

public class OrderableList
extends JPanel {
    private JButton downButton;
    private JList list;
    private OrderableListModel olm;
    private JButton upButton;

    public OrderableList(Object[] objectArray, ListCellRenderer listCellRenderer) {
        this.setLayout(null);
        this.olm = new OrderableListModel();
        this.olm.setData(objectArray);
        this.list = new JList(this.olm);
        this.olm.setList(this.list);
        if (listCellRenderer != null) {
            this.list.setCellRenderer(listCellRenderer);
        }
        Dimension dimension = this.list.getPreferredSize();
        this.list.setSize(dimension);
        this.list.setLocation(10, 10);
        this.add(this.list);
        this.upButton = new JButton("Up");
        this.upButton.addActionListener(new MoveItemAdapter(this.olm, this.list, -1));
        Dimension dimension2 = this.upButton.getPreferredSize();
        this.upButton.setSize(dimension2);
        int n = Math.max(10, 10 + dimension.height / 2 - 3 * dimension2.height / 2);
        int n2 = n + dimension2.height;
        this.upButton.setLocation(dimension.width + 20, n);
        this.add(this.upButton);
        this.downButton = new JButton("Down");
        this.downButton.addActionListener(new MoveItemAdapter(this.olm, this.list, 1));
        dimension2 = this.downButton.getPreferredSize();
        this.downButton.setSize(dimension2);
        this.upButton.setSize(dimension2);
        n = Math.max(n2 + 10, 10 + dimension.height / 2 + dimension2.height / 2);
        n2 = n + dimension2.height;
        this.downButton.setLocation(dimension.width + 20, n);
        this.add(this.downButton);
        Dimension dimension3 = new Dimension(30 + dimension.width + dimension2.width, Math.max(10 + n2, 20 + dimension.height));
        this.setPreferredSize(dimension3);
        this.list.setLocation(10, (dimension3.height - dimension.height) / 2);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
    }

    public Object[] getData() {
        return this.olm.getData();
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.olm.addListDataListener(listDataListener);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Object[] objectArray = new Object[]{"one", "two", "three"};
        jFrame.getContentPane().add(new OrderableList(objectArray, null));
        jFrame.pack();
        jFrame.show();
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.olm.removeListDataListener(listDataListener);
    }

    public void resetModel(Object[] objectArray) {
        this.olm = new OrderableListModel();
        this.olm.setData(objectArray);
        this.list.setModel(this.olm);
    }
}

