/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ant;

import java.io.File;
import java.util.Vector;
import org.acm.seguin.ant.CVSUtil;
import org.acm.seguin.parser.factory.FileParserFactory;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.util.FileSettings;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.apache.tools.ant.types.FileSet;

public final class Pretty
extends Task {
    private CVSUtil cvsUtil = new CVSUtil();
    private Vector filesets = new Vector();
    private boolean cvs = false;
    private File compileDir;

    public void setCvs(boolean cvs) {
        this.cvs = cvs;
    }

    public void setSettingsdir(File new_settings_dir) {
        FileSettings.setSettingsRoot(new_settings_dir);
    }

    public File getCompileDir() {
        return this.compileDir;
    }

    public void setCompileDir(File compileDir) {
        this.compileDir = compileDir;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            PrettyPrintFile ppf = new PrettyPrintFile();
            FixCRLF fixcrlf_task = (FixCRLF)((ProjectComponent)this).project.createTask("fixcrlf");
            this.configureFixCrlfTask(fixcrlf_task);
            ppf.setAsk(false);
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                File from_dir = fs.getDir(((ProjectComponent)this).project);
                String[] src_files = ds.getIncludedFiles();
                int j = 0;
                while (j < src_files.length) {
                    File source_file = new File(from_dir, src_files[j]);
                    if (this.shouldBeautify(source_file, from_dir)) {
                        System.out.println("formatting:" + source_file);
                        ppf.setParserFactory(new FileParserFactory(source_file));
                        ppf.apply(source_file);
                        fixcrlf_task.setSrcdir(from_dir);
                        fixcrlf_task.setIncludesfile(source_file);
                        fixcrlf_task.execute();
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException("Cannot javastyle files", this.location);
        }
    }

    private void configureFixCrlfTask(FixCRLF fixcrlf_task) {
        fixcrlf_task.setOwningTarget(this.getOwningTarget());
        FixCRLF.CrLf eol = new FixCRLF.CrLf();
        eol.setValue("cr");
        fixcrlf_task.setEol(eol);
    }

    private boolean shouldBeautify(File source_file, File from_dir) {
        if (!source_file.canWrite()) {
            return false;
        }
        if (!this.cvs) {
            return this.sourceModifiedAfterLastCompile(source_file, from_dir);
        }
        if (!this.cvsUtil.isFileModified(source_file)) {
            return false;
        }
        return this.sourceModifiedAfterLastCompile(source_file, from_dir);
    }

    private boolean sourceModifiedAfterLastCompile(File source_file, File from_dir) {
        if (this.compileDir == null) {
            return true;
        }
        String source_file_path = source_file.getAbsoluteFile().toString();
        String compile_dir_path = this.compileDir.getAbsoluteFile().toString();
        String from_dir_path = from_dir.getAbsoluteFile().toString();
        String source_file_name_from_dir = source_file_path.substring(from_dir_path.length());
        String source_file_name_wo_ext = source_file_name_from_dir.substring(0, source_file_name_from_dir.lastIndexOf(46));
        String compiled_file_name_from_dir = source_file_name_wo_ext + ".class";
        String compiled_file_name = compile_dir_path + compiled_file_name_from_dir;
        File compiled_file = new File(compiled_file_name);
        if (!compiled_file.exists()) {
            return true;
        }
        return compiled_file.lastModified() <= source_file.lastModified();
    }

    protected void validateAttributes() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one fileset.");
        }
    }
}

