/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.13
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif

#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION)
#include <iostream>
#endif

#include <exception>

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(0) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    const char *message() const {
      return message_.c_str("Could not get exception message in JavaExceptionMessage");
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : classname_(0), msg_(0) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (throwable) {
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(0);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message());
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : classname_(0), msg_(copystr(msg ? msg : "Unspecified DirectorException message")) {
    }

    ~DirectorException() throw() {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const throw() {
      return msg_;
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void raiseJavaException(JNIEnv *jenv) const {
      if (jenv) {
	jenv->ExceptionClear();

	jmethodID ctorMethodID = 0;
	jclass throwableclass = 0;
        if (classname_) {
          throwableclass = jenv->FindClass(classname_);
          if (throwableclass)
            ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
	}

	if (ctorMethodID) {
	  jenv->ThrowNew(throwableclass, what());
	} else {
	  SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
	}
      }
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = 0;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_XapianJNI = NULL;
    jmethodID director_method_ids[54];
  }
}

/* java.i: SWIG interface file for the Java bindings
 *
 * Copyright (c) 2007,2009,2011,2012,2014,2016,2017,2018,2019 Olly Betts
 * Copyright (c) 2012 Dan Colish
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


/** @file xapian-head.i
 * @brief Header for SWIG interface file for Xapian.
 */
/* Copyright (C) 2005,2006,2007,2008,2009,2011,2012,2013,2014,2015,2016 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

// Disable any deprecation warnings for Xapian methods/functions/classes.
#define XAPIAN_DEPRECATED(D) D

#include <xapian.h>

#include <fstream>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

// If a backend has been disabled in xapian-core (manually or automatically) we
// include a stub definition here so the bindings can still be built.
namespace Xapian {



#ifndef XAPIAN_HAS_CHERT_BACKEND
    namespace Chert {
	static Database open(const string &) {
	    throw FeatureUnavailableError("Chert backend not supported");
	}
	static WritableDatabase open(const string &, int, int = 0) {
	    throw FeatureUnavailableError("Chert backend not supported");
	}
    }
#endif

#ifndef XAPIAN_HAS_INMEMORY_BACKEND
    namespace InMemory {
	static WritableDatabase open() {
	    throw FeatureUnavailableError("InMemory backend not supported");
	}
    }
#endif




#ifndef XAPIAN_HAS_REMOTE_BACKEND
    namespace Remote {
	static Database open(const string &, unsigned int, useconds_t = 0, useconds_t = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}

	static WritableDatabase open_writable(const string &, unsigned int, useconds_t = 0, useconds_t = 0, int = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}

	static Database open(const string &, const string &, useconds_t = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}

	static WritableDatabase open_writable(const string &, const string &, useconds_t = 0, int = 0) {
	    throw FeatureUnavailableError("Remote backend not supported");
	}
    }
#endif

}


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <typeinfo>
#include <stdexcept>


#include <string>


#include <vector>
#include <stdexcept>


#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


namespace Xapian {

// Wrap Xapian::version_string as Xapian.Version.String() as Java can't have
// functions outside a class and we don't want Xapian.Xapian.versionString()!
class Version {
  private:
    Version();
    ~Version();
  public:
    static const char * String() { return Xapian::version_string(); }
    static int Major() { return Xapian::major_version(); }
    static int Minor() { return Xapian::minor_version(); }
    static int Revision() { return Xapian::revision(); }
};

}


#include <xapian/iterator.h>


class XapianSWIGStrItor {
    JNIEnv * jenv;

    jobjectArray array;

    jsize i;

  public:
    typedef std::random_access_iterator_tag iterator_category;
    typedef Xapian::Query value_type;
    typedef Xapian::termcount_diff difference_type;
    typedef Xapian::Query * pointer;
    typedef Xapian::Query & reference;

    XapianSWIGStrItor() { }

    void begin(JNIEnv * jenv_, jobjectArray array_) {
	jenv = jenv_;
	array = array_;
	i = 0;
    }

    void end(jsize len_) {
	i = len_;
    }

    XapianSWIGStrItor & operator++() {
	++i;
	return *this;
    }

    Xapian::Query operator*() const {
	jstring term = (jstring)jenv->GetObjectArrayElement(array, i);
	const char *c_term = jenv->GetStringUTFChars(term, 0);
	Xapian::Query subq(c_term);
	jenv->ReleaseStringUTFChars(term, c_term);
	jenv->DeleteLocalRef(term);
	return subq;
    }

    bool operator==(const XapianSWIGStrItor & o) {
	return i == o.i;
    }

    bool operator!=(const XapianSWIGStrItor & o) {
	return !(*this == o);
    }

    difference_type operator-(const XapianSWIGStrItor &o) const {
	return i - o.i;
    }
};

class XapianSWIGQueryItor {
    jlong * p;

  public:
    typedef std::random_access_iterator_tag iterator_category;
    typedef Xapian::Query value_type;
    typedef Xapian::termcount_diff difference_type;
    typedef Xapian::Query * pointer;
    typedef Xapian::Query & reference;

    XapianSWIGQueryItor() { }

    void set_p(jlong * p_) { p = p_; }

    XapianSWIGQueryItor & operator++() {
	++p;
	return *this;
    }

    const Xapian::Query & operator*() const {
	return **(Xapian::Query **)p;
    }

    bool operator==(const XapianSWIGQueryItor & o) {
	return p == o.p;
    }

    bool operator!=(const XapianSWIGQueryItor & o) {
	return !(*this == o);
    }

    difference_type operator-(const XapianSWIGQueryItor &o) const {
	return p - o.p;
    }
};



typedef std::string binary_std_string;


/** @file generic/except.i
 * @brief Language independent exception handling.
 */
/* Warning: This file is generated by ./generic/generate-generic-exceptions
 * - do not modify directly!
 *
 * Copyright (C) 2004,2005,2006,2007,2011,2012,2018 Olly Betts
 * Copyright (C) 2007 Lemur Consulting Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/* This file is included for any languages which don't have language specific
 * handling for exceptions.
 */

#include <exception>

static int XapianExceptionHandler(string & msg) {
    try {
	// Rethrow so we can look at the exception if it was a Xapian::Error.
	throw;
    } catch (const Xapian::Error &e) {
	msg = e.get_description();
	try {
	    // Re-rethrow the previous exception so we can handle the type in a
	    // fine-grained way, but only in one place to avoid bloating the
	    // file.
	    throw;
	} catch (const Xapian::InvalidArgumentError &) {
	    return SWIG_ValueError;
	} catch (const Xapian::RangeError &) {
	    return SWIG_IndexError;
	} catch (const Xapian::DatabaseError &) {
	    return SWIG_IOError;
	} catch (const Xapian::NetworkError &) {
	    return SWIG_IOError;
	} catch (const Xapian::InternalError &) {
	    return SWIG_RuntimeError;
	} catch (const Xapian::RuntimeError &) {
	    return SWIG_RuntimeError;
	} catch (...) {
	    return SWIG_UnknownError;
	}
    } catch (const std::exception &e) {
	msg = "std::exception: ";
        msg += e.what();
    } catch (...) {
	msg = "unknown error in Xapian";
    }
    return SWIG_UnknownError;
}


/* xapian-headers.i: Getting SWIG to parse Xapian's C++ headers.
 *
 * Copyright 2004,2006,2011,2012,2013,2014,2015,2016,2019,2020 Olly Betts
 * Copyright 2014 Assem Chelli
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

SWIGINTERN bool Xapian_PositionIterator_equals(Xapian::PositionIterator const *self,Xapian::PositionIterator const &o){ return *self == o; }
SWIGINTERN Xapian::termpos Xapian_PositionIterator_get_termpos(Xapian::PositionIterator const *self){ return **self; }
SWIGINTERN Xapian::termpos Xapian_PositionIterator_next(Xapian::PositionIterator *self){ return *(++(*self)); }
SWIGINTERN Xapian::docid Xapian_PostingIterator_next(Xapian::PostingIterator *self){
	Xapian::docid tmp;
	if (Xapian::iterator_valid(*self)) {
	    tmp = (**self);
	    ++(*self);
	} else {
	    tmp = -1;
	}
	return tmp;
    }
SWIGINTERN bool Xapian_PostingIterator_hasNext(Xapian::PostingIterator const *self){ return Xapian::iterator_valid(*self); }
SWIGINTERN bool Xapian_PostingIterator_equals(Xapian::PostingIterator const *self,Xapian::PostingIterator const &o){ return *self == o; }
SWIGINTERN Xapian::docid Xapian_PostingIterator_get_docid(Xapian::PostingIterator const *self){ return **self; }
SWIGINTERN std::string Xapian_TermIterator_next(Xapian::TermIterator *self){
	std:string tmp;
	if (Xapian::iterator_valid(*self)) {
	    tmp = (**self);
	    ++(*self);
	}
	return tmp;
    }
SWIGINTERN bool Xapian_TermIterator_hasNext(Xapian::TermIterator const *self){ return Xapian::iterator_valid(*self); }
SWIGINTERN bool Xapian_TermIterator_equals(Xapian::TermIterator const *self,Xapian::TermIterator const &o){ return *self == o; }
SWIGINTERN std::string Xapian_TermIterator_get_term(Xapian::TermIterator const *self){ return **self; }
SWIGINTERN std::string Xapian_ValueIterator_next(Xapian::ValueIterator *self){
	std:string tmp;
	if (Xapian::iterator_valid(*self)) {
	    tmp = (**self);
	    ++(*self);
	}
	return tmp;
    }
SWIGINTERN bool Xapian_ValueIterator_hasNext(Xapian::ValueIterator const *self){ return Xapian::iterator_valid(*self); }
SWIGINTERN bool Xapian_ValueIterator_equals(Xapian::ValueIterator const *self,Xapian::ValueIterator const &o){ return *self == o; }
SWIGINTERN std::string Xapian_ValueIterator_get_value(Xapian::ValueIterator const *self){ return **self; }
SWIGINTERN Xapian::docid Xapian_MSet_get_docid(Xapian::MSet const *self,Xapian::doccount i){
	return *(*self)[i];
    }
SWIGINTERN Xapian::Document Xapian_MSet_get_document(Xapian::MSet const *self,Xapian::doccount i){
	return (*self)[i].get_document();
    }
SWIGINTERN Xapian::MSetIterator Xapian_MSet_get_hit(Xapian::MSet const *self,Xapian::doccount i){
	return (*self)[i];
    }
SWIGINTERN int Xapian_MSet_get_document_percentage(Xapian::MSet const *self,Xapian::doccount i){
	return self->convert_to_percent((*self)[i]);
    }
SWIGINTERN Xapian::docid Xapian_MSetIterator_next(Xapian::MSetIterator *self){
	Xapian::docid tmp;
	if (Xapian::iterator_valid(*self)) {
	    tmp = (**self);
	    ++(*self);
	} else {
	    tmp = -1;
	}
	return tmp;
    }
SWIGINTERN bool Xapian_MSetIterator_hasNext(Xapian::MSetIterator const *self){ return Xapian::iterator_valid(*self); }
SWIGINTERN bool Xapian_MSetIterator_equals(Xapian::MSetIterator const *self,Xapian::MSetIterator const &o){ return *self == o; }
SWIGINTERN Xapian::docid Xapian_MSetIterator_get_docid(Xapian::MSetIterator const *self){ return **self; }
SWIGINTERN Xapian::docid Xapian_MSetIterator_prev(Xapian::MSetIterator *self){ return *(--(*self)); }
SWIGINTERN std::string Xapian_ESetIterator_next(Xapian::ESetIterator *self){
	std:string tmp;
	if (Xapian::iterator_valid(*self)) {
	    tmp = (**self);
	    ++(*self);
	}
	return tmp;
    }
SWIGINTERN bool Xapian_ESetIterator_hasNext(Xapian::ESetIterator const *self){ return Xapian::iterator_valid(*self); }
SWIGINTERN bool Xapian_ESetIterator_equals(Xapian::ESetIterator const *self,Xapian::ESetIterator const &o){ return *self == o; }
SWIGINTERN std::string Xapian_ESetIterator_get_term(Xapian::ESetIterator const *self){ return **self; }
SWIGINTERN std::string Xapian_ESetIterator_prev(Xapian::ESetIterator *self){ return *(--(*self)); }
SWIGINTERN std::pair< Xapian::TermIterator,Xapian::TermIterator > Xapian_Enquire_get_matching_terms(Xapian::Enquire const *self,Xapian::MSetIterator const &item){
	return std::make_pair(self->get_matching_terms_begin(item),
			      self->get_matching_terms_end(item));
    }
SWIGINTERN Xapian::SimpleStopper *new_Xapian_SimpleStopper__SWIG_2(std::string const &file){
	ifstream in_file(file.c_str());
	if (!in_file.is_open())
	    throw Xapian::InvalidArgumentError("Stopword file not found: " + file);
	istream_iterator<std::string> in_iter(in_file);
	istream_iterator<std::string> eof;
	return new Xapian::SimpleStopper(in_iter, eof);
    }
SWIGINTERN bool Xapian_LatLongCoordsIterator_equals(Xapian::LatLongCoordsIterator const *self,Xapian::LatLongCoordsIterator const &o){ return *self == o; }
SWIGINTERN Xapian::LatLongCoord Xapian_LatLongCoordsIterator_get_coord(Xapian::LatLongCoordsIterator const *self){ return **self; }
SWIGINTERN Xapian::LatLongCoord Xapian_LatLongCoordsIterator_next(Xapian::LatLongCoordsIterator *self){ return *(++(*self)); }

/* fake_dbfactory.i: Fake classes for xapian/dbfactory.h functions.
 *
 * Copyright 1999,2000,2001 BrightStation PLC
 * Copyright 2001,2002 Ananova Ltd
 * Copyright 2002,2003,2005 James Aylett
 * Copyright 2002,2003,2004,2005,2006,2007,2008,2009,2010,2011 Olly Betts
 * Copyright 2007 Lemur Consulting Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


namespace Xapian {
static Xapian::valueno getBAD_VALUENO() { return Xapian::BAD_VALUENO; }
}



/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "xapian_wrap.h"

SwigDirector_StemImplementation::SwigDirector_StemImplementation(JNIEnv *jenv) : Xapian::StemImplementation(), Swig::Director(jenv) {
}

SwigDirector_StemImplementation::~SwigDirector_StemImplementation() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_StemImplementation::operator ()(std::string const &word) {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jword = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::StemImplementation::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jword = jenv->NewStringUTF((&word)->c_str());
    Swig::LocalRefGuard word_refguard(jenv, jword); 
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[0], swigjobj, jword);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::StemImplementation::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_StemImplementation::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::StemImplementation::get_description.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[1], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::StemImplementation::get_description ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_StemImplementation::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Ljava/lang/String;)Ljava/lang/String;", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/StemImplementation");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_MatchDecider::SwigDirector_MatchDecider(JNIEnv *jenv) : Xapian::MatchDecider(), Swig::Director(jenv) {
}

bool SwigDirector_MatchDecider::operator ()(Xapian::Document const &doc) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdoc = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::MatchDecider::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Document **)&jdoc = (Xapian::Document *) &doc; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[2], swigjobj, jdoc);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::MatchDecider::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_MatchDecider::~SwigDirector_MatchDecider() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_MatchDecider::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "accept", "(Lorg/xapian/Document;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/MatchDecider");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ExpandDecider::SwigDirector_ExpandDecider(JNIEnv *jenv) : Xapian::ExpandDecider(), Swig::Director(jenv) {
}

bool SwigDirector_ExpandDecider::operator ()(std::string const &term) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jterm = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::ExpandDecider::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jterm = jenv->NewStringUTF((&term)->c_str());
    Swig::LocalRefGuard term_refguard(jenv, jterm); 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[3], swigjobj, jterm);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ExpandDecider::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_ExpandDecider::~SwigDirector_ExpandDecider() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_ExpandDecider::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "accept", "(Ljava/lang/String;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/ExpandDecider");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_KeyMaker::SwigDirector_KeyMaker(JNIEnv *jenv) : Xapian::KeyMaker(), Swig::Director(jenv) {
}

std::string SwigDirector_KeyMaker::operator ()(Xapian::Document const &doc) const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdoc = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::KeyMaker::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Document **)&jdoc = (Xapian::Document *) &doc; 
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[4], swigjobj, jdoc);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::KeyMaker::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_KeyMaker::~SwigDirector_KeyMaker() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_KeyMaker::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Lorg/xapian/Document;)Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/KeyMaker");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_Stopper::SwigDirector_Stopper(JNIEnv *jenv) : Xapian::Stopper(), Swig::Director(jenv) {
}

bool SwigDirector_Stopper::operator ()(std::string const &term) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jterm = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::Stopper::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jterm = jenv->NewStringUTF((&term)->c_str());
    Swig::LocalRefGuard term_refguard(jenv, jterm); 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[5], swigjobj, jterm);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::Stopper::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

SwigDirector_Stopper::~SwigDirector_Stopper() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_Stopper::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return Xapian::Stopper::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[6], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::Stopper::get_description ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Stopper::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Ljava/lang/String;)Z", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/Stopper");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_RangeProcessor::SwigDirector_RangeProcessor(JNIEnv *jenv) : Xapian::RangeProcessor(), Swig::Director(jenv) {
}

SwigDirector_RangeProcessor::SwigDirector_RangeProcessor(JNIEnv *jenv, Xapian::valueno slot_, std::string const &str_, unsigned int flags_) : Xapian::RangeProcessor(slot_, str_, flags_), Swig::Director(jenv) {
}

SwigDirector_RangeProcessor::~SwigDirector_RangeProcessor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::Query SwigDirector_RangeProcessor::operator ()(std::string const &begin, std::string const &end) {
  Xapian::Query c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jbegin = 0 ;
  jstring jend = 0 ;
  Xapian::Query *argp ;
  
  if (!swig_override[0]) {
    return Xapian::RangeProcessor::operator ()(begin,end);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jbegin = jenv->NewStringUTF((&begin)->c_str());
    Swig::LocalRefGuard begin_refguard(jenv, jbegin); 
    jend = jenv->NewStringUTF((&end)->c_str());
    Swig::LocalRefGuard end_refguard(jenv, jend); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[7], swigjobj, jbegin, jend);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    argp = *(Xapian::Query **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Xapian::Query");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::RangeProcessor::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_RangeProcessor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Ljava/lang/String;Ljava/lang/String;)Lorg/xapian/Query;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/RangeProcessor");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ValueRangeProcessor::SwigDirector_ValueRangeProcessor(JNIEnv *jenv) : Xapian::ValueRangeProcessor(), Swig::Director(jenv) {
}

SwigDirector_ValueRangeProcessor::~SwigDirector_ValueRangeProcessor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::valueno SwigDirector_ValueRangeProcessor::operator ()(std::string &begin, std::string &end) {
  Xapian::valueno c_result = SwigValueInit< Xapian::valueno >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jbegin = 0 ;
  jlong jend = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::ValueRangeProcessor::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(std::string **)&jbegin = (std::string *) &begin; 
    *(std::string **)&jend = (std::string *) &end; 
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[8], swigjobj, jbegin, jend);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::valueno)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueRangeProcessor::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ValueRangeProcessor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Lorg/xapian/SWIGTYPE_p_std__string;Lorg/xapian/SWIGTYPE_p_std__string;)I", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/ValueRangeProcessor");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_FieldProcessor::SwigDirector_FieldProcessor(JNIEnv *jenv) : Xapian::FieldProcessor(), Swig::Director(jenv) {
}

SwigDirector_FieldProcessor::~SwigDirector_FieldProcessor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::Query SwigDirector_FieldProcessor::operator ()(std::string const &str) {
  Xapian::Query c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jstr = 0 ;
  Xapian::Query *argp ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::FieldProcessor::operator ().");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jstr = jenv->NewStringUTF((&str)->c_str());
    Swig::LocalRefGuard str_refguard(jenv, jstr); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[9], swigjobj, jstr);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    argp = *(Xapian::Query **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type Xapian::Query");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::FieldProcessor::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_FieldProcessor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Ljava/lang/String;)Lorg/xapian/Query;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/FieldProcessor");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 1; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_Compactor::SwigDirector_Compactor(JNIEnv *jenv) : Xapian::Compactor(), Swig::Director(jenv) {
}

SwigDirector_Compactor::~SwigDirector_Compactor() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_Compactor::set_status(std::string const &table, std::string const &status) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jtable = 0 ;
  jstring jstatus = 0 ;
  
  if (!swig_override[0]) {
    Xapian::Compactor::set_status(table,status);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jtable = jenv->NewStringUTF((&table)->c_str());
    Swig::LocalRefGuard table_refguard(jenv, jtable); 
    jstatus = jenv->NewStringUTF((&status)->c_str());
    Swig::LocalRefGuard status_refguard(jenv, jstatus); 
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[10], swigjobj, jtable, jstatus);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::Compactor::set_status ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_Compactor::resolve_duplicate_metadata(std::string const &key, size_t num_tags, std::string const tags[]) {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jkey = 0 ;
  jlong jnum_tags  ;
  jlong jtags  ;
  
  if (!swig_override[1]) {
    return Xapian::Compactor::resolve_duplicate_metadata(key,num_tags,tags);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jkey = jenv->NewStringUTF((&key)->c_str());
    Swig::LocalRefGuard key_refguard(jenv, jkey); 
    jnum_tags = (jlong) num_tags;
    *((std::string **)&jtags) = (std::string *) tags; 
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[11], swigjobj, jkey, jnum_tags, jtags);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::Compactor::resolve_duplicate_metadata ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Compactor::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "setStatus", "(Ljava/lang/String;Ljava/lang/String;)V", NULL 
    },
    {
      "resolveDuplicateMetadata", "(Ljava/lang/String;JLorg/xapian/SWIGTYPE_p_std__string;)Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/Compactor");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_PostingSource::SwigDirector_PostingSource(JNIEnv *jenv) : Xapian::PostingSource(), Swig::Director(jenv) {
}

SwigDirector_PostingSource::~SwigDirector_PostingSource() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::doccount SwigDirector_PostingSource::get_termfreq_min() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_termfreq_min.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[12], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::get_termfreq_min ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_PostingSource::get_termfreq_est() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_termfreq_est.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[13], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::get_termfreq_est ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_PostingSource::get_termfreq_max() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_termfreq_max.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[14], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::get_termfreq_max ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_PostingSource::get_weight() const {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return Xapian::PostingSource::get_weight();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[15], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::get_weight ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::docid SwigDirector_PostingSource::get_docid() const {
  Xapian::docid c_result = SwigValueInit< Xapian::docid >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::get_docid.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[16], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::docid)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::get_docid ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PostingSource::next(double min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jmin_wt  ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::next.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[17], swigjobj, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::next ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_PostingSource::skip_to(Xapian::docid did, double min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[6]) {
    Xapian::PostingSource::skip_to(did,min_wt);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdid = (jlong) did;
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[18], swigjobj, jdid, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::skip_to ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_PostingSource::check(Xapian::docid did, double min_wt) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[7]) {
    return Xapian::PostingSource::check(did,min_wt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jdid = (jlong) did;
    jmin_wt = (jdouble) min_wt;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[19], swigjobj, jdid, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::check ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_PostingSource::at_end() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::at_end.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[20], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::at_end ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::PostingSource *SwigDirector_PostingSource::clone() const {
  return Xapian::PostingSource::clone();
}

std::string SwigDirector_PostingSource::name() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    return Xapian::PostingSource::name();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[21], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::name ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_PostingSource::serialise() const {
  return Xapian::PostingSource::serialise();
}

Xapian::PostingSource *SwigDirector_PostingSource::unserialise(std::string const &serialised) const {
  return Xapian::PostingSource::unserialise(serialised);
}

Xapian::PostingSource *SwigDirector_PostingSource::unserialise_with_registry(std::string const &serialised, Xapian::Registry const &registry) const {
  return Xapian::PostingSource::unserialise_with_registry(serialised,registry);
}

void SwigDirector_PostingSource::init(Xapian::Database const &db) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdb = 0 ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::PostingSource::init.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Database **)&jdb = (Xapian::Database *) &db; 
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[22], swigjobj, jdb);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::init ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_PostingSource::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[11]) {
    return Xapian::PostingSource::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[23], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::PostingSource::get_description ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_PostingSource::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getTermfreqMin", "()J", NULL 
    },
    {
      "getTermfreqEst", "()J", NULL 
    },
    {
      "getTermfreqMax", "()J", NULL 
    },
    {
      "getWeight", "()D", NULL 
    },
    {
      "getDocId", "()J", NULL 
    },
    {
      "next", "(D)V", NULL 
    },
    {
      "skipTo", "(JD)V", NULL 
    },
    {
      "check", "(JD)Z", NULL 
    },
    {
      "atEnd", "()Z", NULL 
    },
    {
      "name", "()Ljava/lang/String;", NULL 
    },
    {
      "init", "(Lorg/xapian/Database;)V", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/PostingSource");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 12; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ValuePostingSource::SwigDirector_ValuePostingSource(JNIEnv *jenv, Xapian::valueno slot_) : Xapian::ValuePostingSource(slot_), Swig::Director(jenv) {
}

SwigDirector_ValuePostingSource::~SwigDirector_ValuePostingSource() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::doccount SwigDirector_ValuePostingSource::get_termfreq_min() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return Xapian::ValuePostingSource::get_termfreq_min();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[24], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::get_termfreq_min ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_ValuePostingSource::get_termfreq_est() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return Xapian::ValuePostingSource::get_termfreq_est();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[25], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::get_termfreq_est ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_ValuePostingSource::get_termfreq_max() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return Xapian::ValuePostingSource::get_termfreq_max();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[26], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::get_termfreq_max ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_ValuePostingSource::get_weight() const {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return Xapian::PostingSource::get_weight();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[27], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::get_weight ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::docid SwigDirector_ValuePostingSource::get_docid() const {
  Xapian::docid c_result = SwigValueInit< Xapian::docid >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return Xapian::ValuePostingSource::get_docid();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[28], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::docid)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::get_docid ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ValuePostingSource::next(double min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jmin_wt  ;
  
  if (!swig_override[5]) {
    Xapian::ValuePostingSource::next(min_wt);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[29], swigjobj, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::next ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ValuePostingSource::skip_to(Xapian::docid min_docid, double min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmin_docid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[6]) {
    Xapian::ValuePostingSource::skip_to(min_docid,min_wt);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_docid = (jlong) min_docid;
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[30], swigjobj, jmin_docid, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::skip_to ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_ValuePostingSource::check(Xapian::docid min_docid, double min_wt) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmin_docid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[7]) {
    return Xapian::ValuePostingSource::check(min_docid,min_wt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_docid = (jlong) min_docid;
    jmin_wt = (jdouble) min_wt;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[31], swigjobj, jmin_docid, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::check ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ValuePostingSource::at_end() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return Xapian::ValuePostingSource::at_end();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[32], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::at_end ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::PostingSource *SwigDirector_ValuePostingSource::clone() const {
  return Xapian::PostingSource::clone();
}

std::string SwigDirector_ValuePostingSource::name() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    return Xapian::PostingSource::name();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[33], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::name ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_ValuePostingSource::serialise() const {
  return Xapian::PostingSource::serialise();
}

Xapian::PostingSource *SwigDirector_ValuePostingSource::unserialise(std::string const &serialised) const {
  return Xapian::PostingSource::unserialise(serialised);
}

Xapian::PostingSource *SwigDirector_ValuePostingSource::unserialise_with_registry(std::string const &serialised, Xapian::Registry const &registry) const {
  return Xapian::PostingSource::unserialise_with_registry(serialised,registry);
}

void SwigDirector_ValuePostingSource::init(Xapian::Database const &db_) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdb_ = 0 ;
  
  if (!swig_override[10]) {
    Xapian::ValuePostingSource::init(db_);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Database **)&jdb_ = (Xapian::Database *) &db_; 
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[34], swigjobj, jdb_);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::init ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_ValuePostingSource::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[11]) {
    return Xapian::PostingSource::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[35], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValuePostingSource::get_description ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ValuePostingSource::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getTermfreqMin", "()J", NULL 
    },
    {
      "getTermfreqEst", "()J", NULL 
    },
    {
      "getTermfreqMax", "()J", NULL 
    },
    {
      "getWeight", "()D", NULL 
    },
    {
      "getDocId", "()J", NULL 
    },
    {
      "next", "(D)V", NULL 
    },
    {
      "skipTo", "(JD)V", NULL 
    },
    {
      "check", "(JD)Z", NULL 
    },
    {
      "atEnd", "()Z", NULL 
    },
    {
      "name", "()Ljava/lang/String;", NULL 
    },
    {
      "init", "(Lorg/xapian/Database;)V", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/ValuePostingSource");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 12; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_ValueWeightPostingSource::SwigDirector_ValueWeightPostingSource(JNIEnv *jenv, Xapian::valueno slot_) : Xapian::ValueWeightPostingSource(slot_), Swig::Director(jenv) {
}

SwigDirector_ValueWeightPostingSource::~SwigDirector_ValueWeightPostingSource() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Xapian::doccount SwigDirector_ValueWeightPostingSource::get_termfreq_min() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return Xapian::ValuePostingSource::get_termfreq_min();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[36], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::get_termfreq_min ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_ValueWeightPostingSource::get_termfreq_est() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return Xapian::ValuePostingSource::get_termfreq_est();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[37], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::get_termfreq_est ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::doccount SwigDirector_ValueWeightPostingSource::get_termfreq_max() const {
  Xapian::doccount c_result = SwigValueInit< Xapian::doccount >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    return Xapian::ValuePostingSource::get_termfreq_max();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[38], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::doccount)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::get_termfreq_max ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_ValueWeightPostingSource::get_weight() const {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return Xapian::ValueWeightPostingSource::get_weight();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[39], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::get_weight ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::docid SwigDirector_ValueWeightPostingSource::get_docid() const {
  Xapian::docid c_result = SwigValueInit< Xapian::docid >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[4]) {
    return Xapian::ValuePostingSource::get_docid();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[40], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (Xapian::docid)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::get_docid ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ValueWeightPostingSource::next(double min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jmin_wt  ;
  
  if (!swig_override[5]) {
    Xapian::ValuePostingSource::next(min_wt);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[41], swigjobj, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::next ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_ValueWeightPostingSource::skip_to(Xapian::docid min_docid, double min_wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmin_docid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[6]) {
    Xapian::ValuePostingSource::skip_to(min_docid,min_wt);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_docid = (jlong) min_docid;
    jmin_wt = (jdouble) min_wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[42], swigjobj, jmin_docid, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::skip_to ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

bool SwigDirector_ValueWeightPostingSource::check(Xapian::docid min_docid, double min_wt) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jmin_docid  ;
  jdouble jmin_wt  ;
  
  if (!swig_override[7]) {
    return Xapian::ValuePostingSource::check(min_docid,min_wt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jmin_docid = (jlong) min_docid;
    jmin_wt = (jdouble) min_wt;
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[43], swigjobj, jmin_docid, jmin_wt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::check ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_ValueWeightPostingSource::at_end() const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return Xapian::ValuePostingSource::at_end();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[44], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::at_end ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::ValueWeightPostingSource *SwigDirector_ValueWeightPostingSource::clone() const {
  return Xapian::ValueWeightPostingSource::clone();
}

std::string SwigDirector_ValueWeightPostingSource::name() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[9]) {
    return Xapian::ValueWeightPostingSource::name();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[45], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::name ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_ValueWeightPostingSource::serialise() const {
  return Xapian::ValueWeightPostingSource::serialise();
}

Xapian::ValueWeightPostingSource *SwigDirector_ValueWeightPostingSource::unserialise(std::string const &serialised) const {
  return Xapian::ValueWeightPostingSource::unserialise(serialised);
}

Xapian::PostingSource *SwigDirector_ValueWeightPostingSource::unserialise_with_registry(std::string const &serialised, Xapian::Registry const &registry) const {
  return Xapian::PostingSource::unserialise_with_registry(serialised,registry);
}

void SwigDirector_ValueWeightPostingSource::init(Xapian::Database const &db_) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdb_ = 0 ;
  
  if (!swig_override[10]) {
    Xapian::ValueWeightPostingSource::init(db_);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Database **)&jdb_ = (Xapian::Database *) &db_; 
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[46], swigjobj, jdb_);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::init ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_ValueWeightPostingSource::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[11]) {
    return Xapian::ValueWeightPostingSource::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[47], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::ValueWeightPostingSource::get_description ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_ValueWeightPostingSource::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getTermfreqMin", "()J", NULL 
    },
    {
      "getTermfreqEst", "()J", NULL 
    },
    {
      "getTermfreqMax", "()J", NULL 
    },
    {
      "getWeight", "()D", NULL 
    },
    {
      "getDocId", "()J", NULL 
    },
    {
      "next", "(D)V", NULL 
    },
    {
      "skipTo", "(JD)V", NULL 
    },
    {
      "check", "(JD)Z", NULL 
    },
    {
      "atEnd", "()Z", NULL 
    },
    {
      "name", "()Ljava/lang/String;", NULL 
    },
    {
      "init", "(Lorg/xapian/Database;)V", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/ValueWeightPostingSource");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 12; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_MatchSpy::SwigDirector_MatchSpy(JNIEnv *jenv) : Xapian::MatchSpy(), Swig::Director(jenv) {
}

SwigDirector_MatchSpy::~SwigDirector_MatchSpy() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_MatchSpy::operator ()(Xapian::Document const &doc, double wt) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jdoc = 0 ;
  jdouble jwt  ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::MatchSpy::operator ().");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::Document **)&jdoc = (Xapian::Document *) &doc; 
    jwt = (jdouble) wt;
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[48], swigjobj, jdoc, jwt);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::MatchSpy::operator () ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

Xapian::MatchSpy *SwigDirector_MatchSpy::clone() const {
  return Xapian::MatchSpy::clone();
}

std::string SwigDirector_MatchSpy::name() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return Xapian::MatchSpy::name();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[49], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::MatchSpy::name ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_MatchSpy::serialise() const {
  return Xapian::MatchSpy::serialise();
}

Xapian::MatchSpy *SwigDirector_MatchSpy::unserialise(std::string const &serialised, Xapian::Registry const &context) const {
  return Xapian::MatchSpy::unserialise(serialised,context);
}

std::string SwigDirector_MatchSpy::serialise_results() const {
  return Xapian::MatchSpy::serialise_results();
}

void SwigDirector_MatchSpy::merge_results(std::string const &serialised) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jbyteArray jserialised = 0 ;
  
  if (!swig_override[2]) {
    Xapian::MatchSpy::merge_results(serialised);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    size_t serialised_len = (&serialised)->size();
    jserialised = jenv->NewByteArray(serialised_len);
    Swig::LocalRefGuard serialised_refguard(jenv, jserialised);
    {
      const jbyte* data = reinterpret_cast<const jbyte*>((&serialised)->data());
      // Final parameter was not const in Java 6 and earlier.
      jbyte* data_nc = const_cast<jbyte*>(data);
      jenv->SetByteArrayRegion(jserialised, 0, serialised_len, data_nc);
    }
    jenv->CallStaticVoidMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[50], swigjobj, jserialised);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::MatchSpy::merge_results ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

std::string SwigDirector_MatchSpy::get_description() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return Xapian::MatchSpy::get_description();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[51], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::MatchSpy::get_description ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_MatchSpy::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "apply", "(Lorg/xapian/Document;D)V", NULL 
    },
    {
      "name", "()Ljava/lang/String;", NULL 
    },
    {
      "mergeResults", "(B[)V", NULL 
    },
    {
      "toString", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/MatchSpy");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 4; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_LatLongMetric::SwigDirector_LatLongMetric(JNIEnv *jenv) : Xapian::LatLongMetric(), Swig::Director(jenv) {
}

SwigDirector_LatLongMetric::~SwigDirector_LatLongMetric() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


double SwigDirector_LatLongMetric::pointwise_distance(Xapian::LatLongCoord const &a, Xapian::LatLongCoord const &b) const {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong ja = 0 ;
  jlong jb = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::LatLongMetric::pointwise_distance.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(Xapian::LatLongCoord **)&ja = (Xapian::LatLongCoord *) &a; 
    *(Xapian::LatLongCoord **)&jb = (Xapian::LatLongCoord *) &b; 
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[52], swigjobj, ja, jb);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::LatLongMetric::pointwise_distance ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

Xapian::LatLongMetric *SwigDirector_LatLongMetric::clone() const {
  Xapian::LatLongMetric *c_result = 0 ;
  
  SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::LatLongMetric::clone.");
  return c_result;
}

std::string SwigDirector_LatLongMetric::name() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::LatLongMetric::name.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_XapianJNI, Swig::director_method_ids[53], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      jenv->ExceptionClear();
      throw Swig::DirectorException(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = (const char *)jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in Xapian::LatLongMetric::name ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

std::string SwigDirector_LatLongMetric::serialise() const {
  std::string c_result ;
  
  SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::LatLongMetric::serialise.");
  return c_result;
}

Xapian::LatLongMetric *SwigDirector_LatLongMetric::unserialise(std::string const &serialised) const {
  Xapian::LatLongMetric *c_result = 0 ;
  
  SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Xapian::LatLongMetric::unserialise.");
  return c_result;
}

void SwigDirector_LatLongMetric::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "pointwiseDistance", "(Lorg/xapian/LatLongCoord;Lorg/xapian/LatLongCoord;)D", NULL 
    },
    {
      "name", "()Ljava/lang/String;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/xapian/LatLongMetric");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Version_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)Xapian::Version::String();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Version_1major(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Version::Major();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Version_1minor(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Version::Minor();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Version_1revision(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Version::Revision();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_BAD_1VALUENO_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::valueno)(Xapian::BAD_VALUENO);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1CREATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_CREATE);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1CREATE_1OR_1OPEN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_CREATE_OR_OPEN);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1CREATE_1OR_1OVERWRITE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_CREATE_OR_OVERWRITE);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1OPEN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_OPEN);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1NO_1SYNC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_NO_SYNC);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1FULL_1SYNC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_FULL_SYNC);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1DANGEROUS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_DANGEROUS);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1NO_1TERMLIST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_NO_TERMLIST);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1BACKEND_1CHERT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_BACKEND_CHERT);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1BACKEND_1GLASS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_BACKEND_GLASS);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1BACKEND_1INMEMORY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_BACKEND_INMEMORY);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1BACKEND_1STUB_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_BACKEND_STUB);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DB_1RETRY_1LOCK_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DB_RETRY_LOCK);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCHECK_1SHORT_1TREE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCHECK_SHORT_TREE);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCHECK_1FULL_1TREE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCHECK_FULL_TREE);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCHECK_1SHOW_1FREELIST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCHECK_SHOW_FREELIST);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCHECK_1SHOW_1STATS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCHECK_SHOW_STATS);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCHECK_1FIX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCHECK_FIX);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCOMPACT_1MULTIPASS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCOMPACT_MULTIPASS);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCOMPACT_1NO_1RENUMBER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCOMPACT_NO_RENUMBER);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DBCOMPACT_1SINGLE_1FILE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DBCOMPACT_SINGLE_FILE);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DOC_1ASSUME_1VALID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::DOC_ASSUME_VALID);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PositionIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::PositionIterator *)new Xapian::PositionIterator();
  *(Xapian::PositionIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1PositionIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PositionIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::termpos arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  arg2 = (Xapian::termpos)jarg2; 
  {
    try {
      (arg1)->skip_to(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PositionIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PositionIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_PositionIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::PositionIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  arg2 = *(Xapian::PositionIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PositionIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_PositionIterator_equals((Xapian::PositionIterator const *)arg1,(Xapian::PositionIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PositionIterator_1getTermPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termpos)Xapian_PositionIterator_get_termpos((Xapian::PositionIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PositionIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PositionIterator *arg1 = (Xapian::PositionIterator *) 0 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PositionIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termpos)Xapian_PositionIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PostingIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::PostingIterator *)new Xapian::PostingIterator();
  *(Xapian::PostingIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1PostingIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1getWdf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::PostingIterator const *)arg1)->get_wdf();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1getDocLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::PostingIterator const *)arg1)->get_doclength();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1getUniqueTerms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::PostingIterator const *)arg1)->get_unique_terms();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1positionListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingIterator const *)arg1)->positionlist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1positionListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  result = ((Xapian::PostingIterator const *)arg1)->positionlist_end();
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->skip_to(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PostingIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  result = (Xapian::docid)Xapian_PostingIterator_next(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_PostingIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  result = (bool)Xapian_PostingIterator_hasNext((Xapian::PostingIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_PostingIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::PostingIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  arg2 = *(Xapian::PostingIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PostingIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_PostingIterator_equals((Xapian::PostingIterator const *)arg1,(Xapian::PostingIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingIterator_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingIterator *arg1 = (Xapian::PostingIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_PostingIterator_get_docid((Xapian::PostingIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1TermIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TermIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::TermIterator *)new Xapian::TermIterator();
  *(Xapian::TermIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1TermIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermIterator_1getWdf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::TermIterator const *)arg1)->get_wdf();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermIterator_1getTermFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::TermIterator const *)arg1)->get_termfreq();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermIterator_1positionlistCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::TermIterator const *)arg1)->positionlist_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermIterator_1positionListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::TermIterator const *)arg1)->positionlist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermIterator_1positionListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  result = ((Xapian::TermIterator const *)arg1)->positionlist_end();
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->skip_to((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_TermIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::TermIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_TermIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  result = Xapian_TermIterator_next(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_TermIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  result = (bool)Xapian_TermIterator_hasNext((Xapian::TermIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_TermIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  Xapian::TermIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  arg2 = *(Xapian::TermIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::TermIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_TermIterator_equals((Xapian::TermIterator const *)arg1,(Xapian::TermIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_TermIterator_1getTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermIterator *arg1 = (Xapian::TermIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermIterator **)&jarg1; 
  {
    try {
      result = Xapian_TermIterator_get_term((Xapian::TermIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ValueIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::ValueIterator *)new Xapian::ValueIterator();
  *(Xapian::ValueIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValueIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueIterator_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::ValueIterator const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_ValueIterator_1getValueNo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = (Xapian::valueno)((Xapian::ValueIterator const *)arg1)->get_valueno();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueIterator_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->skip_to(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValueIterator_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::docid arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (bool)(arg1)->check(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  result = Xapian_ValueIterator_next(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValueIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  result = (bool)Xapian_ValueIterator_hasNext((Xapian::ValueIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValueIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  Xapian::ValueIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  arg2 = *(Xapian::ValueIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ValueIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_ValueIterator_equals((Xapian::ValueIterator const *)arg1,(Xapian::ValueIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_ValueIterator_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  Xapian::ValueIterator *arg1 = (Xapian::ValueIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueIterator **)&jarg1; 
  {
    try {
      result = Xapian_ValueIterator_get_value((Xapian::ValueIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Document(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Document *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Document *)new Xapian::Document();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Document(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Document **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_Document_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyteArray jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::valueno arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->get_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1addValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyteArray jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::valueno arg2 ;
  std::string *arg3 = 0 ;
  jbyte *jarr3 ;
  std::string c_arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  
  if (!jarg3)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr3 = jenv->GetByteArrayElements(jarg3, NULL);
  if (!jarr3) return ;
  c_arg3.assign(reinterpret_cast<char*>(jarr3), jenv->GetArrayLength(jarg3));
  jenv->ReleaseByteArrayElements(jarg3, jarr3, JNI_ABORT);
  arg3 = &c_arg3;
  
  {
    try {
      (arg1)->add_value(arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1removeValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->remove_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1clearValues(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      (arg1)->clear_values();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Document_1getData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->get_data();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1setData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->set_data((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1addPosting_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  Xapian::termcount arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      (arg1)->add_posting((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1addPosting_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  {
    try {
      (arg1)->add_posting((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1addTerm_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->add_term((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1addTerm_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_term((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1addBooleanTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_boolean_term((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1removePosting_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  Xapian::termcount arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      (arg1)->remove_posting((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1removePosting_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  {
    try {
      (arg1)->remove_posting((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1removePostings_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  Xapian::termpos arg4 ;
  Xapian::termcount arg5 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  arg4 = (Xapian::termpos)jarg4; 
  arg5 = (Xapian::termcount)jarg5; 
  {
    try {
      result = (Xapian::termpos)(arg1)->remove_postings((std::string const &)*arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1removePostings_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termpos arg3 ;
  Xapian::termpos arg4 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termpos)jarg3; 
  arg4 = (Xapian::termpos)jarg4; 
  {
    try {
      result = (Xapian::termpos)(arg1)->remove_postings((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1removeTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->remove_term((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Document_1clearTerms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      (arg1)->clear_terms();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1termListCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Document const *)arg1)->termlist_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1termListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->termlist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1termListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  result = ((Xapian::Document const *)arg1)->termlist_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1valuesCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Document const *)arg1)->values_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1valuesBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->values_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1valuesEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  result = ((Xapian::Document const *)arg1)->values_end();
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::Document const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_Document_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Document_1unserialise(JNIEnv *jenv, jclass jcls, jbyteArray jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  jbyte *jarr1 ;
  std::string c_arg1 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  
  if (!jarg1)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr1 = jenv->GetByteArrayElements(jarg1, NULL);
  if (!jarr1) return 0;
  c_arg1.assign(reinterpret_cast<char*>(jarr1), jenv->GetArrayLength(jarg1));
  jenv->ReleaseByteArrayElements(jarg1, jarr1, JNI_ABORT);
  arg1 = &c_arg1;
  
  {
    try {
      result = Xapian::Document::unserialise((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Document_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Document *arg1 = (Xapian::Document *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Document **)&jarg1; 
  {
    try {
      result = ((Xapian::Document const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Registry(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Registry *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Registry *)new Xapian::Registry();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Registry **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Registry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Registry **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Registry_1registerWeightingScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::Weight *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::Weight **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Weight const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_weighting_scheme((Xapian::Weight const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Registry_1getWeightingScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::Weight *)((Xapian::Registry const *)arg1)->get_weighting_scheme((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Registry_1registerPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::PostingSource *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::PostingSource **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::PostingSource const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_posting_source((Xapian::PostingSource const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Registry_1getPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::PostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::PostingSource *)((Xapian::Registry const *)arg1)->get_posting_source((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Registry_1registerMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::MatchSpy *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::MatchSpy **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MatchSpy const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_match_spy((Xapian::MatchSpy const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Registry_1getMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::Registry const *)arg1)->get_match_spy((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Registry_1registerLatLongMetric(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  Xapian::LatLongMetric *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  arg2 = *(Xapian::LatLongMetric **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->register_lat_long_metric((Xapian::LatLongMetric const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Registry_1getLatLongMetric(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Registry *arg1 = (Xapian::Registry *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::LatLongMetric *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Registry **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::LatLongMetric *)((Xapian::Registry const *)arg1)->get_lat_long_metric((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongMetric **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1AND_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_AND;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1OR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_OR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1AND_1NOT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_AND_NOT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1XOR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_XOR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1AND_1MAYBE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_AND_MAYBE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1FILTER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_FILTER;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1NEAR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_NEAR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1PHRASE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_PHRASE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1VALUE_1RANGE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_VALUE_RANGE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1SCALE_1WEIGHT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_SCALE_WEIGHT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1ELITE_1SET_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_ELITE_SET;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1VALUE_1GE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_VALUE_GE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1VALUE_1LE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_VALUE_LE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1SYNONYM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_SYNONYM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1MAX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_MAX;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1WILDCARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_WILDCARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1OP_1INVALID_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query::op)Xapian::Query::OP_INVALID;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1WILDCARD_1LIMIT_1ERROR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Query::WILDCARD_LIMIT_ERROR;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1WILDCARD_1LIMIT_1FIRST_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Query::WILDCARD_LIMIT_FIRST;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1WILDCARD_1LIMIT_1MOST_1FREQUENT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Query::WILDCARD_LIMIT_MOST_FREQUENT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Query *)new Xapian::Query();
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Query(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Query **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::termcount arg2 ;
  Xapian::termpos arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termpos)jarg3; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::termcount arg2 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::Query *arg2 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (double)jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(Xapian::Query const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::Query *arg2 = 0 ;
  double arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(Xapian::Query const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::Query *arg2 = 0 ;
  Xapian::Query *arg3 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::Query **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(Xapian::Query const &)*arg2,(Xapian::Query const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jbyteArray jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::valueno arg2 ;
  std::string *arg3 = 0 ;
  jbyte *jarr3 ;
  std::string c_arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  
  if (!jarg3)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr3 = jenv->GetByteArrayElements(jarg3, NULL);
  if (!jarr3) return 0;
  c_arg3.assign(reinterpret_cast<char*>(jarr3), jenv->GetArrayLength(jarg3));
  jenv->ReleaseByteArrayElements(jarg3, jarr3, JNI_ABORT);
  arg3 = &c_arg3;
  
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jbyteArray jarg3, jbyteArray jarg4) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::valueno arg2 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  jbyte *jarr3 ;
  std::string c_arg3 ;
  jbyte *jarr4 ;
  std::string c_arg4 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  
  if (!jarg3)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr3 = jenv->GetByteArrayElements(jarg3, NULL);
  if (!jarr3) return 0;
  c_arg3.assign(reinterpret_cast<char*>(jarr3), jenv->GetArrayLength(jarg3));
  jenv->ReleaseByteArrayElements(jarg3, jarr3, JNI_ABORT);
  arg3 = &c_arg3;
  
  
  if (!jarg4)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr4 = jenv->GetByteArrayElements(jarg4, NULL);
  if (!jarr4) return 0;
  c_arg4.assign(reinterpret_cast<char*>(jarr4), jenv->GetArrayLength(jarg4));
  jenv->ReleaseByteArrayElements(jarg4, jarr4, JNI_ABORT);
  arg4 = &c_arg4;
  
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  int arg4 ;
  Xapian::Query::op arg5 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (Xapian::Query::op)jarg5; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(std::string const &)*arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_112(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  int arg4 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (int)jarg4; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_113(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_114(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  std::string *arg2 = 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_117(JNIEnv *jenv, jclass jcls, jint jarg1, jlongArray jarg2, jlong jarg4) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  XapianSWIGQueryItor arg2 ;
  XapianSWIGQueryItor arg3 ;
  Xapian::termcount arg4 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jlong * jarr = jenv->GetLongArrayElements(jarg2, NULL);
  if (!jarr) return 0;
  (&arg2)->set_p(jarr);
  (&arg3)->set_p(jarr + jenv->GetArrayLength(jarg2));
  
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  
  /* We don't change the array so use JNI_ABORT to avoid any work
       * copying back non-existent changes if the JVM gave us a copy
       * of the array data. */
  jenv->ReleaseLongArrayElements(jarg2, jarr, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_118(JNIEnv *jenv, jclass jcls, jint jarg1, jlongArray jarg2) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  XapianSWIGQueryItor arg2 ;
  XapianSWIGQueryItor arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jlong * jarr = jenv->GetLongArrayElements(jarg2, NULL);
  if (!jarr) return 0;
  (&arg2)->set_p(jarr);
  (&arg3)->set_p(jarr + jenv->GetArrayLength(jarg2));
  
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  
  /* We don't change the array so use JNI_ABORT to avoid any work
       * copying back non-existent changes if the JVM gave us a copy
       * of the array data. */
  jenv->ReleaseLongArrayElements(jarg2, jarr, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_119(JNIEnv *jenv, jclass jcls, jint jarg1, jobjectArray jarg2, jlong jarg4) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  XapianSWIGStrItor arg2 ;
  XapianSWIGStrItor arg3 ;
  Xapian::termcount arg4 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    (&arg2)->begin(jenv, jarg2);
    (&arg3)->end(jenv->GetArrayLength(jarg2));
  }
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_120(JNIEnv *jenv, jclass jcls, jint jarg1, jobjectArray jarg2) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  XapianSWIGStrItor arg2 ;
  XapianSWIGStrItor arg3 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    (&arg2)->begin(jenv, jarg2);
    (&arg3)->end(jenv->GetArrayLength(jarg2));
  }
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getTermsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_terms_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getTermsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  result = ((Xapian::Query const *)arg1)->get_terms_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getUniqueTermsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_unique_terms_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getUniqueTermsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  result = ((Xapian::Query const *)arg1)->get_unique_terms_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  result = (Xapian::termcount)((Xapian::Query const *)arg1)->get_length();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Query_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  result = (bool)((Xapian::Query const *)arg1)->empty();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_Query_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1unserialise_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Registry *arg2 = 0 ;
  jbyte *jarr1 ;
  std::string c_arg1 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (!jarg1)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr1 = jenv->GetByteArrayElements(jarg1, NULL);
  if (!jarr1) return 0;
  c_arg1.assign(reinterpret_cast<char*>(jarr1), jenv->GetArrayLength(jarg1));
  jenv->ReleaseByteArrayElements(jarg1, jarr1, JNI_ABORT);
  arg1 = &c_arg1;
  
  arg2 = *(Xapian::Registry **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Registry const & reference is null");
    return 0;
  } 
  {
    try {
      result = Xapian::Query::unserialise((std::string const &)*arg1,(Xapian::Registry const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1unserialise_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jbyteArray jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  jbyte *jarr1 ;
  std::string c_arg1 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  
  if (!jarg1)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr1 = jenv->GetByteArrayElements(jarg1, NULL);
  if (!jarr1) return 0;
  c_arg1.assign(reinterpret_cast<char*>(jarr1), jenv->GetArrayLength(jarg1));
  jenv->ReleaseByteArrayElements(jarg1, jarr1, JNI_ABORT);
  arg1 = &c_arg1;
  
  {
    try {
      result = Xapian::Query::unserialise((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Query_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  result = (Xapian::Query::op)((Xapian::Query const *)arg1)->get_type();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getNumSubqueries(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  result = ((Xapian::Query const *)arg1)->get_num_subqueries();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Query_1getSubquery(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  size_t arg2 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_subquery(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Query_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Query *arg1 = (Xapian::Query *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Query **)&jarg1; 
  {
    try {
      result = ((Xapian::Query const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Query_1_1SWIG_121(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::Query::op arg1 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::Query::op)jarg1; 
  {
    try {
      result = (Xapian::Query *)new Xapian::Query(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1StemImplementation(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::StemImplementation *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::StemImplementation *)new SwigDirector_StemImplementation(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::StemImplementation **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1StemImplementation(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_StemImplementation_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_StemImplementation_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  {
    try {
      result = ((Xapian::StemImplementation const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_StemImplementation_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::StemImplementation *obj = *((Xapian::StemImplementation **)&objarg);
  (void)jcls;
  SwigDirector_StemImplementation *director = dynamic_cast<SwigDirector_StemImplementation *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_StemImplementation_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::StemImplementation *obj = *((Xapian::StemImplementation **)&objarg);
  SwigDirector_StemImplementation *director = dynamic_cast<SwigDirector_StemImplementation *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Stem_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Stem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::Stem *)new Xapian::Stem((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Stem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Stem_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Xapian::Stem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (Xapian::Stem *)new Xapian::Stem((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Stem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Stem_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::StemImplementation *arg1 = (Xapian::StemImplementation *) 0 ;
  Xapian::Stem *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StemImplementation **)&jarg1; 
  {
    try {
      result = (Xapian::Stem *)new Xapian::Stem(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Stem **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Stem(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Stem **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Stem_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stem **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Stem const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Stem_1isNone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stem **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::Stem const *)arg1)->is_none();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Stem_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Stem *arg1 = (Xapian::Stem *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stem **)&jarg1; 
  {
    try {
      result = ((Xapian::Stem const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Stem_1getAvailableLanguages(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Xapian::Stem::get_available_languages();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1TermGenerator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TermGenerator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::TermGenerator *)new Xapian::TermGenerator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermGenerator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1TermGenerator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setStemmer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Stem *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::Stem **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_stemmer((Xapian::Stem const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setStopper_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Stopper *arg2 = (Xapian::Stopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::Stopper **)&jarg2; 
  {
    try {
      (arg1)->set_stopper((Xapian::Stopper const *)arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setStopper_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      (arg1)->set_stopper();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Document *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_document((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermGenerator_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::Document *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      result = (Xapian::Document *) &((Xapian::TermGenerator const *)arg1)->get_document();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::WritableDatabase *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = *(Xapian::WritableDatabase **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::WritableDatabase const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_database((Xapian::WritableDatabase const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_TermGenerator_1FLAG_1SPELLING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::TermGenerator::FLAG_SPELLING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_TermGenerator_1FLAG_1CJK_1NGRAM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::TermGenerator::FLAG_CJK_NGRAM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setFlags_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::TermGenerator::flags arg2 ;
  Xapian::TermGenerator::flags arg3 ;
  Xapian::TermGenerator::flags result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::TermGenerator::flags)jarg2; 
  arg3 = (Xapian::TermGenerator::flags)jarg3; 
  {
    try {
      result = (Xapian::TermGenerator::flags)(arg1)->set_flags(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setFlags_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::TermGenerator::flags arg2 ;
  Xapian::TermGenerator::flags result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::TermGenerator::flags)jarg2; 
  {
    try {
      result = (Xapian::TermGenerator::flags)(arg1)->set_flags(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setStemmingStrategy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::TermGenerator::stem_strategy arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::TermGenerator::stem_strategy)jarg2; 
  {
    try {
      (arg1)->set_stemming_strategy(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setStopperStrategy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::TermGenerator::stop_strategy arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::TermGenerator::stop_strategy)jarg2; 
  {
    try {
      (arg1)->set_stopper_strategy(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setMaxWordLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->set_max_word_length(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1indexText_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->index_text((std::string const &)*arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1indexText_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->index_text((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1indexText_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->index_text((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1indexTextWithoutPositions_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->index_text_without_positions((std::string const &)*arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1indexTextWithoutPositions_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->index_text_without_positions((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1indexTextWithoutPositions_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->index_text_without_positions((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1increaseTermpos_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::termpos arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::termpos)jarg2; 
  {
    try {
      (arg1)->increase_termpos(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1increaseTermpos_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      (arg1)->increase_termpos();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TermGenerator_1getTermPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::termpos result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      result = (Xapian::termpos)((Xapian::TermGenerator const *)arg1)->get_termpos();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_TermGenerator_1setTermpos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  Xapian::termpos arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  arg2 = (Xapian::termpos)jarg2; 
  {
    try {
      (arg1)->set_termpos(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_TermGenerator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TermGenerator *arg1 = (Xapian::TermGenerator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TermGenerator **)&jarg1; 
  {
    try {
      result = ((Xapian::TermGenerator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1MSet(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MSet *)new Xapian::MSet();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1MSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MSet **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1convertToPercent_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jint jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  double arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (int)((Xapian::MSet const *)arg1)->convert_to_percent(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1convertToPercent_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (int)((Xapian::MSet const *)arg1)->convert_to_percent((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getTermFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_termfreq((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_MSet_1getTermWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jdouble jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (double)((Xapian::MSet const *)arg1)->get_termweight((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getFirstItem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_firstitem();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getMatchesLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_matches_lower_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getMatchesEstimated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_matches_estimated();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getMatchesUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_matches_upper_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getUncollapsedMatchesLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_uncollapsed_matches_lower_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getUncollapsedMatchesEstimated(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_uncollapsed_matches_estimated();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getUncollapsedMatchesUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->get_uncollapsed_matches_upper_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_MSet_1getMaxAttained(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (double)((Xapian::MSet const *)arg1)->get_max_attained();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_MSet_1getMaxPossible(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (double)((Xapian::MSet const *)arg1)->get_max_possible();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1SNIPPET_1BACKGROUND_1MODEL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::MSet::SNIPPET_BACKGROUND_MODEL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1SNIPPET_1EXHAUSTIVE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::MSet::SNIPPET_EXHAUSTIVE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1SNIPPET_1EMPTY_1WITHOUT_1MATCH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::MSet::SNIPPET_EMPTY_WITHOUT_MATCH;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1SNIPPET_1CJK_1NGRAM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::MSet::SNIPPET_CJK_NGRAM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jstring jarg6, jstring jarg7, jstring jarg8) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  Xapian::Stem *arg4 = 0 ;
  unsigned int arg5 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(Xapian::Stem **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return 0;
  } 
  arg5 = (unsigned int)jarg5; 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  if(!jarg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0); 
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  jenv->ReleaseStringUTFChars(jarg7, arg7_pstr); 
  if(!jarg8) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0); 
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  jenv->ReleaseStringUTFChars(jarg8, arg8_pstr); 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2,arg3,(Xapian::Stem const &)*arg4,arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jstring jarg6, jstring jarg7) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  Xapian::Stem *arg4 = 0 ;
  unsigned int arg5 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(Xapian::Stem **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return 0;
  } 
  arg5 = (unsigned int)jarg5; 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  if(!jarg7) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0); 
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  jenv->ReleaseStringUTFChars(jarg7, arg7_pstr); 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2,arg3,(Xapian::Stem const &)*arg4,arg5,(std::string const &)*arg6,(std::string const &)*arg7);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jstring jarg6) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  Xapian::Stem *arg4 = 0 ;
  unsigned int arg5 ;
  std::string *arg6 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(Xapian::Stem **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return 0;
  } 
  arg5 = (unsigned int)jarg5; 
  if(!jarg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0); 
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  jenv->ReleaseStringUTFChars(jarg6, arg6_pstr); 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2,arg3,(Xapian::Stem const &)*arg4,arg5,(std::string const &)*arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  Xapian::Stem *arg4 = 0 ;
  unsigned int arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(Xapian::Stem **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return 0;
  } 
  arg5 = (unsigned int)jarg5; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2,arg3,(Xapian::Stem const &)*arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  Xapian::Stem *arg4 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(Xapian::Stem **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2,arg3,(Xapian::Stem const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1snippet_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->snippet((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MSet_1fetch_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::MSetIterator *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return ;
  } 
  arg3 = *(Xapian::MSetIterator **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return ;
  } 
  {
    try {
      ((Xapian::MSet const *)arg1)->fetch((Xapian::MSetIterator const &)*arg2,(Xapian::MSetIterator const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MSet_1fetch_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return ;
  } 
  {
    try {
      ((Xapian::MSet const *)arg1)->fetch((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MSet_1fetch_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      ((Xapian::MSet const *)arg1)->fetch();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSet const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_MSet_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::MSet const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->operator [](arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->back();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSet_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  {
    try {
      result = ((Xapian::MSet const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = (Xapian::docid)Xapian_MSet_get_docid((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = Xapian_MSet_get_document((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSet_1getHit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::MSetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = Xapian_MSet_get_hit((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSetIterator **)&jresult = new Xapian::MSetIterator((const Xapian::MSetIterator &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSet_1getDocumentPercentage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jint jresult = 0 ;
  Xapian::MSet *arg1 = (Xapian::MSet *) 0 ;
  Xapian::doccount arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSet **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      result = (int)Xapian_MSet_get_document_percentage((Xapian::MSet const *)arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MSetIterator_1mset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::MSet *arg2 = (Xapian::MSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  arg2 = *(Xapian::MSet **)&jarg2; 
  if (arg1) (arg1)->mset = *arg2;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1mset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::MSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  result = (Xapian::MSet *)& ((arg1)->mset);
  *(Xapian::MSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MSetIterator_1off_1from_1end_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::MSet::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  arg2 = (Xapian::MSet::size_type)jarg2; 
  if (arg1) (arg1)->off_from_end = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1off_1from_1end_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::MSet::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  result = (Xapian::MSet::size_type) ((arg1)->off_from_end);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1MSetIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MSetIterator *)new Xapian::MSetIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSetIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getRank(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSetIterator const *)arg1)->get_rank();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_document();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (double)((Xapian::MSetIterator const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getCollapseKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_collapse_key();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getCollapseCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::MSetIterator const *)arg1)->get_collapse_count();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getSortKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_sort_key();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getPercent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (int)((Xapian::MSetIterator const *)arg1)->get_percent();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MSetIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::MSetIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  result = (Xapian::docid)Xapian_MSetIterator_next(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_MSetIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  result = (bool)Xapian_MSetIterator_hasNext((Xapian::MSetIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_MSetIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_MSetIterator_equals((Xapian::MSetIterator const *)arg1,(Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_MSetIterator_get_docid((Xapian::MSetIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MSetIterator_1prev(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  {
    try {
      result = (Xapian::docid)Xapian_MSetIterator_prev(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1MSetIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MSetIterator *arg1 = (Xapian::MSetIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MSetIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ESet(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ESet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ESet *)new Xapian::ESet();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ESet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ESet **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESet_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ESet const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ESet_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::ESet const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESet_1getEbound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::ESet const *)arg1)->get_ebound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESet_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::ESetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESetIterator **)&jresult = new Xapian::ESetIterator((const Xapian::ESetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESet_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::ESetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESetIterator **)&jresult = new Xapian::ESetIterator((const Xapian::ESetIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESet_1back(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  Xapian::ESetIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->back();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESetIterator **)&jresult = new Xapian::ESetIterator((const Xapian::ESetIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ESet_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESet *arg1 = (Xapian::ESet *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESet **)&jarg1; 
  {
    try {
      result = ((Xapian::ESet const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ESetIterator_1eset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::ESet *arg2 = (Xapian::ESet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  arg2 = *(Xapian::ESet **)&jarg2; 
  if (arg1) (arg1)->eset = *arg2;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESetIterator_1eset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::ESet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  result = (Xapian::ESet *)& ((arg1)->eset);
  *(Xapian::ESet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ESetIterator_1off_1from_1end_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::ESet::size_type arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  arg2 = (Xapian::ESet::size_type)jarg2; 
  if (arg1) (arg1)->off_from_end = arg2;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ESetIterator_1off_1from_1end_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::ESet::size_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  result = (Xapian::ESet::size_type) ((arg1)->off_from_end);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ESetIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ESetIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ESetIterator *)new Xapian::ESetIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESetIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_ESetIterator_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = (double)((Xapian::ESetIterator const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ESetIterator_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = ((Xapian::ESetIterator const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ESetIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  result = Xapian_ESetIterator_next(arg1);
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ESetIterator_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  result = (bool)Xapian_ESetIterator_hasNext((Xapian::ESetIterator const *)arg1);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ESetIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  Xapian::ESetIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  arg2 = *(Xapian::ESetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ESetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_ESetIterator_equals((Xapian::ESetIterator const *)arg1,(Xapian::ESetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ESetIterator_1getTerm(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = Xapian_ESetIterator_get_term((Xapian::ESetIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ESetIterator_1prev(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  {
    try {
      result = Xapian_ESetIterator_prev(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ESetIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ESetIterator *arg1 = (Xapian::ESetIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ESetIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1RSet(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::RSet *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::RSet *)new Xapian::RSet();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::RSet **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1RSet(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::RSet **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_RSet_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::RSet const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_RSet_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::RSet const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_RSet_1addDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->add_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_RSet_1addDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->add_document((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_RSet_1removeDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->remove_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_RSet_1removeDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->remove_document((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_RSet_1contains_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jboolean jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::docid arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (bool)((Xapian::RSet const *)arg1)->contains(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_RSet_1contains_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((Xapian::RSet const *)arg1)->contains((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_RSet_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::RSet *arg1 = (Xapian::RSet *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RSet **)&jarg1; 
  {
    try {
      result = ((Xapian::RSet const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1MatchDecider(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MatchDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MatchDecider *)new SwigDirector_MatchDecider(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MatchDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_MatchDecider_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::MatchDecider *arg1 = (Xapian::MatchDecider *) 0 ;
  Xapian::Document *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MatchDecider **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((Xapian::MatchDecider const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1MatchDecider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MatchDecider *arg1 = (Xapian::MatchDecider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MatchDecider **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchDecider_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::MatchDecider *obj = *((Xapian::MatchDecider **)&objarg);
  (void)jcls;
  SwigDirector_MatchDecider *director = dynamic_cast<SwigDirector_MatchDecider *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchDecider_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::MatchDecider *obj = *((Xapian::MatchDecider **)&objarg);
  SwigDirector_MatchDecider *director = dynamic_cast<SwigDirector_MatchDecider *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Enquire(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = 0 ;
  Xapian::Enquire *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::Enquire *)new Xapian::Enquire((Xapian::Database const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Enquire **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Enquire(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setQuery_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Query *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return ;
  } 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      (arg1)->set_query((Xapian::Query const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setQuery_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Query *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Query **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Query const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_query((Xapian::Query const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Query *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      result = (Xapian::Query *) &((Xapian::Enquire const *)arg1)->get_query();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1addMatchspy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MatchSpy *arg2 = (Xapian::MatchSpy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MatchSpy **)&jarg2; 
  {
    try {
      (arg1)->add_matchspy(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1clearMatchspies(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      (arg1)->clear_matchspies();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setWeightingScheme(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Weight *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::Weight **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Weight const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_weighting_scheme((Xapian::Weight const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setExpansionScheme_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  std::string *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (double)jarg3; 
  {
    try {
      ((Xapian::Enquire const *)arg1)->set_expansion_scheme((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setExpansionScheme_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::Enquire const *)arg1)->set_expansion_scheme((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setCollapseKey_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::doccount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  {
    try {
      (arg1)->set_collapse_key(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setCollapseKey_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->set_collapse_key(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Enquire_1ASCENDING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Enquire::docid_order result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Enquire::docid_order)Xapian::Enquire::ASCENDING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Enquire_1DESCENDING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Enquire::docid_order result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Enquire::docid_order)Xapian::Enquire::DESCENDING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Enquire_1DONT_1CARE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Enquire::docid_order result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Enquire::docid_order)Xapian::Enquire::DONT_CARE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setDocidOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::Enquire::docid_order arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::Enquire::docid_order)jarg2; 
  {
    try {
      (arg1)->set_docid_order(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setCutoff_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  int arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->set_cutoff(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setCutoff_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->set_cutoff(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByRelevance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      (arg1)->set_sort_by_relevance();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_value(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::KeyMaker *arg2 = (Xapian::KeyMaker *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::KeyMaker **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_key(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByValueThenRelevance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_value_then_relevance(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByKeyThenRelevance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::KeyMaker *arg2 = (Xapian::KeyMaker *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::KeyMaker **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_key_then_relevance(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByRelevanceThenValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_relevance_then_value(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setSortByRelevanceThenKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::KeyMaker *arg2 = (Xapian::KeyMaker *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::KeyMaker **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->set_sort_by_relevance_then_key(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Enquire_1setTimeLimit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->set_time_limit(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::RSet *arg5 = (Xapian::RSet *) 0 ;
  Xapian::MatchDecider *arg6 = (Xapian::MatchDecider *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  arg5 = *(Xapian::RSet **)&jarg5; 
  arg6 = *(Xapian::MatchDecider **)&jarg6; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4,(Xapian::RSet const *)arg5,(Xapian::MatchDecider const *)arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::RSet *arg5 = (Xapian::RSet *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  arg5 = *(Xapian::RSet **)&jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4,(Xapian::RSet const *)arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMSet_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::doccount arg4 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = (Xapian::doccount)jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMSet_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMSet_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::RSet *arg4 = (Xapian::RSet *) 0 ;
  Xapian::MatchDecider *arg5 = (Xapian::MatchDecider *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = *(Xapian::RSet **)&jarg4; 
  arg5 = *(Xapian::MatchDecider **)&jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,(Xapian::RSet const *)arg4,(Xapian::MatchDecider const *)arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMSet_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::doccount arg2 ;
  Xapian::doccount arg3 ;
  Xapian::RSet *arg4 = (Xapian::RSet *) 0 ;
  Xapian::MSet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg4_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  arg3 = (Xapian::doccount)jarg3; 
  arg4 = *(Xapian::RSet **)&jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_mset(arg2,arg3,(Xapian::RSet const *)arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MSet **)&jresult = new Xapian::MSet((const Xapian::MSet &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Enquire_1INCLUDE_1QUERY_1TERMS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Enquire::INCLUDE_QUERY_TERMS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Enquire_1USE_1EXACT_1TERMFREQ_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)Xapian::Enquire::USE_EXACT_TERMFREQ;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jlong jarg5, jobject jarg5_, jdouble jarg6) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  Xapian::ExpandDecider *arg5 = (Xapian::ExpandDecider *) 0 ;
  double arg6 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = *(Xapian::ExpandDecider **)&jarg5; 
  arg6 = (double)jarg6; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,(Xapian::ExpandDecider const *)arg5,arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  Xapian::ExpandDecider *arg5 = (Xapian::ExpandDecider *) 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = *(Xapian::ExpandDecider **)&jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,(Xapian::ExpandDecider const *)arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  Xapian::ExpandDecider *arg4 = (Xapian::ExpandDecider *) 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = *(Xapian::ExpandDecider **)&jarg4; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,(Xapian::ExpandDecider const *)arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jdouble jarg5, jlong jarg6, jobject jarg6_, jdouble jarg7) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  double arg5 ;
  Xapian::ExpandDecider *arg6 = (Xapian::ExpandDecider *) 0 ;
  double arg7 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg6_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = *(Xapian::ExpandDecider **)&jarg6; 
  arg7 = (double)jarg7; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,arg5,(Xapian::ExpandDecider const *)arg6,arg7);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jdouble jarg5, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  double arg5 ;
  Xapian::ExpandDecider *arg6 = (Xapian::ExpandDecider *) 0 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg6_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = *(Xapian::ExpandDecider **)&jarg6; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,arg5,(Xapian::ExpandDecider const *)arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getESet_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::RSet *arg3 = 0 ;
  int arg4 ;
  double arg5 ;
  Xapian::ESet result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = *(Xapian::RSet **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::RSet const & reference is null");
    return 0;
  } 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_eset(arg2,(Xapian::RSet const &)*arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ESet **)&jresult = new Xapian::ESet((const Xapian::ESet &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMatchingTermsBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_matching_terms_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMatchingTermsEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  result = ((Xapian::Enquire const *)arg1)->get_matching_terms_end(arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMatchingTermsBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_matching_terms_begin((Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Enquire_1getMatchingTermsEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  result = ((Xapian::Enquire const *)arg1)->get_matching_terms_end((Xapian::MSetIterator const &)*arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Enquire_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  {
    try {
      result = ((Xapian::Enquire const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_org_xapian_XapianJNI_Enquire_1getMatchingTerms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jobjectArray jresult = 0 ;
  Xapian::Enquire *arg1 = (Xapian::Enquire *) 0 ;
  Xapian::MSetIterator *arg2 = 0 ;
  std::pair< Xapian::TermIterator,Xapian::TermIterator > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Enquire **)&jarg1; 
  arg2 = *(Xapian::MSetIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::MSetIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = Xapian_Enquire_get_matching_terms((Xapian::Enquire const *)arg1,(Xapian::MSetIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    jobjectArray c_result;
    jboolean jbool;
    jstring temp_string;
    int n = 0;
    const jclass clazz = jenv->FindClass("java/lang/String");
    const jclass arrayClass = jenv->FindClass("java/util/ArrayList");
    if (arrayClass == NULL)
    return NULL;
    
    const jmethodID mid_init = jenv->GetMethodID(arrayClass, "<init>", "()V");
    if (mid_init == NULL)
    return NULL;
    
    jobject objArr = jenv->NewObject(arrayClass, mid_init);
    if (objArr == NULL)
    return NULL;
    
    const jmethodID mid_add = jenv->GetMethodID(arrayClass, "add",
      "(Ljava/lang/Object;)Z");
    if (mid_add == NULL)
    return NULL;
    
    const jmethodID mid_toArray = jenv->GetMethodID(arrayClass, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
    if (mid_toArray == NULL) return NULL;
    
    for (Xapian::TermIterator i = (&result)->first; i != (&result)->second; ++i) {
      temp_string = jenv->NewStringUTF((*i).c_str());
      jbool = jenv->CallBooleanMethod(objArr, mid_add, temp_string);
      if (jbool == false) return NULL;
      jenv->DeleteLocalRef(temp_string);
      ++n;
    }
    
    c_result = jenv->NewObjectArray(n, clazz, NULL);
    jresult = (jobjectArray)jenv->CallObjectMethod(objArr, mid_toArray, c_result);
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ExpandDecider(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ExpandDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ExpandDecider *)new SwigDirector_ExpandDecider(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ExpandDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ExpandDecider_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::ExpandDecider *arg1 = (Xapian::ExpandDecider *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ExpandDecider **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::ExpandDecider const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ExpandDecider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ExpandDecider *arg1 = (Xapian::ExpandDecider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ExpandDecider **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ExpandDecider_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ExpandDecider *arg1 = (Xapian::ExpandDecider *) 0 ;
  Xapian::ExpandDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ExpandDecider **)&jarg1; 
  {
    try {
      result = (Xapian::ExpandDecider *)((Xapian::ExpandDecider const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ExpandDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ExpandDecider_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::ExpandDecider *obj = *((Xapian::ExpandDecider **)&objarg);
  (void)jcls;
  SwigDirector_ExpandDecider *director = dynamic_cast<SwigDirector_ExpandDecider *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ExpandDecider_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::ExpandDecider *obj = *((Xapian::ExpandDecider **)&objarg);
  SwigDirector_ExpandDecider *director = dynamic_cast<SwigDirector_ExpandDecider *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ExpandDeciderAnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::ExpandDecider *arg1 = 0 ;
  Xapian::ExpandDecider *arg2 = 0 ;
  Xapian::ExpandDeciderAnd *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ExpandDecider **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ExpandDecider const & reference is null");
    return 0;
  } 
  arg2 = *(Xapian::ExpandDecider **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::ExpandDecider const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::ExpandDeciderAnd *)new Xapian::ExpandDeciderAnd((Xapian::ExpandDecider const &)*arg1,(Xapian::ExpandDecider const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ExpandDeciderAnd **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ExpandDeciderAnd_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::ExpandDeciderAnd *arg1 = (Xapian::ExpandDeciderAnd *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ExpandDeciderAnd **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::ExpandDeciderAnd const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ExpandDeciderAnd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ExpandDeciderAnd *arg1 = (Xapian::ExpandDeciderAnd *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ExpandDeciderAnd **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ExpandDeciderFilterPrefix(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::ExpandDeciderFilterPrefix *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::ExpandDeciderFilterPrefix *)new Xapian::ExpandDeciderFilterPrefix((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ExpandDeciderFilterPrefix **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ExpandDeciderFilterPrefix_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::ExpandDeciderFilterPrefix *arg1 = (Xapian::ExpandDeciderFilterPrefix *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ExpandDeciderFilterPrefix **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::ExpandDeciderFilterPrefix const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ExpandDeciderFilterPrefix(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ExpandDeciderFilterPrefix *arg1 = (Xapian::ExpandDeciderFilterPrefix *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ExpandDeciderFilterPrefix **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1KeyMaker(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::KeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::KeyMaker *)new SwigDirector_KeyMaker(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::KeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_KeyMaker_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  Xapian::KeyMaker *arg1 = (Xapian::KeyMaker *) 0 ;
  Xapian::Document *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::KeyMaker **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::KeyMaker const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1KeyMaker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::KeyMaker *arg1 = (Xapian::KeyMaker *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::KeyMaker **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_KeyMaker_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::KeyMaker *arg1 = (Xapian::KeyMaker *) 0 ;
  Xapian::KeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::KeyMaker **)&jarg1; 
  {
    try {
      result = (Xapian::KeyMaker *)((Xapian::KeyMaker const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::KeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_KeyMaker_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::KeyMaker *obj = *((Xapian::KeyMaker **)&objarg);
  (void)jcls;
  SwigDirector_KeyMaker *director = dynamic_cast<SwigDirector_KeyMaker *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_KeyMaker_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::KeyMaker *obj = *((Xapian::KeyMaker **)&objarg);
  SwigDirector_KeyMaker *director = dynamic_cast<SwigDirector_KeyMaker *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1MultiValueKeyMaker(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MultiValueKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::MultiValueKeyMaker *)new Xapian::MultiValueKeyMaker();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MultiValueKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MultiValueKeyMaker_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::Document *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::MultiValueKeyMaker const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MultiValueKeyMaker_1addValue_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3, jstring jarg4) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      (arg1)->add_value(arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MultiValueKeyMaker_1addValue_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::valueno arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->add_value(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MultiValueKeyMaker_1addValue_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  Xapian::valueno arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      (arg1)->add_value(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1MultiValueKeyMaker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MultiValueKeyMaker *arg1 = (Xapian::MultiValueKeyMaker *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MultiValueKeyMaker **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_RP_1SUFFIX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::RP_SUFFIX);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_RP_1REPEATED_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::RP_REPEATED);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_RP_1DATE_1PREFER_1MDY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(Xapian::RP_DATE_PREFER_MDY);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Stopper(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Stopper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Stopper *)new SwigDirector_Stopper(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Stopper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Stopper_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::Stopper const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Stopper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Stopper_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  {
    try {
      result = ((Xapian::Stopper const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Stopper_1toStringSwigExplicitStopper(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  {
    try {
      result = ((Xapian::Stopper const *)arg1)->Xapian::Stopper::get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Stopper_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Stopper *arg1 = (Xapian::Stopper *) 0 ;
  Xapian::Stopper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Stopper **)&jarg1; 
  {
    try {
      result = (Xapian::Stopper *)((Xapian::Stopper const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Stopper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Stopper_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::Stopper *obj = *((Xapian::Stopper **)&objarg);
  (void)jcls;
  SwigDirector_Stopper *director = dynamic_cast<SwigDirector_Stopper *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Stopper_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::Stopper *obj = *((Xapian::Stopper **)&objarg);
  SwigDirector_Stopper *director = dynamic_cast<SwigDirector_Stopper *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1SimpleStopper_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::SimpleStopper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::SimpleStopper *)new Xapian::SimpleStopper();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::SimpleStopper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_SimpleStopper_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_SimpleStopper_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::SimpleStopper const *)arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_SimpleStopper_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  {
    try {
      result = ((Xapian::SimpleStopper const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1SimpleStopper_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::SimpleStopper *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::SimpleStopper *)new_Xapian_SimpleStopper__SWIG_2((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::SimpleStopper **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1SimpleStopper(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::SimpleStopper *arg1 = (Xapian::SimpleStopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::SimpleStopper **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1RangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::RangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::RangeProcessor *)new SwigDirector_RangeProcessor(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::RangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1RangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  Xapian::RangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = (Xapian::RangeProcessor *)new SwigDirector_RangeProcessor(jenv,arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::RangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1RangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::RangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::RangeProcessor *)new SwigDirector_RangeProcessor(jenv,arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::RangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1RangeProcessor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::RangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::RangeProcessor *)new SwigDirector_RangeProcessor(jenv,arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::RangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1RangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::RangeProcessor *arg1 = (Xapian::RangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::RangeProcessor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_RangeProcessor_1checkRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::RangeProcessor *arg1 = (Xapian::RangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RangeProcessor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (arg1)->check_range((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_RangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::RangeProcessor *arg1 = (Xapian::RangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RangeProcessor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (arg1)->operator ()((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_RangeProcessor_1applySwigExplicitRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::RangeProcessor *arg1 = (Xapian::RangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RangeProcessor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (arg1)->Xapian::RangeProcessor::operator ()((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_RangeProcessor_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::RangeProcessor *arg1 = (Xapian::RangeProcessor *) 0 ;
  Xapian::RangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::RangeProcessor **)&jarg1; 
  {
    try {
      result = (Xapian::RangeProcessor *)((Xapian::RangeProcessor const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::RangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_RangeProcessor_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::RangeProcessor *obj = *((Xapian::RangeProcessor **)&objarg);
  (void)jcls;
  SwigDirector_RangeProcessor *director = dynamic_cast<SwigDirector_RangeProcessor *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_RangeProcessor_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::RangeProcessor *obj = *((Xapian::RangeProcessor **)&objarg);
  SwigDirector_RangeProcessor *director = dynamic_cast<SwigDirector_RangeProcessor *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  unsigned int arg2 ;
  int arg3 ;
  Xapian::DateRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (Xapian::DateRangeProcessor *)new Xapian::DateRangeProcessor(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  unsigned int arg2 ;
  Xapian::DateRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = (Xapian::DateRangeProcessor *)new Xapian::DateRangeProcessor(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::DateRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::DateRangeProcessor *)new Xapian::DateRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateRangeProcessor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  int arg4 ;
  Xapian::DateRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  arg4 = (int)jarg4; 
  {
    try {
      result = (Xapian::DateRangeProcessor *)new Xapian::DateRangeProcessor(arg1,(std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateRangeProcessor_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  Xapian::DateRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = (Xapian::DateRangeProcessor *)new Xapian::DateRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateRangeProcessor_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::DateRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::DateRangeProcessor *)new Xapian::DateRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_DateRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::DateRangeProcessor *arg1 = (Xapian::DateRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DateRangeProcessor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (arg1)->operator ()((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1DateRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DateRangeProcessor *arg1 = (Xapian::DateRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DateRangeProcessor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1NumberRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  Xapian::NumberRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = (Xapian::NumberRangeProcessor *)new Xapian::NumberRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::NumberRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1NumberRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::NumberRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::NumberRangeProcessor *)new Xapian::NumberRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::NumberRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1NumberRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::NumberRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::NumberRangeProcessor *)new Xapian::NumberRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::NumberRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_NumberRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::NumberRangeProcessor *arg1 = (Xapian::NumberRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::NumberRangeProcessor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (arg1)->operator ()((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1NumberRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::NumberRangeProcessor *arg1 = (Xapian::NumberRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::NumberRangeProcessor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueRangeProcessor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ValueRangeProcessor *)new SwigDirector_ValueRangeProcessor(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueRangeProcessor *arg1 = (Xapian::ValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueRangeProcessor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_ValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::ValueRangeProcessor *arg1 = (Xapian::ValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueRangeProcessor_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueRangeProcessor *arg1 = (Xapian::ValueRangeProcessor *) 0 ;
  Xapian::ValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueRangeProcessor **)&jarg1; 
  {
    try {
      result = (Xapian::ValueRangeProcessor *)((Xapian::ValueRangeProcessor const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueRangeProcessor_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::ValueRangeProcessor *obj = *((Xapian::ValueRangeProcessor **)&objarg);
  (void)jcls;
  SwigDirector_ValueRangeProcessor *director = dynamic_cast<SwigDirector_ValueRangeProcessor *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueRangeProcessor_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::ValueRangeProcessor *obj = *((Xapian::ValueRangeProcessor **)&objarg);
  SwigDirector_ValueRangeProcessor *director = dynamic_cast<SwigDirector_ValueRangeProcessor *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1StringValueRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::StringValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::StringValueRangeProcessor *)new Xapian::StringValueRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::StringValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1StringValueRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  Xapian::StringValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Xapian::StringValueRangeProcessor *)new Xapian::StringValueRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::StringValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1StringValueRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::StringValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::StringValueRangeProcessor *)new Xapian::StringValueRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::StringValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_StringValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::StringValueRangeProcessor *arg1 = (Xapian::StringValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::StringValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1StringValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::StringValueRangeProcessor *arg1 = (Xapian::StringValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::StringValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2, jint jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  bool arg2 ;
  int arg3 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = jarg2 ? true : false; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  bool arg2 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3, jboolean jarg4, jint jarg5) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  int arg5 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  arg5 = (int)jarg5; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DateValueRangeProcessor_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::DateValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::DateValueRangeProcessor *)new Xapian::DateValueRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DateValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_DateValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::DateValueRangeProcessor *arg1 = (Xapian::DateValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DateValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1DateValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DateValueRangeProcessor *arg1 = (Xapian::DateValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DateValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1NumberValueRangeProcessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::NumberValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::NumberValueRangeProcessor *)new Xapian::NumberValueRangeProcessor(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::NumberValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1NumberValueRangeProcessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  Xapian::NumberValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = jarg3 ? true : false; 
  {
    try {
      result = (Xapian::NumberValueRangeProcessor *)new Xapian::NumberValueRangeProcessor(arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::NumberValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1NumberValueRangeProcessor_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  std::string *arg2 = 0 ;
  Xapian::NumberValueRangeProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::NumberValueRangeProcessor *)new Xapian::NumberValueRangeProcessor(arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::NumberValueRangeProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_NumberValueRangeProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  Xapian::NumberValueRangeProcessor *arg1 = (Xapian::NumberValueRangeProcessor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::NumberValueRangeProcessor **)&jarg1; 
  arg2 = *(std::string **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  arg3 = *(std::string **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::string & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::valueno)(arg1)->operator ()(*arg2,*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1NumberValueRangeProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::NumberValueRangeProcessor *arg1 = (Xapian::NumberValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::NumberValueRangeProcessor **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1FieldProcessor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::FieldProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::FieldProcessor *)new SwigDirector_FieldProcessor(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::FieldProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1FieldProcessor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::FieldProcessor *arg1 = (Xapian::FieldProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::FieldProcessor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FieldProcessor_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::FieldProcessor *arg1 = (Xapian::FieldProcessor *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FieldProcessor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (arg1)->operator ()((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FieldProcessor_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FieldProcessor *arg1 = (Xapian::FieldProcessor *) 0 ;
  Xapian::FieldProcessor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FieldProcessor **)&jarg1; 
  {
    try {
      result = (Xapian::FieldProcessor *)((Xapian::FieldProcessor const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::FieldProcessor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_FieldProcessor_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::FieldProcessor *obj = *((Xapian::FieldProcessor **)&objarg);
  (void)jcls;
  SwigDirector_FieldProcessor *director = dynamic_cast<SwigDirector_FieldProcessor *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_FieldProcessor_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::FieldProcessor *obj = *((Xapian::FieldProcessor **)&objarg);
  SwigDirector_FieldProcessor *director = dynamic_cast<SwigDirector_FieldProcessor *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1BOOLEAN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_BOOLEAN;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1PHRASE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_PHRASE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1LOVEHATE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_LOVEHATE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1BOOLEAN_1ANY_1CASE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_BOOLEAN_ANY_CASE;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1WILDCARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_WILDCARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1PURE_1NOT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_PURE_NOT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1PARTIAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_PARTIAL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1SPELLING_1CORRECTION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_SPELLING_CORRECTION;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1SYNONYM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_SYNONYM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1AUTO_1SYNONYMS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_AUTO_SYNONYMS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1AUTO_1MULTIWORD_1SYNONYMS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_AUTO_MULTIWORD_SYNONYMS;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1CJK_1NGRAM_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_CJK_NGRAM;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1FLAG_1DEFAULT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::QueryParser::feature_flag result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::QueryParser::feature_flag)Xapian::QueryParser::FLAG_DEFAULT;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1QueryParser(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::QueryParser *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::QueryParser *)new Xapian::QueryParser();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::QueryParser **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1QueryParser(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setStemmer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Stem *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::Stem **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Stem const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_stemmer((Xapian::Stem const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setStemmingStrategy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::QueryParser::stem_strategy arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::QueryParser::stem_strategy)jarg2; 
  {
    try {
      (arg1)->set_stemming_strategy(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setStopper_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Stopper *arg2 = (Xapian::Stopper *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::Stopper **)&jarg2; 
  {
    try {
      (arg1)->set_stopper((Xapian::Stopper const *)arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setStopper_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      (arg1)->set_stopper();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setDefaultOp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Query::op arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::Query::op)jarg2; 
  {
    try {
      (arg1)->set_default_op(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_QueryParser_1getDefaultOp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Query::op result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = (Xapian::Query::op)((Xapian::QueryParser const *)arg1)->get_default_op();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->set_database((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setMaxExpansion_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3, jlong jarg4) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::termcount arg2 ;
  int arg3 ;
  unsigned int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (unsigned int)jarg4; 
  {
    try {
      (arg1)->set_max_expansion(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setMaxExpansion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::termcount arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->set_max_expansion(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setMaxExpansion_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::termcount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      (arg1)->set_max_expansion(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1setMaxWildcardExpansion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::termcount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  {
    try {
      (arg1)->set_max_wildcard_expansion(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1parseQuery_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  std::string *arg4 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  if(!jarg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0); 
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  jenv->ReleaseStringUTFChars(jarg4, arg4_pstr); 
  {
    try {
      result = (arg1)->parse_query((std::string const &)*arg2,arg3,(std::string const &)*arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1parseQuery_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = (arg1)->parse_query((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1parseQuery_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Query result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (arg1)->parse_query((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Query **)&jresult = new Xapian::Query((const Xapian::Query &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addPrefix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->add_prefix((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addPrefix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::FieldProcessor *arg3 = (Xapian::FieldProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::FieldProcessor **)&jarg3; 
  {
    try {
      (arg1)->add_prefix((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jlong jarg4) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = (std::string *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = *(std::string **)&jarg4; 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,(std::string const &)*arg3,(std::string const *)arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jboolean jarg4) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  arg4 = jarg4 ? true : false; 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,(std::string const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::FieldProcessor *arg3 = (Xapian::FieldProcessor *) 0 ;
  std::string *arg4 = (std::string *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::FieldProcessor **)&jarg3; 
  arg4 = *(std::string **)&jarg4; 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,arg3,(std::string const *)arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::FieldProcessor *arg3 = (Xapian::FieldProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::FieldProcessor **)&jarg3; 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addBooleanPrefix_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::FieldProcessor *arg3 = (Xapian::FieldProcessor *) 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::FieldProcessor **)&jarg3; 
  arg4 = jarg4 ? true : false; 
  {
    try {
      (arg1)->add_boolean_prefix((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1stopListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->stoplist_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1stopListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  result = ((Xapian::QueryParser const *)arg1)->stoplist_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1unstemBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->unstem_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_QueryParser_1unstemEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((Xapian::QueryParser const *)arg1)->unstem_end((std::string const &)*arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addRangeprocessor_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::RangeProcessor *arg2 = (Xapian::RangeProcessor *) 0 ;
  std::string *arg3 = (std::string *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::RangeProcessor **)&jarg2; 
  arg3 = *(std::string **)&jarg3; 
  {
    try {
      (arg1)->add_rangeprocessor(arg2,(std::string const *)arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addRangeprocessor_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::RangeProcessor *arg2 = (Xapian::RangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::RangeProcessor **)&jarg2; 
  {
    try {
      (arg1)->add_rangeprocessor(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_QueryParser_1addValuerangeprocessor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  Xapian::ValueRangeProcessor *arg2 = (Xapian::ValueRangeProcessor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  arg2 = *(Xapian::ValueRangeProcessor **)&jarg2; 
  {
    try {
      (arg1)->add_valuerangeprocessor(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_QueryParser_1getCorrectedQueryString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->get_corrected_query_string();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_QueryParser_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::QueryParser *arg1 = (Xapian::QueryParser *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::QueryParser **)&jarg1; 
  {
    try {
      result = ((Xapian::QueryParser const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_sortableSerialise(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jbyteArray jresult = 0 ;
  double arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = Xapian::sortable_serialise(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_sortableUnserialise(JNIEnv *jenv, jclass jcls, jbyteArray jarg1) {
  jdouble jresult = 0 ;
  std::string *arg1 = 0 ;
  jbyte *jarr1 ;
  std::string c_arg1 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  
  if (!jarg1)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr1 = jenv->GetByteArrayElements(jarg1, NULL);
  if (!jarr1) return 0;
  c_arg1.assign(reinterpret_cast<char*>(jarr1), jenv->GetArrayLength(jarg1));
  jenv->ReleaseByteArrayElements(jarg1, jarr1, JNI_ABORT);
  arg1 = &c_arg1;
  
  {
    try {
      result = (double)Xapian::sortable_unserialise((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueSetMatchDecider(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  bool arg2 ;
  Xapian::ValueSetMatchDecider *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (Xapian::ValueSetMatchDecider *)new Xapian::ValueSetMatchDecider(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueSetMatchDecider **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueSetMatchDecider_1addValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->add_value((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueSetMatchDecider_1removeValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->remove_value((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValueSetMatchDecider_1accept(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  Xapian::Document *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)((Xapian::ValueSetMatchDecider const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValueSetMatchDecider(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueSetMatchDecider *arg1 = (Xapian::ValueSetMatchDecider *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueSetMatchDecider **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Weight_1TWO_1STAGE_1SMOOTHING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Weight::type_smoothing result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Weight::type_smoothing)Xapian::Weight::TWO_STAGE_SMOOTHING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Weight_1DIRICHLET_1SMOOTHING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Weight::type_smoothing result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Weight::type_smoothing)Xapian::Weight::DIRICHLET_SMOOTHING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Weight_1ABSOLUTE_1DISCOUNT_1SMOOTHING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Weight::type_smoothing result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Weight::type_smoothing)Xapian::Weight::ABSOLUTE_DISCOUNT_SMOOTHING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Weight_1JELINEK_1MERCER_1SMOOTHING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Weight::type_smoothing result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Weight::type_smoothing)Xapian::Weight::JELINEK_MERCER_SMOOTHING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Weight_1DIRICHLET_1PLUS_1SMOOTHING_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Weight::type_smoothing result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Weight::type_smoothing)Xapian::Weight::DIRICHLET_PLUS_SMOOTHING;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::Weight *arg1 = (Xapian::Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BoolWeight(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::BoolWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::BoolWeight *)new Xapian::BoolWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BoolWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_BoolWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::BoolWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BoolWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::BoolWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BoolWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BoolWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BoolWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::BoolWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BoolWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BoolWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1BoolWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::BoolWeight *arg1 = (Xapian::BoolWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::BoolWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1TfIdfWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::TfIdfWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::TfIdfWeight *)new Xapian::TfIdfWeight((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TfIdfWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1TfIdfWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TfIdfWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::TfIdfWeight *)new Xapian::TfIdfWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TfIdfWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_TfIdfWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TfIdfWeight *arg1 = (Xapian::TfIdfWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TfIdfWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::TfIdfWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TfIdfWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::TfIdfWeight *arg1 = (Xapian::TfIdfWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TfIdfWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::TfIdfWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TfIdfWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::TfIdfWeight *arg1 = (Xapian::TfIdfWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TfIdfWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::TfIdfWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TfIdfWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::TfIdfWeight *arg1 = (Xapian::TfIdfWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TfIdfWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::TfIdfWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TfIdfWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::TfIdfWeight *arg1 = (Xapian::TfIdfWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TfIdfWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::TfIdfWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1TfIdfWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TfIdfWeight *arg1 = (Xapian::TfIdfWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TfIdfWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BM25Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  Xapian::BM25Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  {
    try {
      result = (Xapian::BM25Weight *)new Xapian::BM25Weight(arg1,arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BM25Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BM25Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::BM25Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::BM25Weight *)new Xapian::BM25Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BM25Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_BM25Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::BM25Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::BM25Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BM25Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::BM25Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BM25Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1BM25Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::BM25Weight *arg1 = (Xapian::BM25Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::BM25Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BM25PlusWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jdouble jarg6) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  Xapian::BM25PlusWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  {
    try {
      result = (Xapian::BM25PlusWeight *)new Xapian::BM25PlusWeight(arg1,arg2,arg3,arg4,arg5,arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BM25PlusWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BM25PlusWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::BM25PlusWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::BM25PlusWeight *)new Xapian::BM25PlusWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BM25PlusWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_BM25PlusWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::BM25PlusWeight *arg1 = (Xapian::BM25PlusWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25PlusWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::BM25PlusWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25PlusWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::BM25PlusWeight *arg1 = (Xapian::BM25PlusWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25PlusWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::BM25PlusWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25PlusWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BM25PlusWeight *arg1 = (Xapian::BM25PlusWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25PlusWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BM25PlusWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25PlusWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::BM25PlusWeight *arg1 = (Xapian::BM25PlusWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25PlusWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::BM25PlusWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BM25PlusWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BM25PlusWeight *arg1 = (Xapian::BM25PlusWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BM25PlusWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BM25PlusWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1BM25PlusWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::BM25PlusWeight *arg1 = (Xapian::BM25PlusWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::BM25PlusWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1TradWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::TradWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::TradWeight *)new Xapian::TradWeight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TradWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1TradWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::TradWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::TradWeight *)new Xapian::TradWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TradWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_TradWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::TradWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TradWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::TradWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TradWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::TradWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TradWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::TradWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_TradWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::TradWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1TradWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::TradWeight *arg1 = (Xapian::TradWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::TradWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1InL2Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::InL2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::InL2Weight *)new Xapian::InL2Weight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::InL2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1InL2Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::InL2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::InL2Weight *)new Xapian::InL2Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::InL2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_InL2Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::InL2Weight *arg1 = (Xapian::InL2Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::InL2Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::InL2Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_InL2Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::InL2Weight *arg1 = (Xapian::InL2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::InL2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::InL2Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_InL2Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::InL2Weight *arg1 = (Xapian::InL2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::InL2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::InL2Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_InL2Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::InL2Weight *arg1 = (Xapian::InL2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::InL2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::InL2Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_InL2Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::InL2Weight *arg1 = (Xapian::InL2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::InL2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::InL2Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1InL2Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::InL2Weight *arg1 = (Xapian::InL2Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::InL2Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1IfB2Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::IfB2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::IfB2Weight *)new Xapian::IfB2Weight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::IfB2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1IfB2Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::IfB2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::IfB2Weight *)new Xapian::IfB2Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::IfB2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_IfB2Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::IfB2Weight *arg1 = (Xapian::IfB2Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IfB2Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::IfB2Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IfB2Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::IfB2Weight *arg1 = (Xapian::IfB2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IfB2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::IfB2Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IfB2Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::IfB2Weight *arg1 = (Xapian::IfB2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IfB2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::IfB2Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IfB2Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::IfB2Weight *arg1 = (Xapian::IfB2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IfB2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::IfB2Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IfB2Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::IfB2Weight *arg1 = (Xapian::IfB2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IfB2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::IfB2Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1IfB2Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::IfB2Weight *arg1 = (Xapian::IfB2Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::IfB2Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1IneB2Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::IneB2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::IneB2Weight *)new Xapian::IneB2Weight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::IneB2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1IneB2Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::IneB2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::IneB2Weight *)new Xapian::IneB2Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::IneB2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_IneB2Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::IneB2Weight *arg1 = (Xapian::IneB2Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IneB2Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::IneB2Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IneB2Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::IneB2Weight *arg1 = (Xapian::IneB2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IneB2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::IneB2Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IneB2Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::IneB2Weight *arg1 = (Xapian::IneB2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IneB2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::IneB2Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IneB2Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::IneB2Weight *arg1 = (Xapian::IneB2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IneB2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::IneB2Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_IneB2Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::IneB2Weight *arg1 = (Xapian::IneB2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::IneB2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::IneB2Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1IneB2Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::IneB2Weight *arg1 = (Xapian::IneB2Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::IneB2Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BB2Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::BB2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::BB2Weight *)new Xapian::BB2Weight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BB2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1BB2Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::BB2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::BB2Weight *)new Xapian::BB2Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::BB2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_BB2Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::BB2Weight *arg1 = (Xapian::BB2Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BB2Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::BB2Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BB2Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::BB2Weight *arg1 = (Xapian::BB2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BB2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::BB2Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BB2Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BB2Weight *arg1 = (Xapian::BB2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BB2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BB2Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BB2Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::BB2Weight *arg1 = (Xapian::BB2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BB2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::BB2Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_BB2Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::BB2Weight *arg1 = (Xapian::BB2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::BB2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::BB2Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1BB2Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::BB2Weight *arg1 = (Xapian::BB2Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::BB2Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DLHWeight(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::DLHWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::DLHWeight *)new Xapian::DLHWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DLHWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_DLHWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::DLHWeight *arg1 = (Xapian::DLHWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DLHWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::DLHWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DLHWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::DLHWeight *arg1 = (Xapian::DLHWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DLHWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::DLHWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DLHWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::DLHWeight *arg1 = (Xapian::DLHWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DLHWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::DLHWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DLHWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::DLHWeight *arg1 = (Xapian::DLHWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DLHWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::DLHWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DLHWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::DLHWeight *arg1 = (Xapian::DLHWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DLHWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::DLHWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1DLHWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DLHWeight *arg1 = (Xapian::DLHWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DLHWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PL2Weight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::PL2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::PL2Weight *)new Xapian::PL2Weight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PL2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PL2Weight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PL2Weight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::PL2Weight *)new Xapian::PL2Weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PL2Weight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PL2Weight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PL2Weight *arg1 = (Xapian::PL2Weight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2Weight **)&jarg1; 
  {
    try {
      result = ((Xapian::PL2Weight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2Weight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::PL2Weight *arg1 = (Xapian::PL2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::PL2Weight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2Weight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PL2Weight *arg1 = (Xapian::PL2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::PL2Weight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2Weight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::PL2Weight *arg1 = (Xapian::PL2Weight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2Weight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::PL2Weight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2Weight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PL2Weight *arg1 = (Xapian::PL2Weight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2Weight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::PL2Weight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1PL2Weight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PL2Weight *arg1 = (Xapian::PL2Weight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PL2Weight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PL2PlusWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  Xapian::PL2PlusWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (Xapian::PL2PlusWeight *)new Xapian::PL2PlusWeight(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PL2PlusWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PL2PlusWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PL2PlusWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::PL2PlusWeight *)new Xapian::PL2PlusWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PL2PlusWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PL2PlusWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PL2PlusWeight *arg1 = (Xapian::PL2PlusWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2PlusWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::PL2PlusWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2PlusWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::PL2PlusWeight *arg1 = (Xapian::PL2PlusWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2PlusWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::PL2PlusWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2PlusWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PL2PlusWeight *arg1 = (Xapian::PL2PlusWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2PlusWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::PL2PlusWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2PlusWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::PL2PlusWeight *arg1 = (Xapian::PL2PlusWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2PlusWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::PL2PlusWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PL2PlusWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PL2PlusWeight *arg1 = (Xapian::PL2PlusWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PL2PlusWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::PL2PlusWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1PL2PlusWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PL2PlusWeight *arg1 = (Xapian::PL2PlusWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PL2PlusWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DPHWeight(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::DPHWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::DPHWeight *)new Xapian::DPHWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DPHWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_DPHWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::DPHWeight *arg1 = (Xapian::DPHWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DPHWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::DPHWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DPHWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::DPHWeight *arg1 = (Xapian::DPHWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DPHWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::DPHWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DPHWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::DPHWeight *arg1 = (Xapian::DPHWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DPHWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::DPHWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DPHWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::DPHWeight *arg1 = (Xapian::DPHWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DPHWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::DPHWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DPHWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::DPHWeight *arg1 = (Xapian::DPHWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DPHWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::DPHWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1DPHWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DPHWeight *arg1 = (Xapian::DPHWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DPHWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LMWeight_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jdouble jarg1, jint jarg2, jdouble jarg3, jdouble jarg4) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::Weight::type_smoothing arg2 ;
  double arg3 ;
  double arg4 ;
  Xapian::LMWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (Xapian::Weight::type_smoothing)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      result = (Xapian::LMWeight *)new Xapian::LMWeight(arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LMWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LMWeight_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jint jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::Weight::type_smoothing arg2 ;
  double arg3 ;
  Xapian::LMWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (Xapian::Weight::type_smoothing)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (Xapian::LMWeight *)new Xapian::LMWeight(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LMWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LMWeight_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jint jarg2) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::Weight::type_smoothing arg2 ;
  Xapian::LMWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (Xapian::Weight::type_smoothing)jarg2; 
  {
    try {
      result = (Xapian::LMWeight *)new Xapian::LMWeight(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LMWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LMWeight_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::LMWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::LMWeight *)new Xapian::LMWeight(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LMWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LMWeight_1_1SWIG_14(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::LMWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::LMWeight *)new Xapian::LMWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LMWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LMWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::LMWeight *arg1 = (Xapian::LMWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LMWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::LMWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LMWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::LMWeight *arg1 = (Xapian::LMWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LMWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::LMWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LMWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::LMWeight *arg1 = (Xapian::LMWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LMWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::LMWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LMWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::LMWeight *arg1 = (Xapian::LMWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LMWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::LMWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LMWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::LMWeight *arg1 = (Xapian::LMWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LMWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::LMWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LMWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LMWeight *arg1 = (Xapian::LMWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LMWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_CoordWeight_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->init(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1CoordWeight(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::CoordWeight *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::CoordWeight *)new Xapian::CoordWeight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::CoordWeight **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_CoordWeight_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  {
    try {
      result = ((Xapian::CoordWeight const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_CoordWeight_1getSumPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  Xapian::termcount arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  arg4 = (Xapian::termcount)jarg4; 
  {
    try {
      result = (double)((Xapian::CoordWeight const *)arg1)->get_sumpart(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_CoordWeight_1getMaxPart(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::CoordWeight const *)arg1)->get_maxpart();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_CoordWeight_1getSumExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jdouble jresult = 0 ;
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  Xapian::termcount arg2 ;
  Xapian::termcount arg3 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  arg2 = (Xapian::termcount)jarg2; 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      result = (double)((Xapian::CoordWeight const *)arg1)->get_sumextra(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_CoordWeight_1getMaxExtra(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  {
    try {
      result = (double)((Xapian::CoordWeight const *)arg1)->get_maxextra();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1CoordWeight(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::CoordWeight *arg1 = (Xapian::CoordWeight *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::CoordWeight **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Compactor_1STANDARD_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Compactor::compaction_level result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Compactor::compaction_level)Xapian::Compactor::STANDARD;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Compactor_1FULL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Compactor::compaction_level result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Compactor::compaction_level)Xapian::Compactor::FULL;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_Compactor_1FULLER_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::Compactor::compaction_level result;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::Compactor::compaction_level)Xapian::Compactor::FULLER;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Compactor(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Compactor *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Compactor *)new SwigDirector_Compactor(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Compactor **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Compactor(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setBlockSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      (arg1)->set_block_size(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setRenumber(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->set_renumber(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setMultipass(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->set_multipass(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setCompactionLevel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  Xapian::Compactor::compaction_level arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  arg2 = (Xapian::Compactor::compaction_level)jarg2; 
  {
    try {
      (arg1)->set_compaction_level(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setDestdir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->set_destdir((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1addSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->add_source((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1compact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  {
    try {
      (arg1)->compact();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setStatus(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->set_status((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1setStatusSwigExplicitCompactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->Xapian::Compactor::set_status((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Compactor_1resolveDuplicateMetadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  std::string *arg4 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(std::string **)&jarg4; 
  {
    try {
      result = (arg1)->resolve_duplicate_metadata((std::string const &)*arg2,arg3,(std::string const (*))arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Compactor_1resolveDuplicateMetadataSwigExplicitCompactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jlong jarg4) {
  jstring jresult = 0 ;
  Xapian::Compactor *arg1 = (Xapian::Compactor *) 0 ;
  std::string *arg2 = 0 ;
  size_t arg3 ;
  std::string *arg4 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Compactor **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (size_t)jarg3; 
  arg4 = *(std::string **)&jarg4; 
  {
    try {
      result = (arg1)->Xapian::Compactor::resolve_duplicate_metadata((std::string const &)*arg2,arg3,(std::string const (*))arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::Compactor *obj = *((Xapian::Compactor **)&objarg);
  (void)jcls;
  SwigDirector_Compactor *director = dynamic_cast<SwigDirector_Compactor *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Compactor_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::Compactor *obj = *((Xapian::Compactor **)&objarg);
  SwigDirector_Compactor *director = dynamic_cast<SwigDirector_Compactor *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1PostingSource(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::PostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::PostingSource *)new SwigDirector_PostingSource(jenv);
  *(Xapian::PostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1PostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingSource_1getTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::PostingSource const *)arg1)->get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingSource_1getTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::PostingSource const *)arg1)->get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingSource_1getTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::PostingSource const *)arg1)->get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1setMaxweight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->set_maxweight(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PostingSource_1getMaxweight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  result = (double)((Xapian::PostingSource const *)arg1)->get_maxweight();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::PostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_PostingSource_1getWeightSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::PostingSource const *)arg1)->Xapian::PostingSource::get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingSource_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::PostingSource const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1skipToSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->Xapian::PostingSource::skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_PostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_PostingSource_1checkSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->Xapian::PostingSource::check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_PostingSource_1atEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::PostingSource const *)arg1)->at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PostingSource_1nameSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->Xapian::PostingSource::name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_PostingSource_1toStringSwigExplicitPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::PostingSource const *)arg1)->Xapian::PostingSource::get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PostingSource_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::PostingSource *arg1 = (Xapian::PostingSource *) 0 ;
  Xapian::PostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::PostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::PostingSource *)((Xapian::PostingSource const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::PostingSource *obj = *((Xapian::PostingSource **)&objarg);
  (void)jcls;
  SwigDirector_PostingSource *director = dynamic_cast<SwigDirector_PostingSource *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_PostingSource_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::PostingSource *obj = *((Xapian::PostingSource **)&objarg);
  SwigDirector_PostingSource *director = dynamic_cast<SwigDirector_PostingSource *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValuePostingSource(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValuePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValuePostingSource *)new SwigDirector_ValuePostingSource(jenv,arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValuePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getTermfreqMinSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->Xapian::ValuePostingSource::get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getTermfreqEstSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->Xapian::ValuePostingSource::get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getTermfreqMaxSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::ValuePostingSource const *)arg1)->Xapian::ValuePostingSource::get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1nextSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->Xapian::ValuePostingSource::next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1skipToSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->Xapian::ValuePostingSource::skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1checkSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->Xapian::ValuePostingSource::check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1atEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::ValuePostingSource const *)arg1)->at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1atEndSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::ValuePostingSource const *)arg1)->Xapian::ValuePostingSource::at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::ValuePostingSource const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getDocIdSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::ValuePostingSource const *)arg1)->Xapian::ValuePostingSource::get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1initSwigExplicitValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->Xapian::ValuePostingSource::init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValuePostingSource const *)arg1)->get_database();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getSlot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::valueno)((Xapian::ValuePostingSource const *)arg1)->get_slot();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValuePostingSource const *)arg1)->get_value();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1done(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      (arg1)->done();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1getStarted(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::ValuePostingSource const *)arg1)->get_started();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1setTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      (arg1)->set_termfreq_min(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1setTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      (arg1)->set_termfreq_est(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1setTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  Xapian::doccount arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  arg2 = (Xapian::doccount)jarg2; 
  {
    try {
      (arg1)->set_termfreq_max(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValuePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValuePostingSource *arg1 = (Xapian::ValuePostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValuePostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::ValuePostingSource *obj = *((Xapian::ValuePostingSource **)&objarg);
  (void)jcls;
  SwigDirector_ValuePostingSource *director = dynamic_cast<SwigDirector_ValuePostingSource *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::ValuePostingSource *obj = *((Xapian::ValuePostingSource **)&objarg);
  SwigDirector_ValuePostingSource *director = dynamic_cast<SwigDirector_ValuePostingSource *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValueWeightPostingSource *)new SwigDirector_ValueWeightPostingSource(jenv,arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::ValueWeightPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1getWeightSwigExplicitValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::ValueWeightPostingSource const *)arg1)->Xapian::ValueWeightPostingSource::get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueWeightPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1nameSwigExplicitValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueWeightPostingSource const *)arg1)->Xapian::ValueWeightPostingSource::name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1initSwigExplicitValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->Xapian::ValueWeightPostingSource::init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueWeightPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1toStringSwigExplicitValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueWeightPostingSource const *)arg1)->Xapian::ValueWeightPostingSource::get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueWeightPostingSource *arg1 = (Xapian::ValueWeightPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueWeightPostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::ValueWeightPostingSource *obj = *((Xapian::ValueWeightPostingSource **)&objarg);
  (void)jcls;
  SwigDirector_ValueWeightPostingSource *director = dynamic_cast<SwigDirector_ValueWeightPostingSource *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::ValueWeightPostingSource *obj = *((Xapian::ValueWeightPostingSource **)&objarg);
  SwigDirector_ValueWeightPostingSource *director = dynamic_cast<SwigDirector_ValueWeightPostingSource *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DecreasingValueWeightPostingSource_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::docid arg2 ;
  Xapian::docid arg3 ;
  Xapian::DecreasingValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (Xapian::docid)jarg3; 
  {
    try {
      result = (Xapian::DecreasingValueWeightPostingSource *)new Xapian::DecreasingValueWeightPostingSource(arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DecreasingValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DecreasingValueWeightPostingSource_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::docid arg2 ;
  Xapian::DecreasingValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (Xapian::DecreasingValueWeightPostingSource *)new Xapian::DecreasingValueWeightPostingSource(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DecreasingValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1DecreasingValueWeightPostingSource_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::DecreasingValueWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::DecreasingValueWeightPostingSource *)new Xapian::DecreasingValueWeightPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::DecreasingValueWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::DecreasingValueWeightPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::DecreasingValueWeightPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::DecreasingValueWeightPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1DecreasingValueWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::DecreasingValueWeightPostingSource *arg1 = (Xapian::DecreasingValueWeightPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueMapPostingSource(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValueMapPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValueMapPostingSource *)new Xapian::ValueMapPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueMapPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1addMapping(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdouble jarg3) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  std::string *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->add_mapping((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1clearMappings(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      (arg1)->clear_mappings();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1setDefaultWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->set_default_weight(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::ValueMapPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueMapPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueMapPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValueMapPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueMapPostingSource *arg1 = (Xapian::ValueMapPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueMapPostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1FixedWeightPostingSource(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::FixedWeightPostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::FixedWeightPostingSource *)new Xapian::FixedWeightPostingSource(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::FixedWeightPostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1getTermfreqMin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::FixedWeightPostingSource const *)arg1)->get_termfreq_min();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1getTermfreqEst(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::FixedWeightPostingSource const *)arg1)->get_termfreq_est();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1getTermfreqMax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::FixedWeightPostingSource const *)arg1)->get_termfreq_max();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::FixedWeightPostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1atEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::FixedWeightPostingSource const *)arg1)->at_end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1getDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::FixedWeightPostingSource const *)arg1)->get_docid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::FixedWeightPostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::FixedWeightPostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1FixedWeightPostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::FixedWeightPostingSource *arg1 = (Xapian::FixedWeightPostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::FixedWeightPostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1MatchSpy(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Xapian::MatchSpy *)new SwigDirector_MatchSpy(jenv);
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1MatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchSpy_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  Xapian::Document *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->operator ()((Xapian::Document const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MatchSpy_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MatchSpy_1nameSwigExplicitMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->Xapian::MatchSpy::name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchSpy_1mergeResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->merge_results((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchSpy_1mergeResultsSwigExplicitMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->Xapian::MatchSpy::merge_results((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MatchSpy_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_MatchSpy_1toStringSwigExplicitMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::MatchSpy const *)arg1)->Xapian::MatchSpy::get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MatchSpy_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::MatchSpy *arg1 = (Xapian::MatchSpy *) 0 ;
  Xapian::MatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::MatchSpy **)&jarg1; 
  {
    try {
      result = (Xapian::MatchSpy *)((Xapian::MatchSpy const *)arg1)->release();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::MatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchSpy_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::MatchSpy *obj = *((Xapian::MatchSpy **)&objarg);
  (void)jcls;
  SwigDirector_MatchSpy *director = dynamic_cast<SwigDirector_MatchSpy *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_MatchSpy_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::MatchSpy *obj = *((Xapian::MatchSpy **)&objarg);
  SwigDirector_MatchSpy *director = dynamic_cast<SwigDirector_MatchSpy *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueCountMatchSpy_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::ValueCountMatchSpy *)new Xapian::ValueCountMatchSpy();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueCountMatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1ValueCountMatchSpy_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::ValueCountMatchSpy *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (Xapian::valueno)jarg1; 
  {
    try {
      result = (Xapian::ValueCountMatchSpy *)new Xapian::ValueCountMatchSpy(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueCountMatchSpy **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1getTotal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  result = ((Xapian::ValueCountMatchSpy const *)arg1)->get_total();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1valuesBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->values_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1valuesEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  result = ((Xapian::ValueCountMatchSpy const *)arg1)->values_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1topValuesBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  size_t arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  arg2 = (size_t)jarg2; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->top_values_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1topValuesEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  size_t arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  arg2 = (size_t)jarg2; 
  result = ((Xapian::ValueCountMatchSpy const *)arg1)->top_values_end(arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  Xapian::Document *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->operator ()((Xapian::Document const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1mergeResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->merge_results((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  {
    try {
      result = ((Xapian::ValueCountMatchSpy const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1ValueCountMatchSpy(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::ValueCountMatchSpy *arg1 = (Xapian::ValueCountMatchSpy *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::ValueCountMatchSpy **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_milesToMetres(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jdouble jresult = 0 ;
  double arg1 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (double)Xapian::miles_to_metres(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_metresToMiles(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jdouble jresult = 0 ;
  double arg1 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (double)Xapian::metres_to_miles(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1latitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->latitude = arg2;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1latitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  result = (double) ((arg1)->latitude);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1longitude_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  arg2 = (double)jarg2; 
  if (arg1) (arg1)->longitude = arg2;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1longitude_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  result = (double) ((arg1)->longitude);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongCoord_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::LatLongCoord *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::LatLongCoord *)new Xapian::LatLongCoord();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoord **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongCoord_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  Xapian::LatLongCoord *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (Xapian::LatLongCoord *)new Xapian::LatLongCoord(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoord **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1unserialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->unserialise((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoord const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LatLongCoord_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoord const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LatLongCoord(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LatLongCoord *arg1 = (Xapian::LatLongCoord *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LatLongCoord **)&jarg1; 
  {
    try {
      delete arg1;
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongCoordsIterator(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::LatLongCoordsIterator *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::LatLongCoordsIterator *)new Xapian::LatLongCoordsIterator();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoordsIterator **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_LatLongCoordsIterator_1equals(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  Xapian::LatLongCoordsIterator *arg1 = (Xapian::LatLongCoordsIterator *) 0 ;
  Xapian::LatLongCoordsIterator *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::LatLongCoordsIterator **)&jarg1; 
  arg2 = *(Xapian::LatLongCoordsIterator **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoordsIterator const & reference is null");
    return 0;
  } 
  {
    try {
      result = (bool)Xapian_LatLongCoordsIterator_equals((Xapian::LatLongCoordsIterator const *)arg1,(Xapian::LatLongCoordsIterator const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongCoordsIterator_1getCoord(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::LatLongCoordsIterator *arg1 = (Xapian::LatLongCoordsIterator *) 0 ;
  Xapian::LatLongCoord result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoordsIterator **)&jarg1; 
  {
    try {
      result = Xapian_LatLongCoordsIterator_get_coord((Xapian::LatLongCoordsIterator const *)arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoord **)&jresult = new Xapian::LatLongCoord((const Xapian::LatLongCoord &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongCoordsIterator_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::LatLongCoordsIterator *arg1 = (Xapian::LatLongCoordsIterator *) 0 ;
  Xapian::LatLongCoord result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoordsIterator **)&jarg1; 
  {
    try {
      result = Xapian_LatLongCoordsIterator_next(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoord **)&jresult = new Xapian::LatLongCoord((const Xapian::LatLongCoord &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LatLongCoordsIterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LatLongCoordsIterator *arg1 = (Xapian::LatLongCoordsIterator *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LatLongCoordsIterator **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  Xapian::LatLongCoordsIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoords const *)arg1)->begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoordsIterator **)&jresult = new Xapian::LatLongCoordsIterator((const Xapian::LatLongCoordsIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  Xapian::LatLongCoordsIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoords const *)arg1)->end();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoordsIterator **)&jresult = new Xapian::LatLongCoordsIterator((const Xapian::LatLongCoordsIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoords const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1empty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::LatLongCoords const *)arg1)->empty();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  Xapian::LatLongCoord *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  arg2 = *(Xapian::LatLongCoord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->append((Xapian::LatLongCoord const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongCoords_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::LatLongCoords *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::LatLongCoords *)new Xapian::LatLongCoords();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoords **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongCoords_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::LatLongCoord *arg1 = 0 ;
  Xapian::LatLongCoords *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoord **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongCoords *)new Xapian::LatLongCoords((Xapian::LatLongCoord const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongCoords **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1unserialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  std::string *arg2 = 0 ;
  jbyte *jarr2 ;
  std::string c_arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  
  if (!jarg2)
  SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
  jarr2 = jenv->GetByteArrayElements(jarg2, NULL);
  if (!jarr2) return ;
  c_arg2.assign(reinterpret_cast<char*>(jarr2), jenv->GetArrayLength(jarg2));
  jenv->ReleaseByteArrayElements(jarg2, jarr2, JNI_ABORT);
  arg2 = &c_arg2;
  
  {
    try {
      (arg1)->unserialise((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1serialise(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoords const *)arg1)->serialise();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LatLongCoords_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongCoords const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LatLongCoords(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LatLongCoords *arg1 = (Xapian::LatLongCoords *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LatLongCoords **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LatLongMetric(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LatLongMetric *arg1 = (Xapian::LatLongMetric *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LatLongMetric **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1pointwiseDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  Xapian::LatLongMetric *arg1 = (Xapian::LatLongMetric *) 0 ;
  Xapian::LatLongCoord *arg2 = 0 ;
  Xapian::LatLongCoord *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Xapian::LatLongMetric **)&jarg1; 
  arg2 = *(Xapian::LatLongCoord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongCoord **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  {
    try {
      result = (double)((Xapian::LatLongMetric const *)arg1)->pointwise_distance((Xapian::LatLongCoord const &)*arg2,(Xapian::LatLongCoord const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1apply_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  Xapian::LatLongMetric *arg1 = (Xapian::LatLongMetric *) 0 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongCoords *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Xapian::LatLongMetric **)&jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongCoords **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  {
    try {
      result = (double)((Xapian::LatLongMetric const *)arg1)->operator ()((Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongCoords const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1apply_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  jdouble jresult = 0 ;
  Xapian::LatLongMetric *arg1 = (Xapian::LatLongMetric *) 0 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  std::string *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::LatLongMetric **)&jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = (double)((Xapian::LatLongMetric const *)arg1)->operator ()((Xapian::LatLongCoords const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1apply_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4) {
  jdouble jresult = 0 ;
  Xapian::LatLongMetric *arg1 = (Xapian::LatLongMetric *) 0 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  size_t arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::LatLongMetric **)&jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = (size_t)jarg4; 
  {
    try {
      result = (double)((Xapian::LatLongMetric const *)arg1)->operator ()((Xapian::LatLongCoords const &)*arg2,(char const *)arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::LatLongMetric *arg1 = (Xapian::LatLongMetric *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongMetric **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongMetric const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongMetric(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::LatLongMetric *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::LatLongMetric *)new SwigDirector_LatLongMetric(jenv);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongMetric **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Xapian::LatLongMetric *obj = *((Xapian::LatLongMetric **)&objarg);
  (void)jcls;
  SwigDirector_LatLongMetric *director = dynamic_cast<SwigDirector_LatLongMetric *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongMetric_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Xapian::LatLongMetric *obj = *((Xapian::LatLongMetric **)&objarg);
  SwigDirector_LatLongMetric *director = dynamic_cast<SwigDirector_LatLongMetric *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1GreatCircleMetric_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::GreatCircleMetric *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::GreatCircleMetric *)new Xapian::GreatCircleMetric();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::GreatCircleMetric **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1GreatCircleMetric_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  Xapian::GreatCircleMetric *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (Xapian::GreatCircleMetric *)new Xapian::GreatCircleMetric(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::GreatCircleMetric **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_GreatCircleMetric_1pointwiseDistance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jdouble jresult = 0 ;
  Xapian::GreatCircleMetric *arg1 = (Xapian::GreatCircleMetric *) 0 ;
  Xapian::LatLongCoord *arg2 = 0 ;
  Xapian::LatLongCoord *arg3 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(Xapian::GreatCircleMetric **)&jarg1; 
  arg2 = *(Xapian::LatLongCoord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongCoord **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  {
    try {
      result = (double)((Xapian::GreatCircleMetric const *)arg1)->pointwise_distance((Xapian::LatLongCoord const &)*arg2,(Xapian::LatLongCoord const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_GreatCircleMetric_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::GreatCircleMetric *arg1 = (Xapian::GreatCircleMetric *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::GreatCircleMetric **)&jarg1; 
  {
    try {
      result = ((Xapian::GreatCircleMetric const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1GreatCircleMetric(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::GreatCircleMetric *arg1 = (Xapian::GreatCircleMetric *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::GreatCircleMetric **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jdouble jarg5, jdouble jarg6) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  double arg6 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongMetric const &)*arg3,arg4,arg5,arg6);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  double arg4 ;
  double arg5 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongMetric const &)*arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  double arg4 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongMetric const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongMetric const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,arg3,arg4,arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3, jdouble jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  double arg3 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistancePostingSource_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongDistancePostingSource *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongDistancePostingSource *)new Xapian::LatLongDistancePostingSource(arg1,(Xapian::LatLongCoords const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistancePostingSource **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LatLongDistancePostingSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->next(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1skipTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->skip_to(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1check(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jdouble jarg3) {
  jboolean jresult = 0 ;
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  Xapian::docid arg2 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)(arg1)->check(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1getWeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  {
    try {
      result = (double)((Xapian::LatLongDistancePostingSource const *)arg1)->get_weight();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongDistancePostingSource const *)arg1)->name();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->init((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::LatLongDistancePostingSource *arg1 = (Xapian::LatLongDistancePostingSource *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::LatLongDistancePostingSource **)&jarg1; 
  {
    try {
      result = ((Xapian::LatLongDistancePostingSource const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistanceKeyMaker_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  double arg4 ;
  Xapian::LatLongDistanceKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  {
    try {
      result = (Xapian::LatLongDistanceKeyMaker *)new Xapian::LatLongDistanceKeyMaker(arg1,(Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongMetric const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistanceKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistanceKeyMaker_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  Xapian::LatLongDistanceKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongDistanceKeyMaker *)new Xapian::LatLongDistanceKeyMaker(arg1,(Xapian::LatLongCoords const &)*arg2,(Xapian::LatLongMetric const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistanceKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistanceKeyMaker_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoords *arg2 = 0 ;
  Xapian::LatLongDistanceKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoords **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoords const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongDistanceKeyMaker *)new Xapian::LatLongDistanceKeyMaker(arg1,(Xapian::LatLongCoords const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistanceKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistanceKeyMaker_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoord *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  double arg4 ;
  Xapian::LatLongDistanceKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  {
    try {
      result = (Xapian::LatLongDistanceKeyMaker *)new Xapian::LatLongDistanceKeyMaker(arg1,(Xapian::LatLongCoord const &)*arg2,(Xapian::LatLongMetric const &)*arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistanceKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistanceKeyMaker_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoord *arg2 = 0 ;
  Xapian::LatLongMetric *arg3 = 0 ;
  Xapian::LatLongDistanceKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  arg3 = *(Xapian::LatLongMetric **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongMetric const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongDistanceKeyMaker *)new Xapian::LatLongDistanceKeyMaker(arg1,(Xapian::LatLongCoord const &)*arg2,(Xapian::LatLongMetric const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistanceKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1LatLongDistanceKeyMaker_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::valueno arg1 ;
  Xapian::LatLongCoord *arg2 = 0 ;
  Xapian::LatLongDistanceKeyMaker *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (Xapian::valueno)jarg1; 
  arg2 = *(Xapian::LatLongCoord **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::LatLongCoord const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::LatLongDistanceKeyMaker *)new Xapian::LatLongDistanceKeyMaker(arg1,(Xapian::LatLongCoord const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::LatLongDistanceKeyMaker **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1LatLongDistanceKeyMaker(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::LatLongDistanceKeyMaker *arg1 = (Xapian::LatLongDistanceKeyMaker *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::LatLongDistanceKeyMaker **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_LatLongDistanceKeyMaker_1apply(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  Xapian::LatLongDistanceKeyMaker *arg1 = (Xapian::LatLongDistanceKeyMaker *) 0 ;
  Xapian::Document *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::LatLongDistanceKeyMaker **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = ((Xapian::LatLongDistanceKeyMaker const *)arg1)->operator ()((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1addDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::Database *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = *(Xapian::Database **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Database const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->add_database((Xapian::Database const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->size();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Database_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::Database *)new Xapian::Database();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Database_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = (Xapian::Database *)new Xapian::Database((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Database_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::Database *)new Xapian::Database((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Database_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = (Xapian::Database *)new Xapian::Database(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1Database_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  Xapian::Database *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    try {
      result = (Xapian::Database *)new Xapian::Database(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1Database(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::Database **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Database_1reopen(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->reopen();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      (arg1)->close();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Database_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1postListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::PostingIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->postlist_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PostingIterator **)&jresult = new Xapian::PostingIterator((const Xapian::PostingIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1postListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::PostingIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((Xapian::Database const *)arg1)->postlist_end((std::string const &)*arg2);
  *(Xapian::PostingIterator **)&jresult = new Xapian::PostingIterator((const Xapian::PostingIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1termListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->termlist_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1termListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  result = ((Xapian::Database const *)arg1)->termlist_end(arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Database_1hasPositions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::Database const *)arg1)->has_positions();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1positionListBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  std::string *arg3 = 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->positionlist_begin(arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1positionListEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  std::string *arg3 = 0 ;
  Xapian::PositionIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  result = ((Xapian::Database const *)arg1)->positionlist_end(arg2,(std::string const &)*arg3);
  *(Xapian::PositionIterator **)&jresult = new Xapian::PositionIterator((const Xapian::PositionIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1allTermsBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->allterms_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1allTermsBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->allterms_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1allTermsEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((Xapian::Database const *)arg1)->allterms_end((std::string const &)*arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1allTermsEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  result = ((Xapian::Database const *)arg1)->allterms_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getDocCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::doccount)((Xapian::Database const *)arg1)->get_doccount();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getLastDocId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::docid)((Xapian::Database const *)arg1)->get_lastdocid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_xapian_XapianJNI_Database_1getAvLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::doclength result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::doclength)((Xapian::Database const *)arg1)->get_avlength();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getTotalLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::totallength result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::totallength)((Xapian::Database const *)arg1)->get_total_length();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getTermFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::doccount)((Xapian::Database const *)arg1)->get_termfreq((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Database_1termExists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((Xapian::Database const *)arg1)->term_exists((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getCollectionFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_collection_freq((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getValueFreq(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::doccount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = (Xapian::doccount)((Xapian::Database const *)arg1)->get_value_freq(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_Database_1getValueLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyteArray jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_value_lower_bound(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_org_xapian_XapianJNI_Database_1getValueUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyteArray jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_value_upper_bound(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  {
    size_t len = (&result)->size();
    jbyteArray c_result = jenv->NewByteArray(len);
    const jbyte* data = reinterpret_cast<const jbyte*>((&result)->data());
    // Final parameter was not const in Java 6 and earlier.
    jbyte* data_nc = const_cast<jbyte*>(data);
    jenv->SetByteArrayRegion(c_result, 0, len, data_nc);
    jresult = c_result;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getDoclengthLowerBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_doclength_lower_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getDoclengthUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_doclength_upper_bound();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getWdfUpperBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_wdf_upper_bound((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1valuestreamBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->valuestream_begin(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1valuestreamEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::valueno arg2 ;
  Xapian::ValueIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::valueno)jarg2; 
  result = ((Xapian::Database const *)arg1)->valuestream_end(arg2);
  *(Xapian::ValueIterator **)&jresult = new Xapian::ValueIterator((const Xapian::ValueIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getDocLength(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_doclength(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getUniqueTerms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::termcount result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = (Xapian::termcount)((Xapian::Database const *)arg1)->get_unique_terms(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1keepAlive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      (arg1)->keep_alive();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::docid arg2 ;
  unsigned int arg3 ;
  Xapian::Document result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_document(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Document **)&jresult = new Xapian::Document((const Xapian::Document &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Database_1getSpellingSuggestion_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_spelling_suggestion((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Database_1getSpellingSuggestion_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_spelling_suggestion((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1spellingsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->spellings_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1spellingsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  result = ((Xapian::Database const *)arg1)->spellings_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1synonymsBegin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonyms_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1synonymsEnd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((Xapian::Database const *)arg1)->synonyms_end((std::string const &)*arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1synonymKeysBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonym_keys_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1synonymKeysBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->synonym_keys_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1synonymKeysEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((Xapian::Database const *)arg1)->synonym_keys_end((std::string const &)*arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1synonymKeysEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  result = ((Xapian::Database const *)arg1)->synonym_keys_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Database_1getMetadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_metadata((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1metadataKeysBegin_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((Xapian::Database const *)arg1)->metadata_keys_begin((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1metadataKeysBegin_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->metadata_keys_begin();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1metadataKeysEnd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  result = ((Xapian::Database const *)arg1)->metadata_keys_end((std::string const &)*arg2);
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1metadataKeysEnd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::TermIterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  result = ((Xapian::Database const *)arg1)->metadata_keys_end();
  *(Xapian::TermIterator **)&jresult = new Xapian::TermIterator((const Xapian::TermIterator &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_Database_1getUuid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = ((Xapian::Database const *)arg1)->get_uuid();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_xapian_XapianJNI_Database_1locked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (bool)((Xapian::Database const *)arg1)->locked();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1getRevision(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  Xapian::rev result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  {
    try {
      result = (Xapian::rev)((Xapian::Database const *)arg1)->get_revision();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1check_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = Xapian::Database::check((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1check_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Database::check((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1check_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  int arg1 ;
  int arg2 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      result = Xapian::Database::check(arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Database_1check_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    try {
      result = Xapian::Database::check(arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  arg4 = (int)jarg4; 
  {
    try {
      (arg1)->compact((std::string const &)*arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      (arg1)->compact((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->compact((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jint jarg4) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  int arg2 ;
  unsigned int arg3 ;
  int arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = (int)jarg4; 
  {
    try {
      (arg1)->compact(arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  int arg2 ;
  unsigned int arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      (arg1)->compact(arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (int)jarg2; 
  {
    try {
      (arg1)->compact(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  std::string *arg2 = 0 ;
  unsigned int arg3 ;
  int arg4 ;
  Xapian::Compactor *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(Xapian::Database **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (unsigned int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(Xapian::Compactor **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Compactor & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->compact((std::string const &)*arg2,arg3,arg4,*arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_Database_1compact_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jint jarg4, jlong jarg5, jobject jarg5_) {
  Xapian::Database *arg1 = (Xapian::Database *) 0 ;
  int arg2 ;
  unsigned int arg3 ;
  int arg4 ;
  Xapian::Compactor *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(Xapian::Database **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(Xapian::Compactor **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Compactor & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->compact(arg2,arg3,arg4,*arg5);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_delete_1WritableDatabase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1WritableDatabase_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1WritableDatabase_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1WritableDatabase_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_new_1WritableDatabase_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::WritableDatabase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (Xapian::WritableDatabase *)new Xapian::WritableDatabase((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1commit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->commit();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->flush();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1beginTransaction_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->begin_transaction(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1beginTransaction_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->begin_transaction();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1commitTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->commit_transaction();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1cancelTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      (arg1)->cancel_transaction();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1addDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  Xapian::Document *arg2 = 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = *(Xapian::Document **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::docid)(arg1)->add_document((Xapian::Document const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1deleteDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  Xapian::docid arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  {
    try {
      (arg1)->delete_document(arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1deleteDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->delete_document((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1replaceDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jobject jarg3_) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  Xapian::docid arg2 ;
  Xapian::Document *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  arg2 = (Xapian::docid)jarg2; 
  arg3 = *(Xapian::Document **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->replace_document(arg2,(Xapian::Document const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1replaceDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::Document *arg3 = 0 ;
  Xapian::docid result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = *(Xapian::Document **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Xapian::Document const & reference is null");
    return 0;
  } 
  {
    try {
      result = (Xapian::docid)(arg1)->replace_document((std::string const &)*arg2,(Xapian::Document const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1addSpelling_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->add_spelling((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1addSpelling_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->add_spelling((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1removeSpelling_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  Xapian::termcount arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (Xapian::termcount)jarg3; 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->remove_spelling((std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1removeSpelling_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->remove_spelling((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1addSynonym(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->add_synonym((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1removeSynonym(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->remove_synonym((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1clearSynonyms(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((Xapian::WritableDatabase const *)arg1)->clear_synonyms((std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1setMetadata(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->set_metadata((std::string const &)*arg2,(std::string const &)*arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Xapian::WritableDatabase *arg1 = (Xapian::WritableDatabase *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Xapian::WritableDatabase **)&jarg1; 
  {
    try {
      result = ((Xapian::WritableDatabase const *)arg1)->get_description();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Auto_1openStub(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Auto::open_stub((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Chert_1open_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = Xapian::Chert::open((std::string const &)*arg1);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Chert_1open_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = Xapian::Chert::open((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Chert_1open_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  int arg2 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (int)jarg2; 
  {
    try {
      result = Xapian::Chert::open((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_InMemory_1open(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = Xapian::InMemory::open();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1open_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  useconds_t arg3 ;
  useconds_t arg4 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (useconds_t)jarg3; 
  arg4 = (useconds_t)jarg4; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1open_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  useconds_t arg3 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (useconds_t)jarg3; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1open_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1openWritable_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  useconds_t arg3 ;
  useconds_t arg4 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (useconds_t)jarg3; 
  arg4 = (useconds_t)jarg4; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,arg2,arg3,arg4);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1openWritable_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  useconds_t arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  arg3 = (useconds_t)jarg3; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1openWritable_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  unsigned int arg2 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1open_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  useconds_t arg3 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (useconds_t)jarg3; 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1open_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Xapian::Database result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = Xapian::Remote::open((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::Database **)&jresult = new Xapian::Database((const Xapian::Database &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1openWritable_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  useconds_t arg3 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  arg3 = (useconds_t)jarg3; 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_Remote_1openWritable_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Xapian::WritableDatabase result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = Xapian::Remote::open_writable((std::string const &)*arg1,(std::string const &)*arg2);
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  *(Xapian::WritableDatabase **)&jresult = new Xapian::WritableDatabase((const Xapian::WritableDatabase &)result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_xapian_XapianJNI_getBAD_1VALUENO(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  Xapian::valueno result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (Xapian::valueno)Xapian::getBAD_VALUENO();
    } catch (...) {
      string msg;
      int code = XapianExceptionHandler(msg);
      {
        SWIG_JavaException(jenv, code, msg.c_str()); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ExpandDeciderAnd_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ExpandDecider **)&baseptr = *(Xapian::ExpandDeciderAnd **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ExpandDeciderFilterPrefix_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ExpandDecider **)&baseptr = *(Xapian::ExpandDeciderFilterPrefix **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_MultiValueKeyMaker_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::KeyMaker **)&baseptr = *(Xapian::MultiValueKeyMaker **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_SimpleStopper_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Stopper **)&baseptr = *(Xapian::SimpleStopper **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_DateRangeProcessor_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::RangeProcessor **)&baseptr = *(Xapian::DateRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_NumberRangeProcessor_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::RangeProcessor **)&baseptr = *(Xapian::NumberRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_StringValueRangeProcessor_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValueRangeProcessor **)&baseptr = *(Xapian::StringValueRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_DateValueRangeProcessor_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::StringValueRangeProcessor **)&baseptr = *(Xapian::DateValueRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_NumberValueRangeProcessor_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::StringValueRangeProcessor **)&baseptr = *(Xapian::NumberValueRangeProcessor **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueSetMatchDecider_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::MatchDecider **)&baseptr = *(Xapian::ValueSetMatchDecider **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_BoolWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::BoolWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TfIdfWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::TfIdfWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_BM25Weight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::BM25Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_BM25PlusWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::BM25PlusWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_TradWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::TradWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_InL2Weight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::InL2Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_IfB2Weight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::IfB2Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_IneB2Weight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::IneB2Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_BB2Weight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::BB2Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_DLHWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::DLHWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PL2Weight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::PL2Weight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_PL2PlusWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::PL2PlusWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_DPHWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::DPHWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LMWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::LMWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_CoordWeight_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Weight **)&baseptr = *(Xapian::CoordWeight **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValuePostingSource_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::PostingSource **)&baseptr = *(Xapian::ValuePostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueWeightPostingSource_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValuePostingSource **)&baseptr = *(Xapian::ValueWeightPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_DecreasingValueWeightPostingSource_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValueWeightPostingSource **)&baseptr = *(Xapian::DecreasingValueWeightPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueMapPostingSource_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValuePostingSource **)&baseptr = *(Xapian::ValueMapPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_FixedWeightPostingSource_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::PostingSource **)&baseptr = *(Xapian::FixedWeightPostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_ValueCountMatchSpy_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::MatchSpy **)&baseptr = *(Xapian::ValueCountMatchSpy **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_GreatCircleMetric_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::LatLongMetric **)&baseptr = *(Xapian::GreatCircleMetric **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongDistancePostingSource_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::ValuePostingSource **)&baseptr = *(Xapian::LatLongDistancePostingSource **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_LatLongDistanceKeyMaker_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::KeyMaker **)&baseptr = *(Xapian::LatLongDistanceKeyMaker **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_xapian_XapianJNI_WritableDatabase_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Xapian::Database **)&baseptr = *(Xapian::WritableDatabase **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_org_xapian_XapianJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[54] = {
    {
      "SwigDirector_StemImplementation_apply", "(Lorg/xapian/StemImplementation;Ljava/lang/String;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_StemImplementation_toString", "(Lorg/xapian/StemImplementation;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_MatchDecider_accept", "(Lorg/xapian/MatchDecider;J)Z" 
    },
    {
      "SwigDirector_ExpandDecider_accept", "(Lorg/xapian/ExpandDecider;Ljava/lang/String;)Z" 
    },
    {
      "SwigDirector_KeyMaker_apply", "(Lorg/xapian/KeyMaker;J)Ljava/lang/String;" 
    },
    {
      "SwigDirector_Stopper_apply", "(Lorg/xapian/Stopper;Ljava/lang/String;)Z" 
    },
    {
      "SwigDirector_Stopper_toString", "(Lorg/xapian/Stopper;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_RangeProcessor_apply", "(Lorg/xapian/RangeProcessor;Ljava/lang/String;Ljava/lang/String;)J" 
    },
    {
      "SwigDirector_ValueRangeProcessor_apply", "(Lorg/xapian/ValueRangeProcessor;JJ)I" 
    },
    {
      "SwigDirector_FieldProcessor_apply", "(Lorg/xapian/FieldProcessor;Ljava/lang/String;)J" 
    },
    {
      "SwigDirector_Compactor_setStatus", "(Lorg/xapian/Compactor;Ljava/lang/String;Ljava/lang/String;)V" 
    },
    {
      "SwigDirector_Compactor_resolveDuplicateMetadata", "(Lorg/xapian/Compactor;Ljava/lang/String;JJ)Ljava/lang/String;" 
    },
    {
      "SwigDirector_PostingSource_getTermfreqMin", "(Lorg/xapian/PostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_getTermfreqEst", "(Lorg/xapian/PostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_getTermfreqMax", "(Lorg/xapian/PostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_getWeight", "(Lorg/xapian/PostingSource;)D" 
    },
    {
      "SwigDirector_PostingSource_getDocId", "(Lorg/xapian/PostingSource;)J" 
    },
    {
      "SwigDirector_PostingSource_next", "(Lorg/xapian/PostingSource;D)V" 
    },
    {
      "SwigDirector_PostingSource_skipTo", "(Lorg/xapian/PostingSource;JD)V" 
    },
    {
      "SwigDirector_PostingSource_check", "(Lorg/xapian/PostingSource;JD)Z" 
    },
    {
      "SwigDirector_PostingSource_atEnd", "(Lorg/xapian/PostingSource;)Z" 
    },
    {
      "SwigDirector_PostingSource_name", "(Lorg/xapian/PostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_PostingSource_init", "(Lorg/xapian/PostingSource;J)V" 
    },
    {
      "SwigDirector_PostingSource_toString", "(Lorg/xapian/PostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_ValuePostingSource_getTermfreqMin", "(Lorg/xapian/ValuePostingSource;)J" 
    },
    {
      "SwigDirector_ValuePostingSource_getTermfreqEst", "(Lorg/xapian/ValuePostingSource;)J" 
    },
    {
      "SwigDirector_ValuePostingSource_getTermfreqMax", "(Lorg/xapian/ValuePostingSource;)J" 
    },
    {
      "SwigDirector_ValuePostingSource_getWeight", "(Lorg/xapian/ValuePostingSource;)D" 
    },
    {
      "SwigDirector_ValuePostingSource_getDocId", "(Lorg/xapian/ValuePostingSource;)J" 
    },
    {
      "SwigDirector_ValuePostingSource_next", "(Lorg/xapian/ValuePostingSource;D)V" 
    },
    {
      "SwigDirector_ValuePostingSource_skipTo", "(Lorg/xapian/ValuePostingSource;JD)V" 
    },
    {
      "SwigDirector_ValuePostingSource_check", "(Lorg/xapian/ValuePostingSource;JD)Z" 
    },
    {
      "SwigDirector_ValuePostingSource_atEnd", "(Lorg/xapian/ValuePostingSource;)Z" 
    },
    {
      "SwigDirector_ValuePostingSource_name", "(Lorg/xapian/ValuePostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_ValuePostingSource_init", "(Lorg/xapian/ValuePostingSource;J)V" 
    },
    {
      "SwigDirector_ValuePostingSource_toString", "(Lorg/xapian/ValuePostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_getTermfreqMin", "(Lorg/xapian/ValueWeightPostingSource;)J" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_getTermfreqEst", "(Lorg/xapian/ValueWeightPostingSource;)J" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_getTermfreqMax", "(Lorg/xapian/ValueWeightPostingSource;)J" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_getWeight", "(Lorg/xapian/ValueWeightPostingSource;)D" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_getDocId", "(Lorg/xapian/ValueWeightPostingSource;)J" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_next", "(Lorg/xapian/ValueWeightPostingSource;D)V" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_skipTo", "(Lorg/xapian/ValueWeightPostingSource;JD)V" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_check", "(Lorg/xapian/ValueWeightPostingSource;JD)Z" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_atEnd", "(Lorg/xapian/ValueWeightPostingSource;)Z" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_name", "(Lorg/xapian/ValueWeightPostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_init", "(Lorg/xapian/ValueWeightPostingSource;J)V" 
    },
    {
      "SwigDirector_ValueWeightPostingSource_toString", "(Lorg/xapian/ValueWeightPostingSource;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_MatchSpy_apply", "(Lorg/xapian/MatchSpy;JD)V" 
    },
    {
      "SwigDirector_MatchSpy_name", "(Lorg/xapian/MatchSpy;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_MatchSpy_mergeResults", "(Lorg/xapian/MatchSpy;[B)V" 
    },
    {
      "SwigDirector_MatchSpy_toString", "(Lorg/xapian/MatchSpy;)Ljava/lang/String;" 
    },
    {
      "SwigDirector_LatLongMetric_pointwiseDistance", "(Lorg/xapian/LatLongMetric;JJ)D" 
    },
    {
      "SwigDirector_LatLongMetric_name", "(Lorg/xapian/LatLongMetric;)Ljava/lang/String;" 
    }
  };
  Swig::jclass_XapianJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_XapianJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_method_ids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_method_ids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

