/* Automatically generated file using generate_code.sh from the .wxm examples           */
/* This file is part of wxMaxima, but read only by gettext allowing to translate the    */
/* example files.                                                                       */

/* Copyright (C) 2019 wxMaxima Team (https://wxMaxima-developers.github.io/wxmaxima/)   */

/* This program is free software; you can redistribute it and/or modify                 */
/* it under the terms of the GNU General Public License as published by                 */
/* the Free Software Foundation; either version 2 of the License, or                    */
/* (at your option) any later version.                                                  */

/* This program is distributed in the hope that it will be useful,                      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of                       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                        */
/* GNU General Public License for more details.                                         */

/* You should have received a copy of the GNU General Public License                    */
/* along with this program; if not, write to the Free Software                          */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            */

#include <wx/wx.h>
#include <wx/string.h

wxString examples = 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.01.1-DevelopmentSnapshot ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Solving differential equations\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If the equation that defines the shape of a curve references the steepness of the curve (diff('f(x),x)), the steepness of the steepness of the curve (diff('f(x),x,2)) or any other derivation of the curve the result is a differential equation that describes the general shapes the curve can have without describing its actual height.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Often a differential equation has a solution that cannot be expressed symbolically as mathematics lacks the necessary functions. In other cases one has to guess the general form of the solution and the computer only helps in finding the values of the parameters this solution contains. In the simple cases an engineer encounters on a daily basis maxima can do this automatically, instead.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"An example\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"A circuit is provided with an input capacitance of C_In=100nF, provides a resistive load R_Load and is connected to a power supply U_Supply via a cable of the inductivity L_Cable. In this moment the circuit is destroyed by an overvoltage. Let's see if we can calculate how high this voltage was.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"First we describe the energy-storing circuit elements. The voltage over the inductivity of the cable is calculated as follows:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq1:U_Supply=U_In(t)+L_Cable*diff(I_Cable(t),t);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The current into the input capacitance is:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq2:I_C(t)=C_In*diff(U_In(t),t);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Now we have enough information to calculate the input voltage itself:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq3:U_In(t)=R_Load*(I_Cable(t)-I_C(t));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If we did everything right maxima now can determine the equation that defines the general shape of all possible loading curves:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"desolve([eq1,eq2,eq3],[U_In(t),I_Cable(t),I_C(t)]);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"/* [wxMaxima: question  start ] */\n" 
L"<mth><st>Is </st><munder altCopy=\"L_Cable\"><mrow><mi>L</mi></mrow><mrow><mi>Cable</mi></mrow></munder><h>*</h><mrow><p><mn>4</mn><h>*</h><munder altCopy=\"C_In\"><mrow><mi>C</mi></mrow><mrow><mi>In</mi></mrow></munder><h>*</h><msup><mrow><munder altCopy=\"R_Load\"><mrow><mi>R</mi></mrow><mrow><mi>Load</mi></mrow></munder></mrow><mn>2</mn></msup><mi>-</mi><munder altCopy=\"L_Cable\"><mrow><mi>L</mi></mrow><mrow><mi>Cable</mi></mrow></munder></p></mrow><st> positive, negative or zero?</st></mth>\n" 
L"/* [wxMaxima: question  end   ] */\n" 
L"/* [wxMaxima: answer  start ] */\n" 
L"p;\n" 
L"/* [wxMaxima: answer  end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"In this case the answer to the question desolve() asks doesn't actually affect the shape of the result, but the way the result is expressed. The equations we get are very generic, though, still, as maxima knows the general set of shapes the function might have, but in order to draw actual curves lacks I_Cable(0) and U_In(0):\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"I_Cable(t=0)=atvalue(I_Cable(t),t=0,0);\n" 
L"U_In(t=0)=atvalue(U_In(t),t=0,0);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Next let's avoid the question using assume():\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"assume(L_Cable>0,R_Load>0,C_In>0,(4*C_In*R_Load^2-L_Cable)>0);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Additionally we are interested only in the first item in the result list:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sol1:desolve([eq1,eq2,eq3],[U_In(t),I_Cable(t),I_C(t)])[1];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"/* [wxMaxima: question  start ] */\n" 
L"<mth><st>Is </st><munder altCopy=\"L_Cable\"><mrow><mi>L</mi></mrow><mrow><mi>Cable</mi></mrow></munder><h>*</h><mrow><p><mn>4</mn><h>*</h><munder altCopy=\"C_In\"><mrow><mi>C</mi></mrow><mrow><mi>In</mi></mrow></munder><h>*</h><msup><mrow><munder altCopy=\"R_Load\"><mrow><mi>R</mi></mrow><mrow><mi>Load</mi></mrow></munder></mrow><mn>2</mn></msup><mi>-</mi><munder altCopy=\"L_Cable\"><mrow><mi>L</mi></mrow><mrow><mi>Cable</mi></mrow></munder></p></mrow><st> positive, negative or zero?</st></mth>\n" 
L"/* [wxMaxima: question  end   ] */\n" 
L"/* [wxMaxima: answer  start ] */\n" 
L"p;\n" 
L"/* [wxMaxima: answer  end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Let's specify the circuit values we might know about...\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals:[\n" 
L"    U_Supply=5,\n" 
L"    R_Load=100,\n" 
L"    C_In=100*10^-9\n" 
L"];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sol1_val:subst(vals,sol1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"...and let's plot the result for different L_Cable:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"engineering-format\")$\n" 
L"engineering_format_floats: true$\n" 
L"engineering_format_min: .01$\n" 
L"engineering_format_max: 1000$\n" 
L"fpprintprec: 6$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxplot_size:[1280,800]$\n" 
L"wxanimate_autoplay:true$\n" 
L"wxanimate_framerate:2$\n" 
L"with_slider_draw(\n" 
L"    L,makelist(i*10^-9*10,i,1,20),\n" 
L"    title=sconcat(\"L_{Cable}=\",float(L)),\n" 
L"    explicit(\n" 
L"        subst(\n" 
L"            t=us*10^-6,\n" 
L"            subst(\n" 
L"                L_Cable=L,\n" 
L"                rhs(sol1_val)\n" 
L"            )\n" 
L"        ),\n" 
L"        us,0,20\n" 
L"    ),\n" 
L"    yrange=[0,10], grid=[2,1]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.01.1-DevelopmentSnapshot\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.01.2-DevelopmentSnapshot ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Visualizing 3D curves\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxplot_size:[1200,900]$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Standard curves\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Maxima's default way of displaying 3d surfaces is optimized on fast display. In order to get a feeling for the shape of the curve it might help to right-click on it and press on the \"Popout interactively\" button which opens a window the curve can be rotated in:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"curve1:z=sin(x)*cos(y);\n" 
L"wxdraw3d(\n" 
L"    explicit(\n" 
L"        rhs(curve1),\n" 
L"        x,-3,3,\n" 
L"        y,-3,3\n" 
L"    )\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Slower to draw, but easier to understand the curve is if the surface isn't transparent:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw3d(\n" 
L"    surface_hide=true,\n" 
L"    explicit(\n" 
L"        rhs(curve1),\n" 
L"        x,-3,3,\n" 
L"        y,-3,3\n" 
L"    )\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Alternatively the curve can be made more colorful:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw3d(\n" 
L"    enhanced3d=true,\n" 
L"    explicit(\n" 
L"        rhs(curve1),\n" 
L"        x,-3,3,\n" 
L"        y,-3,3\n" 
L"    )\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Contour lines\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If not the shape, but the absolute heights are important maxima offers contour lines.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw3d(\n" 
L"    surface_hide=true,\n" 
L"    color=\"#a0a0a0\",\n" 
L"    key=\"curve_1\",\n" 
L"    explicit(\n" 
L"        rhs(curve1),\n" 
L"        x,-3,3,\n" 
L"        y,-3,3\n" 
L"    ),\n" 
L"    contour='both,\n" 
L"    contour_levels=[-1,.2,1]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"In many cases the actual curve actually isn't important while the height values are. In this case it is possible to generate a top view without drawing the actual surface:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw3d(\n" 
L"    explicit(\n" 
L"        rhs(curve1),\n" 
L"        x,-3,3,\n" 
L"        y,-3,3\n" 
L"    ),\n" 
L"    contour='map,\n" 
L"    contour_levels=[-1,.1,1]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Moving pictures\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"In order to make the 3d shape easier to grasp\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"As can easily be seen if one pops out the above images interactively and moves them the human brain is quite efficient in grasping the complete shape of a moving picture. wxMaxima allows to embed such a thing into the worksheet:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxanimate_autoplay:true$\n" 
L"wxanimate_framerate:10$\n" 
L"with_slider_draw3d(\n" 
L"    α,makelist(10*sin(2*π*t/20),t,0,40),\n" 
L"    view=[60,30+α],\n" 
L"    surface_hide=true,\n" 
L"    key=\"curve_1\",\n" 
L"    explicit(\n" 
L"        rhs(curve1),\n" 
L"        x,-3,3,\n" 
L"        y,-3,3\n" 
L"    ),\n" 
L"    contour='both,\n" 
L"    contour_levels=[-1,.2,1]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"In order to allow to read values more easily\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Sometimes it isn't actually necessary to display the whole 3D shape and the height of the curve is more easy to read if one assigns the mouse's scroll wheel to the y coordinate.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxanimate_autoplay:false;\n" 
L"with_slider_draw(\n" 
L"    y_coord,makelist(i,i,-2,2,.1),\n" 
L"    key=\"z_{curve_1}\",\n" 
L"    explicit(\n" 
L"        subst(y=y_coord,rhs(curve1)),\n" 
L"        x,-3,3\n" 
L"    ),\n" 
L"    grid=[2,2],\n" 
L"    title=sconcat(\"y=\",y_coord),\n" 
L"    xlabel=\"x\",ylabel=\"z\",\n" 
L"    yrange=[-1,1]\n" 
L"),fpprintprec=3$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"In order to view this picture just click on it and move the mouse wheel. The fact that y needs to substituted into the equation to plot manually is a long-standing bug in maxima's makelist() command.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.01.2-DevelopmentSnapshot\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.03.1-DevelopmentSnapshot ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Fast list access\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Lists and Arrays\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If one wants to store a bunch of items there is basically two methods:\n" 
L" * Arrays: If you know in advance that you want to store n items and that all have the same size m it is easy to allocate m*n bytes of memory. Determining the address the k-th element starts is easy in this case.\n" 
L" * Lists: Memory for each list element is allocated the moment a new element is needed and each element knows where in the computer's memory the next list element is stored.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Maxima loves Lists: It is easy to append items to a lists at any time. It is easy to delete list items. List items can be re-ordered just by swapping a few pointers. Maxima contains fast methods to sort lists, to eliminate double elements. But determining the length of a list or the address the nth list item is stored at means having to iterate through the list querying each item where the next list item can be found.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Fast access to all list elements\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Accessing a random item of a list involves a time-consuming iterating over the list. But if one plans to iterate through the whole list, anyway (as one normally has to) this work isn't much of an overhead - and maxima offers several functions for this purpose:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"makelist\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Makelist is a quite universal swiss-army knife, if what you want to generate is shaped like a list.\n" 
L"The most widely known form of this command is:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"list1:makelist(i,i,1,10);\n" 
L"list2:makelist(i,i,0,9/10,1/10);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"But you can also tell makelist to iterate over a list - which is quite fast:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"list3:makelist(sin(i),i,list2);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"for\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"For does do nearly the same as makelist except that it doesn't return a list.:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"for i in list3 do disp(asin(i));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"pop\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"It is possible to access all list elements by accessing and removing the first element repeatedly:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"while not emptyp(list3) do \n" 
L"    disp(pop(list3));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"map\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"map runs the same function on every single list element:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"list2;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"map(sin,list2);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If the function one wants to run on each list element is only used once and one doesn't want to give this one-time-function a name one can ask the lambda() command to generate a name-less function with one argument: Just passlambda() first the list of the arguments the new command shall have and the contents of that command:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"map(\n" 
L"    lambda(\n" 
L"        [x],\n" 
L"        sin(cos(x))\n" 
L"    ),\n" 
L"    list2\n" 
L");\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Iterating through two lists at the same time\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"One way to do so efficiently is to use the pop() method on both lists. The other is to make a list of lists:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"M1:matrix(list1,list2);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"M2:transpose(M1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Now we extract the list of arguments to the matrix() command:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"list4:args(M2);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Of course all of these commands can be executed in one long command line:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"list5:args(transpose(matrix(list1,list2)));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"...and over this list we can iterate efficiently again:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"makelist(f(i[1])=i[2],i,list4);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.03.1-DevelopmentSnapshot\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.03.1-DevelopmentSnapshot ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Fitting equations to real measurement data\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"One place Maxima can show its full power at is where symbolical mathematics that describes a phenomenon is used for understanding real measurement data.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"As a first step normally the real measurement data is loaded from a .csv file using read_matrix:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"? read_matrix;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"For the sake of generating a self-contained example we generate this data synthetically. For the first example a parabola with a bit of measurement noise might be a good start:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"fun1(x):=3*x^2-2*x+7;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"time1:makelist(i,i,-10,10,.02)$\n" 
L"data1:transpose(\n" 
L"    matrix(\n" 
L"        time1,\n" 
L"        makelist(fun1(i)+random(32.0)-16,i,time1)\n" 
L"    )\n" 
L")$\n" 
L"wxdraw2d(grid=true,xlabel=\"x\",ylabel=\"y\",\n" 
L"    points(data1)\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"The general approach\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Let's assume we have guessed that the curve might be something parabola-like:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"approach1:y=a*x^2+b*x+c;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Maxima now offers a simple, but powerful curve fitter that guesses the parameters a,b and c for us:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"lsquares\")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lsquares_estimates_approximate(\n" 
L"    lsquares_mse(\n" 
L"        data1,[x,y],approach1\n" 
L"    ),\n" 
L"    [a,b,c],\n" 
L"    initial=[0,0,0]\n" 
L");\n" 
L"params1:%[1];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"In this example the \"initial=\" wasn't really necessary. But sometimes using the wrong starting point means that lsquares heads for the wrong local optimum of the problem.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"rec1:subst(params1,approach1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw2d(\n" 
L"    grid=true,xlabel=\"x\",ylabel=\"y\",\n" 
L"    color=red,key=\"Reconstructed\",\n" 
L"    explicit(rhs(rec1),x,-10,10),\n" 
L"    color=blue,key=\"Original\",\n" 
L"    explicit(fun1,x,-10,10)\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Besides lsquares_estimates_approximate the lsquares package also provides a command named lsquares_estimates that tries to find the exact optimum by running the problem through solve() before finding the answer numerically. But as it is always the case with computers if the problem that is to be solved is complex one does never know in advance how long it will take and if it ever will finish. lsquares_estimates_approximate doesn't have this drawback.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Dealing with non-evenly-spaced data\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Sometimes the input data isn't evenly spaced.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The places with a higher density of samples have more weight when fitting data to the curves. So let's add an error to the place with the highest data density and see if we can cope with it.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"time2:makelist(i^4*i/abs(i),i,-2,2,.02)$\n" 
L"data2:transpose(\n" 
L"    matrix(\n" 
L"        time2,\n" 
L"        makelist(fun1(i)+random(4.0)-2+50*sin(i)/i,i,time2)\n" 
L"    )\n" 
L")$\n" 
L"wxdraw2d(grid=true,xlabel=\"x\",ylabel=\"y\",\n" 
L"    points(data2),\n" 
L"    yrange=[0,800]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Since the biggest error occurs where we have the highest density of data the result of fitting the curve to this data directly will be suboptimal:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lsquares_estimates_approximate(\n" 
L"    lsquares_mse(\n" 
L"        data2,[x,y],approach1\n" 
L"    ),\n" 
L"    [a,b,c]\n" 
L");\n" 
L"params2_1:%[1];\n" 
L"wxdraw2d(\n" 
L"    grid=true,xlabel=\"x\",ylabel=\"y\",\n" 
L"    color=red,key=\"Reconstructed\",\n" 
L"    explicit(rhs(subst(params2_1,approach1)),x,-10,10),\n" 
L"    color=blue,key=\"Original\",\n" 
L"    explicit(fun1,x,-10,10)\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Converting the data to an continuous curve\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The interpol package allows to generate continuous and half-way smooth curves from any input data.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"interpol\")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"data2_cont:cspline(data2,'varname=x)$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw2d(\n" 
L"    explicit(data2_cont,x,-10,10),\n" 
L"    grid=true,xlabel=\"x\",ylabel=\"y\"\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Generating evenly-spaced samples from this curve\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"First we generate the new data and time vector. As always the fact that a subst() is necessary in this step is caused by a bug in makelist.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"time_i:makelist(i,i,-10,10,.05)$\n" 
L"values2_i:makelist(subst(x=i,data2_cont),i,time_i)$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Now we generate a matrix of values lsquares can deal with:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"data2_i:float(transpose(matrix(time_i,values2_i)))$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The result is a still noisy and distorted, but more evenly-spaced curve:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw2d(\n" 
L"    points(data2_i),\n" 
L"    grid=true,xlabel=\"x\",ylabel=\"y\"\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Fitting this curve will yield a better result as the first attempt:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lsquares_estimates_approximate(\n" 
L"    lsquares_mse(\n" 
L"        data2_i,[x,y],approach1\n" 
L"    ),\n" 
L"    [a,b,c]\n" 
L");\n" 
L"params2_2:%[1];\n" 
L"wxdraw2d(\n" 
L"    grid=true,xlabel=\"x\",ylabel=\"y\",\n" 
L"    color=red,key=\"Reconstructed\",\n" 
L"    explicit(rhs(subst(params2_2,approach1)),x,-10,10),\n" 
L"    color=blue,key=\"Original\",\n" 
L"    explicit(fun1,x,-10,10)\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Fitting data to a·exp(k·t)\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The natural approach to fitting data to exponential curves would be:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"approach2:y=a*exp(k*t);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Unfortunately it is hard to fit to experimental data to this approach in many ways, for example:\n" 
L" * One part of this curve results in low values. Even small measurement noise on this part will yield widely incorrect results for the curve parameters as the fitter is trying to model the noise, too, and as noise in nonlinear systems tends not to be averanged out completely.\n" 
L" * Another part of this curve contains quite in high values and is sensitive to even small changes in k. As the fitter wants to keep the overall error low it will therefore respect this part much more than the lower, more good-natured part of the curve.\n" 
L" * Starting from the wrong point and optimizing a and k in the direction that reduces the error most in each step might lead to a point that is far from being the solution\n" 
L" * and trying to use lsquares_estimates to find the ideal solution often leads to numbers that exceed the floating-point range (or exact numbers longer than the computer's memory).\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"A better approach is therefore to use Caruana's approach for fitting:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"approach2/a;\n" 
L"caruana:log(%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"This approach is much more good-natured for finding the parameters (that can then be substituted into approach2).\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The problem with noise causing finding erroneous parameters is still valid, though, in this case.  It can be partially eliminated by introducing a c_noise, as proposed by Guo.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(approach2)=rhs(approach2+c_noise);\n" 
L"%-c_noise;\n" 
L"%/a;\n" 
L"approach_guo:log(%),logexpand=super;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Additionally https://ieeexplore.ieee.org/document/5999593 offers an iterative method that allows to reduce the influence of noise in each step:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Using a different fitting algorithm\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Maxima provides a second algorithm that often produces even better results, but is a bit more complicated to use. For example it requires us to manually compile a list of the errors we want to minimize. Let's do that for data2_i and approach1:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"approach1;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"errval:lhs(approach1)-rhs(approach1);\n" 
L"my_mse:makelist(\n" 
L"    subst(\n" 
L"        [x=i[1],y=i[2]],\n" 
L"        errval\n" 
L"    ),\n" 
L"    i,args(data2_i)\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Hints for understanding this construct:\n" 
L" * args() converts a matrix to a list of lists, \n" 
L" * The makelist() command steps through this list and for each  data point assigns the list of the x and y value to i\n" 
L" * rhs() and lhs() extract the right hand side and the left hand side of an equation (the part right and left of the \"=\") \n" 
L" * and since we know which element in i means which variable we can use subst() in orer to substitute the elements in i into errval, the equation that tells us how big the error in this point is.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The result is a list of error values, each in the following format:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"my_mse[1];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Now let's load the package that contains the other fitter:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"minpack\")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Fitting the data is simple:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"param_list:[a,b,c];\n" 
L"result:minpack_lsquares(my_mse,param_list,[1,1,1]);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Converting the result into a list of equations is a bit more complicated:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"params_3:map(lambda([x],x[1]=x[2]),args(transpose(matrix(param_list,result[1]))));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Hints for understanding this line:\n" 
L" * Map runs a command on each element of a list\n" 
L" * We want to  provide map with a command that converts something of the type \"[a,3]\" to an \"a=3\".  But we won't re-use this command so there is no need to actually give this command a name. Therefore we use lambda() in order to create a name-less command with one parameter, x.\n" 
L" * args again converts a matrix to a list of lists and\n" 
L" * we need to convert our input data into a list in order to transpose it (which means: exchange the columns by rows and vice versa)\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The result isn't too bad, this time, neither:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw2d(\n" 
L"    grid=true,xlabel=\"x\",ylabel=\"y\",\n" 
L"    color=red,key=\"Reconstructed\",\n" 
L"    explicit(rhs(subst(params_3,approach1)),x,-10,10),\n" 
L"    color=blue,key=\"Original\",\n" 
L"    explicit(fun1,x,-10,10)\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.03.1-DevelopmentSnapshot\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.01.1 ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Number formats\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Floating-point numbers\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Most computers include floating-point units that make relatively-high-precision calculations very fast. If a number is input with a decimal dot or in the \"1e3\" notation maxima assumes one wants to use the kind of floats the machine supports out-of-the box:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"1.0;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"1000121012.10;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"1e9;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Any other number can be converted to a floating-point one using the float() keyword:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"float(10);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"float(10/3);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The drawback the enhanced speed comes with is that using floating-point numbers come with inaccuracies that might hit when one least expects them. For example machine floats cannot exactly express seemingly simple numbers like 0.1:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"rationalize(0.1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Another drawback is that mathematics is based on the fact that two things that cancel each other out actually do so:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"0.1+0.01-0.1-0.01;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Rump and Wilkinson have provided warning examples of simple polynomials where this adds up to catastrophic errors quickly and it is surprising how often one encounters similar in real live including a big fraction of the glitches one can find in computer games.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Maxima allows to customize the format floating-point numbers are displayed in:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"engineering-format\")$\n" 
L"engineering_format_floats: true$\n" 
L"engineering_format_min: .01$\n" 
L"engineering_format_max: 1000$\n" 
L"fpprintprec: 6$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"0.1+0.01-0.1-0.01;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"float(π);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"float(π*10000);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Bigfloats\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Maxima alternatively provides its own implementation of floating-point numbers that are slow (they have to be processed in software), but can be provided with any precision. Numbers can be converted to bigfloats using the bfloat() command or by entering a \"b\" instead of an \"e\" when declaring the exponent:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"fpprintprec:0$\n" 
L"fpprec:100$\n" 
L"bfloat(%pi);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"rationalize(1b-1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If too low or to high a number of digits is displayed here when right-clicking on such a number opens up a menu that allows to customize this behavior.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Exact numbers\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The type of number maxima was written for is exact numbers instead. Maxima assumes any number that doesn't contain a decimal dot to be intended as being an exact number:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"1/10;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"π/4*3;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sqrt(2)/2;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"exp(21/7);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"R_100=121*10^3;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Many hard-to-find errors can be avoided by using exact numbers. It is therefore wise to use exact numbers wherever possible and only to convert the results to floats using float() or bfloat():\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sqrt(π)*3;\n" 
L"float(%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.01.1\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.01.2-DevelopmentSnapshot ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Solving equations\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Mathematics can be seen as a language consisting only of a rather small set of words and only a handful of grammatical rules. Both sets are carefully chosen, though, that by simply reformulating the question in many cases the answer can be found.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If you are studying mathematics the good news is that solving equations is an art a computer can help with in many special cases but that often relies on human creativity for finding algorithms and ways.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Simple equations\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"For many problems Maxima's solve() program instantly finds a list of solutions:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"pyth:c^2=a^2+b^2;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sol1:solve(pyth,a);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Both solutions solve() offers are valid. We can pick any of them manually, for example:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sol2:sol1[2];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"By having given this equation a name (\"sol2\") we gained a way to re-use this equation later.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"This time the type of solutions we can get depends on the value of a which is why maxima asked about it. One can avoid asking questions by telling the answers to maxima's assume database:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"assume(a>0, b>0, c>0);\n" 
L"solve(sol2,b);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Solve also accepts lists as its arguments. In this case it will only find solutions if the following conditions are all met:\n" 
L" * The number of linearly independent equations matches the number of variables to solve to\n" 
L" * The solution doesn't completely change its form depending on the range one variable is in.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq2:a+2*b=10;\n" 
L"solve(\n" 
L"    [pyth,eq2],\n" 
L"    [a,b]\n" 
L");\n" 
L"rootscontract(%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"By choosing [a,b] as the list of solution variables maxima is automatically told to eliminate these two variables on the right side of the equations, if possible.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Re-using the solutions\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"As seen above the last equation displayed by maxima can be referenced by using the placeholder \"%\":\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"%;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Additionally have given nearly all equations names that allow to reference the whenever we need them. For example we can print them out again:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"sol2;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"We can use them as an input to solve:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"solve(sol2,b);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"/* [wxMaxima: question  start ] */\n" 
L"<mth><st>Is </st><mi>a</mi><st> positive, negative or zero?</st></mth>\n" 
L"/* [wxMaxima: question  end   ] */\n" 
L"/* [wxMaxima: answer  start ] */\n" 
L"p;\n" 
L"/* [wxMaxima: answer  end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"We can introduce (\"substitute\") them into other equations:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"E=m*c^2;\n" 
L"subst(pyth,%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Additionally the left hand side and the right hand side can be extracted using the command lhs() and rhs() which allows to use the part left or right to to the \"=\" in a new equation:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(pyth);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"rhs(pyth);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq10:sin(δ)=rhs(pyth);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Boiling it down to numbers\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If in mathematics two things cancel each other out they do so exactly. The same isn't true with IEEE floating-point numbers like the ones the computer uses:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L".1;\n" 
L"%-.01;\n" 
L"%-.1;\n" 
L"%+.01;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Many computer programs are configured to show small numbers as \"0\" or only to show the first few digits after the decimal dot hoping that the rest is a rounding error that doesn't add up (see wilkinson's polynomial for an example where this happens quickly). Maxima's solve instead tries to replace floating-point numbers by the exact fraction it most likely means and warns about doing so:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"solve(x+.1=2,x);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Since it often is the general case that allows to learn about the fundamental mechanisms often a good approach is to solve everything symbolically and to keep the actual numerical input values in a separate list like the following one:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals:[\n" 
L"    a=sqrt(1/2),\n" 
L"    b=sqrt(1/2),\n" 
L"    δ=π/2\n" 
L"];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Whenever a numerical value is needed this list can be introduced into any equation:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"subst(vals,pyth);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"subst(vals,eq10);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"What if there exists no symbolical solution?\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Some solutions have never been assigned a name in mathematics. One popular example would be:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq2:cos(x)=x;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"solve() which tries to find a symbolical solution is bound to fail here and tells us how far it got:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"solve(eq2,x);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"In this case maxima offers several options to at least find the numerical values, two examples are given below:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw2d(\n" 
L"    explicit(\n" 
L"        rhs(eq2)-lhs(eq2),\n" 
L"        x,-1,1\n" 
L"    ),\n" 
L"    grid=true\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"mnewton\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"mnewton uses a modified version of newton's method for finding a solution of a nonlinear, but differentiable, statical and monotonic function near to a point (in this example 0.1)\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"mnewton\")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"mnewton(eq2,x,.1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"find_root\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"find_root even works if the equation isn't differentiable and searches for a solution in between two points.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"find_root(eq2,x,-.001,1);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.01.2-DevelopmentSnapshot\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.01.2-DevelopmentSnapshot ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Tolerance calculations\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If the outcome of a calculation depends on many factors determining manually which cases are the worst-case one is a manual and error-prone process. Alternatives to doing so are:\n" 
L" * Implementing a full-fledged interval arithmetics that automatically determines the range of the output depending on the ranges of the input parameters. Unfortunately doing so is so complex that any interval arithmetics is bound to work only in more or less trivial cases.\n" 
L" * Calculating the derivation of the result over the tolerance of each parameter hoping these derivations point to a global maximum, not only to a local one.\n" 
L" * A montecarlo analysis: All parameters are filled with random values out of their tolerance range. Then the calculation is repeated until the spread of the outcome can be seen.\n" 
L" * Or systematically trying out all combinations at the edges of the n-dimensional tolerance space. \n" 
L"The last two of these methods are described here.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"The problem\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"A simple voltage divider of R_1 and R_2 is powered by a voltage source U_In. In which range can U_Out lie?\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Mathematical description\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq1: I=U_In/(R_1+R_2);\n" 
L"eq2: U_Out=I*R_2;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"These equations are simple enough that there is no need to use solve() to introduce them into each other:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"uout:subst(eq1,eq2);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Input values that include a tolerance\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"First we load the tolerance calculation package:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"load(\"wrstcse\")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"The tolerance calculation package lets tol[n] tolerate between -1 and 1. tol[n] with the same n are coupled tolerances that share the same value. In theory the \"n\" doesn't need to be a number. But if it is a symbolic name one has to make sure this name is never assigned a value else tol[name] will be replaced by tol[<value of the variable \"name\">]\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Let's assume that R_1 is a 100Ω with 10% tolerance. R_2 is a 1000Ω resistor with 1% tolerance instead:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals1:[\n" 
L"    R_1=100*(1+.1*tol[1]),\n" 
L"    R_2=1000*(1+.01*tol[2])\n" 
L"];\n" 
L"wc_inputvalueranges(%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"We can propose another set of values: Two resistors that are only 10% ones, but are guaranteed to always deviate into the same direction by the same percentage.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals2:[\n" 
L"    R_1=100*(1+.1*tol[1]),\n" 
L"    R_2=1000*(1+.1*tol[1])\n" 
L"];\n" 
L"wc_inputvalueranges(%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Print out the results\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Just substituting the values into the equations provides us with the equation containing the real values and the tolerances in wrstcse's notation:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"subst(vals1,uout);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If we just want to know the typical value we can do the following:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wc_typicalvalues(subst(vals1,uout));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wc_typicalvalues(subst(vals2,uout));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"We now want to test all combinations of minimum, typical or maximum value, instead.\n" 
L"First we tell maxima not to print a warning if a float is replaced by a fraction of the same value:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"ratprint:false;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Then we ask wrstcse to print out the tolerances of the right hand side of our equation \"uout\":\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals1,rhs(uout)));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"This result is still - well, hard to interpret, because Maxima didn't know the value of U_In which is necessary to decide which of all the terms is the minimum and which is the maximum. But we can inform maxima about the necessary facts:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"assume(U_In>0);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals1,rhs(uout)));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals2,rhs(uout)));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"As we have guessed the 2nd voltage divider was the better one.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Specifying complex tolerances\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Now we want to tell maxima that the voltage source provides a voltage between 4V and 6V, typically 4.5V. For doing this a specialized function exists:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals3:[\n" 
L"    R_1=100*(1+.1*tol[1]),\n" 
L"    R_2=1000*(1+.1*tol[1]),\n" 
L"    U_In=wc_mintypmax2tol(tol[3],4,4.5,6)    \n" 
L"];\n" 
L"wc_inputvalueranges(%);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals3,rhs(uout)));\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Appending lists of tolerances\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If it is necessary to append two lists of values with tolerances to each other without risking a collision of tol[n] that happen to have the same n in the two lists the following function can be used:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals4:[\n" 
L"    U_In=wc_mintypmax2tol(tol[1],4,4.5,6)    \n" 
L"];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"vals5:wc_tolappend(vals1,vals4);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"wc_tolappend() appends values with tolerances and renumbers the tol[n]\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Using a bigger or lower number of samples\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"By default the wrstcse package tests all combinations of 3 values per tol[n]: The minimum, the maximum and the typical value. If we only want to test 2 values (the minimum and the maximum) that might speed up lengthy calculations with many values that contain tolerances:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals5,rhs(uout)),2);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Monte carlo analysis\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"This time we want the tolerance package to use 1000 random sets of values and to find the best and worst case that can be reached using these values:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals5,rhs(uout)),-1000);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If this calculation is repeated it will naturally result in slightly different numeric values:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lhs(uout)=wc_mintypmax(subst(vals5,rhs(uout)),-1000);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"A ridiculously advanced example\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Description of the problem\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Someone constructs a magic drill that is guaranteed to generate holes that exactly meet 3 points. But that points unfortunately all have tolerances. We now are asked to produce images of the possible outcome.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Round holes can be described as follows:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"hole1:(x-x_1)^2+(y-y_1)^2=r^2;\n" 
L"hole2:(x-x_2)^2+(y-y_2)^2=r^2;\n" 
L"hole3:(x-x_3)^2+(y-y_3)^2=r^2;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"solve([hole1,hole2,hole3],[x,y,r])$\n" 
L"sol1:%[2];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"The coordinates of the points the holes touch\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"coords:[\n" 
L"    x_1=0+.04*tol[x1],y_1=0+.04*tol[y1],\n" 
L"    x_2=1+.04*tol[x2],y_2=0+.04*tol[y2],\n" 
L"    x_3=0+.04*tol[x3],y_3=1+.04*tol[y3]\n" 
L"];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Generating a list of 100 sets of possible values of \"coords\"\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"lstOfCoords:wc_montecarlo(coords,100)$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Plotting these lists\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxanimate_autoplay:true$\n" 
L"wxanimate_framerate:5$\n" 
L"with_slider_draw2d(\n" 
L"    i,lstOfCoords,\n" 
L"    point_type=2,grid=true,\n" 
L"    proportional_axes='xy,\n" 
L"    subst(\n" 
L"        i,\n" 
L"        [\n" 
L"            key=\"The 3 coordinates\",\n" 
L"            points([x_1,x_2,x_3],[y_1,y_2,y_3]),\n" 
L"            key=\"\",fill_color=\"#000000FF\",\n" 
L"            subst(\n" 
L"                sol1,\n" 
L"                ellipse(x,y,r,r,0,360)\n" 
L"            )\n" 
L"        ]\n" 
L"    ),\n" 
L"    xrange=[-.55,1.55],\n" 
L"    yrange=[-.55,1.55]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxdraw2d(\n" 
L"    point_type=2,grid=true,\n" 
L"    proportional_axes='xy,\n" 
L"    makelist(\n" 
L"        subst(\n" 
L"            i,\n" 
L"            [\n" 
L"                points([x_1,x_2,x_3],[y_1,y_2,y_3]),\n" 
L"                key=\"\",fill_color=\"#000000FF\",\n" 
L"                subst(\n" 
L"                    sol1,\n" 
L"                    ellipse(x,y,r,r,0,360)\n" 
L"                )\n" 
L"            ]\n" 
L"        ),i,lstOfCoords),\n" 
L"    xrange=[-.55,1.55],\n" 
L"    yrange=[-.55,1.55]\n" 
L")$\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.01.2-DevelopmentSnapshot\"$\n" 
L"/* [wxMaxima batch file version 1] [ DO NOT EDIT BY HAND! ]*/\n" 
L"/* [ Created with wxMaxima version 20.02.2 ] */\n" 
L"/* [wxMaxima: title   start ]\n"  + _(
L"Advanced variable names\n" 
) + L"   [wxMaxima: title   end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Engineer-style Subscripts\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"wxMaxima allows to use engineer-style subscripts in variable or function names:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"R_100=U_In/I_Out;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"If this feature is over-eager (or not eagerly enough) wxMaxima offers additional control:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxsubscripts: 'all$\n" 
L"RR_xy;\n" 
L"R_100;\n" 
L"RR_100;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxsubscripts: false$\n" 
L"RR_xy;\n" 
L"R_100;\n" 
L"RR_100;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxsubscripts: true$\n" 
L"RR_xy;\n" 
L"R_100;\n" 
L"RR_100;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"wxsubscripts: true$\n" 
L"wxdeclare_subscripted(ew_wewr)$\n" 
L"ew_wewr;\n" 
L"ew_qwqw;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Variable and equation names containing \"'\", \"+\", \"-\" or the like\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"By escaping it with a backslash nearly every symbol can be made to be interpreted as an ordinary character:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq1\\':φ_\\-=10;\n" 
L"eq1\\'\\':φ_\\+=φ_\\-;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq1:subst(eq1\\',eq1\\'\\');\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Equipping any character with accents\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Unicode supports so-called \"combining diacritics\" that allow to assemble a character from several elements. Maxima might not know that the individual parts these characters are combined to are meant to be interpreted as ordinary letters, though, so assembling weird characters is a multi-step process:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Easy access to combining diacritics\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L" * Open the \"mathematical symbols\" sidebar (if it isn't already displayed) and right-click on it\n" 
L" * Drag-and-drop a combining diacritic to the \"add new symbols\" dialogue, for example one of the following.\n" 
L" * The \"symbols\" sidebar now should allow for easy access to these characters.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"A few combining diacritics are:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L" * ̂\n" 
L" * ̃\n" 
L" * ̅\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: subsect start ]\n"  + _(
L"Actually using combining diacritics\n" 
) + L"   [wxMaxima: subsect end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"* First enter the character you want to equip with new accents or the like.\n" 
L"* Then add a Backslash (\"\\\") in order to tell maxima that the symbol that now follows is to be interpreted as an ordinary character\n" 
L"* Then add the combining diacritic(s):\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"d\\̃=10;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"T\\̂/U_Test;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"Pre- and post- super- and subscripts\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Thanks to Robert Dodier it is now possible to equip variables with super-, and subscripts that are displayed left of the variable name, too:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"declare_index_properties(A,[postsubscript,postsuperscript,presubscript,presuperscript])$\n" 
L"A[postsubscript,postsuperscript,presubscript,presuperscript];\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: section start ]\n"  + _(
L"A weird example, just for showing off\n" 
) + L"   [wxMaxima: section end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"Let's hope the font that is used to display this includes cherries, pear and banana symbols.\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"eq1:🍐+🍌=🍒;\n" 
L"eq2:🍐+🍐=🍌;\n" 
L"eq3:🍌=10;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"solve([eq1,eq2,eq3],[🍐,🍌,🍒]);\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"/* [wxMaxima: comment start ]\n"  + _(
L"For all xkcd fans:\n" 
) + L"   [wxMaxima: comment end   ] */\n"  
L"\n" 
L"\n" 
L"/* [wxMaxima: input   start ] */\n" 
L"xkcd_55:sqrt(💓)=\\?;\n" 
L"/* [wxMaxima: input   end   ] */\n" 
L"\n" 
L"\n" 
L"\n" 
L"/* Old versions of Maxima abort on loading files that end in a comment. */\n" 
L"\"Created with wxMaxima 20.02.2\"$\n" 
" ";
