/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.SimpleResolver;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestExternalSubset
extends BaseVStreamTest {
    public void testSimpleValidExternalSubset() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'myurl' ><root>text</root>";
        String EXT_ENTITY_VALUE = "just testing";
        String EXT_SUBSET = "<!ELEMENT root (#PCDATA)>\n<!-- comments are ok!!! -->";
        XMLStreamReader sr = this.getReader(XML, true, new SimpleResolver(EXT_SUBSET));
        TestExternalSubset.assertTokenType(11, sr.next());
        TestExternalSubset.assertTokenType(1, sr.next());
        TestExternalSubset.assertEquals((String)"root", (String)sr.getLocalName());
        TestExternalSubset.assertTokenType(4, sr.next());
        TestExternalSubset.assertEquals((String)"text", (String)TestExternalSubset.getAndVerifyText(sr));
        TestExternalSubset.assertTokenType(2, sr.next());
        sr.close();
    }

    public void testEntityInExternalSubset() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'myurl' ><root>&extEnt;</root>";
        String EXT_ENTITY_VALUE = "just testing";
        String EXT_SUBSET = "<!ELEMENT root (#PCDATA)>\n<!ENTITY extEnt '" + EXT_ENTITY_VALUE + "'>\n";
        XMLStreamReader sr = this.getReader(XML, true, new SimpleResolver(EXT_SUBSET));
        TestExternalSubset.assertTokenType(11, sr.next());
        TestExternalSubset.assertTokenType(1, sr.next());
        TestExternalSubset.assertEquals((String)"root", (String)sr.getLocalName());
        TestExternalSubset.assertTokenType(4, sr.next());
        TestExternalSubset.assertEquals((String)EXT_ENTITY_VALUE, (String)TestExternalSubset.getAndVerifyText(sr));
        TestExternalSubset.assertTokenType(2, sr.next());
        sr.close();
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, XMLResolver resolver) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestExternalSubset.setCoalescing(f, false);
        TestExternalSubset.setNamespaceAware(f, nsAware);
        TestExternalSubset.setSupportDTD(f, true);
        TestExternalSubset.setValidating(f, true);
        TestExternalSubset.setSupportExternalEntities(f, true);
        TestExternalSubset.setResolver(f, resolver);
        return TestExternalSubset.constructStreamReader(f, contents);
    }
}

