/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestAttrTypes
extends BaseVStreamTest {
    public TestAttrTypes(String name) {
        super(name);
    }

    public void testAttrTypes() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root \nattrCData CDATA #IMPLIED\nattrId ID #IMPLIED\nattrIdref IDREF #IMPLIED\nattrIdrefs IDREFS #IMPLIED\nattrEnum (val1| val2) #IMPLIED\nattrEnt ENTITY #IMPLIED\nattrEnts ENTITIES #IMPLIED\nattrName NMTOKEN #IMPLIED\nattrNames NMTOKENS #IMPLIED\n>\n]><root attrCData='1' attrId='id' attrIdref=\"id\" attrIdrefs='id' attrEnum='val1' attrName='name' attrNames='name1 name2' />";
        XMLStreamReader sr = this.getValidatingReader(XML, true);
        TestAttrTypes.assertTokenType(11, sr.next());
        TestAttrTypes.assertTokenType(1, sr.next());
        int count = sr.getAttributeCount();
        TestAttrTypes.assertEquals((int)7, (int)count);
        HashMap<String, String> seen = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            String value;
            String name = sr.getAttributeLocalName(i);
            String old = seen.put(name, value = sr.getAttributeValue(i));
            if (old != null) {
                TestAttrTypes.fail((String)("Duplicate attribute '" + name + "': previous value: '" + value + "'"));
            }
            String type = sr.getAttributeType(i);
            if (name.equals("attrCData")) {
                TestAttrTypes.assertEquals((String)"CDATA", (String)type);
                continue;
            }
            if (name.equals("attrId")) {
                TestAttrTypes.assertEquals((String)"ID", (String)type);
                continue;
            }
            if (name.equals("attrIdref")) {
                TestAttrTypes.assertEquals((String)"IDREF", (String)type);
                continue;
            }
            if (name.equals("attrIdrefs")) {
                TestAttrTypes.assertEquals((String)"IDREFS", (String)type);
                continue;
            }
            if (name.equals("attrEnum")) {
                TestAttrTypes.assertEquals((String)"ENUMERATED", (String)type);
                continue;
            }
            if (name.equals("attrName")) {
                TestAttrTypes.assertEquals((String)"NMTOKEN", (String)type);
                continue;
            }
            if (name.equals("attrNames")) {
                TestAttrTypes.assertEquals((String)"NMTOKENS", (String)type);
                continue;
            }
            TestAttrTypes.fail((String)("Unexpected attribute '" + name + "'"));
        }
    }

    private XMLStreamReader getReader(String contents) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestAttrTypes.setCoalescing(f, false);
        TestAttrTypes.setSupportDTD(f, true);
        TestAttrTypes.setValidating(f, true);
        return TestAttrTypes.constructStreamReader(f, contents);
    }
}

