/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestProcInstrRead
extends BaseStreamTest {
    public TestProcInstrRead(String name) {
        super(name);
    }

    public void testProcInstrProperties() throws XMLStreamException {
        this.doTestProperties(true, true);
        this.doTestProperties(true, false);
        this.doTestProperties(false, true);
        this.doTestProperties(false, false);
    }

    public void testSpaceHandling() throws XMLStreamException {
        String CONTENT_TEXT = "some   data ";
        String CONTENT = "   " + CONTENT_TEXT;
        String XML = "<?target   " + CONTENT + "?><root />";
        for (int i = 0; i < 3; ++i) {
            boolean ns = (i & 1) != 0;
            boolean dtd = (i & 2) != 0;
            XMLStreamReader sr = this.getReader(XML, ns, dtd);
            TestProcInstrRead.assertTokenType(3, sr.next());
            TestProcInstrRead.assertEquals((String)"target", (String)sr.getPITarget());
            String content = sr.getPIData();
            TestProcInstrRead.assertNotNull((Object)content);
            if (content.equals(CONTENT_TEXT)) continue;
            if (CONTENT_TEXT.trim().equals(content.trim())) {
                TestProcInstrRead.fail((String)("Proc. instr. white space handling not correct: expected data '" + CONTENT_TEXT + "', got '" + content + "'"));
            }
            TestProcInstrRead.fail((String)("Processing instruction data incorrect: expected '" + CONTENT_TEXT + "', got '" + content + "'"));
        }
    }

    public void testInvalidProcInstr() throws XMLStreamException {
        String XML = "<?xMl Can not use that target!  ?><root />";
        String XML2 = "<?   ?>   <root />";
        String XML3 = "<root><?target data   ></root>";
        for (int i = 0; i < 3; ++i) {
            boolean ns = (i & 1) != 0;
            boolean dtd = (i & 2) != 0;
            this.streamThroughFailing(this.getReader(XML, ns, dtd), "invalid processing instruction target ('xml' [case-insensitive] not legal) [ns: " + ns + ", dtd: " + dtd + "]");
            this.streamThroughFailing(this.getReader(XML2, ns, dtd), "invalid processing instruction; empty proc. instr (missing target)");
            this.streamThroughFailing(this.getReader(XML3, ns, dtd), "invalid processing instruction; ends with '?', not \"?>\"");
        }
    }

    public void testUnfinishedPI() throws XMLStreamException {
        String XML = "<root><!? target data     </root>";
        for (int i = 0; i < 3; ++i) {
            boolean ns = (i & 1) != 0;
            this.streamThroughFailing(this.getReader(XML, ns, true), "invalid proc. instr. (unfinished)");
        }
    }

    public void testRunawayProcInstr() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ENTITY pi '<?target d'>\n]><root>&pi;?></root>";
        XMLStreamReader sr = this.getReader(XML, true, true);
        try {
            TestProcInstrRead.assertTokenType(11, sr.next());
            TestProcInstrRead.assertTokenType(1, sr.next());
            int type = sr.next();
            if (type != 3) {
                this.reportNADueToEntityExpansion("testRunawayProcInstr", type);
                return;
            }
            type = sr.next();
            TestProcInstrRead.fail((String)("Expected an exception for split/runaway processing instruction (instead got event " + TestProcInstrRead.tokenTypeDesc(type) + ")"));
        }
        catch (XMLStreamException sex) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testLongerProcInstr() throws XMLStreamException {
        int type;
        String XML = "<?xml version='1.0'?>\n\n<!-- Richard Tobin's XML 1.0 2nd edition errata test suite. \n     Copyright Richard Tobin, HCRC July 2003.\n     May be freely redistributed provided copyright notice is retained.\n  -->\n\n<?xml-stylesheet href='xmlconformance.xsl' type='text/xsl'?>\n\n<!DOCTYPE TESTSUITE [\n    <!ENTITY eduni-errata2e SYSTEM 'errata2e.xml'>\n]>\n\n<TESTSUITE PROFILE=\"Richard Tobin's XML 1.0 2nd edition errata test suite 21 Jul 2003\">\n    &eduni-errata2e;\n</TESTSUITE>\n";
        XMLStreamReader sr = this.getReader(XML, true, true);
        while ((type = sr.next()) == 6) {
        }
        TestProcInstrRead.assertTokenType(5, type);
        while ((type = sr.next()) == 6) {
        }
        TestProcInstrRead.assertTokenType(3, type);
        TestProcInstrRead.assertEquals((String)"xml-stylesheet", (String)sr.getPITarget());
        while ((type = sr.next()) == 6) {
        }
        TestProcInstrRead.assertTokenType(11, type);
        while ((type = sr.next()) == 6) {
        }
        TestProcInstrRead.assertTokenType(1, type);
    }

    private void doTestProperties(boolean ns, boolean dtd) throws XMLStreamException {
        String DATA = "data & more data (???) <>";
        XMLStreamReader sr = this.getReader("<?target data & more data (???) <> ?><root />", ns, dtd);
        TestProcInstrRead.assertEquals((int)3, (int)sr.next());
        TestProcInstrRead.assertEquals((boolean)false, (boolean)sr.isStartElement());
        TestProcInstrRead.assertEquals((boolean)false, (boolean)sr.isEndElement());
        TestProcInstrRead.assertEquals((boolean)false, (boolean)sr.isCharacters());
        TestProcInstrRead.assertEquals((boolean)false, (boolean)sr.isWhiteSpace());
        TestProcInstrRead.assertFalse((String)"Processing instructions have no names; XMLStreamReader.hasName() should return false", (boolean)sr.hasName());
        TestProcInstrRead.assertEquals((boolean)false, (boolean)sr.hasText());
        TestProcInstrRead.assertNotNull((Object)sr.getLocation());
        if (ns) {
            TestProcInstrRead.assertNotNull((Object)sr.getNamespaceContext());
        }
        for (int i = 0; i < 10; ++i) {
            String method = "";
            try {
                Object result = null;
                switch (i) {
                    case 0: {
                        method = "getName";
                        result = sr.getName();
                        break;
                    }
                    case 1: {
                        method = "getPrefix";
                        result = sr.getPrefix();
                        break;
                    }
                    case 2: {
                        method = "getLocalName";
                        result = sr.getLocalName();
                        break;
                    }
                    case 3: {
                        method = "getNamespaceURI";
                        result = sr.getNamespaceURI();
                        break;
                    }
                    case 4: {
                        method = "getNamespaceCount";
                        result = new Integer(sr.getNamespaceCount());
                        break;
                    }
                    case 5: {
                        method = "getAttributeCount";
                        result = new Integer(sr.getAttributeCount());
                        break;
                    }
                    case 6: {
                        method = "getText";
                        result = sr.getText();
                        break;
                    }
                    case 7: {
                        method = "getTextCharacters";
                        result = sr.getTextCharacters();
                        break;
                    }
                    case 8: {
                        method = "getTextStart";
                        result = new Integer(sr.getTextStart());
                        break;
                    }
                    case 9: {
                        method = "getTextLength";
                        result = new Integer(sr.getTextLength());
                    }
                }
                TestProcInstrRead.fail((String)("Expected IllegalStateException, when calling " + method + "() for PROCESSING_INSTRUCTION"));
                continue;
            }
            catch (IllegalStateException iae) {
                // empty catch block
            }
        }
        TestProcInstrRead.assertEquals((String)"target", (String)sr.getPITarget());
        TestProcInstrRead.assertEquals((String)"data & more data (???) <>".trim(), (String)sr.getPIData().trim());
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, boolean supportDTD) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestProcInstrRead.setCoalescing(f, false);
        TestProcInstrRead.setNamespaceAware(f, nsAware);
        TestProcInstrRead.setSupportDTD(f, supportDTD);
        TestProcInstrRead.setValidating(f, false);
        return TestProcInstrRead.constructStreamReader(f, contents);
    }
}

