/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestElements
extends BaseStreamTest {
    public TestElements(String name) {
        super(name);
    }

    public void testNsProperties() throws XMLStreamException {
        this.testProperties(true, "testNsProperties");
    }

    public void testNonNsProperties() throws XMLStreamException {
        this.testProperties(false, "testNonNsProperties");
    }

    public void testValidNsElems() throws XMLStreamException {
        this.testValid(true, "testValidNsElems");
    }

    public void testValidNonNsElems() throws XMLStreamException {
        this.testValid(false, "testValidNonNsElems");
    }

    public void testInvalidNsElems() throws XMLStreamException {
        this.testInvalid(true, "testInvalidNsElems");
    }

    public void testInvalidNonNsElems() throws XMLStreamException {
        this.testInvalid(false, "testInvalidNonNsElems");
    }

    public void testEmptyDocument() throws XMLStreamException {
        String EMPTY_XML = "   ";
        this.streamThroughFailing(this.getElemReader(EMPTY_XML, true), "empty document (not valid, missing root element)");
        XMLStreamReader sr = this.getElemReader(EMPTY_XML, false);
        if (sr != null) {
            this.streamThroughFailing(sr, "empty document (not valid, missing root element)");
        }
    }

    public void testNoRootDocument() throws XMLStreamException {
        String NOROOT_XML = "<?xml version='1.0' ?>\n   <!-- comment...-->   <?target !?>";
        this.streamThroughFailing(this.getElemReader(NOROOT_XML, true), "document without root element");
        XMLStreamReader sr = this.getElemReader(NOROOT_XML, false);
        if (sr != null) {
            this.streamThroughFailing(sr, "document without root element");
        }
    }

    public void testInvalidEmptyElem() throws XMLStreamException {
        String XML = "<root>   <elem / ></root>";
        String MSG = "malformed empty element (space between '/' and '>')";
        this.streamThroughFailing(this.getElemReader(XML, true), MSG);
        XMLStreamReader sr = this.getElemReader(XML, false);
        if (sr != null) {
            this.streamThroughFailing(sr, MSG);
        }
    }

    private void testProperties(boolean nsAware, String method) throws XMLStreamException {
        XMLStreamReader sr = this.getElemReader("<root />", nsAware);
        if (sr == null) {
            this.reportNADueToNS(method);
            return;
        }
        TestElements.assertEquals((int)1, (int)sr.next());
        this.testStartOrEnd(nsAware, sr, true);
        TestElements.assertEquals((int)2, (int)sr.next());
        this.testStartOrEnd(nsAware, sr, false);
    }

    private void testStartOrEnd(boolean nsAware, XMLStreamReader sr, boolean isStart) throws XMLStreamException {
        int evtType = isStart ? 1 : 2;
        TestElements.assertEquals((int)evtType, (int)sr.getEventType());
        String eventStr = TestElements.tokenTypeDesc(evtType);
        TestElements.assertEquals((boolean)isStart, (boolean)sr.isStartElement());
        TestElements.assertEquals((!isStart ? 1 : 0) != 0, (boolean)sr.isEndElement());
        TestElements.assertEquals((boolean)false, (boolean)sr.isCharacters());
        TestElements.assertEquals((boolean)false, (boolean)sr.isWhiteSpace());
        TestElements.assertEquals((boolean)true, (boolean)sr.hasName());
        TestElements.assertEquals((boolean)false, (boolean)sr.hasText());
        TestElements.assertNotNull((Object)sr.getLocation());
        QName n = sr.getName();
        TestElements.assertNotNull((Object)n);
        TestElements.assertEquals((String)"root", (String)n.getLocalPart());
        String prefix = n.getPrefix();
        TestElements.assertTrue((prefix == null || prefix.length() == 0 ? 1 : 0) != 0);
        String uri = n.getNamespaceURI();
        TestElements.assertTrue((uri == null || uri.length() == 0 ? 1 : 0) != 0);
        if (isStart) {
            TestElements.assertEquals((int)0, (int)sr.getAttributeCount());
        } else {
            try {
                int count = sr.getAttributeCount();
                TestElements.fail((String)("Expected an IllegalStateException when trying to call getAttributeCount() for " + eventStr));
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        TestElements.assertEquals((int)0, (int)sr.getNamespaceCount());
        if (nsAware) {
            TestElements.assertNotNull((Object)sr.getNamespaceContext());
        }
        for (int i = 0; i < 4; ++i) {
            String method = "";
            try {
                Object result = null;
                switch (i) {
                    case 0: {
                        method = "getText";
                        result = sr.getText();
                        break;
                    }
                    case 1: {
                        method = "getTextCharacters";
                        result = sr.getTextCharacters();
                        break;
                    }
                    case 2: {
                        method = "getPITarget";
                        result = sr.getPITarget();
                        break;
                    }
                    case 3: {
                        method = "getPIData";
                        result = sr.getPIData();
                    }
                }
                TestElements.fail((String)("Expected IllegalStateException, when calling " + method + "() for " + eventStr));
                continue;
            }
            catch (IllegalStateException iae) {
                // empty catch block
            }
        }
    }

    private void testValid(boolean nsAware, String method) throws XMLStreamException {
        String NS_URL1 = "http://www.stax.org";
        String NS_PREFIX1 = "prefix1";
        String NS_URL2 = "urn://mydummyid";
        String NS_PREFIX2 = "prefix2";
        String VALID_CONTENT = "<root><prefix1:elem xmlns:prefix1='http://www.stax.org' prefix1:attr='value'>Text</prefix1:elem><elem2 xmlns='urn://mydummyid' attr='value' /></root>";
        XMLStreamReader sr = this.getElemReader("<root><prefix1:elem xmlns:prefix1='http://www.stax.org' prefix1:attr='value'>Text</prefix1:elem><elem2 xmlns='urn://mydummyid' attr='value' /></root>", nsAware);
        if (sr == null) {
            this.reportNADueToNS(method);
            return;
        }
        this.streamThrough(sr);
        sr = this.getElemReader("<root><prefix1:elem xmlns:prefix1='http://www.stax.org' prefix1:attr='value'>Text</prefix1:elem><elem2 xmlns='urn://mydummyid' attr='value' /></root>", nsAware);
        TestElements.assertTokenType(1, sr.next());
        TestElements.assertEquals((String)"root", (String)sr.getLocalName());
        String prefix = sr.getPrefix();
        TestElements.assertNull((String)"Missing prefix should be reported as null", (Object)prefix);
        String nsURI = sr.getNamespaceURI();
        if (nsAware) {
            TestElements.assertNull((String)"Default (non-defined) namespace should be reported as empty String", (Object)nsURI);
        } else {
            TestElements.assertNull((String)"Default (non-defined) namespace should be reported as NULL in non-NS mode", (Object)nsURI);
        }
        QName name = sr.getName();
        TestElements.assertNotNull((String)"Shouldn't get null QName for any start element", (Object)name);
        TestElements.assertEquals((Object)name, (Object)new QName("root"));
        TestElements.assertNull((Object)sr.getNamespaceURI());
        TestElements.assertEquals((int)0, (int)sr.getAttributeCount());
        TestElements.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestElements.assertEquals((int)1, (int)sr.next());
        if (nsAware) {
            TestElements.assertEquals((String)"elem", (String)sr.getLocalName());
            TestElements.assertEquals((String)"prefix1", (String)sr.getPrefix());
            TestElements.assertEquals((String)"http://www.stax.org", (String)sr.getNamespaceURI());
        } else {
            TestElements.assertEquals((String)"prefix1:elem", (String)sr.getLocalName());
            TestElements.assertEquals(null, (String)sr.getPrefix());
            TestElements.assertNull((Object)sr.getNamespaceURI());
        }
        int expNs = nsAware ? 1 : 0;
        int expAttr = nsAware ? 1 : 2;
        TestElements.assertEquals((int)expAttr, (int)sr.getAttributeCount());
        TestElements.assertEquals((int)expNs, (int)sr.getNamespaceCount());
        TestElements.assertEquals((int)4, (int)sr.next());
        TestElements.assertEquals((String)"Text", (String)TestElements.getAndVerifyText(sr));
        TestElements.assertEquals((int)2, (int)sr.next());
        if (nsAware) {
            TestElements.assertEquals((String)"elem", (String)sr.getLocalName());
            TestElements.assertEquals((String)"prefix1", (String)sr.getPrefix());
            TestElements.assertEquals((String)"http://www.stax.org", (String)sr.getNamespaceURI());
        } else {
            TestElements.assertEquals((String)"prefix1:elem", (String)sr.getLocalName());
            TestElements.assertNull((Object)sr.getPrefix());
            TestElements.assertNull((Object)sr.getNamespaceURI());
        }
        TestElements.assertEquals((int)expNs, (int)sr.getNamespaceCount());
        TestElements.assertEquals((int)1, (int)sr.next());
        TestElements.assertEquals((String)"elem2", (String)sr.getLocalName());
        TestElements.assertEquals(null, (String)sr.getPrefix());
        if (nsAware) {
            TestElements.assertEquals((String)"urn://mydummyid", (String)sr.getNamespaceURI());
        } else {
            TestElements.assertNull((Object)sr.getNamespaceURI());
        }
        TestElements.assertEquals((int)expAttr, (int)sr.getAttributeCount());
        TestElements.assertEquals((int)expNs, (int)sr.getNamespaceCount());
        TestElements.assertEquals((int)2, (int)sr.next());
        TestElements.assertEquals((String)"elem2", (String)sr.getLocalName());
        TestElements.assertEquals(null, (String)sr.getPrefix());
        if (nsAware) {
            TestElements.assertEquals((String)"urn://mydummyid", (String)sr.getNamespaceURI());
        } else {
            TestElements.assertNull((Object)sr.getNamespaceURI());
        }
        TestElements.assertEquals((int)expNs, (int)sr.getNamespaceCount());
        TestElements.assertEquals((int)2, (int)sr.next());
        TestElements.assertEquals((String)"root", (String)sr.getLocalName());
        TestElements.assertEquals(null, (String)sr.getPrefix());
        TestElements.assertNull((Object)sr.getNamespaceURI());
        TestElements.assertEquals((int)0, (int)sr.getNamespaceCount());
    }

    private void testInvalid(boolean nsAware, String method) throws XMLStreamException {
        String XML = "<root>  text </notroot>";
        XMLStreamReader sr = this.getElemReader(XML, nsAware);
        if (sr == null) {
            this.reportNADueToNS(method);
            return;
        }
        this.streamThroughFailing(sr, "incorrect nesting (wrong end element name)");
        if (nsAware) {
            XML = "<a:root xmlns:a='myurl' xmlns:b='myurl'>  text </b:root>";
            sr = this.getElemReader(XML, nsAware);
            this.streamThroughFailing(sr, "incorrect nesting (namespace prefix in close element not the same as in start element)");
        }
        XML = "<root><branch>  text </branch>";
        this.streamThroughFailing(this.getElemReader(XML, nsAware), "incorrect nesting (missing end element)");
        XML = "<root /><anotherRoot />";
        this.streamThroughFailing(this.getElemReader(XML, nsAware), "more than one root element");
    }

    private XMLStreamReader getElemReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        if (!TestElements.setNamespaceAware(f, nsAware)) {
            return null;
        }
        TestElements.setCoalescing(f, true);
        TestElements.setValidating(f, false);
        return TestElements.constructStreamReader(f, contents);
    }
}

