/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.BaseStaxTest;

public class BaseStreamTest
extends BaseStaxTest {
    protected static boolean DEF_PRINT_EXP_EXCEPTION = false;
    protected boolean PRINT_EXP_EXCEPTION = DEF_PRINT_EXP_EXCEPTION;

    protected BaseStreamTest() {
    }

    protected BaseStreamTest(String name) {
        super(name);
    }

    protected int streamThrough(XMLStreamReader sr) throws XMLStreamException {
        int result = 0;
        BaseStreamTest.assertNotNull((Object)sr);
        while (sr.hasNext()) {
            int type = sr.next();
            result += type;
            if (sr.hasText()) {
                result += BaseStreamTest.getAndVerifyText(sr).hashCode();
            }
            if (!sr.hasName()) continue;
            QName n = sr.getName();
            BaseStreamTest.assertNotNull((Object)n);
            result += n.hashCode();
        }
        return result;
    }

    protected int streamThroughFailing(XMLInputFactory f, String contents, String msg) {
        int result = 0;
        try {
            XMLStreamReader sr = BaseStreamTest.constructStreamReader(f, contents);
            result = this.streamThrough(sr);
        }
        catch (XMLStreamException ex) {
            if (this.PRINT_EXP_EXCEPTION) {
                System.out.println("Expected failure: '" + ex.getMessage() + "' " + "(matching message: '" + msg + "')");
            }
            return 0;
        }
        catch (Exception ex2) {
            if (ex2.getCause() instanceof XMLStreamException) {
                if (this.PRINT_EXP_EXCEPTION) {
                    System.out.println("Expected failure: '" + ex2.getMessage() + "' " + "(matching message: '" + msg + "')");
                }
                return 0;
            }
            BaseStreamTest.fail((String)("Expected an XMLStreamException (either direct, or getCause() of a primary exception) for " + msg + ", got: " + ex2));
        }
        BaseStreamTest.fail((String)("Expected an exception for " + msg));
        return result;
    }

    protected int streamThroughFailing(XMLStreamReader sr, String msg) {
        int result = 0;
        try {
            result = this.streamThrough(sr);
        }
        catch (XMLStreamException ex) {
            if (this.PRINT_EXP_EXCEPTION) {
                System.out.println("Expected failure: '" + ex.getMessage() + "' " + "(matching message: '" + msg + "')");
            }
            return 0;
        }
        catch (Exception ex2) {
            if (ex2.getCause() instanceof XMLStreamException) {
                if (this.PRINT_EXP_EXCEPTION) {
                    System.out.println("Expected failure: '" + ex2.getMessage() + "' " + "(matching message: '" + msg + "')");
                }
                return 0;
            }
            BaseStreamTest.fail((String)("Expected an XMLStreamException (either direct, or getCause() of a primary exception) for " + msg + ", got: " + ex2));
        }
        BaseStreamTest.fail((String)("Expected an exception for " + msg));
        return result;
    }
}

