/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestStartElem
extends BaseEventTest {
    static final String[] ATTR11_NAMES = new String[]{"method", "activeShell", "source", "data", "widget", "length", "start", "styledTextNewValue", "replacedText", "styledTextFunction", "raw"};
    static final String[] ATTR11_VALUES = new String[]{"a", "x", "y", "z", "a", "1", "2", "t", "", "f", "b"};

    public void testStartElemNs() throws XMLStreamException {
        String XML = "<root xmlns='http://my' xmlns:a='ns:attrs' attr1='value1' a:attr2='value2'/>";
        XMLEventReader er = this.getReader(XML, true, false);
        TestStartElem.assertTokenType(7, er.nextEvent().getEventType());
        XMLEvent evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        TestStartElem.assertTrue((boolean)evt.isStartElement());
        StartElement se = evt.asStartElement();
        this.testEventWritability(se);
        NamespaceContext nsCtxt = se.getNamespaceContext();
        TestStartElem.assertNotNull((String)"StartElement.getNamespaceContext() should never return null", (Object)nsCtxt);
        TestStartElem.assertNull((Object)nsCtxt.getPrefix("a"));
        TestStartElem.assertNull((Object)nsCtxt.getPrefix("http://foobar"));
        TestStartElem.assertNull((Object)nsCtxt.getNamespaceURI("b"));
        TestStartElem.assertNull((Object)nsCtxt.getNamespaceURI("http://my"));
        Iterator<Object> it = nsCtxt.getPrefixes("http://foobar");
        TestStartElem.assertTrue((it == null || !it.hasNext() ? 1 : 0) != 0);
        it = nsCtxt.getPrefixes("a");
        TestStartElem.assertTrue((it == null || !it.hasNext() ? 1 : 0) != 0);
        TestStartElem.assertEquals((String)"a", (String)nsCtxt.getPrefix("ns:attrs"));
        TestStartElem.assertEquals((String)"", (String)nsCtxt.getPrefix("http://my"));
        TestStartElem.assertEquals((String)"http://my", (String)nsCtxt.getNamespaceURI(""));
        TestStartElem.assertEquals((String)"ns:attrs", (String)nsCtxt.getNamespaceURI("a"));
        it = se.getNamespaces();
        TestStartElem.assertEquals((int)2, (int)this.countElements(it));
        TestStartElem.assertTokenType(2, er.nextEvent().getEventType());
        TestStartElem.assertTokenType(8, er.nextEvent().getEventType());
        TestStartElem.assertFalse((boolean)er.hasNext());
    }

    public void testNestedStartElemNs() throws XMLStreamException {
        String XML = "<root><leaf xmlns='x' /><branch xmlns:a='b' xmlns:x='url'><leaf xmlns:a='c' x:attr='value'/></branch></root>";
        XMLEventReader er = this.getReader(XML, true, false);
        TestStartElem.assertTokenType(7, er.nextEvent().getEventType());
        XMLEvent evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        StartElement se = evt.asStartElement();
        this.testEventWritability(se);
        TestStartElem.assertEquals((int)0, (int)this.countElements(se.getNamespaces()));
        NamespaceContext nsCtxt = se.getNamespaceContext();
        TestStartElem.assertNotNull((String)"StartElement.getNamespaceContext() should never return null", (Object)nsCtxt);
        TestStartElem.assertNull((Object)nsCtxt.getPrefix("a"));
        TestStartElem.assertNull((Object)nsCtxt.getNamespaceURI("b"));
        evt = er.nextEvent();
        TestStartElem.assertTrue((boolean)evt.isStartElement());
        se = evt.asStartElement();
        TestStartElem.assertEquals((String)"leaf", (String)se.getName().getLocalPart());
        TestStartElem.assertEquals((int)1, (int)this.countElements(se.getNamespaces()));
        TestStartElem.assertEquals((String)"x", (String)se.getName().getNamespaceURI());
        nsCtxt = se.getNamespaceContext();
        TestStartElem.assertEquals((String)"x", (String)nsCtxt.getNamespaceURI(""));
        TestStartElem.assertEquals((String)"", (String)nsCtxt.getPrefix("x"));
        this.testEventWritability(se);
        evt = er.nextEvent();
        TestStartElem.assertTrue((boolean)evt.isEndElement());
        this.testEventWritability(evt);
        evt = er.nextEvent();
        TestStartElem.assertTrue((boolean)evt.isStartElement());
        se = evt.asStartElement();
        TestStartElem.assertEquals((String)"branch", (String)se.getName().getLocalPart());
        TestStartElem.assertEquals((int)2, (int)this.countElements(se.getNamespaces()));
        nsCtxt = se.getNamespaceContext();
        TestStartElem.assertEquals((String)"a", (String)nsCtxt.getPrefix("b"));
        TestStartElem.assertEquals((String)"b", (String)nsCtxt.getNamespaceURI("a"));
        TestStartElem.assertEquals((String)"x", (String)nsCtxt.getPrefix("url"));
        TestStartElem.assertEquals((String)"url", (String)nsCtxt.getNamespaceURI("x"));
        this.testEventWritability(se);
        evt = er.nextEvent();
        TestStartElem.assertTrue((boolean)evt.isStartElement());
        se = evt.asStartElement();
        nsCtxt = se.getNamespaceContext();
        TestStartElem.assertEquals((String)"leaf", (String)se.getName().getLocalPart());
        TestStartElem.assertEquals((int)1, (int)this.countElements(se.getNamespaces()));
        nsCtxt = se.getNamespaceContext();
        TestStartElem.assertEquals((String)"a", (String)nsCtxt.getPrefix("c"));
        TestStartElem.assertEquals((String)"c", (String)nsCtxt.getNamespaceURI("a"));
        TestStartElem.assertEquals((String)"x", (String)nsCtxt.getPrefix("url"));
        TestStartElem.assertEquals((String)"url", (String)nsCtxt.getNamespaceURI("x"));
        TestStartElem.assertNull((Object)nsCtxt.getPrefix("b"));
        TestStartElem.assertTrue((boolean)er.nextEvent().isEndElement());
    }

    public void testNestedStartElemNs2() throws XMLStreamException {
        String XML = "<root><branch xmlns:a='url'><leaf /></branch></root>";
        XMLEventReader er = this.getReader(XML, true, false);
        TestStartElem.assertTokenType(7, er.nextEvent().getEventType());
        XMLEvent evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        StartElement se = evt.asStartElement();
        TestStartElem.assertEquals((String)"root", (String)se.getName().getLocalPart());
        TestStartElem.assertEquals((int)0, (int)this.countElements(se.getNamespaces()));
        evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        se = evt.asStartElement();
        TestStartElem.assertEquals((String)"branch", (String)se.getName().getLocalPart());
        TestStartElem.assertEquals((int)1, (int)this.countElements(se.getNamespaces()));
        NamespaceContext nsCtxt = se.getNamespaceContext();
        TestStartElem.assertNotNull((String)"StartElement.getNamespaceContext() should never return null", (Object)nsCtxt);
        TestStartElem.assertEquals((String)"url", (String)nsCtxt.getNamespaceURI("a"));
        TestStartElem.assertEquals((String)"a", (String)nsCtxt.getPrefix("url"));
        evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        se = evt.asStartElement();
        TestStartElem.assertEquals((String)"leaf", (String)se.getName().getLocalPart());
        TestStartElem.assertEquals((int)0, (int)this.countElements(se.getNamespaces()));
        nsCtxt = se.getNamespaceContext();
        TestStartElem.assertEquals((String)"url", (String)nsCtxt.getNamespaceURI("a"));
        TestStartElem.assertEquals((String)"a", (String)nsCtxt.getPrefix("url"));
        TestStartElem.assertTrue((boolean)er.nextEvent().isEndElement());
        TestStartElem.assertTrue((boolean)er.nextEvent().isEndElement());
        TestStartElem.assertTrue((boolean)er.nextEvent().isEndElement());
    }

    public void testStartElemAttrs() throws XMLStreamException {
        String XML = "<root xmlns:a='ns:attrs' attr1='value1' a:attr2='value2'><leaf xmlns='url:ns2' attr='x' /></root>";
        XMLEventReader er = this.getReader(XML, true, false);
        TestStartElem.assertTokenType(7, er.nextEvent().getEventType());
        XMLEvent evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        StartElement se = evt.asStartElement();
        this.assertAttr(se, "", "attr1", "value1");
        this.assertNqAttr(se, "attr1", "value1");
        this.assertAttr(se, "ns:attrs", "attr2", "value2");
        this.assertAttr(se, "", "attr2", null);
        this.assertNqAttr(se, "attr2", null);
        this.assertAttr(se, "ns:attrs", "attr1", null);
        evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        se = evt.asStartElement();
        this.assertAttr(se, "", "attr", "x");
        this.assertNqAttr(se, "attr", "x");
        this.assertAttr(se, "url:ns2", "attr", null);
        this.assertAttr(se, "url:ns2", "x", null);
        this.assertAttr(se, "ns:foo", "foobar", null);
        this.assertAttr(se, "", "attr1", null);
        this.assertNqAttr(se, "attr1", null);
        TestStartElem.assertTokenType(2, er.nextEvent().getEventType());
        TestStartElem.assertTokenType(2, er.nextEvent().getEventType());
        TestStartElem.assertTokenType(8, er.nextEvent().getEventType());
    }

    public void testStartElemManyAttrsNs() throws XMLStreamException {
        XMLEventReader er = this.getReader(this.get11AttrDoc(), true, false);
        TestStartElem.assertTokenType(7, er.nextEvent().getEventType());
        XMLEvent evt = er.nextEvent();
        TestStartElem.assertTokenType(1, evt.getEventType());
        StartElement se = evt.asStartElement();
        TestStartElem.assertEquals((int)11, (int)this.countElements(se.getAttributes()));
        int i = ATTR11_NAMES.length;
        while (--i >= 0) {
            String name = ATTR11_NAMES[i];
            String value = ATTR11_VALUES[i];
            this.assertAttr11Value(se, name, value);
            this.assertAttr11Value(se, "" + name, value);
            String start = name.substring(0, 1);
            this.assertAttr11Value(se, name + start, null);
            this.assertAttr11Value(se, start + name, null);
        }
        TestStartElem.assertTokenType(2, er.nextEvent().getEventType());
        er.close();
    }

    private void assertAttr11Value(StartElement elem, String localName, String expValue) {
        String actValue;
        String msg = "Wrong value for attribute '" + localName + "'; ";
        Attribute attr = elem.getAttributeByName(new QName(localName));
        String string = actValue = attr == null ? null : attr.getValue();
        if (expValue == null) {
            TestStartElem.assertNull((String)msg, (Object)actValue);
        } else {
            TestStartElem.assertEquals((String)msg, (String)expValue, (String)actValue);
        }
        attr = elem.getAttributeByName(new QName("", localName));
        String string2 = actValue = attr == null ? null : attr.getValue();
        if (expValue == null) {
            TestStartElem.assertNull((String)msg, (Object)actValue);
        } else {
            TestStartElem.assertEquals((String)msg, (String)expValue, (String)actValue);
        }
        attr = elem.getAttributeByName(new QName("", localName, ""));
        String string3 = actValue = attr == null ? null : attr.getValue();
        if (expValue == null) {
            TestStartElem.assertNull((String)msg, (Object)actValue);
        } else {
            TestStartElem.assertEquals((String)msg, (String)expValue, (String)actValue);
        }
    }

    private String get11AttrDoc() {
        StringBuffer sb = new StringBuffer();
        sb.append("<root");
        for (int i = 0; i < ATTR11_NAMES.length; ++i) {
            sb.append(' ');
            sb.append(ATTR11_NAMES[i]);
            sb.append('=');
            sb.append((i & 1) == 0 ? (char)'\"' : '\'');
            sb.append(ATTR11_VALUES[i]);
            sb.append((i & 1) == 0 ? (char)'\"' : '\'');
        }
        sb.append(" />");
        return sb.toString();
    }

    private int countElements(Iterator it) {
        int count = 0;
        if (it != null) {
            while (it.hasNext()) {
                ++count;
                it.next();
            }
        }
        return count;
    }

    private void assertAttr(StartElement se, String nsURI, String localName, String expValue) {
        QName qn = new QName(nsURI, localName);
        Attribute attr = se.getAttributeByName(qn);
        if (expValue == null) {
            TestStartElem.assertNull((String)("Should not find attribute '" + qn + "'"), (Object)attr);
        } else {
            TestStartElem.assertNotNull((String)("Should find attribute '" + qn + "' but got null"), (Object)attr);
            TestStartElem.assertEquals((String)("Attribute '" + qn + "' has unexpected value"), (String)expValue, (String)attr.getValue());
        }
    }

    private void assertNqAttr(StartElement se, String localName, String expValue) {
        QName qn = new QName(localName);
        Attribute attr = se.getAttributeByName(qn);
        if (expValue == null) {
            TestStartElem.assertNull((String)("Should not find attribute '" + qn + "'"), (Object)attr);
        } else {
            TestStartElem.assertNotNull((String)("Should find attribute '" + qn + "' but got null"), (Object)attr);
            TestStartElem.assertEquals((String)("Attribute '" + qn + "' has unexpected value"), (String)expValue, (String)attr.getValue());
        }
        qn = new QName("", localName);
        attr = se.getAttributeByName(qn);
        if (expValue == null) {
            TestStartElem.assertNull((String)("Should not find attribute '" + qn + "'"), (Object)attr);
        } else {
            TestStartElem.assertNotNull((String)("Should find attribute '" + qn + "' but got null"), (Object)attr);
            TestStartElem.assertEquals((String)("Attribute '" + qn + "' has unexpected value"), (String)expValue, (String)attr.getValue());
        }
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestStartElem.setNamespaceAware(f, nsAware);
        TestStartElem.setCoalescing(f, coalesce);
        TestStartElem.setSupportDTD(f, true);
        TestStartElem.setValidating(f, false);
        return TestStartElem.constructEventReader(f, contents);
    }
}

