/*
 * Direct3D wine OpenGL include file
 *
 * Copyright 2002-2003 The wine-d3d team
 * Copyright 2002-2004 Jason Edmeades
 *                     Raphael Junqueira
 * Copyright 2007 Roderick Colenbrander
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WINE_WINED3D_GL_H
#define __WINE_WINED3D_GL_H

#include "wine/wgl.h"

#define GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI 0x8837  /* not in the gl spec */

/* GLES-only defines
 * FIXME: Those should be automatically included in wgl.h by make_opengl. */
#define GL_HALF_FLOAT_OES 0x8D61
#define GL_SLUMINANCE_NV  0x8C46
#define GL_SLUMINANCE_ALPHA_NV 0x8C44

void (WINE_GLAPI *glDisableWINE)(GLenum cap) DECLSPEC_HIDDEN;
void (WINE_GLAPI *glEnableWINE)(GLenum cap) DECLSPEC_HIDDEN;

/* OpenGL extensions. */
enum wined3d_gl_extension
{
    WINED3D_GL_EXT_NONE,

    /* ANGLE */
    ANGLE_TEXTURE_COMPRESSION_DXT3,
    ANGLE_TEXTURE_COMPRESSION_DXT5,
    /* APPLE */
    APPLE_FENCE,
    APPLE_FLOAT_PIXELS,
    APPLE_FLUSH_BUFFER_RANGE,
    APPLE_YCBCR_422,
    /* ARB */
    ARB_BASE_INSTANCE,
    ARB_BLEND_FUNC_EXTENDED,
    ARB_BUFFER_STORAGE,
    ARB_CLEAR_BUFFER_OBJECT,
    ARB_CLEAR_TEXTURE,
    ARB_CLIP_CONTROL,
    ARB_COLOR_BUFFER_FLOAT,
    ARB_COMPUTE_SHADER,
    ARB_CONSERVATIVE_DEPTH,
    ARB_COPY_BUFFER,
    ARB_COPY_IMAGE,
    ARB_CULL_DISTANCE,
    ARB_DEBUG_OUTPUT,
    ARB_DEPTH_BUFFER_FLOAT,
    ARB_DEPTH_CLAMP,
    ARB_DEPTH_TEXTURE,
    ARB_DERIVATIVE_CONTROL,
    ARB_DRAW_BUFFERS,
    ARB_DRAW_ELEMENTS_BASE_VERTEX,
    ARB_DRAW_INDIRECT,
    ARB_DRAW_INSTANCED,
    ARB_ES2_COMPATIBILITY,
    ARB_ES3_COMPATIBILITY,
    ARB_EXPLICIT_ATTRIB_LOCATION,
    ARB_FRAGMENT_COORD_CONVENTIONS,
    ARB_FRAGMENT_LAYER_VIEWPORT,
    ARB_FRAGMENT_PROGRAM,
    ARB_FRAGMENT_SHADER,
    ARB_FRAMEBUFFER_NO_ATTACHMENTS,
    ARB_FRAMEBUFFER_OBJECT,
    ARB_FRAMEBUFFER_SRGB,
    ARB_GPU_SHADER5,
    ARB_HALF_FLOAT_PIXEL,
    ARB_HALF_FLOAT_VERTEX,
    ARB_INSTANCED_ARRAYS,
    ARB_INTERNALFORMAT_QUERY,
    ARB_INTERNALFORMAT_QUERY2,
    ARB_MAP_BUFFER_ALIGNMENT,
    ARB_MAP_BUFFER_RANGE,
    ARB_MULTISAMPLE,
    ARB_MULTITEXTURE,
    ARB_OCCLUSION_QUERY,
    ARB_PIPELINE_STATISTICS_QUERY,
    ARB_PIXEL_BUFFER_OBJECT,
    ARB_POINT_PARAMETERS,
    ARB_POINT_SPRITE,
    ARB_PROVOKING_VERTEX,
    ARB_QUERY_BUFFER_OBJECT,
    ARB_SAMPLE_SHADING,
    ARB_SAMPLER_OBJECTS,
    ARB_SEAMLESS_CUBE_MAP,
    ARB_SHADER_ATOMIC_COUNTERS,
    ARB_SHADER_BIT_ENCODING,
    ARB_SHADER_IMAGE_LOAD_STORE,
    ARB_SHADER_IMAGE_SIZE,
    ARB_SHADER_STORAGE_BUFFER_OBJECT,
    ARB_SHADER_TEXTURE_IMAGE_SAMPLES,
    ARB_SHADER_TEXTURE_LOD,
    ARB_SHADING_LANGUAGE_100,
    ARB_SHADING_LANGUAGE_420PACK,
    ARB_SHADING_LANGUAGE_PACKING,
    ARB_SHADOW,
    ARB_STENCIL_TEXTURING,
    ARB_SYNC,
    ARB_TESSELLATION_SHADER,
    ARB_TEXTURE_BORDER_CLAMP,
    ARB_TEXTURE_BUFFER_OBJECT,
    ARB_TEXTURE_BUFFER_RANGE,
    ARB_TEXTURE_COMPRESSION,
    ARB_TEXTURE_COMPRESSION_BPTC,
    ARB_TEXTURE_COMPRESSION_RGTC,
    ARB_TEXTURE_CUBE_MAP,
    ARB_TEXTURE_CUBE_MAP_ARRAY,
    ARB_TEXTURE_ENV_COMBINE,
    ARB_TEXTURE_ENV_DOT3,
    ARB_TEXTURE_FILTER_ANISOTROPIC,
    ARB_TEXTURE_FLOAT,
    ARB_TEXTURE_GATHER,
    ARB_TEXTURE_MIRRORED_REPEAT,
    ARB_TEXTURE_MIRROR_CLAMP_TO_EDGE,
    ARB_TEXTURE_MULTISAMPLE,
    ARB_TEXTURE_NON_POWER_OF_TWO,
    ARB_TEXTURE_QUERY_LEVELS,
    ARB_TEXTURE_RECTANGLE,
    ARB_TEXTURE_RG,
    ARB_TEXTURE_RGB10_A2UI,
    ARB_TEXTURE_STORAGE,
    ARB_TEXTURE_STORAGE_MULTISAMPLE,
    ARB_TEXTURE_SWIZZLE,
    ARB_TEXTURE_VIEW,
    ARB_TIMER_QUERY,
    ARB_TRANSFORM_FEEDBACK2,
    ARB_TRANSFORM_FEEDBACK3,
    ARB_UNIFORM_BUFFER_OBJECT,
    ARB_VERTEX_ARRAY_BGRA,
    ARB_VERTEX_BUFFER_OBJECT,
    ARB_VERTEX_PROGRAM,
    ARB_VERTEX_SHADER,
    ARB_VERTEX_TYPE_2_10_10_10_REV,
    ARB_VIEWPORT_ARRAY,
    /* ATI */
    ATI_FRAGMENT_SHADER,
    ATI_SEPARATE_STENCIL,
    ATI_TEXTURE_COMPRESSION_3DC,
    ATI_TEXTURE_ENV_COMBINE3,
    ATI_TEXTURE_MIRROR_ONCE,
    /* EXT */
    EXT_BLEND_COLOR,
    EXT_BLEND_EQUATION_SEPARATE,
    EXT_BLEND_FUNC_SEPARATE,
    EXT_BLEND_MINMAX,
    EXT_BLEND_SUBTRACT,
    EXT_DRAW_BUFFERS2,
    EXT_DEPTH_BOUNDS_TEST,
    EXT_FOG_COORD,
    EXT_FRAMEBUFFER_BLIT,
    EXT_FRAMEBUFFER_MULTISAMPLE,
    EXT_FRAMEBUFFER_OBJECT,
    EXT_GPU_PROGRAM_PARAMETERS,
    EXT_GPU_SHADER4,
    EXT_GPU_SHADER5,
    EXT_PACKED_DEPTH_STENCIL,
    EXT_PACKED_FLOAT,
    EXT_POINT_PARAMETERS,
    EXT_PROVOKING_VERTEX,
    EXT_SECONDARY_COLOR,
    EXT_STENCIL_TWO_SIDE,
    EXT_STENCIL_WRAP,
    EXT_TEXTURE3D,
    EXT_TEXTURE_ARRAY,
    EXT_TEXTURE_COMPRESSION_DXT1,
    EXT_TEXTURE_COMPRESSION_RGTC,
    EXT_TEXTURE_COMPRESSION_S3TC,
    EXT_TEXTURE_CUBE_MAP_ARRAY,
    EXT_TEXTURE_ENV_COMBINE,
    EXT_TEXTURE_ENV_DOT3,
    EXT_TEXTURE_INTEGER,
    EXT_TEXTURE_LOD_BIAS,
    EXT_TEXTURE_MIRROR_CLAMP,
    EXT_TEXTURE_SHARED_EXPONENT,
    EXT_TEXTURE_SNORM,
    EXT_TEXTURE_SRGB,
    EXT_TEXTURE_SRGB_DECODE,
    EXT_VERTEX_ARRAY_BGRA,
    /* OES */
    EXT_COLOR_BUFFER_FLOAT,
    EXT_COLOR_BUFFER_HALF_FLOAT,
    EXT_CONSERVATIVE_DEPTH,
    EXT_SHADER_TEXTURE_LOD,
    EXT_TEXTURE_TYPE_2_10_10_10_REV,
    OES_DEPTH24,
    OES_DEPTH_TEXTURE,
    OES_GPU_SHADER5,
    OES_SAMPLE_VARIABLES,
    OES_SHADER_IO_BLOCKS,
    OES_STANDARD_DERIVATIVES,
    OES_TEXTURE_CUBE_MAP_ARRAY,
    OES_TEXTURE_FLOAT,
    OES_TEXTURE_FLOAT_LINEAR,
    OES_TEXTURE_HALF_FLOAT,
    OES_TEXTURE_HALF_FLOAT_LINEAR,
    /* Khronos */
    KHR_DEBUG,
    /* NVIDIA */
    NV_FENCE,
    NV_FOG_DISTANCE,
    NV_FRAGMENT_PROGRAM,
    NV_FRAGMENT_PROGRAM2,
    NV_FRAGMENT_PROGRAM_OPTION,
    NV_HALF_FLOAT,
    NV_LIGHT_MAX_EXPONENT,
    NV_POINT_SPRITE,
    NV_REGISTER_COMBINERS,
    NV_REGISTER_COMBINERS2,
    NV_SRGB_FORMATS,
    NV_TEXGEN_REFLECTION,
    NV_TEXTURE_ENV_COMBINE4,
    NV_TEXTURE_SHADER,
    NV_TEXTURE_SHADER2,
    NV_VERTEX_PROGRAM,
    NV_VERTEX_PROGRAM1_1,
    NV_VERTEX_PROGRAM2,
    NV_VERTEX_PROGRAM2_OPTION,
    NV_VERTEX_PROGRAM3,
    /* WGL extensions */
    WGL_ARB_PIXEL_FORMAT,
    WGL_EXT_SWAP_CONTROL,
    WGL_WINE_PIXEL_FORMAT_PASSTHROUGH,
    WGL_WINE_QUERY_RENDERER,
    /* Internally used */
    WINED3D_GL_BLEND_EQUATION,
    WINED3D_GL_GEOMETRY_SHADER,
    WINED3D_GL_LEGACY_FORMATS,
    WINED3D_GL_LEGACY_COMPLEX,
    WINED3D_GL_CLIP_DISTANCE,
    WINED3D_GL_COMPLEX_FORMATS,
    WINED3D_GL_TEXTURE_RG_16,
    WINED3D_GL_TEXTURE_SNORM_16,
    WINED3D_GL_TEXTURE_FLOAT_RGB,
    WINED3D_GL_D32_UNORM,
    WINED3D_GL_DESKTOP_OPENGL,
    WINED3D_GL_LEGACY_CONTEXT,
    WINED3D_GL_NORMALIZED_TEXRECT,
    WINED3D_GL_POINTSPRITE,
    WINED3D_GL_POINTSPRITE_ORIGIN,
    WINED3D_GL_PRIMITIVE_QUERY,
    WINED3D_GL_SEPARATE_STENCIL,
    WINED3D_GLSL_BINDING,
    WINED3D_GLSL_INTERP_QUALIFIER,
    WINED3D_GLSL_SCALAR_SWIZZLE,
    WINED3D_GL_SM4_SUPPORT,
    WINED3D_GL_SM5_SUPPORT,

    WINED3D_GL_EXT_COUNT,
};
#endif /* __WINE_WINED3D_GL */
