/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public abstract class EdgeAdapter
extends LineAdapter
implements MindMapEdge {
    public static final int WIDTH_PARENT = -1;
    public static final int WIDTH_THIN = 0;

    public EdgeAdapter(MindMapNode target, FreeMindMain frame) {
        this(target, frame, "standardedgecolor", "standardedgestyle");
    }

    protected EdgeAdapter(MindMapNode target, FreeMindMain frame, String standardColorPropertyString, String standardStylePropertyString) {
        super(target, frame, standardColorPropertyString, standardStylePropertyString);
        this.NORMAL_WIDTH = -1;
    }

    public Color getColor() {
        if (this.color == null) {
            if (this.getTarget().isRoot()) {
                String stdcolor = this.getFrame().getProperty(this.standardColorPropertyString);
                if (stdcolor.length() == 7) {
                    return Tools.xmlToColor(stdcolor);
                }
                return Color.blue;
            }
            return this.getSource().getEdge().getColor();
        }
        return this.color;
    }

    public int getWidth() {
        if (this.width == -1) {
            if (this.getTarget().isRoot()) {
                return 0;
            }
            return this.getSource().getEdge().getWidth();
        }
        return this.width;
    }

    public Stroke getStroke() {
        if (this.width == 0) {
            return null;
        }
        if (this.stroke == null) {
            if (this.getTarget().isRoot()) {
                return null;
            }
            return this.getSource().getEdge().getStroke();
        }
        return this.stroke;
    }

    public void setWidth(int width) {
        this.width = width;
        this.stroke = width == -1 || width == 0 ? null : new BasicStroke(this.getWidth(), 0, 0);
    }

    public String getStyle() {
        if (this.style == null) {
            if (this.getTarget().isRoot()) {
                return this.getFrame().getProperty(this.standardStylePropertyString);
            }
            return this.getSource().getEdge().getStyle();
        }
        return this.style;
    }

    private MindMapNode getSource() {
        return this.target.getParentNode();
    }
}

