/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.main.ExampleFileFilter;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.MapAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public abstract class ControllerAdapter
implements ModeController {
    Mode mode;
    private int noOfMaps = 0;
    private Clipboard clipboard;
    private int status;
    public Action copy = null;
    public Action copySingle = null;
    public Action cut = null;
    public Action paste = null;
    static final Color selectionColor = new Color(200, 220, 200);
    private JPopupMenu popupmenu;
    protected final ControllerPopupMenuListener popupListenerSingleton = new ControllerPopupMenuListener();
    private static final int SCROLL_SKIPS = 8;
    private static final int SCROLL_SKIP = 10;
    private static final int HORIZONTAL_SCROLL_MASK = 29;
    private static final int ZOOM_MASK = 2;
    private static Tools.BooleanHolder booleanHolderForConfirmState;
    private FocusListener textFieldListener = null;
    private boolean isBlocked = false;
    public final int NEW_CHILD_WITHOUT_FOCUS = 1;
    public final int NEW_CHILD = 2;
    public final int NEW_SIBLING_BEHIND = 3;
    public final int NEW_SIBLING_BEFORE = 4;

    public ControllerAdapter() {
    }

    public ControllerAdapter(Mode mode) {
        this.mode = mode;
        this.cut = new CutAction(this);
        this.paste = new PasteAction(this);
        this.copy = new CopyAction(this);
        this.copySingle = new CopySingleAction(this);
        DropTarget dropTarget = new DropTarget(this.getFrame().getViewport(), new FileOpener());
        this.clipboard = this.getFrame().getViewport().getToolkit().getSystemSelection();
        if (this.clipboard == null) {
            this.clipboard = this.getFrame().getViewport().getToolkit().getSystemClipboard();
        }
    }

    protected abstract MindMapNode newNode();

    public MapAdapter newModel() {
        throw new UnsupportedOperationException();
    }

    protected FileFilter getFileFilter() {
        return null;
    }

    public void nodeChanged(MindMapNode n) {
    }

    public void anotherNodeSelected(MindMapNode n) {
    }

    public void doubleClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MindMapNode node = ((NodeView)e.getComponent()).getModel();
        if (node.hasChildren()) {
            this.plainClick(e);
            return;
        }
        if (!(e.isAltDown() || e.isControlDown() || e.isShiftDown() || e.isPopupTrigger() || e.getButton() != 1 || node.getLink() != null)) {
            this.edit(null, false, false);
        }
    }

    public void plainClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MindMapNode node = ((NodeView)e.getComponent()).getModel();
        if (this.getView().getSelected().followLink(e.getX())) {
            this.loadURL();
        } else {
            if (!node.hasChildren()) {
                this.doubleClick(e);
                return;
            }
            this.toggleFolded();
        }
    }

    protected String getText(String textId) {
        return this.getController().getResourceString(textId);
    }

    protected boolean binOptionIsTrue(String option) {
        return this.getFrame().getProperty(option).equals("true");
    }

    public void newMap() {
        this.getController().getMapModuleManager().newMapModule(this.newModel());
        this.mapOpened(true);
    }

    protected void newMap(MindMap map) {
        this.getController().getMapModuleManager().newMapModule(map);
        this.mapOpened(true);
    }

    public void load(File file) throws FileNotFoundException, IOException, XMLParseException {
        MapAdapter model = this.newModel();
        model.load(file);
        this.getController().getMapModuleManager().newMapModule(model);
        this.mapOpened(true);
    }

    public boolean save() {
        if (this.getModel().isSaved()) {
            return true;
        }
        if (this.getModel().getFile() == null || this.getModel().isReadOnly()) {
            return this.saveAs();
        }
        return this.save(this.getModel().getFile());
    }

    protected LinkedList getSelecteds() {
        LinkedList<MindMapNode> selecteds = new LinkedList<MindMapNode>();
        ListIterator it = this.getView().getSelecteds().listIterator();
        if (it != null) {
            while (it.hasNext()) {
                NodeView selected = (NodeView)it.next();
                selecteds.add(selected.getModel());
            }
        }
        return selecteds;
    }

    public boolean save(File file) {
        return this.getModel().save(file);
    }

    protected JMenuItem add(JMenu menu, Action action, String keystroke) {
        JMenuItem item = menu.add(action);
        item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getProperty(keystroke)));
        return item;
    }

    protected void add(JMenu menu, Action action) {
        menu.add(action);
    }

    public void open() {
        int returnVal;
        JFileChooser chooser = null;
        chooser = this.getMap() != null && this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null ? new JFileChooser(this.getMap().getFile().getParentFile()) : new JFileChooser();
        if (this.getFileFilter() != null) {
            chooser.addChoosableFileFilter(this.getFileFilter());
        }
        if ((returnVal = chooser.showOpenDialog(this.getView())) == 0) {
            try {
                this.load(chooser.getSelectedFile());
            }
            catch (Exception ex) {
                this.handleLoadingException(ex);
            }
        }
        this.getController().setTitle();
    }

    public void handleLoadingException(Exception ex) {
        String exceptionType = ex.getClass().getName();
        if (exceptionType.equals("freemind.main.XMLParseException")) {
            int showDetail = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_corrupted"), "FreeMind", 0, 0);
            if (showDetail == 0) {
                this.getController().errorMessage(ex);
            }
        } else if (exceptionType.equals("java.io.FileNotFoundException")) {
            this.getController().errorMessage(ex.getMessage());
        } else {
            this.getController().errorMessage(ex);
        }
    }

    public boolean saveAs() {
        int overwriteMap;
        JFileChooser chooser = null;
        if (this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null) {
            chooser = new JFileChooser(this.getMap().getFile().getParentFile());
        } else {
            chooser = new JFileChooser();
            chooser.setSelectedFile(new File(((Object)((MindMapNode)this.getMap().getRoot())).toString() + ".mm"));
        }
        if (this.getFileFilter() != null) {
            chooser.addChoosableFileFilter(this.getFileFilter());
        }
        chooser.setDialogTitle(this.getText("save_as"));
        int returnVal = chooser.showSaveDialog(this.getView());
        if (returnVal != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        String ext = Tools.getExtension(f.getName());
        if (!ext.equals("mm")) {
            f = new File(f.getParent(), f.getName() + ".mm");
        }
        if (f.exists() && (overwriteMap = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_already_exists"), "FreeMind", 0)) != 0) {
            return false;
        }
        try {
            String lockingUser = this.getModel().tryToLock(f);
            if (lockingUser != null) {
                this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("map_locked_by_save_as"), f.getName(), lockingUser));
                return false;
            }
        }
        catch (Exception e) {
            this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_failed_by_save_as"), f.getName()));
            return false;
        }
        this.save(f);
        this.getController().getMapModuleManager().updateMapModuleName();
        return true;
    }

    public boolean close() {
        Object[] options = new String[]{this.getText("yes"), this.getText("no"), this.getText("cancel")};
        if (!this.getModel().isSaved()) {
            boolean savingNotCancelled;
            String text = this.getText("save_unsaved") + "\n" + this.getMapModule().toString();
            String title = this.getText("save");
            int returnVal = JOptionPane.showOptionDialog(this.getFrame().getContentPane(), text, title, 1, 3, null, options, options[0]);
            if (returnVal == 0 ? !(savingNotCancelled = this.save()) : returnVal == 2) {
                return false;
            }
        }
        this.getModel().destroy();
        this.mapOpened(false);
        return true;
    }

    public void mapOpened(boolean open) {
        if (open) {
            if (this.noOfMaps == 0) {
                this.setAllActions(true);
                if (this.cut != null) {
                    this.cut.setEnabled(true);
                }
                if (this.copy != null) {
                    this.copy.setEnabled(true);
                }
                if (this.copySingle != null) {
                    this.copySingle.setEnabled(true);
                }
                if (this.paste != null) {
                    this.paste.setEnabled(true);
                }
            }
            if (this.getFrame().getView() != null) {
                DropTarget dropTarget = new DropTarget(this.getFrame().getView(), new FileOpener());
            }
            ++this.noOfMaps;
        } else {
            --this.noOfMaps;
            if (this.noOfMaps == 0) {
                this.setAllActions(false);
                if (this.cut != null) {
                    this.cut.setEnabled(false);
                }
                if (this.copy != null) {
                    this.copy.setEnabled(false);
                }
                if (this.copySingle != null) {
                    this.copySingle.setEnabled(true);
                }
                if (this.paste != null) {
                    this.paste.setEnabled(false);
                }
            }
        }
    }

    protected void setAllActions(boolean enabled) {
    }

    public void showPopupMenu(MouseEvent e) {
        JPopupMenu popupmenu;
        if (e.isPopupTrigger() && (popupmenu = this.getPopupMenu()) != null) {
            popupmenu.addPopupMenuListener(this.popupListenerSingleton);
            popupmenu.show(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public JPopupMenu getPopupForModel(Object obj) {
        return null;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.isBlocked()) {
            return;
        }
        if ((e.getModifiers() & 2) != 0) {
            float newZoomFactor = 1.0f + Math.abs((float)e.getWheelRotation()) / 10.0f;
            if (e.getWheelRotation() < 0) {
                newZoomFactor = 1.0f / newZoomFactor;
            }
            float newZoom = ((MapView)e.getComponent()).getZoom() * newZoomFactor;
            newZoom = (float)Math.rint(newZoom * 1000.0f) / 1000.0f;
            this.getController().setZoom(newZoom);
        } else if ((e.getModifiers() & 0x1D) != 0) {
            for (int i = 0; i < 8; ++i) {
                ((MapView)e.getComponent()).scrollBy(10 * e.getWheelRotation(), 0);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                ((MapView)e.getComponent()).scrollBy(0, 10 * e.getWheelRotation());
            }
        }
    }

    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
        if (this.getView().getSelected() != null) {
            if (e == null || !addNew) {
                this.edit(this.getView().getSelected(), this.getView().getSelected(), e, false, false, editLong);
            } else if (!this.isBlocked()) {
                this.addNew(this.getView().getSelected(), 3, e);
            }
            if (e != null) {
                e.consume();
            }
        }
    }

    private void changeComponentHeight(JComponent component, int difference, int minimum) {
        Dimension preferredSize = component.getPreferredSize();
        System.out.println("pf:" + preferredSize);
        if (preferredSize.getHeight() + (double)difference >= (double)minimum) {
            System.out.println("pf:" + preferredSize);
            component.setPreferredSize(new Dimension((int)preferredSize.getWidth(), (int)preferredSize.getHeight() + difference));
        }
    }

    private void editLong(NodeView node, String text, KeyEvent firstEvent) {
        boolean BUTTON_OK = false;
        boolean BUTTON_CANCEL = true;
        int BUTTON_SPLIT = 2;
        final JDialog dialog = new JDialog((JFrame)((Object)this.getFrame()), this.getText("edit_long_node"), true);
        final JTextArea textArea = new JTextArea(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        if (firstEvent != null) {
            switch (firstEvent.getKeyCode()) {
                case 36: {
                    textArea.setCaretPosition(0);
                    break;
                }
                default: {
                    textArea.setCaretPosition(text.length());
                    break;
                }
            }
        } else {
            textArea.setCaretPosition(text.length());
        }
        JScrollPane editorScrollPane = new JScrollPane(textArea);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        int preferredHeight = node.getHeight();
        preferredHeight = Math.max(preferredHeight, Integer.parseInt(this.getFrame().getProperty("el__min_default_window_height")));
        preferredHeight = Math.min(preferredHeight, Integer.parseInt(this.getFrame().getProperty("el__max_default_window_height")));
        int preferredWidth = node.getWidth();
        preferredWidth = Math.max(preferredWidth, Integer.parseInt(this.getFrame().getProperty("el__min_default_window_width")));
        preferredWidth = Math.min(preferredWidth, Integer.parseInt(this.getFrame().getProperty("el__max_default_window_width")));
        editorScrollPane.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        JPanel panel = new JPanel();
        final Tools.IntHolder eventSource = new Tools.IntHolder();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton(this.getText("cancel"));
        JButton splitButton = new JButton(this.getText("split"));
        final JCheckBox enterConfirms = new JCheckBox(this.getText("enter_confirms"), this.binOptionIsTrue("el__enter_confirms_by_default"));
        if (booleanHolderForConfirmState == null) {
            booleanHolderForConfirmState = new Tools.BooleanHolder();
            booleanHolderForConfirmState.setValue(enterConfirms.isSelected());
        } else {
            enterConfirms.setSelected(booleanHolderForConfirmState.getValue());
        }
        okButton.setMnemonic(79);
        enterConfirms.setMnemonic(69);
        splitButton.setMnemonic(83);
        cancelButton.setMnemonic(67);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                eventSource.setValue(0);
                dialog.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                eventSource.setValue(1);
                dialog.dispose();
            }
        });
        splitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                eventSource.setValue(2);
                dialog.dispose();
            }
        });
        enterConfirms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textArea.requestFocus();
                booleanHolderForConfirmState.setValue(enterConfirms.isSelected());
            }
        });
        textArea.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    eventSource.setValue(1);
                    dialog.dispose();
                } else if (e.getKeyCode() == 10) {
                    if (enterConfirms.isSelected() == ((e.getModifiers() & 2) == 0)) {
                        e.consume();
                        eventSource.setValue(0);
                        dialog.dispose();
                    } else if (enterConfirms.isSelected() && (e.getModifiers() & 2) != 0) {
                        e.consume();
                        textArea.insert("\n", textArea.getCaretPosition());
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        textArea.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            private void conditionallyShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    EditPopupMenu popupMenu = new EditPopupMenu(textArea);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        });
        textArea.setFont(node.getFont());
        textArea.setForeground(node.getForeground());
        JPanel buttonPane = new JPanel();
        buttonPane.add(enterConfirms);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.add(splitButton);
        buttonPane.setMaximumSize(new Dimension(1000, 20));
        if (this.getFrame().getProperty("el__buttons_position").equals("above")) {
            panel.add(buttonPane);
            panel.add(editorScrollPane);
        } else {
            panel.add(editorScrollPane);
            panel.add(buttonPane);
        }
        panel.setLayout(new BoxLayout(panel, 1));
        dialog.setDefaultCloseOperation(2);
        dialog.setContentPane(panel);
        dialog.pack();
        this.getView().scrollNodeToVisible(node, 0);
        Point frameScreenLocation = this.getFrame().getLayeredPane().getLocationOnScreen();
        double posX = node.getLocationOnScreen().getX() - frameScreenLocation.getX();
        double posY = node.getLocationOnScreen().getY() - frameScreenLocation.getY() + (double)(this.binOptionIsTrue("el__position_window_below_node") ? node.getHeight() : 0);
        if (posX + (double)dialog.getWidth() > (double)this.getFrame().getLayeredPane().getWidth()) {
            posX = this.getFrame().getLayeredPane().getWidth() - dialog.getWidth();
        }
        if (posY + (double)dialog.getHeight() > (double)this.getFrame().getLayeredPane().getHeight()) {
            posY = this.getFrame().getLayeredPane().getHeight() - dialog.getHeight();
        }
        posX = (posX < 0.0 ? 0.0 : posX) + frameScreenLocation.getX();
        posY = (posY < 0.0 ? 0.0 : posY) + frameScreenLocation.getY();
        dialog.setLocation(new Double(posX).intValue(), new Double(posY).intValue());
        textArea.requestFocusInWindow();
        dialog.show();
        if (eventSource.getValue() == 0) {
            this.getModel().changeNode(node.getModel(), textArea.getText());
        }
        if (eventSource.getValue() == 2) {
            this.getModel().splitNode(node.getModel(), textArea.getCaretPosition(), textArea.getText());
            this.getController().obtainFocusForSelected();
        }
    }

    private void closeEdit() {
        if (this.textFieldListener != null) {
            this.textFieldListener.focusLost(null);
        }
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    private void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    private void edit(NodeView node, NodeView prevSelected, KeyEvent firstEvent, boolean isNewNode, boolean parentFolded, boolean editLong) {
        if (node == null) {
            return;
        }
        this.closeEdit();
        this.setBlocked(true);
        String text = ((Object)node.getModel()).toString();
        if (node.getIsLong() || editLong) {
            this.editLong(node, text, firstEvent);
            this.setBlocked(false);
            return;
        }
        final JTextField textField = text.length() < 8 ? new JTextField(text, 8) : new JTextField(text);
        int linkIconWidth = 16;
        int textFieldBorderWidth = 2;
        int cursorWidth = 1;
        int xOffset = -1 * textFieldBorderWidth + node.getLeftWidthOverhead() - 1;
        int yOffset = -1;
        int widthAddition = 2 * textFieldBorderWidth + cursorWidth - 2 * node.getLeftWidthOverhead() + 2;
        int heightAddition = 2;
        if (node.getModel().getLink() != null) {
            xOffset += linkIconWidth;
            widthAddition -= linkIconWidth;
        }
        if (node.getModel().getIcons().size() != 0) {
            xOffset += linkIconWidth * node.getModel().getIcons().size();
            widthAddition -= linkIconWidth;
        }
        int MINIMAL_LEAF_WIDTH = 150;
        int MINIMAL_WIDTH = 50;
        int xSize = node.getWidth() + widthAddition;
        int xExtraWidth = 0;
        if (150 > xSize && (node.getModel().isFolded() || !node.getModel().hasChildren())) {
            xExtraWidth = 150 - xSize;
            xSize = 150;
            if (node.isLeft()) {
                xExtraWidth = -xExtraWidth;
                textField.setHorizontalAlignment(4);
            }
        } else if (50 > xSize) {
            xExtraWidth = 50 - xSize;
            xSize = 50;
            if (node.isLeft()) {
                xExtraWidth = -xExtraWidth;
                textField.setHorizontalAlignment(4);
            }
        }
        textField.setSize(xSize, node.getHeight() + heightAddition);
        textField.setFont(node.getFont());
        textField.setForeground(node.getForeground());
        textField.setSelectedTextColor(node.getForeground());
        textField.setSelectionColor(selectionColor);
        boolean INIT = false;
        boolean EDIT = true;
        int CANCEL = 2;
        Tools.IntHolder eventSource = new Tools.IntHolder();
        eventSource.setValue(0);
        class TextFieldListener
        implements KeyListener,
        FocusListener,
        MouseListener {
            private final /* synthetic */ Tools.IntHolder val$eventSource;
            private final /* synthetic */ KeyEvent val$firstEvent;
            private final /* synthetic */ JTextField val$textField;
            private final /* synthetic */ NodeView val$node;
            private final /* synthetic */ boolean val$isNewNode;
            private final /* synthetic */ NodeView val$prevSelected;
            private final /* synthetic */ boolean val$parentFolded;

            TextFieldListener(Tools.IntHolder val$eventSource, KeyEvent val$firstEvent, JTextField val$textField, NodeView val$node, boolean val$isNewNode, NodeView val$prevSelected, boolean val$parentFolded) {
                this.val$eventSource = val$eventSource;
                this.val$firstEvent = val$firstEvent;
                this.val$textField = val$textField;
                this.val$node = val$node;
                this.val$isNewNode = val$isNewNode;
                this.val$prevSelected = val$prevSelected;
                this.val$parentFolded = val$parentFolded;
            }

            public void focusGained(FocusEvent e) {
                if (this.val$eventSource.getValue() == 0) {
                    this.val$eventSource.setValue(1);
                    if (this.val$firstEvent instanceof KeyEvent) {
                        KeyEvent firstKeyEvent = this.val$firstEvent;
                        if (firstKeyEvent.getKeyChar() == '\uffff') {
                            switch (firstKeyEvent.getKeyCode()) {
                                case 36: {
                                    this.val$textField.setCaretPosition(0);
                                    break;
                                }
                                case 35: {
                                    this.val$textField.setCaretPosition(this.val$textField.getText().length());
                                }
                            }
                        } else {
                            KeyEvent keyEv = new KeyEvent(firstKeyEvent.getComponent(), 400, firstKeyEvent.getWhen(), firstKeyEvent.getModifiers(), 0, firstKeyEvent.getKeyChar(), 0);
                            this.val$textField.selectAll();
                            this.val$textField.dispatchEvent(keyEv);
                        }
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                if (e == null) {
                    ControllerAdapter.this.getModel().changeNode(this.val$node.getModel(), this.val$textField.getText());
                    ControllerAdapter.this.getFrame().getLayeredPane().remove(this.val$textField);
                    ControllerAdapter.this.getFrame().repaint();
                    ControllerAdapter.this.textFieldListener = null;
                    this.val$eventSource.setValue(2);
                } else if (this.val$eventSource.getValue() != 2) {
                    ControllerAdapter.this.getModel().changeNode(this.val$node.getModel(), this.val$textField.getText());
                    ControllerAdapter.this.getFrame().getLayeredPane().remove(this.val$textField);
                    ControllerAdapter.this.getFrame().repaint();
                    ControllerAdapter.this.setBlocked(false);
                    ControllerAdapter.this.textFieldListener = null;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() || e.isControlDown()) {
                    return;
                }
                boolean commit = true;
                switch (e.getKeyCode()) {
                    case 27: {
                        commit = false;
                    }
                    case 10: {
                        e.consume();
                        this.val$eventSource.setValue(2);
                        if (commit) {
                            ControllerAdapter.this.getModel().changeNode(this.val$node.getModel(), this.val$textField.getText());
                        } else if (this.val$isNewNode) {
                            ControllerAdapter.this.getView().selectAsTheOnlyOneSelected(this.val$node);
                            ControllerAdapter.this.getModel().cut();
                            ControllerAdapter.this.select(this.val$prevSelected);
                            if (this.val$parentFolded) {
                                ControllerAdapter.this.getModel().setFolded(this.val$prevSelected.getModel(), true);
                            }
                        }
                        ControllerAdapter.this.getFrame().getLayeredPane().remove(this.val$textField);
                        ControllerAdapter.this.getFrame().repaint();
                        ControllerAdapter.this.setBlocked(false);
                        ControllerAdapter.this.textFieldListener = null;
                        ControllerAdapter.this.getController().obtainFocusForSelected();
                        break;
                    }
                    case 32: {
                        e.consume();
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            private void conditionallyShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    EditPopupMenu popupMenu = new EditPopupMenu(this.val$textField);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        }
        TextFieldListener textFieldListener = new TextFieldListener(eventSource, firstEvent, textField, node, isNewNode, prevSelected, parentFolded);
        this.textFieldListener = textFieldListener;
        textField.addFocusListener(textFieldListener);
        textField.addKeyListener(textFieldListener);
        textField.addMouseListener(textFieldListener);
        this.getView().scrollNodeToVisible(node, xExtraWidth);
        Point frameScreenLocation = this.getFrame().getLayeredPane().getLocationOnScreen();
        Point nodeScreenLocation = node.getLocationOnScreen();
        int xLeft = (int)(nodeScreenLocation.getX() - frameScreenLocation.getX() + (double)xOffset);
        if (xExtraWidth < 0) {
            xLeft += xExtraWidth;
        }
        textField.setLocation(xLeft, (int)(nodeScreenLocation.getY() - frameScreenLocation.getY() + (double)yOffset));
        this.getFrame().getLayeredPane().add(textField);
        this.getFrame().repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                textField.requestFocus();
            }
        });
    }

    public void addNew(NodeView target, int newNodeMode, KeyEvent e) {
        this.closeEdit();
        MindMapNode newNode = this.newNode();
        MindMapNode targetNode = target.getModel();
        switch (newNodeMode) {
            case 3: 
            case 4: {
                if (targetNode.isRoot()) {
                    this.getController().errorMessage(this.getText("new_node_as_sibling_not_possible_for_the_root"));
                    this.setBlocked(false);
                    return;
                }
                MindMapNode parent = targetNode.getParentNode();
                int childPosition = parent.getChildPosition(targetNode);
                if (newNodeMode == 3) {
                    ++childPosition;
                }
                if (targetNode.isLeft() != null) {
                    newNode.setLeft(targetNode.isLeft().getValue());
                }
                this.getModel().insertNodeInto(newNode, parent, childPosition);
                this.select(newNode.getViewer());
                this.getFrame().repaint();
                this.edit(newNode.getViewer(), target, e, true, false, false);
                break;
            }
            case 1: 
            case 2: {
                boolean parentFolded = targetNode.isFolded();
                if (parentFolded) {
                    this.getModel().setFolded(targetNode, false);
                }
                int position = this.getFrame().getProperty("placenewbranches").equals("last") ? targetNode.getChildCount() : 0;
                this.getModel().insertNodeInto(newNode, targetNode, position);
                this.getFrame().repaint();
                if (newNodeMode == 2) {
                    this.select(newNode.getViewer());
                }
                NodeView editView = newNode.getViewer();
                this.edit(editView, targetNode.getViewer(), e, true, parentFolded, false);
            }
        }
    }

    public void toggleFolded() {
        Tools.BooleanHolder state = null;
        boolean allNodeHaveSameFoldedStatus = true;
        ListIterator it = this.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNode node = (MindMapNode)it.next();
            if (state == null) {
                state = new Tools.BooleanHolder();
                state.setValue(node.isFolded());
                continue;
            }
            if (node.isFolded() == state.getValue()) continue;
            allNodeHaveSameFoldedStatus = false;
            break;
        }
        boolean fold = true;
        if (allNodeHaveSameFoldedStatus && state != null) {
            fold = !state.getValue();
        }
        MindMapNode lastNode = null;
        ListIterator it2 = this.getView().getSelectedsByDepth().listIterator();
        while (it2.hasNext()) {
            MindMapNode node = ((NodeView)it2.next()).getModel();
            if (node.hasChildren() || node.isFolded() || Tools.safeEquals(this.getFrame().getProperty("enable_leaves_folding"), "true")) {
                this.getModel().setFolded(node, fold);
            }
            lastNode = node;
        }
        if (lastNode != null) {
            this.getView().selectAsTheOnlyOneSelected(lastNode.getViewer());
        }
    }

    protected void toggleChildrenFolded() {
        NodeAdapter parent = this.getSelected();
        ListIterator children_it = parent.getViewer().getChildrenViews().listIterator();
        boolean areAnyFolded = false;
        while (children_it.hasNext() && !areAnyFolded) {
            NodeView child = (NodeView)children_it.next();
            if (!child.getModel().isFolded()) continue;
            areAnyFolded = true;
        }
        boolean enableLeavesFolding = Tools.safeEquals(this.getFrame().getProperty("enable_leaves_folding"), "true");
        children_it = parent.getViewer().getChildrenViews().listIterator();
        while (children_it.hasNext()) {
            MindMapNode child = ((NodeView)children_it.next()).getModel();
            if (!child.hasChildren() && !enableLeavesFolding && !child.isFolded()) continue;
            this.getModel().setFolded(child, !areAnyFolded);
        }
        this.getView().selectAsTheOnlyOneSelected(parent.getViewer());
        this.getController().obtainFocusForSelected();
    }

    protected void setLinkByTextField() {
        String inputValue = JOptionPane.showInputDialog(this.getText("edit_link_manually"), (Object)this.getModel().getLink(this.getSelected()));
        if (inputValue != null) {
            if (inputValue.equals("")) {
                inputValue = null;
            }
            this.getModel().setLink(this.getSelected(), inputValue);
        }
    }

    protected void setLinkByFileChooser() {
        String relative = this.getLinkByFileChooser(this.getFileFilter());
        if (relative != null) {
            this.getModel().setLink(this.getSelected(), relative);
        }
    }

    protected void setImageByFileChooser() {
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("png");
        filter.addExtension("gif");
        filter.setDescription("JPG, PNG and GIF Images");
        boolean picturesAmongSelecteds = false;
        ListIterator e = this.getSelecteds().listIterator();
        while (e.hasNext()) {
            String link = ((MindMapNode)e.next()).getLink();
            if (link == null || !filter.accept(new File(link))) continue;
            picturesAmongSelecteds = true;
            break;
        }
        try {
            if (picturesAmongSelecteds) {
                e = this.getSelecteds().listIterator();
                while (e.hasNext()) {
                    String possiblyRelative;
                    String relative;
                    MindMapNode node = (MindMapNode)e.next();
                    if (node.getLink() == null || (relative = Tools.isAbsolutePath(possiblyRelative = node.getLink()) ? new File(possiblyRelative).toURL().toString() : possiblyRelative) == null) continue;
                    String strText = "<html><img src=\"" + relative + "\">";
                    node.setLink(null);
                    this.getModel().changeNode(node, strText);
                }
            } else {
                String relative = this.getLinkByFileChooser(filter);
                if (relative != null) {
                    String strText = "<html><img src=\"" + relative + "\">";
                    this.getModel().changeNode(this.getSelected(), strText);
                }
            }
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
    }

    protected String getLinkByFileChooser(FileFilter fileFilter) {
        String relative = null;
        JFileChooser chooser = null;
        if (this.getMap().getFile() == null) {
            JOptionPane.showMessageDialog(this.getFrame().getContentPane(), this.getText("not_saved_for_link_error"), "FreeMind", 2);
            return null;
        }
        chooser = this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null ? new JFileChooser(this.getMap().getFile().getParentFile()) : new JFileChooser();
        if (fileFilter != null) {
            chooser.setFileFilter(fileFilter);
        } else {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        int returnVal = chooser.showOpenDialog(this.getFrame().getContentPane());
        if (returnVal == 0) {
            URL link;
            File input = chooser.getSelectedFile();
            try {
                link = input.toURL();
                relative = link.toString();
            }
            catch (MalformedURLException ex) {
                this.getController().errorMessage(this.getText("url_error"));
                return null;
            }
            if (this.getFrame().getProperty("links").equals("relative")) {
                try {
                    relative = Tools.toRelativeURL(this.getMap().getFile().toURL(), link);
                }
                catch (MalformedURLException ex) {
                    this.getController().errorMessage(this.getText("url_error"));
                    return null;
                }
            }
        }
        return relative;
    }

    public void loadURL(String relative) {
        URL absolute = null;
        if (this.getMap().getFile() == null) {
            this.getFrame().out("You must save the current map first!");
            this.save();
        }
        try {
            absolute = Tools.isAbsolutePath(relative) ? new File(relative).toURL() : new URL(this.getMap().getFile().toURL(), relative);
            String extension = Tools.getExtension(absolute.toString());
            if (extension != null && extension.equals("mm")) {
                String fileName = absolute.getFile();
                File file = new File(fileName);
                if (!this.getController().getMapModuleManager().tryToChangeToMapModule(file.getName())) {
                    this.getFrame().setWaitingCursor(true);
                    this.load(file);
                }
            } else {
                this.getFrame().openDocument(absolute);
            }
        }
        catch (MalformedURLException ex) {
            this.getController().errorMessage(this.getText("url_error") + "\n" + ex);
            return;
        }
        catch (FileNotFoundException e) {
            int returnVal = JOptionPane.showConfirmDialog(this.getView(), this.getText("repair_link_question"), this.getText("repair_link"), 0);
            if (returnVal == 0) {
                this.setLinkByTextField();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getFrame().setWaitingCursor(false);
    }

    public void loadURL() {
        String link = this.getSelected().getLink();
        if (link != null) {
            this.loadURL(link);
        }
    }

    protected Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    protected MapModule getMapModule() {
        return this.getController().getMapModuleManager().getMapModule();
    }

    public MapAdapter getMap() {
        if (this.getMapModule() != null) {
            return (MapAdapter)this.getMapModule().getModel();
        }
        return null;
    }

    public URL getResource(String name) {
        return this.getFrame().getResource(name);
    }

    public Controller getController() {
        return this.getMode().getController();
    }

    public FreeMindMain getFrame() {
        return this.getController().getFrame();
    }

    private MapAdapter getModel() {
        return (MapAdapter)this.getController().getModel();
    }

    public MapView getView() {
        return this.getController().getView();
    }

    protected void updateMapModuleName() {
        this.getController().getMapModuleManager().updateMapModuleName();
    }

    private NodeAdapter getSelected() {
        return (NodeAdapter)this.getView().getSelected().getModel();
    }

    public boolean extendSelection(MouseEvent e) {
        NodeView newlySelectedNodeView = (NodeView)e.getSource();
        boolean extend = e.isControlDown();
        boolean range = e.isShiftDown();
        boolean branch = e.isAltGraphDown() || e.isAltDown();
        boolean retValue = false;
        if (extend || range || branch || !this.getView().isSelected(newlySelectedNodeView)) {
            if (!range) {
                if (extend) {
                    this.getView().toggleSelected(newlySelectedNodeView);
                } else {
                    this.select(newlySelectedNodeView);
                }
                retValue = true;
            } else {
                retValue = this.getView().selectContinuous(newlySelectedNodeView);
            }
            if (branch) {
                this.getView().selectBranch(newlySelectedNodeView, extend);
                retValue = true;
            }
        }
        if (retValue) {
            e.consume();
            String link = newlySelectedNodeView.getModel().getLink();
            link = link != null ? link : " ";
            this.getController().getFrame().out(link);
        }
        return retValue;
    }

    private void select(NodeView node) {
        this.getView().selectAsTheOnlyOneSelected(node);
        this.getView().setSiblingMaxLevel(node.getModel().getNodeLevel());
    }

    private class EditPopupMenu
    extends JPopupMenu {
        public EditPopupMenu(JTextComponent textComponent) {
            this.add(new EditCopyAction(textComponent));
        }
    }

    protected class EditCopyAction
    extends AbstractAction {
        private JTextComponent textComponent;

        public EditCopyAction(JTextComponent textComponent) {
            super(ControllerAdapter.this.getText("copy"));
            this.textComponent = textComponent;
        }

        public void actionPerformed(ActionEvent e) {
            String selection = this.textComponent.getSelectedText();
            if (selection != null) {
                ControllerAdapter.this.clipboard.setContents(new StringSelection(selection), null);
            }
        }
    }

    protected class FileOpener
    implements DropTargetListener {
        protected FileOpener() {
        }

        private boolean isDragAcceptable(DropTargetDragEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        private boolean isDropAcceptable(DropTargetDropEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        public void drop(DropTargetDropEvent dtde) {
            if (!this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(1);
            try {
                Object data = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
                Iterator iterator = ((List)data).iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    ControllerAdapter.this.load(file);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ControllerAdapter.this.getView(), "Couldn't open dropped file(s). Reason: " + e.getMessage());
                dtde.dropComplete(false);
                return;
            }
            dtde.dropComplete(true);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
                return;
            }
        }

        public void dragOver(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    protected class PasteAction
    extends AbstractAction {
        public PasteAction(Object controller) {
            super(ControllerAdapter.this.getText("paste"), new ImageIcon(ControllerAdapter.this.getResource("images/Paste24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (ControllerAdapter.this.clipboard != null) {
                ControllerAdapter.this.getModel().paste(ControllerAdapter.this.clipboard.getContents(this), ControllerAdapter.this.getView().getSelected().getModel());
            }
        }
    }

    protected class CutAction
    extends AbstractAction {
        public CutAction(Object controller) {
            super(ControllerAdapter.this.getText("cut"), new ImageIcon(ControllerAdapter.this.getResource("images/Cut24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            Transferable copy;
            if (ControllerAdapter.this.getMapModule() != null && (copy = ControllerAdapter.this.getView().getModel().cut()) != null) {
                ControllerAdapter.this.clipboard.setContents(copy, null);
                ControllerAdapter.this.getController().obtainFocusForSelected();
            }
        }
    }

    protected class CopySingleAction
    extends AbstractAction {
        public CopySingleAction(Object controller) {
            super(ControllerAdapter.this.getText("copy_single"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            Transferable copy;
            if (ControllerAdapter.this.getMapModule() != null && (copy = ControllerAdapter.this.getView().getModel().copySingle()) != null) {
                ControllerAdapter.this.clipboard.setContents(copy, null);
            }
        }
    }

    protected class CopyAction
    extends AbstractAction {
        public CopyAction(Object controller) {
            super(ControllerAdapter.this.getText("copy"), new ImageIcon(ControllerAdapter.this.getResource("images/Copy24.gif")));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            Transferable copy;
            if (ControllerAdapter.this.getMapModule() != null && (copy = ControllerAdapter.this.getView().getModel().copy()) != null) {
                ControllerAdapter.this.clipboard.setContents(copy, null);
            }
        }
    }

    protected class FollowLinkAction
    extends AbstractAction {
        public FollowLinkAction() {
            super(ControllerAdapter.this.getText("follow_link"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.loadURL();
        }
    }

    protected class SetLinkByTextFieldAction
    extends AbstractAction {
        public SetLinkByTextFieldAction() {
            super(ControllerAdapter.this.getText("set_link_by_textfield"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.setLinkByTextField();
        }
    }

    protected class SetImageByFileChooserAction
    extends AbstractAction {
        public SetImageByFileChooserAction() {
            super(ControllerAdapter.this.getText("set_image_by_filechooser"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.setImageByFileChooser();
            ControllerAdapter.this.getController().obtainFocusForSelected();
        }
    }

    protected class SetLinkByFileChooserAction
    extends AbstractAction {
        public SetLinkByFileChooserAction() {
            super(ControllerAdapter.this.getText("set_link_by_filechooser"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.setLinkByFileChooser();
        }
    }

    protected class ToggleChildrenFoldedAction
    extends AbstractAction {
        public ToggleChildrenFoldedAction() {
            super(ControllerAdapter.this.getText("toggle_children_folded"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.toggleChildrenFolded();
        }
    }

    protected class ToggleFoldedAction
    extends AbstractAction {
        public ToggleFoldedAction() {
            super(ControllerAdapter.this.getText("toggle_folded"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.toggleFolded();
        }
    }

    protected class NodeDownAction
    extends AbstractAction {
        public NodeDownAction() {
            super(ControllerAdapter.this.getText("node_down"));
        }

        public void actionPerformed(ActionEvent e) {
            MindMapNode selected = ControllerAdapter.this.getView().getSelected().getModel();
            if (!selected.isRoot()) {
                MindMapNode parent = selected.getParentNode();
                int index = ControllerAdapter.this.getModel().getIndexOfChild(parent, selected);
                int newIndex = ControllerAdapter.this.getModel().moveNodeTo(selected, parent, index, 1);
                ControllerAdapter.this.getModel().removeNodeFromParent(selected);
                ControllerAdapter.this.getModel().insertNodeInto(selected, parent, newIndex);
                ControllerAdapter.this.getModel().nodeStructureChanged(parent);
                ControllerAdapter.this.getView().selectAsTheOnlyOneSelected(selected.getViewer());
                ControllerAdapter.this.getController().obtainFocusForSelected();
            }
        }
    }

    protected class NodeUpAction
    extends AbstractAction {
        public NodeUpAction() {
            super(ControllerAdapter.this.getText("node_up"));
        }

        public void actionPerformed(ActionEvent e) {
            MindMapNode selected = ControllerAdapter.this.getView().getSelected().getModel();
            if (!selected.isRoot()) {
                MindMapNode parent = selected.getParentNode();
                int index = ControllerAdapter.this.getModel().getIndexOfChild(parent, selected);
                int newIndex = ControllerAdapter.this.getModel().moveNodeTo(selected, parent, index, -1);
                ControllerAdapter.this.getModel().removeNodeFromParent(selected);
                ControllerAdapter.this.getModel().insertNodeInto(selected, parent, newIndex);
                ControllerAdapter.this.getModel().nodeStructureChanged(parent);
                ControllerAdapter.this.getView().selectAsTheOnlyOneSelected(selected.getViewer());
                ControllerAdapter.this.getController().obtainFocusForSelected();
            }
        }
    }

    protected class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(ControllerAdapter.this.getText("remove_node"));
        }

        public void actionPerformed(ActionEvent e) {
            if (ControllerAdapter.this.getMapModule() != null) {
                ControllerAdapter.this.getView().getModel().cut();
                ControllerAdapter.this.getController().obtainFocusForSelected();
            }
        }
    }

    protected class NewPreviousSiblingAction
    extends AbstractAction {
        public NewPreviousSiblingAction() {
            super(ControllerAdapter.this.getText("new_sibling_before"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.addNew(ControllerAdapter.this.getView().getSelected(), 4, null);
        }
    }

    protected class NewChildAction
    extends AbstractAction {
        public NewChildAction() {
            super(ControllerAdapter.this.getText("new_child"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.addNew(ControllerAdapter.this.getView().getSelected(), 2, null);
        }
    }

    protected class NewSiblingAction
    extends AbstractAction {
        public NewSiblingAction() {
            super(ControllerAdapter.this.getText("new_sibling_behind"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.addNew(ControllerAdapter.this.getView().getSelected(), 3, null);
        }
    }

    protected class NewChildWithoutFocusAction
    extends AbstractAction {
        public NewChildWithoutFocusAction() {
            super(ControllerAdapter.this.getText("new_node"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.addNew(ControllerAdapter.this.getView().getSelected(), 1, null);
        }
    }

    protected class EditLongAction
    extends AbstractAction {
        public EditLongAction() {
            super(ControllerAdapter.this.getText("edit_long_node"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.edit(null, false, true);
        }
    }

    protected class EditAction
    extends AbstractAction {
        public EditAction() {
            super(ControllerAdapter.this.getText("edit"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.edit(null, false, false);
        }
    }

    protected class GotoLinkNodeAction
    extends AbstractAction {
        MindMapNode source;

        public GotoLinkNodeAction(String text, MindMapNode source) {
            super("", new ImageIcon(ControllerAdapter.this.getResource("images/Link.png")));
            String adaptedText = new String(text);
            adaptedText = adaptedText.replaceAll("<html>", "");
            if (adaptedText.length() > 40) {
                adaptedText = adaptedText.substring(0, 40) + " ...";
            }
            this.putValue("Name", ControllerAdapter.this.getText("follow_link") + adaptedText);
            this.putValue("ShortDescription", text);
            this.source = source;
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.getMap().displayNode(this.source, null);
        }
    }

    protected class FindNextAction
    extends AbstractAction {
        public FindNextAction() {
            super(ControllerAdapter.this.getText("find_next"));
        }

        public void actionPerformed(ActionEvent e) {
            String what = ControllerAdapter.this.getView().getModel().getFindWhat();
            if (what == null) {
                ControllerAdapter.this.getController().informationMessage(ControllerAdapter.this.getText("no_previous_find"), ControllerAdapter.this.getView().getSelected());
                return;
            }
            boolean found = ControllerAdapter.this.getView().getModel().findNext();
            ControllerAdapter.this.getView().repaint();
            if (!found) {
                ControllerAdapter.this.getController().informationMessage(ControllerAdapter.this.getText("no_more_found_from").replaceAll("\\$1", what).replaceAll("\\$2", ControllerAdapter.this.getView().getModel().getFindFromText()), ControllerAdapter.this.getView().getSelected());
            }
        }
    }

    protected class FindAction
    extends AbstractAction {
        public FindAction() {
            super(ControllerAdapter.this.getText("find"));
        }

        public void actionPerformed(ActionEvent e) {
            String what = JOptionPane.showInputDialog(ControllerAdapter.this.getView().getSelected(), (Object)ControllerAdapter.this.getText("find_what"));
            if (what == null || what.equals("")) {
                return;
            }
            boolean found = ControllerAdapter.this.getView().getModel().find(ControllerAdapter.this.getView().getSelected().getModel(), what, false);
            ControllerAdapter.this.getView().repaint();
            if (!found) {
                ControllerAdapter.this.getController().informationMessage(ControllerAdapter.this.getText("no_found_from").replaceAll("\\$1", what).replaceAll("\\$2", ControllerAdapter.this.getView().getModel().getFindFromText()), ControllerAdapter.this.getView().getSelected());
            }
        }
    }

    protected class SaveAsAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAsAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("save_as"), new ImageIcon(ControllerAdapter.this.getResource("images/SaveAs24.gif")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.saveAs();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    protected class SaveAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("save"), new ImageIcon(ControllerAdapter.this.getResource("images/Save24.gif")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.save();
            ControllerAdapter.this.getFrame().out(ControllerAdapter.this.getText("saved"));
            ControllerAdapter.this.getController().setTitle();
        }
    }

    protected class OpenAction
    extends AbstractAction {
        ControllerAdapter mc;

        public OpenAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("open"), new ImageIcon(ControllerAdapter.this.getResource("images/Open24.gif")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.open();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    protected class NewMapAction
    extends AbstractAction {
        ControllerAdapter c;

        public NewMapAction(ControllerAdapter controller) {
            super(ControllerAdapter.this.getText("new"), new ImageIcon(ControllerAdapter.this.getResource("images/New24.gif")));
            this.c = controller;
        }

        public void actionPerformed(ActionEvent e) {
            this.c.newMap();
        }
    }

    private class ControllerPopupMenuListener
    implements PopupMenuListener {
        private ControllerPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }
    }
}

