/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

public class MainToolBar
extends JToolBar {
    JComboBox zoom;
    Controller c;
    String userDefinedZoom;

    public MainToolBar(Controller c) {
        this.setRollover(true);
        this.c = c;
        this.userDefinedZoom = c.getResourceString("user_defined_zoom");
        JButton button = this.add(c.navigationPreviousMap);
        button.setText("");
        button = this.add(c.navigationNextMap);
        button.setText("");
        button = this.add(c.printDirect);
        button.setText("");
        this.zoom = new JComboBox<String>(c.getZooms());
        this.zoom.setSelectedItem("100%");
        this.zoom.addItem(this.userDefinedZoom);
        this.add(this.zoom);
        this.zoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainToolBar.this.setZoomByItem(e.getItem());
            }
        });
    }

    private void setZoomByItem(Object item) {
        if (((String)item).equals(this.userDefinedZoom)) {
            return;
        }
        String dirty = (String)item;
        String cleaned = dirty.substring(0, dirty.length() - 1);
        this.c.setZoom((float)Integer.parseInt(cleaned, 10) / 100.0f);
    }

    public void zoomOut() {
        if (this.zoom.getSelectedIndex() > 0) {
            this.setZoomByItem(this.zoom.getItemAt(this.zoom.getSelectedIndex() - 1));
        }
    }

    public void zoomIn() {
        if (this.zoom.getSelectedIndex() < this.zoom.getItemCount() - 1) {
            this.setZoomByItem(this.zoom.getItemAt(this.zoom.getSelectedIndex() + 1));
        }
    }

    public String getItemForZoom(float f) {
        return (int)(f * 100.0f) + "%";
    }

    public void setZoomComboBox(float f) {
        String toBeFound = this.getItemForZoom(f);
        for (int i = 0; i < this.zoom.getItemCount(); ++i) {
            if (!toBeFound.equals((String)this.zoom.getItemAt(i))) continue;
            this.zoom.setSelectedItem(toBeFound);
            return;
        }
        this.zoom.setSelectedItem(this.userDefinedZoom);
    }

    public void setAllActions(boolean enabled) {
        if (this.zoom != null) {
            this.zoom.setEnabled(enabled);
        }
    }
}

