! WHIZARD 2.2.7 Aug 11 2015
! 
! Copyright (C) 1999-2015 by 
!     Wolfgang Kilian <kilian@physik.uni-siegen.de>
!     Thorsten Ohl <ohl@physik.uni-wuerzburg.de>
!     Juergen Reuter <juergen.reuter@desy.de>
!     
!     with contributions from
!     Fabian Bach <fabian.bach@desy.de>
!     Christian Speckner <cnspeckn@googlemail.com> 
!     Christian Weiss <christian.weiss@desy.de>
!     and Hans-Werner Boschmann, Felix Braam, 
!     Sebastian Schmidt, Daniel Wiesler 
!
! WHIZARD is free software; you can redistribute it and/or modify it
! under the terms of the GNU General Public License as published by 
! the Free Software Foundation; either version 2, or (at your option)
! any later version.
!
! WHIZARD is distributed in the hope that it will be useful, but
! WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
! GNU General Public License for more details.
!
! You should have received a copy of the GNU General Public License
! along with this program; if not, write to the Free Software
! Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This file has been stripped of most comments.  For documentation, refer
! to the source 'whizard.nw'

module sindarin_parser_ut

  use unit_tests
  use sindarin_parser_uti
  
  implicit none
  private

  public :: sindarin_parser_test

contains
  
  subroutine sindarin_parser_test (u, results)
    integer, intent(in) :: u
    type(test_results_t), intent(inout) :: results
    call test (sindarin_parser_1, "sindarin_parser_1", &
         "syntax table", &
         u, results)
    call test (sindarin_parser_2, "sindarin_parser_2", &
         "repository", &
         u, results)
    call test (sindarin_parser_3, "sindarin_parser_3", &
         "parse script: logicals", &
         u, results)
    call test (sindarin_parser_4, "sindarin_parser_4", &
         "parse script: integers", &
         u, results)
    call test (sindarin_parser_5, "sindarin_parser_5", &
         "parse script: comparisons", &
         u, results)
    call test (sindarin_parser_6, "sindarin_parser_6", &
         "parse script: conditionals", &
         u, results)
    call test (sindarin_parser_7, "sindarin_parser_7", &
         "parse script: containers", &
         u, results)  
  end subroutine sindarin_parser_test

end module sindarin_parser_ut
