(* $Id: comphep_syntax.mli 4926 2013-12-04 12:35:06Z jr_reuter $

   Copyright (C) 1999-2014 by

       Wolfgang Kilian <kilian@physik.uni-siegen.de>
       Thorsten Ohl <ohl@physik.uni-wuerzburg.de>
       Juergen Reuter <juergen.reuter@desy.de>
       with contributions from
       Christian Speckner <cnspeckn@googlemail.com>

   WHIZARD is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   WHIZARD is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *)

type raw =
  | I | Integer of int | Symbol of string
  | Application of string * raw
  | Dotproduct of raw * raw
  | Product of (raw * int) list
  | Sum of (raw * int) list

val symbol : string -> raw
val integer : int -> raw
val imag : raw

val apply : string -> raw -> raw
val dot : raw -> raw -> raw
val multiply : raw -> raw -> raw
val divide : raw -> raw -> raw
val power : raw -> int -> raw
val add : raw -> raw -> raw
val subtract : raw -> raw -> raw
val neg : raw -> raw

(*i
 *  Local Variables:
 *  mode:caml
 *  indent-tabs-mode:nil
 *  page-delimiter:"^(\\* .*\n"
 *  End:
i*)

