C-----------------------------------------------------------------------
      FUNCTION IJKGDS1(I,J,IJKGDSA)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:  IJKGDS1    RETURN FIELD POSITION FOR A GIVEN GRID POINT
C   PRGMMR: IREDELL       ORG: W/NMC23       DATE: 96-04-10
C
C ABSTRACT: THIS SUBPROGRAM DECODES THE GRIB GRID DESCRIPTION SECTION
C           AND RETURNS THE FIELD POSITION FOR A GIVEN GRID POINT.
C           CALL IJKGDS0 TO SET UP THE NAVIGATION PARAMETER ARRAY.
C
C PROGRAM HISTORY LOG:
C   96-04-10  IREDELL
C   97-03-11  IREDELL  ALLOWED HEMISPHERIC GRIDS TO WRAP OVER ONE POLE
C   98-07-13  BALDWIN  ADD 2D STAGGERED ETA GRID INDEXING (203)
C 1999-04-08  IREDELL  SPLIT IJKGDS INTO TWO
C
C USAGE:    ...IJKGDS1(I,J,IJKGDSA)
C
C   INPUT ARGUMENT LIST:
C     I        - INTEGER X GRID POINT
C     J        - INTEGER Y GRID POINT
C     IJKGDSA  - INTEGER (20) NAVIGATION PARAMETER ARRAY
C                IJKGDSA(1) IS NUMBER OF X POINTS
C                IJKGDSA(2) IS NUMBER OF Y POINTS
C                IJKGDSA(3) IS X WRAPAROUND INCREMENT
C                           (0 IF NO WRAPAROUND)
C                IJKGDSA(4) IS Y WRAPAROUND LOWER PIVOT POINT
C                           (0 IF NO WRAPAROUND)
C                IJKGDSA(5) IS Y WRAPAROUND UPPER PIVOT POINT
C                           (0 IF NO WRAPAROUND)
C                IJKGDSA(6) IS SCANNING MODE
C                           (0 IF X FIRST THEN Y; 1 IF Y FIRST THEN X;
C                            2 IF STAGGERED DIAGONAL LIKE PROJECTION 201;
C                            3 IF STAGGERED DIAGONAL LIKE PROJECTION 203)
C                IJKGDSA(7) IS MASS/WIND FLAG FOR STAGGERED DIAGONAL
C                           (0 IF MASS; 1 IF WIND)
C                IJKGDSA(8:20) ARE UNUSED AT THE MOMENT
C
C   OUTPUT ARGUMENT LIST:
C     IJKGDS   - INTEGER POSITION IN GRIB FIELD TO LOCATE GRID POINT
C                (0 IF OUT OF BOUNDS)
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C
C$$$
      INTEGER I,J
      INTEGER IJKGDSA(20)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  EXTRACT FROM NAVIGATION PARAMETER ARRAY
      IM=IJKGDSA(1)
      JM=IJKGDSA(2)
      IWRAP=IJKGDSA(3)
      JWRAP1=IJKGDSA(4)
      JWRAP2=IJKGDSA(5)
      NSCAN=IJKGDSA(6)
      KSCAN=IJKGDSA(7)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  COMPUTE WRAPAROUNDS IN X AND Y IF NECESSARY AND POSSIBLE
      II=I
      JJ=J
      IF(IWRAP.GT.0) THEN
        II=MOD(I-1+IWRAP,IWRAP)+1
        IF(J.LT.1.AND.JWRAP1.GT.0) THEN
          JJ=JWRAP1-J
          II=MOD(II-1+IWRAP/2,IWRAP)+1
        ELSEIF(J.GT.JM.AND.JWRAP2.GT.0) THEN
          JJ=JWRAP2-J
          II=MOD(II-1+IWRAP/2,IWRAP)+1
        ENDIF
      ENDIF
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  COMPUTE POSITION FOR THE APPROPRIATE SCANNING MODE
      IJKGDS1=0
      IF(NSCAN.EQ.0) THEN
        IF(II.GE.1.AND.II.LE.IM.AND.JJ.GE.1.AND.JJ.LE.JM)
     &  IJKGDS1=II+(JJ-1)*IM
      ELSEIF(NSCAN.EQ.1) THEN
        IF(II.GE.1.AND.II.LE.IM.AND.JJ.GE.1.AND.JJ.LE.JM)
     &  IJKGDS1=JJ+(II-1)*JM
      ELSEIF(NSCAN.EQ.2) THEN
        IS1=(JM+1-KSCAN)/2
        IIF=JJ+(II-IS1)
        JJF=JJ-(II-IS1)+KSCAN
        IF(IIF.GE.1.AND.IIF.LE.2*IM-1.AND.JJF.GE.1.AND.JJF.LE.JM)
     &  IJKGDS1=(IIF+(JJF-1)*(2*IM-1)+1-KSCAN)/2
      ELSEIF(NSCAN.EQ.3) THEN
        IS1=(JM+1-KSCAN)/2
        IIF=JJ+(II-IS1)
        JJF=JJ-(II-IS1)+KSCAN
        IF(IIF.GE.1.AND.IIF.LE.2*IM-1.AND.JJF.GE.1.AND.JJF.LE.JM)
     &  IJKGDS1=(IIF+1)/2+(JJF-1)*IM
      ENDIF
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
