 SUBROUTINE POLFIXS_NN(NM,NX,KM,RLAT,IB,LO,GO)
!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:  POLFIXS    MAKE MULTIPLE POLE SCALAR VALUES CONSISTENT
!                         WHEN USING NEAREST NEIGHBOR INTERPOLATION.
!   PRGMMR: IREDELL       ORG: W/NMC23       DATE: 2019-05-28
!
! ABSTRACT: THIS SUBPROGRAM SETS POLAR POINTS ON A LATITUDE/
!           LONGITUDE GRID TO A SINGLE VALUE.  FOR BITMAPPED
!           FIELDS, A VALUE IS RETURNED IF THE MAJORITY OF
!           OF POLE POINTS ARE NOT BITMAPPED OUT.  
!        
! PROGRAM HISTORY LOG:
!   2019-05-28  INITIAL VERSION BASED ON ROUTINE POLFIXS
!
! USAGE:    CALL POLFIXS(NM,NX,KM,RLAT,IB,LO,GO)
!
!   INPUT ARGUMENT LIST:
!     NM       - INTEGER NUMBER OF GRID POINTS
!     NX       - INTEGER LEADING DIMENSION OF FIELDS
!     KM       - INTEGER NUMBER OF FIELDS
!     RLAT     - REAL (NM) LATITUDES IN DEGREES
!     IB       - INTEGER (KM) BITMAP FLAGS
!     LO       - LOGICAL*1 (NX,KM) BITMAPS (IF SOME IB(K)=1)
!     GO       - REAL (NX,KM) FIELDS
!
!   OUTPUT ARGUMENT LIST:
!     LO       - LOGICAL*1 (NX,KM) BITMAPS (IF SOME IB(K)=1)
!     GO       - REAL (NX,KM) FIELDS
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 90
!
!$$$
 IMPLICIT NONE
!
 INTEGER,    INTENT(IN   ) :: NM, NX, KM
 INTEGER,    INTENT(IN   ) :: IB(KM)
!
 LOGICAL*1,  INTENT(INOUT) :: LO(NX,KM)
!
 REAL,       INTENT(IN   ) :: RLAT(NM)
 REAL,       INTENT(INOUT) :: GO(NX,KM)
!
 REAL,       PARAMETER     :: RLATNP=89.9995
 REAL,       PARAMETER     :: RLATSP=-RLATNP
!
 INTEGER                   :: K, N
!
 REAL                      :: WNP, GNP, TNP, WSP, GSP, TSP
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 DO K=1,KM
   WNP=0.
   GNP=0.
   TNP=0.
   WSP=0.
   GSP=0.
   TSP=0.
! CHECK ALL POLE POINTS AND PICK THE LAST VALID POINT.  WILL WORK
! WHEN INTERPOLATING CATEGORICAL OR FLOATING POINT FIELDS USING 
! NEIGHBOR METHOD.
   DO N=1,NM
     IF(RLAT(N).GE.RLATNP) THEN
       WNP=WNP+1
       IF(IB(K).EQ.0.OR.LO(N,K)) THEN
         GNP=GO(N,K)
         TNP=TNP+1
       ENDIF
     ELSEIF(RLAT(N).LE.RLATSP) THEN
       WSP=WSP+1
       IF(IB(K).EQ.0.OR.LO(N,K)) THEN
         GSP=GO(N,K)
         TSP=TSP+1
       ENDIF
     ENDIF
   ENDDO
! DISTRIBUTE POLE VALUE TO ALL POLE POINTS.
   IF(WNP.GT.1) THEN
     IF(TNP.LT.WNP/2) THEN
       GNP=0.
     ENDIF
     DO N=1,NM
       IF(RLAT(N).GE.RLATNP) THEN
         IF(IB(K).NE.0) LO(N,K)=TNP.GE.WNP/2
         GO(N,K)=GNP
       ENDIF
     ENDDO
   ENDIF
   IF(WSP.GT.1) THEN
     IF(TSP.LT.WSP/2) THEN
       GSP=0.
     ENDIF
     DO N=1,NM
       IF(RLAT(N).LE.RLATSP) THEN
         IF(IB(K).NE.0) LO(N,K)=TSP.GE.WSP/2
         GO(N,K)=GSP
       ENDIF
     ENDDO
   ENDIF
 ENDDO
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 END SUBROUTINE POLFIXS_NN
