#include "incu/system.hh"
#include <cstdlib>
#include <stdexcept>
#include <sys/wait.h>

int incu::System::run()  {
  const std::string cmd_str = str();
  int resultcode = system(cmd_str.c_str());
  if(resultcode == -1)
    throw std::runtime_error("shellCmd: Failed to fork");
  if(resultcode == 127)
    throw std::runtime_error("shellCmd: Failed to execute shell");
  if(!WIFEXITED(resultcode))
    throw std::runtime_error("shellCmd: abnormal exit");
  int exitstatus = WEXITSTATUS(resultcode);

  // We don't care about the exitstatus here, any strange value might be
  // normal for the actual called program.  Just return it.
  return exitstatus;
}
