#include "incu/socket.hh"
#include "incu/filedescriptors.hh"
#include <unistd.h>

incu::SockaddrIn&
incu::SockaddrIn::addr(const std::string& a) {
  struct hostent* he = gethostbyname(a.c_str());
#if 0
  if(!he)
    throw(runtime_error(string("gethostbyname: ") + hstrerror(h_errno) +
			" (" + a + ")"));
#else
  if(!he) switch(h_errno) {
  case NETDB_INTERNAL: throw c_error("gethostbyname internal error");
  case HOST_NOT_FOUND: throw std::runtime_error("Host not found: " + a);
  case TRY_AGAIN:      throw std::runtime_error("gethostbyname: Try again");
  case NO_RECOVERY:    throw std::runtime_error("gethostbyname: No recovery");
  case NO_DATA:        throw std::runtime_error("gethostbyname: No data");
# if (NO_DATA != NO_ADDRESS)	// The same on some (most?) systems
  case NO_ADDRESS:     throw std::runtime_error("gethostbyname: No address");
# endif
  default:             throw std::runtime_error("gethostbyname: Unknown error");
  }
#endif

  memcpy(&sin.sin_addr, he->h_addr_list[0], sizeof(sin.sin_addr));
  return *this;
}

incu::Socket::Socket(int domain, int type, const char* protocol) 
  : serv_sock(-1), iobuf(0), inbuf(0), outbuf(0)
{
  struct protoent *tp = getprotobyname(protocol);
  if(!tp) throw c_error("Cannot get tcp trotocol");
  
  /* Create TCP socket */
  serv_sock = socket(domain, type, tp->p_proto);
  if( serv_sock < 0) throw c_error("Cannot create socekt");
}

void
incu::Socket::close() {
  
  delete iobuf;
  delete inbuf;
  delete outbuf;
  
  iobuf = inbuf = outbuf = 0;
  
  if (serv_sock != -1) {
    
    if (::close(serv_sock) != 0)
      throw c_error("Failed to close socket");
    
    serv_sock = -1;
  }
}

std::ostream& 
incu::operator << (std::ostream& out, const SockaddrIn& addr) {
  if(!out) return out;
  // Note: This is probably to simplistic ...
  unsigned long num = addr.sin.sin_addr.s_addr;
  for(int i = 0; i < 4; ++i) {
    out << (num & 0xff) << '.';
    num >>= 8;
  }
  out << ntohs(addr.sin.sin_port);
  return out;
}  

std::streambuf*
incu::Socket::getIOBuf() {
  if(inbuf || outbuf)
    throw std::runtime_error("Cant have both separate and unified io buffers");
  if(!iobuf)
    iobuf = new IoFdBuf(serv_sock);
  return iobuf;
}

std::streambuf*
incu::Socket::getInBuf() {
  if(!inbuf) 
    inbuf = new InFdBuf(serv_sock);
  return inbuf;
}

std::streambuf*
incu::Socket::getOutBuf() {
  if(!outbuf)
    outbuf = new OutFdBuf(serv_sock);
  return outbuf;
}
