#include <incu/pipe.hh>
#include <unistd.h>
#include <incu/error.hh>
#include "incu/filedescriptors.hh"


incu::Pipe::Pipe()
  : inbuf(0), outbuf(0)
{
  if(pipe(filedesc) == -1)
    throw incu::c_error("pipe");
}

incu::Pipe::~Pipe() {
  closeReader();
  closeWriter();
}

void
incu::Pipe::closeReader(bool delete_buffer) {
  if(delete_buffer) delete inbuf;
  close(filedesc[0]);
}

void 
incu::Pipe::closeWriter(bool delete_buffer) {
  if(delete_buffer) delete outbuf;
  close(filedesc[1]);
}


std::streambuf*
incu::Pipe::getReadBuf() {
  if(!inbuf) 
    inbuf = new InFdBuf(filedesc[0]);
  return inbuf;
}

std::streambuf*
incu::Pipe::getWriteBuf() {
  if(!outbuf)
    outbuf = new OutFdBuf(filedesc[1]);
  return outbuf;
}
