#ifndef INCU_TIME
#define INCU_TIME
#include <sys/time.h>
#include <incu/error.hh>

namespace incu {

  class TimeVal : public timeval {
  public:
    TimeVal(long seconds, long microseconds = 0) {
      tv_sec = seconds;
      tv_usec = microseconds;
    } 
  };
  
  class Time {
  public:
    explicit Time(const time_t& val) : value(val) {}
    Time() : value(time(0)) {
      if(value == -1)
      throw c_error("get time()");
    }
    std::string format() const;
    
  private:
    time_t value;

    friend std::ostream& operator << (std::ostream& out, const Time& t);
  };
};

#endif // INCU_TIME
