#ifndef INCU_FILEDESC
#define INCU_FILEDESC
// Strange stuff that works directly on filedescriptors.  The implementation
// of other parts of incu use this, but you are not encoraged to use this
// directly ...
#include <iostream>

namespace incu {

  int move_fd(int to, int from);

  class FdBufBase : public std::streambuf {
  protected:
    FdBufBase(int fd, bool should_close, int bufsize);
    virtual ~FdBufBase();
    
    int fd_;
    bool should_close_;
    int bufsize_;
  };
  
  class OutFdBuf : virtual public FdBufBase {
  public:
    OutFdBuf(int fd, bool should_close = false, int bufsize = 1024);
    virtual ~OutFdBuf();
    
  protected:
    virtual int sync();
    virtual int overflow (int c);
    
  private:
    char *outbuffer_;
  };
  
  class InFdBuf : virtual public FdBufBase {
  public:
    InFdBuf(int fd, bool should_close = false, int bufsize = 1024);
    virtual ~InFdBuf();
    
  protected:
    virtual int underflow ();
    
  private:
    char *inbuffer_;
  };

  class IoFdBuf : public OutFdBuf, public InFdBuf {
  public:
    IoFdBuf(int fd, bool should_close = false, int bufsize = 1024);
  };
};

#endif
