#include "incu/filedescriptors.hh"
#include "incu/error.hh"
#include <fcntl.h>
#include <unistd.h>

int
incu::move_fd(int to, int from) {
  if (to == from) return 0;
  if (to == from) return 0;
  if (fcntl(from,F_GETFL,0) == -1) return -1;
  close(to);
  if (fcntl(from,F_DUPFD,to) == -1) return -1;
  close(from);
  return 0;
}

incu::FdBufBase::FdBufBase(int fd, bool should_close, int bufsize)
  : fd_(fd), should_close_(should_close), bufsize_(bufsize)
{}

incu::FdBufBase::~FdBufBase() {
  if(should_close_)
    close(fd_);
}

incu::OutFdBuf::OutFdBuf(int fd, bool should_close, int bufsize)
  : FdBufBase(fd, should_close, bufsize),
    outbuffer_(new char[bufsize_+1])
{
  setp(outbuffer_, outbuffer_+bufsize_);
}

incu::OutFdBuf::~OutFdBuf() {
  overflow(EOF);
  delete[] outbuffer_;
}
    
int incu::OutFdBuf::sync() {
//   std::cerr << "Got a call to sync" << std::endl;
  return overflow(EOF);
}

int incu::OutFdBuf::overflow (int c) {
  char *endpos = pptr();
  if (c != EOF) {
    if(endpos <= outbuffer_+bufsize_)
      *(endpos++) = static_cast<char>(c);
    else
      std::cerr << "Oups: We might miss a character here." << std::endl;
  }
  int nbyte = endpos - pbase();
  if(nbyte > 0) {
//     std::cerr << "Doing an actual write: \""
// 	      << std::string(pbase(), endpos) << "\"" << std::endl;
    int status = write(fd_, pbase(), nbyte);
    if(status == -1) {
      throw c_error("write");
    } else if(status == nbyte) {
    } else {
      std::cerr << "Wrote only " << status << " bytes, not " << nbyte
		<< std::endl;
    }
    setp(outbuffer_, outbuffer_+bufsize_);
  } else {
//     std::cerr << "Owerflow with nothing to write." << std::endl;
    return 0;
  }
  return 1;
  // Todo:  Really check what the return values are supposed to mean!
}

incu::InFdBuf::InFdBuf(int fd, bool should_close, int bufsize) 
  : FdBufBase(fd, should_close, bufsize),
    inbuffer_(new char[bufsize_])
{
  setg(inbuffer_, inbuffer_ + bufsize_, inbuffer_ + bufsize_);
}

incu::InFdBuf::~InFdBuf() {
  delete[] inbuffer_;
}

int incu::InFdBuf::underflow () {
  if(gptr() && gptr() < egptr()) {
    // Shouldn't have been called?
    return *gptr();
  }
  const int status = read(fd_, inbuffer_, bufsize_);
//   std::cerr << "Actual read yielded " << status
// 	    << " (" << egptr() - gptr() << ") " << std::endl;
  if(status == -1) {
    throw c_error("read");
  }
  if(status <= 0) return EOF;

//   std::cerr << "--\n" << std::string(inbuffer_, inbuffer_+status) << "\n--"
// 	    << " [" << inbuffer_[0] << ']' << std::endl;
  setg(inbuffer_, inbuffer_, inbuffer_+status);
  return inbuffer_[0];
}

incu::IoFdBuf::IoFdBuf(int fd, bool should_close, int bufsize)
  : FdBufBase(fd, should_close, bufsize),
    OutFdBuf(fd, should_close, bufsize),
    InFdBuf(fd, should_close, bufsize)
{
//   std::cerr << "Created an IoFdBuf" << std::endl;
}
