description("Test the computed style of the -webkit-animation-trigger property.");

// These have to be global for the test helpers to see them.
var stylesheet, triggerStyle, subRule;
var styleElement = document.createElement("style");
document.head.appendChild(styleElement);
stylesheet = styleElement.sheet;

function testComputedTriggerRule(description, rule, expectedLength, expectedTexts)
{
    debug("");
    debug(description + " : " + rule);

    stylesheet.insertRule("body { -webkit-animation-trigger: " + rule + "; }", 0);

    triggerStyle = window.getComputedStyle(document.body).getPropertyCSSValue("-webkit-animation-trigger");
    shouldBe("triggerStyle.length", "" + expectedLength);
    for (var i = 0; i < expectedLength; i++) {
        subRule = triggerStyle[i];
        shouldBe("subRule.cssText", "'" + expectedTexts[i] + "'");
    }
    stylesheet.deleteRule(0);
}

testComputedTriggerRule("Auto",
                        "auto", 1,
                        ["auto"]);

testComputedTriggerRule("One container-scroll value",
                        "container-scroll(10px)", 1,
                        ["container-scroll(10px)"]);

testComputedTriggerRule("One container-scroll value",
                        "container-scroll(2em)", 1,
                        ["container-scroll(32px)"]);

testComputedTriggerRule("One container-scroll value with end value",
                        "container-scroll(10px, 20px)", 1,
                        ["container-scroll(10px, 20px)"]);

testComputedTriggerRule("Two container-scroll values",
                        "container-scroll(10px), container-scroll(20px)", 2,
                        ["container-scroll(10px)", "container-scroll(20px)"]);

testComputedTriggerRule("Many container-scroll values",
                        "container-scroll(10px), container-scroll(20px), container-scroll(30px), container-scroll(40px), container-scroll(1px)", 5,
                        ["container-scroll(10px)", "container-scroll(20px)", "container-scroll(30px)", "container-scroll(40px)", "container-scroll(1px)"]);

testComputedTriggerRule("No value",
                        "", 1,
                        ["auto"]);

testComputedTriggerRule("Bad value",
                        "banana", 1,
                        ["auto"]);

testComputedTriggerRule("Multiple bad values",
                        "banana, eggs, bacon", 1,
                        ["auto"]);

testComputedTriggerRule("Some good, some bad values",
                        "container-scroll(10), eggs, bacon", 1,
                        ["auto"]);

successfullyParsed = true;
