// Copyright (c) 2012 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es5id: 7.6.1-8-3
description: >
    Allow reserved words as property names by set function within an
    object, accessed via indexing: instanceof, typeof, else
---*/

        var test0 = 0, test1 = 1, test2 = 2;
        var tokenCodes  = {
            set instanceof(value){
                test0 = value;
            },
            get instanceof(){
                return test0;
            },
            set typeof(value){
                test1 = value;
            },
            get typeof(){
                return test1;
            },
            set else(value){
                test2 = value;
            },
            get else(){
                return test2;
            }
        }; 
        var arr = [
            'instanceof',
            'typeof',
            'else'
        ];
        for (var i = 0; i < arr.length; i++) {
            assert.sameValue(tokenCodes[arr[i]], i, 'tokenCodes[arr[i]]');
        }
