// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
es6id: 22.2.3.3
description: |
  Return value from [[ByteOffset]] internal slot
info: >
  22.2.3.3 get %TypedArray%.prototype.byteOffset

  ...
  6. Let offset be the value of O's [[ByteOffset]] internal slot.
  7. Return size.
includes: [testTypedArray.js]
---*/

testWithTypedArrayConstructors(function(TA) {
  var ta1 = new TA();
  assert.sameValue(ta1.byteOffset, 0, "Regular typedArray");

  var offset = 4 * TA.BYTES_PER_ELEMENT;

  var buffer1 = new ArrayBuffer(8 * TA.BYTES_PER_ELEMENT);
  var ta2 = new TA(buffer1, offset);
  assert.sameValue(ta2.byteOffset, offset, "TA(buffer, offset)");

  var buffer2 = new ArrayBuffer(8 * TA.BYTES_PER_ELEMENT);
  var sample = new TA(buffer2, offset);
  var ta3 = new TA(sample);
  assert.sameValue(ta3.byteOffset, 0, "TA(typedArray)");
});
